/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.GDE;
import gde.device.DataTypes;
import gde.device.smmodellbau.UniLog2Dialog;
import gde.device.smmodellbau.UniLog2SetupConfiguration2;
import gde.device.smmodellbau.UniLog2SetupReaderWriter;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.SWTResourceManager;
import gde.utils.StringHelper;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UniLog2SetupConfiguration1
extends Composite {
    static final Logger log = Logger.getLogger(UniLog2SetupConfiguration1.class.getName());
    final UniLog2Dialog dialog;
    final DataExplorer application;
    final UniLog2SetupReaderWriter configuration;
    CLabel serialNumberLabel;
    CLabel firmwareLabel;
    Text serialNumberText;
    Text firmwareText;
    Group commonAdjustmentsGroup;
    Group logStartStopGroup;
    CLabel dataRateLabel;
    CLabel currentSensorTypeLabel;
    CLabel propellerBladesLabel;
    CLabel motorPolsLabel;
    CLabel gearFactorLabel;
    CLabel varioTriggerLevelLabel;
    CLabel varioTriggerSinkLevelLabel;
    CLabel varioToneLabel;
    CLabel varioFactorLabel;
    CLabel varioFilterLabel;
    CLabel limiterModusLabel;
    CLabel energyLimitLabel;
    CLabel autoStartCurrentUnitLabel;
    CLabel autoStartRxUnitLabel;
    CLabel autoStartTimeUnitLabel;
    CLabel a1ModusLabel;
    CLabel a2ModusLabel;
    CLabel a3ModusLabel;
    CLabel minMaxRxLabel;
    CLabel capacityResetLabel;
    CLabel currentOffsetLabel;
    CLabel telemetrieTypeLabel;
    CLabel autoStopLabel;
    Text gearFactorText;
    Text varioTriggerLevelText;
    Text varioTriggerSinkLevelText;
    Text energyLimitText;
    Slider gearFactorSlider;
    Slider varioTriggerLevelSlider;
    Slider varioTriggerSinkLevelSlider;
    Slider energyLimitSlider;
    CCombo dataRateCombo;
    CCombo currentSensorCombo;
    CCombo propBladesCombo;
    CCombo varioToneCombo;
    CCombo limiterModusCombo;
    CCombo minMaxRxCombo;
    CCombo capacityResetCombo;
    CCombo currentOffsetCombo;
    CCombo autoStopCombo;
    CCombo autoStartCurrentCombo;
    CCombo autoStartRxCombo;
    CCombo autoStartTimeCombo;
    CCombo a1ModusCombo;
    CCombo a2ModusCombo;
    CCombo a3ModusCombo;
    CCombo varioFactorCombo;
    CCombo varioFilterCombo;
    CCombo telemetrieTypeCombo;
    Button autoStartCurrentButton;
    Button autoStartRxButton;
    Button autoStartTimeButton;
    Composite fillerComposite;
    Composite addonComposite;
    CLabel frskyIdLabel;
    Button fixSerialNumberButton;
    Button robbeTBoxButton;
    CCombo frskyIdCombo;
    final String[] dataRateValues = new String[]{" 20 Hz", " 10 Hz", "  5 Hz", "  2 Hz", "  1 Hz"};
    final String[] currentSensorTypes = new String[]{"  20 A", " 40/80 A", " 150 A", " 400 A"};
    final String[] analogModi = Messages.getString((String)"GDE_MSGT2549").split(",");
    final String[] numberProbMotorPoles = new String[]{" 1 / 2", " 2 / 4", " 3 / 6", " 4 / 8", " 5 / 10", " 6 / 12", " 7 / 14"};
    final String[] currentStartValues = new String[]{"  1", "  2", "  3", "  4", "  5", "  6", "  7", "  8", "  9", " 10"};
    final String[] rxStartValues = new String[]{"  1.1", "  1.2", "  1.3", "  1.4", "  1.5", "  1.6", "  1.7", "  1.8", "  1.9", Messages.getString((String)"GDE_MSGT2508")};
    final String[] timeStartValues = new String[]{"  5", " 10", " 15", " 20", " 25", " 30", " 35", " 40", " 45", " 50", " 55", " 60", " 65", " 70", " 75", " 80", " 85", " 90"};
    final String[] voltageRxValues = new String[]{"  3.00", "  3.25", "  3.50", "  3.75", "  4.00", "  4.25", "  4.50", "  4.75", "  4.80", "  4.85", "  4.90", "  4.95", "  5.00", "  5.05", "  5.10", "  5.15", "  5.20", "  5.25", "  5.50", "  6.00", "  6.25", "  6.50", "  6.75", "  7.00", "  7.25", "  7.50", "  7.75", "  8.00"};
    final String[] frskyIDs = new String[]{" 0x00", " 0xA1", " 0x22", " 0x83", " 0xE4", " 0x45", " 0xC6", " 0x67", " 0x48", " 0xE9", " 0x6A", " 0xCB", " 0xAC", " 0x0D", " 0x8E", " 0x2F", " 0xD0", " 0x71", " 0xF2", " 0x53", " 0x34", " 0x95", " 0x16", " 0xB7", " 0x98", " 0x39", " 0xBA", " 0x1B"};
    final String[] telemetrieTypes = new String[]{" - - - ", " Futaba", " JR DMSS", " HoTT GAM", " HoTT EAM", " HoTT ESC", " JetiDuplex", " M-Link", " FrSky", " HoTT Vario", " Spektrum"};
    final String[] capacityResets = Messages.getString((String)"GDE_MSGT2581").split(",");
    final String[] currentOffsets = Messages.getString((String)"GDE_MSGT2582").split(",");
    final String[] varioFactors;
    final String[] varioFilters = Messages.getString((String)"GDE_MSGT2588").split(",");

    public static void main(String[] args) {
        UniLog2SetupConfiguration1.showGUI();
    }

    public static void showGUI() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        UniLog2SetupConfiguration1 inst = new UniLog2SetupConfiguration1((Composite)shell, 0);
        Point size = inst.getSize();
        shell.setLayout((Layout)new FillLayout());
        shell.layout();
        if (size.x == 0 && size.y == 0) {
            inst.pack();
            shell.pack();
        } else {
            Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
            shell.setSize(shellBounds.width, shellBounds.height);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public UniLog2SetupConfiguration1(Composite parent, int style) {
        super(parent, style);
        this.dialog = null;
        this.configuration = null;
        this.application = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 41; ++i) {
            sb.append(String.format(Locale.ENGLISH, " %2.1f ,", 1.0 + (double)i / 10.0));
        }
        this.varioFactors = sb.toString().split(",");
        this.initGUI();
    }

    public UniLog2SetupConfiguration1(Composite parent, int style, UniLog2Dialog useDialog, UniLog2SetupReaderWriter useConfiguration) {
        super(parent, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.dialog = useDialog;
        this.configuration = useConfiguration;
        this.application = DataExplorer.getInstance();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 41; ++i) {
            sb.append(String.format(Locale.ENGLISH, " %2.1f ,", 1.0 + (double)i / 10.0));
        }
        this.varioFactors = sb.toString().split(",");
        this.initGUI();
        this.updateValues();
    }

    public void updateValues() {
        this.serialNumberText.setText("" + this.configuration.serialNumber);
        this.firmwareText.setText(String.format(" %.2f", (double)this.configuration.firmwareVersion / 100.0));
        this.dataRateCombo.select(this.configuration.dataRate - 1);
        this.currentSensorCombo.select((int)this.configuration.currentSensorType);
        this.a1ModusCombo.select((int)this.configuration.modusA1);
        this.a2ModusCombo.select((int)this.configuration.modusA2);
        this.a3ModusCombo.select((int)this.configuration.modusA3);
        this.propBladesCombo.select(this.configuration.numberProb_MotorPole - 1);
        this.gearFactorSlider.setSelection(this.configuration.gearFactor - 100);
        this.gearFactorText.setText(String.format(Locale.ENGLISH, " %.2f", (double)this.configuration.gearFactor / 100.0));
        this.varioTriggerLevelSlider.setSelection((int)this.configuration.varioThreshold);
        this.varioTriggerLevelText.setText(String.format(Locale.ENGLISH, "+%.1f", (double)this.configuration.varioThreshold / 10.0));
        this.varioTriggerSinkLevelSlider.setSelection((int)this.configuration.varioThresholdSink);
        this.varioTriggerSinkLevelText.setText(String.format(Locale.ENGLISH, "-%.1f", (double)this.configuration.varioThresholdSink / 10.0));
        this.varioToneCombo.select((int)this.configuration.varioTon);
        this.varioFactorCombo.select((int)this.configuration.varioFactor);
        this.varioFilterCombo.select((int)this.configuration.varioFilter);
        this.limiterModusCombo.select((int)this.configuration.limiterModus);
        this.energyLimitSlider.setSelection((int)this.configuration.energyLimit);
        this.energyLimitText.setText(" " + this.configuration.energyLimit);
        this.minMaxRxCombo.select((int)this.configuration.minMaxRx);
        this.capacityResetCombo.select((int)this.configuration.capacityReset);
        this.currentOffsetCombo.select((int)this.configuration.currentOffset);
        this.telemetrieTypeCombo.select((int)this.configuration.telemetrieType);
        this.frskyIdCombo.select(this.configuration.frskyAddr - 1);
        this.fixSerialNumberButton.setSelection(this.configuration.serialNumberFix == 1);
        this.robbeTBoxButton.setSelection(this.configuration.robbe_T_Box == 1);
        this.autoStartCurrentButton.setSelection((this.configuration.startModus & 1) > 0);
        this.autoStartRxButton.setSelection((this.configuration.startModus & 2) > 0);
        this.autoStartTimeButton.setSelection((this.configuration.startModus & 4) > 0);
        this.autoStartCurrentCombo.select(this.configuration.startCurrent - 1);
        this.autoStartRxCombo.select(this.configuration.startRx - 11);
        this.autoStartTimeCombo.select(this.configuration.startTime / 5 - 1);
        this.autoStopCombo.select((int)this.configuration.stopModus);
        this.changeVisibility();
    }

    void initGUI() {
        SWTResourceManager.registerResourceUser((Widget)this);
        try {
            this.setLayout((Layout)new FormLayout());
            this.commonAdjustmentsGroup = new Group((Composite)this, 0);
            RowLayout commonAdjustmentsGroupLayout = new RowLayout(256);
            this.commonAdjustmentsGroup.setLayout((Layout)commonAdjustmentsGroupLayout);
            FormData commonAdjustmentsGroupLData = new FormData();
            commonAdjustmentsGroupLData.width = 290;
            commonAdjustmentsGroupLData.height = 515;
            commonAdjustmentsGroupLData.left = new FormAttachment(0, 1000, 12);
            commonAdjustmentsGroupLData.top = new FormAttachment(0, 1000, 5);
            this.commonAdjustmentsGroup.setLayoutData((Object)commonAdjustmentsGroupLData);
            this.commonAdjustmentsGroup.setText(Messages.getString((String)"GDE_MSGT2533"));
            this.commonAdjustmentsGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.serialNumberLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData serialNumberLabelLData = new RowData();
            serialNumberLabelLData.width = GDE.IS_LINUX ? 90 : 100;
            serialNumberLabelLData.height = 20;
            this.serialNumberLabel.setLayoutData((Object)serialNumberLabelLData);
            this.serialNumberLabel.setText(Messages.getString((String)"GDE_MSGT2534"));
            this.serialNumberLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.serialNumberText = new Text((Composite)this.commonAdjustmentsGroup, 133120);
            RowData serialNumberTextLData = new RowData();
            serialNumberTextLData.width = 50;
            serialNumberTextLData.height = 16;
            this.serialNumberText.setLayoutData((Object)serialNumberTextLData);
            this.serialNumberText.setEditable(false);
            this.serialNumberText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.firmwareLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 131072);
            RowData firmwareLabelLData = new RowData();
            firmwareLabelLData.width = GDE.IS_LINUX ? 65 : 75;
            firmwareLabelLData.height = 20;
            this.firmwareLabel.setLayoutData((Object)firmwareLabelLData);
            this.firmwareLabel.setText(Messages.getString((String)"GDE_MSGT2535"));
            this.firmwareLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.firmwareText = new Text((Composite)this.commonAdjustmentsGroup, 133120);
            RowData firmwareTextLData = new RowData();
            firmwareTextLData.width = GDE.IS_LINUX ? 35 : 40;
            firmwareTextLData.height = 16;
            this.firmwareText.setLayoutData((Object)firmwareTextLData);
            this.firmwareText.setEditable(false);
            this.firmwareText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.commonAdjustmentsGroup, 0);
            RowData fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 5;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.telemetrieTypeLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData telemetrieTypeLabelLData = new RowData();
            telemetrieTypeLabelLData.width = 130;
            telemetrieTypeLabelLData.height = 20;
            this.telemetrieTypeLabel.setLayoutData((Object)telemetrieTypeLabelLData);
            this.telemetrieTypeLabel.setText(Messages.getString((String)"GDE_MSGT2580"));
            this.telemetrieTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetrieTypeCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData telemetrieTypeComboLData = new RowData();
            telemetrieTypeComboLData.width = 130;
            telemetrieTypeComboLData.height = 17;
            this.telemetrieTypeCombo.setLayoutData((Object)telemetrieTypeComboLData);
            this.telemetrieTypeCombo.setItems(this.telemetrieTypes);
            this.telemetrieTypeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.telemetrieTypeCombo.setEditable(false);
            this.telemetrieTypeCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.telemetrieTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "telemetrieTypeCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.telemetrieType = (short)UniLog2SetupConfiguration1.this.telemetrieTypeCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    UniLog2SetupConfiguration1.this.changeVisibility();
                }
            });
            this.addonComposite = new Composite((Composite)this.commonAdjustmentsGroup, 0);
            this.addonComposite.setLayout((Layout)new FormLayout());
            RowData addonCompositeLData = new RowData();
            addonCompositeLData.width = 285;
            addonCompositeLData.height = 44;
            this.addonComposite.setLayoutData((Object)addonCompositeLData);
            this.frskyIdLabel = new CLabel(this.addonComposite, 0);
            FormData frskyIdLabelLData = new FormData();
            frskyIdLabelLData.width = 130;
            frskyIdLabelLData.height = 20;
            frskyIdLabelLData.left = new FormAttachment(0, 1000, 2);
            frskyIdLabelLData.top = new FormAttachment(0, 1000, 0);
            this.frskyIdLabel.setLayoutData((Object)frskyIdLabelLData);
            this.frskyIdLabel.setText(Messages.getString((String)"GDE_MSGT2579"));
            this.frskyIdLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fixSerialNumberButton = new Button(this.addonComposite, 16416);
            FormData sensorTypeLabelLData = new FormData();
            sensorTypeLabelLData.width = 130;
            sensorTypeLabelLData.height = 20;
            sensorTypeLabelLData.left = new FormAttachment(0, 1000, 2);
            sensorTypeLabelLData.top = new FormAttachment(0, 1000, 0);
            this.fixSerialNumberButton.setLayoutData((Object)sensorTypeLabelLData);
            this.fixSerialNumberButton.setText(Messages.getString((String)"GDE_MSGT2592"));
            this.fixSerialNumberButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fixSerialNumberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "fixSerialNumberButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.serialNumberFix = (byte)(UniLog2SetupConfiguration1.this.fixSerialNumberButton.getSelection() ? 1 : 0);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.robbeTBoxButton = new Button(this.addonComposite, 16416);
            sensorTypeLabelLData = new FormData();
            sensorTypeLabelLData.width = 115;
            sensorTypeLabelLData.height = 20;
            sensorTypeLabelLData.left = new FormAttachment(0, 1000, 2);
            sensorTypeLabelLData.top = new FormAttachment(0, 1000, 22);
            this.robbeTBoxButton.setLayoutData((Object)sensorTypeLabelLData);
            this.robbeTBoxButton.setText(Messages.getString((String)"GDE_MSGT2593"));
            this.robbeTBoxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.robbeTBoxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "robbeTBoxButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.robbe_T_Box = (byte)(UniLog2SetupConfiguration1.this.robbeTBoxButton.getSelection() ? 1 : 0);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.frskyIdCombo = new CCombo(this.addonComposite, 2048);
            FormData sensorTypeComboLData = new FormData();
            sensorTypeComboLData.width = 80;
            sensorTypeComboLData.height = 20;
            sensorTypeComboLData.left = new FormAttachment(0, 1000, 137);
            sensorTypeComboLData.top = new FormAttachment(0, 1000, 0);
            this.frskyIdCombo.setLayoutData((Object)sensorTypeComboLData);
            this.frskyIdCombo.setItems(this.frskyIDs);
            this.frskyIdCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.frskyIdCombo.setEditable(false);
            this.frskyIdCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.frskyIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "sensorTypeCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.frskyAddr = (short)(UniLog2SetupConfiguration1.this.frskyIdCombo.getSelectionIndex() + 1);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.addonComposite.layout();
            this.dataRateLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData dataRateLabelLData = new RowData();
            dataRateLabelLData.width = 130;
            dataRateLabelLData.height = 20;
            this.dataRateLabel.setLayoutData((Object)dataRateLabelLData);
            this.dataRateLabel.setText(Messages.getString((String)"GDE_MSGT2536"));
            this.dataRateLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.dataRateCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            this.dataRateCombo.setItems(this.dataRateValues);
            this.dataRateCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData dataRateComboLData = new RowData();
            dataRateComboLData.width = 84;
            dataRateComboLData.height = 17;
            this.dataRateCombo.setLayoutData((Object)dataRateComboLData);
            this.dataRateCombo.setEditable(false);
            this.dataRateCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.dataRateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "dataRateCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.dataRate = (short)(UniLog2SetupConfiguration1.this.dataRateCombo.getSelectionIndex() + 1);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.currentSensorTypeLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData currentSensorTypeLabelLData = new RowData();
            currentSensorTypeLabelLData.width = 130;
            currentSensorTypeLabelLData.height = 20;
            this.currentSensorTypeLabel.setLayoutData((Object)currentSensorTypeLabelLData);
            this.currentSensorTypeLabel.setText(Messages.getString((String)"GDE_MSGT2537"));
            this.currentSensorTypeLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentSensorCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData currentSensorComboLData = new RowData();
            currentSensorComboLData.width = 84;
            currentSensorComboLData.height = 17;
            this.currentSensorCombo.setLayoutData((Object)currentSensorComboLData);
            this.currentSensorCombo.setItems(this.currentSensorTypes);
            this.currentSensorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentSensorCombo.setEditable(false);
            this.currentSensorCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.currentSensorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "currentSensorCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.currentSensorType = (short)UniLog2SetupConfiguration1.this.currentSensorCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.a1ModusLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData a1ModusLabelLData = new RowData();
            a1ModusLabelLData.width = 130;
            a1ModusLabelLData.height = 20;
            this.a1ModusLabel.setLayoutData((Object)a1ModusLabelLData);
            this.a1ModusLabel.setText(Messages.getString((String)"GDE_MSGT2538"));
            this.a1ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a1ModusCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            this.a1ModusCombo.setItems(this.analogModi);
            this.a1ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData a1ModusComboLData = new RowData();
            a1ModusComboLData.width = 105;
            a1ModusComboLData.height = 17;
            this.a1ModusCombo.setLayoutData((Object)a1ModusComboLData);
            this.a1ModusCombo.setEditable(false);
            this.a1ModusCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.a1ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a1ModusCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.modusA1 = (short)UniLog2SetupConfiguration1.this.a1ModusCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.updateAnalogAlarmUnits();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.a2ModusLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData a2ModusLabelLData = new RowData();
            a2ModusLabelLData.width = 130;
            a2ModusLabelLData.height = 20;
            this.a2ModusLabel.setLayoutData((Object)a2ModusLabelLData);
            this.a2ModusLabel.setText(Messages.getString((String)"GDE_MSGT2539"));
            this.a2ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a2ModusCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            this.a2ModusCombo.setItems(this.analogModi);
            this.a2ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData a2ModusComboLData = new RowData();
            a2ModusComboLData.width = 105;
            a2ModusComboLData.height = 17;
            this.a2ModusCombo.setLayoutData((Object)a2ModusComboLData);
            this.a2ModusCombo.setEditable(false);
            this.a2ModusCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.a2ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a2ModusCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.modusA2 = (short)UniLog2SetupConfiguration1.this.a2ModusCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.updateAnalogAlarmUnits();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.a3ModusLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData a3ModusLabelLData = new RowData();
            a3ModusLabelLData.width = 130;
            a3ModusLabelLData.height = 20;
            this.a3ModusLabel.setLayoutData((Object)a3ModusLabelLData);
            this.a3ModusLabel.setText(Messages.getString((String)"GDE_MSGT2540"));
            this.a3ModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.a3ModusCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            this.a3ModusCombo.setItems(this.analogModi);
            this.a3ModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData a3ModusComboLData = new RowData();
            a3ModusComboLData.width = 105;
            a3ModusComboLData.height = 17;
            this.a3ModusCombo.setLayoutData((Object)a3ModusComboLData);
            this.a3ModusCombo.setEditable(false);
            this.a3ModusCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.a3ModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "a3ModusCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.modusA3 = (short)UniLog2SetupConfiguration1.this.a3ModusCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.updateAnalogAlarmUnits();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.propellerBladesLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData propellerBladesLabelLData = new RowData();
            propellerBladesLabelLData.width = 130;
            propellerBladesLabelLData.height = 20;
            this.propellerBladesLabel.setLayoutData((Object)propellerBladesLabelLData);
            this.propellerBladesLabel.setText(Messages.getString((String)"GDE_MSGT2541"));
            this.propellerBladesLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.propBladesCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData propBladesComboLData = new RowData();
            propBladesComboLData.width = 65;
            propBladesComboLData.height = 17;
            this.propBladesCombo.setLayoutData((Object)propBladesComboLData);
            this.propBladesCombo.setItems(this.numberProbMotorPoles);
            this.propBladesCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.propBladesCombo.setEditable(false);
            this.propBladesCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.propBladesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "propBladesCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.numberProb_MotorPole = (short)(UniLog2SetupConfiguration1.this.propBladesCombo.getSelectionIndex() + 1);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.motorPolsLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData motorPolsLabelLData = new RowData();
            motorPolsLabelLData.width = 76;
            motorPolsLabelLData.height = 20;
            this.motorPolsLabel.setLayoutData((Object)motorPolsLabelLData);
            this.motorPolsLabel.setText(Messages.getString((String)"GDE_MSGT2542"));
            this.motorPolsLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearFactorLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData gearFactorLabelLData = new RowData();
            gearFactorLabelLData.width = 130;
            gearFactorLabelLData.height = 20;
            this.gearFactorLabel.setLayoutData((Object)gearFactorLabelLData);
            this.gearFactorLabel.setText(Messages.getString((String)"GDE_MSGT2543"));
            this.gearFactorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearFactorText = new Text((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData gearFactorTextLData = new RowData();
            gearFactorTextLData.width = GDE.IS_LINUX ? 30 : 35;
            gearFactorTextLData.height = 16;
            this.gearFactorText.setLayoutData((Object)gearFactorTextLData);
            this.gearFactorText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.gearFactorText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent verifyevent) {
                    log.log(Level.FINEST, "gearFactorText.verify, event=" + String.valueOf(verifyevent));
                    verifyevent.doit = StringHelper.verifyTypedInput((DataTypes)DataTypes.DOUBLE, (String)verifyevent.text);
                }
            });
            this.gearFactorText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent keyevent) {
                    log.log(Level.FINEST, "gearFactorText.keyReleased, event=" + String.valueOf(keyevent));
                    try {
                        UniLog2SetupConfiguration1.this.configuration.gearFactor = (short)(Double.parseDouble(UniLog2SetupConfiguration1.this.gearFactorText.getText().trim().replace(',', '.')) * 100.0);
                        if (UniLog2SetupConfiguration1.this.configuration.gearFactor < 100) {
                            UniLog2SetupConfiguration1.this.configuration.gearFactor = (short)100;
                            UniLog2SetupConfiguration1.this.gearFactorText.setText(String.format(Locale.ENGLISH, " %.2f", (double)UniLog2SetupConfiguration1.this.configuration.gearFactor / 100.0));
                            UniLog2SetupConfiguration1.this.gearFactorSlider.setSelection(UniLog2SetupConfiguration1.this.gearFactorSlider.getMaximum());
                        } else if (UniLog2SetupConfiguration1.this.configuration.gearFactor > 2000) {
                            UniLog2SetupConfiguration1.this.configuration.gearFactor = (short)2000;
                            UniLog2SetupConfiguration1.this.gearFactorText.setText(String.format(Locale.ENGLISH, " %.2f", (double)UniLog2SetupConfiguration1.this.configuration.gearFactor / 100.0));
                            UniLog2SetupConfiguration1.this.gearFactorSlider.setSelection(UniLog2SetupConfiguration1.this.gearFactorSlider.getMinimum());
                        } else {
                            UniLog2SetupConfiguration1.this.gearFactorSlider.setSelection(UniLog2SetupConfiguration1.this.configuration.gearFactor - 100);
                        }
                        UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            this.gearFactorText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent evt) {
                    UniLog2SetupConfiguration1.this.gearFactorText.setText(String.format(Locale.ENGLISH, " %.2f", (double)UniLog2SetupConfiguration1.this.configuration.gearFactor / 100.0));
                }
            });
            RowData gearFactorSliderLData = new RowData();
            gearFactorSliderLData.width = 101;
            gearFactorSliderLData.height = 18;
            this.gearFactorSlider = new Slider((Composite)this.commonAdjustmentsGroup, 0);
            this.gearFactorSlider.setLayoutData((Object)gearFactorSliderLData);
            this.gearFactorSlider.setMinimum(0);
            this.gearFactorSlider.setMaximum(1910);
            this.gearFactorSlider.setIncrement(1);
            this.gearFactorSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "gearFactorSlider.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.gearFactor = (short)(UniLog2SetupConfiguration1.this.gearFactorSlider.getSelection() + 100);
                    UniLog2SetupConfiguration1.this.gearFactorText.setText(String.format(Locale.ENGLISH, " %.2f", (double)UniLog2SetupConfiguration1.this.configuration.gearFactor / 100.0));
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioTriggerLevelLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData varioTriggerLevelLabelLData = new RowData();
            varioTriggerLevelLabelLData.width = 130;
            varioTriggerLevelLabelLData.height = 20;
            this.varioTriggerLevelLabel.setLayoutData((Object)varioTriggerLevelLabelLData);
            this.varioTriggerLevelLabel.setText(Messages.getString((String)"GDE_MSGT2544"));
            this.varioTriggerLevelLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioTriggerLevelText = new Text((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData varioTriggerLevelTextLData = new RowData();
            varioTriggerLevelTextLData.width = GDE.IS_LINUX ? 30 : 35;
            varioTriggerLevelTextLData.height = 16;
            this.varioTriggerLevelText.setLayoutData((Object)varioTriggerLevelTextLData);
            this.varioTriggerLevelText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioTriggerLevelText.setEditable(false);
            this.varioTriggerLevelText.setBackground(SWTResourceManager.getColor((int)1));
            RowData varioTriggerLevelSliderLData = new RowData();
            varioTriggerLevelSliderLData.width = 101;
            varioTriggerLevelSliderLData.height = 18;
            this.varioTriggerLevelSlider = new Slider((Composite)this.commonAdjustmentsGroup, 0);
            this.varioTriggerLevelSlider.setLayoutData((Object)varioTriggerLevelSliderLData);
            this.varioTriggerLevelSlider.setMinimum(0);
            this.varioTriggerLevelSlider.setMaximum(60);
            this.varioTriggerLevelSlider.setIncrement(1);
            this.varioTriggerLevelSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioTriggerLevelSlider.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.varioThreshold = (short)UniLog2SetupConfiguration1.this.varioTriggerLevelSlider.getSelection();
                    UniLog2SetupConfiguration1.this.varioTriggerLevelText.setText(String.format(Locale.ENGLISH, "+%.1f", (double)UniLog2SetupConfiguration1.this.configuration.varioThreshold / 10.0));
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioTriggerSinkLevelLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData varioTriggerSinkLevelLabelLData = new RowData();
            varioTriggerSinkLevelLabelLData.width = 130;
            varioTriggerSinkLevelLabelLData.height = 20;
            this.varioTriggerSinkLevelLabel.setLayoutData((Object)varioTriggerSinkLevelLabelLData);
            this.varioTriggerSinkLevelLabel.setText(Messages.getString((String)"GDE_MSGT2513"));
            this.varioTriggerSinkLevelLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioTriggerSinkLevelText = new Text((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData varioTriggerSinkLevelTextLData = new RowData();
            varioTriggerSinkLevelTextLData.width = GDE.IS_LINUX ? 30 : 35;
            varioTriggerSinkLevelTextLData.height = 16;
            this.varioTriggerSinkLevelText.setLayoutData((Object)varioTriggerSinkLevelTextLData);
            this.varioTriggerSinkLevelText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioTriggerSinkLevelText.setEditable(false);
            this.varioTriggerSinkLevelText.setBackground(SWTResourceManager.getColor((int)1));
            RowData varioTriggerSinkLevelSliderLData = new RowData();
            varioTriggerSinkLevelSliderLData.width = 101;
            varioTriggerSinkLevelSliderLData.height = 18;
            this.varioTriggerSinkLevelSlider = new Slider((Composite)this.commonAdjustmentsGroup, 0);
            this.varioTriggerSinkLevelSlider.setLayoutData((Object)varioTriggerSinkLevelSliderLData);
            this.varioTriggerSinkLevelSlider.setMinimum(0);
            this.varioTriggerSinkLevelSlider.setMaximum(60);
            this.varioTriggerSinkLevelSlider.setIncrement(1);
            this.varioTriggerSinkLevelSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioTriggerSinkLevelSlider.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.varioThresholdSink = (short)UniLog2SetupConfiguration1.this.varioTriggerSinkLevelSlider.getSelection();
                    UniLog2SetupConfiguration1.this.varioTriggerSinkLevelText.setText(String.format(Locale.ENGLISH, "-%.1f", (double)UniLog2SetupConfiguration1.this.configuration.varioThresholdSink / 10.0));
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioToneLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData varioToneLabelLData = new RowData();
            varioToneLabelLData.width = 130;
            varioToneLabelLData.height = 20;
            this.varioToneLabel.setLayoutData((Object)varioToneLabelLData);
            this.varioToneLabel.setText(Messages.getString((String)"GDE_MSGT2545"));
            this.varioToneLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioToneCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData varioToneComboLData = new RowData();
            varioToneComboLData.width = 84;
            varioToneComboLData.height = 17;
            this.varioToneCombo.setLayoutData((Object)varioToneComboLData);
            this.varioToneCombo.setItems(Messages.getString((String)"GDE_MSGT2522").split(","));
            this.varioToneCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioToneCombo.setEditable(false);
            this.varioToneCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.varioToneCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioToneCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.varioTon = (short)UniLog2SetupConfiguration1.this.varioToneCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioFactorLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData varioFactorLabelLData = new RowData();
            varioFactorLabelLData.width = 130;
            varioFactorLabelLData.height = 20;
            this.varioFactorLabel.setLayoutData((Object)varioFactorLabelLData);
            this.varioFactorLabel.setText(Messages.getString((String)"GDE_MSGT2586"));
            this.varioFactorLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFactorCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData varioFactorComboLData = new RowData();
            varioFactorComboLData.width = 84;
            varioFactorComboLData.height = 17;
            this.varioFactorCombo.setLayoutData((Object)varioFactorComboLData);
            this.varioFactorCombo.setItems(this.varioFactors);
            this.varioFactorCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFactorCombo.setEditable(false);
            this.varioFactorCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.varioFactorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioFactorCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.varioFactor = (short)UniLog2SetupConfiguration1.this.varioFactorCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.varioFilterLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData varioFilterLabelLData = new RowData();
            varioFilterLabelLData.width = 130;
            varioFilterLabelLData.height = 20;
            this.varioFilterLabel.setLayoutData((Object)varioFilterLabelLData);
            this.varioFilterLabel.setText(Messages.getString((String)"GDE_MSGT2587"));
            this.varioFilterLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFilterCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData varioFilterComboLData = new RowData();
            varioFilterComboLData.width = 84;
            varioFilterComboLData.height = 17;
            this.varioFilterCombo.setLayoutData((Object)varioFilterComboLData);
            this.varioFilterCombo.setItems(this.varioFilters);
            this.varioFilterCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.varioFilterCombo.setEditable(false);
            this.varioFilterCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.varioFilterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "varioFilterCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.varioFilter = (short)UniLog2SetupConfiguration1.this.varioFilterCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.limiterModusLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData limiterModusLabelLData = new RowData();
            limiterModusLabelLData.width = 130;
            limiterModusLabelLData.height = 20;
            this.limiterModusLabel.setLayoutData((Object)limiterModusLabelLData);
            this.limiterModusLabel.setText(Messages.getString((String)"GDE_MSGT2546"));
            this.limiterModusLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.limiterModusCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData limiterModusComboLData = new RowData();
            limiterModusComboLData.width = 84;
            limiterModusComboLData.height = 17;
            this.limiterModusCombo.setLayoutData((Object)limiterModusComboLData);
            this.limiterModusCombo.setItems(Messages.getString((String)"GDE_MSGT2521").split(","));
            this.limiterModusCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.limiterModusCombo.setEditable(false);
            this.limiterModusCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.limiterModusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "limiterModusCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.limiterModus = (short)UniLog2SetupConfiguration1.this.limiterModusCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.energyLimitLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData energyLimitLabelLData = new RowData();
            energyLimitLabelLData.width = 130;
            energyLimitLabelLData.height = 20;
            this.energyLimitLabel.setLayoutData((Object)energyLimitLabelLData);
            this.energyLimitLabel.setText(Messages.getString((String)"GDE_MSGT2547"));
            this.energyLimitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyLimitText = new Text((Composite)this.commonAdjustmentsGroup, 0x1000800);
            RowData energyLimitTextLData = new RowData();
            energyLimitTextLData.width = GDE.IS_MAC ? 39 : (GDE.IS_LINUX ? 30 : 35);
            energyLimitTextLData.height = 16;
            this.energyLimitText.setLayoutData((Object)energyLimitTextLData);
            this.energyLimitText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.energyLimitText.setEditable(false);
            this.energyLimitText.setBackground(SWTResourceManager.getColor((int)1));
            RowData energyLimitSliderLData = new RowData();
            energyLimitSliderLData.width = 101;
            energyLimitSliderLData.height = 18;
            this.energyLimitSlider = new Slider((Composite)this.commonAdjustmentsGroup, 2048);
            this.energyLimitSlider.setLayoutData((Object)energyLimitSliderLData);
            this.energyLimitSlider.setMinimum(0);
            this.energyLimitSlider.setMaximum(2010);
            this.energyLimitSlider.setIncrement(1);
            this.energyLimitSlider.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "energyLimitSlider.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.energyLimit = (short)UniLog2SetupConfiguration1.this.energyLimitSlider.getSelection();
                    UniLog2SetupConfiguration1.this.energyLimitText.setText("" + UniLog2SetupConfiguration1.this.configuration.energyLimit);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.minMaxRxLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData minMaxRxLabelLData = new RowData();
            minMaxRxLabelLData.width = 130;
            minMaxRxLabelLData.height = 20;
            this.minMaxRxLabel.setLayoutData((Object)minMaxRxLabelLData);
            this.minMaxRxLabel.setText(Messages.getString((String)"GDE_MSGT2548"));
            this.minMaxRxLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.minMaxRxCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData minMaxRxComboLData = new RowData();
            minMaxRxComboLData.width = 84;
            minMaxRxComboLData.height = 17;
            this.minMaxRxCombo.setLayoutData((Object)minMaxRxComboLData);
            this.minMaxRxCombo.setItems(Messages.getString((String)"GDE_MSGT2519").split(","));
            this.minMaxRxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.minMaxRxCombo.setEditable(false);
            this.minMaxRxCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.minMaxRxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "minMaxRxCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.minMaxRx = (short)UniLog2SetupConfiguration1.this.minMaxRxCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.capacityResetLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData capacityResetLabelLData = new RowData();
            capacityResetLabelLData.width = 130;
            capacityResetLabelLData.height = 20;
            this.capacityResetLabel.setLayoutData((Object)capacityResetLabelLData);
            this.capacityResetLabel.setText(Messages.getString((String)"GDE_MSGT2583"));
            this.capacityResetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityResetCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData capacityResetComboLData = new RowData();
            capacityResetComboLData.width = 130;
            capacityResetComboLData.height = 17;
            this.capacityResetCombo.setLayoutData((Object)capacityResetComboLData);
            this.capacityResetCombo.setItems(this.capacityResets);
            this.capacityResetCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.capacityResetCombo.setEditable(false);
            this.capacityResetCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.capacityResetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "capacityResetCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.capacityReset = (short)UniLog2SetupConfiguration1.this.capacityResetCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.currentOffsetLabel = new CLabel((Composite)this.commonAdjustmentsGroup, 0);
            RowData currentOffsetLabelLData = new RowData();
            currentOffsetLabelLData.width = 130;
            currentOffsetLabelLData.height = 20;
            this.currentOffsetLabel.setLayoutData((Object)currentOffsetLabelLData);
            this.currentOffsetLabel.setText(Messages.getString((String)"GDE_MSGT2584"));
            this.currentOffsetLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentOffsetCombo = new CCombo((Composite)this.commonAdjustmentsGroup, 2048);
            RowData currentOffsetComboLData = new RowData();
            currentOffsetComboLData.width = 84;
            currentOffsetComboLData.height = 17;
            this.currentOffsetCombo.setLayoutData((Object)currentOffsetComboLData);
            this.currentOffsetCombo.setItems(this.currentOffsets);
            this.currentOffsetCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.currentOffsetCombo.setEditable(false);
            this.currentOffsetCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.currentOffsetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "currentOffsetCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.currentOffset = (short)UniLog2SetupConfiguration1.this.currentOffsetCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.logStartStopGroup = new Group((Composite)this, 0);
            RowLayout logStartStopGroupLayout = new RowLayout(256);
            this.logStartStopGroup.setLayout((Layout)logStartStopGroupLayout);
            FormData logStartStopGroupLData = new FormData();
            logStartStopGroupLData.width = 290;
            logStartStopGroupLData.height = 105;
            logStartStopGroupLData.left = new FormAttachment(0, 1000, 12);
            logStartStopGroupLData.top = new FormAttachment(0, 1000, 540);
            this.logStartStopGroup.setLayoutData((Object)logStartStopGroupLData);
            this.logStartStopGroup.setText(Messages.getString((String)"GDE_MSGT2526"));
            this.logStartStopGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.fillerComposite = new Composite((Composite)this.logStartStopGroup, 0);
            fillerCompositeRA1LData = new RowData();
            fillerCompositeRA1LData.width = 280;
            fillerCompositeRA1LData.height = 5;
            this.fillerComposite.setLayoutData((Object)fillerCompositeRA1LData);
            this.autoStartCurrentButton = new Button((Composite)this.logStartStopGroup, 32);
            RowData startByCurrentButtonLData = new RowData();
            startByCurrentButtonLData.width = 130;
            startByCurrentButtonLData.height = 19;
            this.autoStartCurrentButton.setLayoutData((Object)startByCurrentButtonLData);
            this.autoStartCurrentButton.setText(Messages.getString((String)"GDE_MSGT2527"));
            this.autoStartCurrentButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartCurrentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartCurrentButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startModus = UniLog2SetupConfiguration1.this.autoStartCurrentButton.getSelection() ? (short)(UniLog2SetupConfiguration1.this.configuration.startModus | 1) : (short)(UniLog2SetupConfiguration1.this.configuration.startModus ^ 1);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartCurrentCombo = new CCombo((Composite)this.logStartStopGroup, 2048);
            RowData currentTriggerComboLData = new RowData();
            currentTriggerComboLData.width = 84;
            currentTriggerComboLData.height = 17;
            this.autoStartCurrentCombo.setLayoutData((Object)currentTriggerComboLData);
            this.autoStartCurrentCombo.setItems(this.currentStartValues);
            this.autoStartCurrentCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartCurrentCombo.setEditable(false);
            this.autoStartCurrentCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.autoStartCurrentCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartCurrentCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startCurrent = (short)(UniLog2SetupConfiguration1.this.autoStartCurrentCombo.getSelectionIndex() + 1);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartCurrentUnitLabel = new CLabel((Composite)this.logStartStopGroup, 0);
            RowData currentTriggerUnitLabelLData = new RowData();
            currentTriggerUnitLabelLData.width = 49;
            currentTriggerUnitLabelLData.height = 20;
            this.autoStartCurrentUnitLabel.setLayoutData((Object)currentTriggerUnitLabelLData);
            this.autoStartCurrentUnitLabel.setText("[A]");
            this.autoStartCurrentUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartRxButton = new Button((Composite)this.logStartStopGroup, 16416);
            RowData rxTriggerButtonLData = new RowData();
            rxTriggerButtonLData.width = 130;
            rxTriggerButtonLData.height = 16;
            this.autoStartRxButton.setLayoutData((Object)rxTriggerButtonLData);
            this.autoStartRxButton.setText(Messages.getString((String)"GDE_MSGT2528"));
            this.autoStartRxButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartRxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartRxButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startModus = UniLog2SetupConfiguration1.this.autoStartRxButton.getSelection() ? (short)(UniLog2SetupConfiguration1.this.configuration.startModus | 2) : (short)(UniLog2SetupConfiguration1.this.configuration.startModus ^ 2);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartRxCombo = new CCombo((Composite)this.logStartStopGroup, 2048);
            RowData rxTriggerComboLData = new RowData();
            rxTriggerComboLData.width = 84;
            rxTriggerComboLData.height = 17;
            this.autoStartRxCombo.setLayoutData((Object)rxTriggerComboLData);
            this.autoStartRxCombo.setItems(this.rxStartValues);
            this.autoStartRxCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartRxCombo.setEditable(false);
            this.autoStartRxCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.autoStartRxCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartRxCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startRx = (short)(UniLog2SetupConfiguration1.this.autoStartRxCombo.getSelectionIndex() + 11);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartRxUnitLabel = new CLabel((Composite)this.logStartStopGroup, 0);
            RowData rxTriggerUnitLabelLData = new RowData();
            rxTriggerUnitLabelLData.width = 49;
            rxTriggerUnitLabelLData.height = 20;
            this.autoStartRxUnitLabel.setLayoutData((Object)rxTriggerUnitLabelLData);
            this.autoStartRxUnitLabel.setText(Messages.getString((String)"GDE_MSGT2529"));
            this.autoStartRxUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartTimeButton = new Button((Composite)this.logStartStopGroup, 16416);
            RowData timeTriggerButtonLData = new RowData();
            timeTriggerButtonLData.width = 130;
            timeTriggerButtonLData.height = 16;
            this.autoStartTimeButton.setLayoutData((Object)timeTriggerButtonLData);
            this.autoStartTimeButton.setText(Messages.getString((String)"GDE_MSGT2530"));
            this.autoStartTimeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartTimeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartTimeButton.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startModus = UniLog2SetupConfiguration1.this.autoStartTimeButton.getSelection() ? (short)(UniLog2SetupConfiguration1.this.configuration.startModus | 4) : (short)(UniLog2SetupConfiguration1.this.configuration.startModus ^ 4);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartTimeCombo = new CCombo((Composite)this.logStartStopGroup, 2048);
            RowData timeTriggerComboLData = new RowData();
            timeTriggerComboLData.width = 84;
            timeTriggerComboLData.height = 17;
            this.autoStartTimeCombo.setLayoutData((Object)timeTriggerComboLData);
            this.autoStartTimeCombo.setItems(this.timeStartValues);
            this.autoStartTimeCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStartTimeCombo.setEditable(false);
            this.autoStartTimeCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.autoStartTimeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStartTimeCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.startTime = (short)((UniLog2SetupConfiguration1.this.autoStartTimeCombo.getSelectionIndex() + 1) * 5);
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.autoStartTimeUnitLabel = new CLabel((Composite)this.logStartStopGroup, 0);
            RowData timeTriggerUnitLabelLData = new RowData();
            timeTriggerUnitLabelLData.width = 49;
            timeTriggerUnitLabelLData.height = 20;
            this.autoStartTimeUnitLabel.setLayoutData((Object)timeTriggerUnitLabelLData);
            this.autoStartTimeUnitLabel.setText(Messages.getString((String)"GDE_MSGT2531"));
            this.autoStartTimeUnitLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStopLabel = new CLabel((Composite)this.logStartStopGroup, 0);
            RowData autoStopLabelLData = new RowData();
            autoStopLabelLData.width = 130;
            autoStopLabelLData.height = 20;
            this.autoStopLabel.setLayoutData((Object)autoStopLabelLData);
            this.autoStopLabel.setText(Messages.getString((String)"GDE_MSGT2532"));
            this.autoStopLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.autoStopCombo = new CCombo((Composite)this.logStartStopGroup, 2048);
            this.autoStopCombo.setItems(Messages.getString((String)"GDE_MSGT2519").split(","));
            this.autoStopCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            RowData autoStopComboLData = new RowData();
            autoStopComboLData.width = 84;
            autoStopComboLData.height = 17;
            this.autoStopCombo.setLayoutData((Object)autoStopComboLData);
            this.autoStopCombo.setEditable(false);
            this.autoStopCombo.setBackground(SWTResourceManager.getColor((int)1));
            this.autoStopCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "autoStopCombo.widgetSelected, event=" + String.valueOf(evt));
                    UniLog2SetupConfiguration1.this.configuration.stopModus = (short)UniLog2SetupConfiguration1.this.autoStopCombo.getSelectionIndex();
                    UniLog2SetupConfiguration1.this.dialog.enableSaveConfigurationButton(true);
                }
            });
            this.layout();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public void changeVisibility() {
        this.frskyIdLabel.setVisible(false);
        this.frskyIdCombo.setVisible(false);
        this.fixSerialNumberButton.setVisible(false);
        this.robbeTBoxButton.setVisible(false);
        if (UniLog2SetupConfiguration2.mLinkGroupStatic != null && !UniLog2SetupConfiguration2.mLinkGroupStatic.isDisposed()) {
            UniLog2SetupConfiguration2.mLinkGroupStatic.setVisible(false);
        }
        if (UniLog2SetupConfiguration2.jetiExGroupStatic != null && !UniLog2SetupConfiguration2.jetiExGroupStatic.isDisposed()) {
            UniLog2SetupConfiguration2.jetiExGroupStatic.setVisible(false);
        }
        if (UniLog2SetupConfiguration2.spektrumAdapterGroupStatic != null && !UniLog2SetupConfiguration2.spektrumAdapterGroupStatic.isDisposed()) {
            UniLog2SetupConfiguration2.spektrumAdapterGroupStatic.setVisible(false);
        }
        if (this.telemetrieTypeCombo != null && !this.telemetrieTypeCombo.isDisposed()) {
            switch (this.telemetrieTypeCombo.getSelectionIndex()) {
                case 10: {
                    if (UniLog2SetupConfiguration2.spektrumAdapterGroupStatic == null || UniLog2SetupConfiguration2.spektrumAdapterGroupStatic.isDisposed()) break;
                    UniLog2SetupConfiguration2.spektrumAdapterGroupStatic.setVisible(true);
                    break;
                }
                case 8: {
                    this.frskyIdLabel.setVisible(true);
                    this.frskyIdCombo.setVisible(true);
                    break;
                }
                case 7: {
                    if (UniLog2SetupConfiguration2.mLinkGroupStatic == null) break;
                    UniLog2SetupConfiguration2.mLinkGroupStatic.setVisible(true);
                    break;
                }
                case 6: {
                    this.fixSerialNumberButton.setVisible(true);
                    if (UniLog2SetupConfiguration2.jetiExGroupStatic == null) break;
                    UniLog2SetupConfiguration2.jetiExGroupStatic.setVisible(true);
                    break;
                }
                case 1: {
                    this.fixSerialNumberButton.setVisible(true);
                    this.robbeTBoxButton.setVisible(true);
                    break;
                }
            }
        }
    }
}

