/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;

public class Jdk14Logger
implements Log,
Serializable {
    private static final long serialVersionUID = 4784713551416303804L;
    protected static final Level dummyLevel = Level.FINE;
    protected transient Logger logger = null;
    protected String name = null;

    public Jdk14Logger(String name) {
        this.name = name;
        this.logger = this.getLogger();
    }

    protected void log(Level level, String msg, Throwable ex) {
        Logger logger = this.getLogger();
        if (logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = this.name;
            String method = "unknown";
            if (locations != null && locations.length > 2) {
                StackTraceElement caller2 = locations[2];
                method = caller2.getMethodName();
            }
            if (ex == null) {
                logger.logp(level, cname, method, msg);
            } else {
                logger.logp(level, cname, method, msg, ex);
            }
        }
    }

    public void debug(Object message2) {
        this.log(Level.FINE, String.valueOf(message2), null);
    }

    public void debug(Object message2, Throwable exception) {
        this.log(Level.FINE, String.valueOf(message2), exception);
    }

    public void error(Object message2) {
        this.log(Level.SEVERE, String.valueOf(message2), null);
    }

    public void error(Object message2, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message2), exception);
    }

    public void fatal(Object message2) {
        this.log(Level.SEVERE, String.valueOf(message2), null);
    }

    public void fatal(Object message2, Throwable exception) {
        this.log(Level.SEVERE, String.valueOf(message2), exception);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger(this.name);
        }
        return this.logger;
    }

    public void info(Object message2) {
        this.log(Level.INFO, String.valueOf(message2), null);
    }

    public void info(Object message2, Throwable exception) {
        this.log(Level.INFO, String.valueOf(message2), exception);
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void trace(Object message2) {
        this.log(Level.FINEST, String.valueOf(message2), null);
    }

    public void trace(Object message2, Throwable exception) {
        this.log(Level.FINEST, String.valueOf(message2), exception);
    }

    public void warn(Object message2) {
        this.log(Level.WARNING, String.valueOf(message2), null);
    }

    public void warn(Object message2, Throwable exception) {
        this.log(Level.WARNING, String.valueOf(message2), exception);
    }
}

