/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.SWTException;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.DISPPARAMS;
import org.eclipse.swt.internal.ole.win32.EXCEPINFO;
import org.eclipse.swt.internal.ole.win32.FUNCDESC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.ITypeInfo;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.TYPEATTR;
import org.eclipse.swt.internal.ole.win32.VARDESC;
import org.eclipse.swt.internal.ole.win32.VARIANT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.OlePropertyDescription;
import org.eclipse.swt.ole.win32.Variant;

public final class OleAutomation {
    private IUnknown objIUnknown;
    private IDispatch objIDispatch;
    private String exceptionDescription;
    private ITypeInfo objITypeInfo;

    OleAutomation(IDispatch idispatch) {
        if (idispatch == null) {
            OLE.error(1011);
        }
        this.objIDispatch = idispatch;
        this.objIDispatch.AddRef();
        long[] ppv = new long[1];
        int result2 = this.objIDispatch.GetTypeInfo(0, 2048, ppv);
        if (result2 == 0) {
            this.objITypeInfo = new ITypeInfo(ppv[0]);
        }
    }

    public OleAutomation(OleClientSite clientSite) {
        if (clientSite == null) {
            OLE.error(1011);
        }
        this.objIDispatch = clientSite.getAutomationObject();
        long[] ppv = new long[1];
        int result2 = this.objIDispatch.GetTypeInfo(0, 2048, ppv);
        if (result2 == 0) {
            this.objITypeInfo = new ITypeInfo(ppv[0]);
        }
    }

    public OleAutomation(String progId) {
        try {
            long[] ppvObject;
            int flags;
            int result2;
            OS.OleInitialize(0L);
            GUID appClsid = this.getClassID(progId);
            if (appClsid == null) {
                OS.OleUninitialize();
                OLE.error(1004);
            }
            if ((result2 = COM.CoCreateInstance(appClsid, 0L, flags = 5, COM.IIDIUnknown, ppvObject = new long[1])) != 0) {
                OS.OleUninitialize();
                OLE.error(1001, result2);
            }
            this.objIUnknown = new IUnknown(ppvObject[0]);
            ppvObject[0] = 0L;
            result2 = this.objIUnknown.QueryInterface(COM.IIDIDispatch, ppvObject);
            if (result2 != 0) {
                OLE.error(1003);
            }
            this.objIDispatch = new IDispatch(ppvObject[0]);
            ppvObject[0] = 0L;
            result2 = this.objIDispatch.GetTypeInfo(0, 2048, ppvObject);
            if (result2 == 0) {
                this.objITypeInfo = new ITypeInfo(ppvObject[0]);
            }
        }
        catch (SWTException e2) {
            this.dispose();
            throw e2;
        }
    }

    public void dispose() {
        if (this.objIDispatch != null) {
            this.objIDispatch.Release();
        }
        this.objIDispatch = null;
        if (this.objITypeInfo != null) {
            this.objITypeInfo.Release();
        }
        this.objITypeInfo = null;
        if (this.objIUnknown != null) {
            this.objIUnknown.Release();
            OS.OleUninitialize();
        }
        this.objIUnknown = null;
    }

    long getAddress() {
        return this.objIDispatch.getAddress();
    }

    GUID getClassID(String clientName) {
        int result2;
        GUID guid = new GUID();
        char[] buffer = null;
        if (clientName != null) {
            int count = clientName.length();
            buffer = new char[count + 1];
            clientName.getChars(0, count, buffer, 0);
        }
        if (COM.CLSIDFromProgID(buffer, guid) != 0 && (result2 = COM.CLSIDFromString(buffer, guid)) != 0) {
            return null;
        }
        return guid;
    }

    public String getHelpFile(int dispId) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] file = new String[1];
        int rc = this.objITypeInfo.GetDocumentation(dispId, null, null, null, file);
        if (rc == 0) {
            return file[0];
        }
        return null;
    }

    public String getDocumentation(int dispId) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] doc = new String[1];
        int rc = this.objITypeInfo.GetDocumentation(dispId, null, doc, null, null);
        if (rc == 0) {
            return doc[0];
        }
        return null;
    }

    public OlePropertyDescription getPropertyDescription(int index) {
        if (this.objITypeInfo == null) {
            return null;
        }
        long[] ppVarDesc = new long[1];
        int rc = this.objITypeInfo.GetVarDesc(index, ppVarDesc);
        if (rc != 0) {
            return null;
        }
        VARDESC vardesc = new VARDESC();
        COM.MoveMemory(vardesc, ppVarDesc[0], VARDESC.sizeof);
        OlePropertyDescription data2 = new OlePropertyDescription();
        data2.id = vardesc.memid;
        data2.name = this.getName(vardesc.memid);
        data2.type = vardesc.elemdescVar_tdesc_vt;
        if (data2.type == 26) {
            short[] vt = new short[1];
            OS.MoveMemory(vt, vardesc.elemdescVar_tdesc_union + (long)C.PTR_SIZEOF, 2);
            data2.type = vt[0];
        }
        data2.flags = vardesc.wVarFlags;
        data2.kind = vardesc.varkind;
        data2.description = this.getDocumentation(vardesc.memid);
        data2.helpFile = this.getHelpFile(vardesc.memid);
        this.objITypeInfo.ReleaseVarDesc(ppVarDesc[0]);
        return data2;
    }

    public OleFunctionDescription getFunctionDescription(int index) {
        if (this.objITypeInfo == null) {
            return null;
        }
        long[] ppFuncDesc = new long[1];
        int rc = this.objITypeInfo.GetFuncDesc(index, ppFuncDesc);
        if (rc != 0) {
            return null;
        }
        FUNCDESC funcdesc = new FUNCDESC();
        COM.MoveMemory(funcdesc, ppFuncDesc[0], FUNCDESC.sizeof);
        OleFunctionDescription data2 = new OleFunctionDescription();
        data2.id = funcdesc.memid;
        data2.optionalArgCount = funcdesc.cParamsOpt;
        data2.invokeKind = funcdesc.invkind;
        data2.funcKind = funcdesc.funckind;
        data2.flags = funcdesc.wFuncFlags;
        data2.callingConvention = funcdesc.callconv;
        data2.documentation = this.getDocumentation(funcdesc.memid);
        data2.helpFile = this.getHelpFile(funcdesc.memid);
        String[] names = this.getNames(funcdesc.memid, funcdesc.cParams + 1);
        if (names.length > 0) {
            data2.name = names[0];
        }
        data2.args = new OleParameterDescription[funcdesc.cParams];
        int i2 = 0;
        while (i2 < data2.args.length) {
            data2.args[i2] = new OleParameterDescription();
            if (names.length > i2 + 1) {
                data2.args[i2].name = names[i2 + 1];
            }
            short[] vt = new short[1];
            OS.MoveMemory(vt, funcdesc.lprgelemdescParam + (long)(i2 * COM.ELEMDESC_sizeof()) + (long)C.PTR_SIZEOF, 2);
            if (vt[0] == 26) {
                long[] pTypedesc = new long[1];
                OS.MoveMemory(pTypedesc, funcdesc.lprgelemdescParam + (long)(i2 * COM.ELEMDESC_sizeof()), C.PTR_SIZEOF);
                short[] vt2 = new short[1];
                OS.MoveMemory(vt2, pTypedesc[0] + (long)C.PTR_SIZEOF, 2);
                vt[0] = (short)(vt2[0] | 0x4000);
            }
            data2.args[i2].type = vt[0];
            short[] wParamFlags = new short[1];
            OS.MoveMemory(wParamFlags, funcdesc.lprgelemdescParam + (long)(i2 * COM.ELEMDESC_sizeof()) + (long)COM.TYPEDESC_sizeof() + (long)C.PTR_SIZEOF, 2);
            data2.args[i2].flags = wParamFlags[0];
            ++i2;
        }
        data2.returnType = funcdesc.elemdescFunc_tdesc_vt;
        if (data2.returnType == 26) {
            short[] vt = new short[1];
            OS.MoveMemory(vt, funcdesc.elemdescFunc_tdesc_union + (long)C.PTR_SIZEOF, 2);
            data2.returnType = vt[0];
        }
        this.objITypeInfo.ReleaseFuncDesc(ppFuncDesc[0]);
        return data2;
    }

    public TYPEATTR getTypeInfoAttributes() {
        if (this.objITypeInfo == null) {
            return null;
        }
        long[] ppTypeAttr = new long[1];
        int rc = this.objITypeInfo.GetTypeAttr(ppTypeAttr);
        if (rc != 0) {
            return null;
        }
        TYPEATTR typeattr = new TYPEATTR();
        COM.MoveMemory(typeattr, ppTypeAttr[0], TYPEATTR.sizeof);
        this.objITypeInfo.ReleaseTypeAttr(ppTypeAttr[0]);
        return typeattr;
    }

    public String getName(int dispId) {
        if (this.objITypeInfo == null) {
            return null;
        }
        String[] name = new String[1];
        int rc = this.objITypeInfo.GetDocumentation(dispId, name, null, null, null);
        if (rc == 0) {
            return name[0];
        }
        return null;
    }

    public String[] getNames(int dispId, int maxSize) {
        if (this.objITypeInfo == null) {
            return new String[0];
        }
        String[] names = new String[maxSize];
        int[] count = new int[1];
        int rc = this.objITypeInfo.GetNames(dispId, names, maxSize, count);
        if (rc == 0) {
            String[] newNames = new String[count[0]];
            System.arraycopy(names, 0, newNames, 0, count[0]);
            return newNames;
        }
        return new String[0];
    }

    public int[] getIDsOfNames(String[] names) {
        int[] rgdispid = new int[names.length];
        int result2 = this.objIDispatch.GetIDsOfNames(new GUID(), names, names.length, 2048, rgdispid);
        if (result2 != 0) {
            return null;
        }
        return rgdispid;
    }

    public String getLastError() {
        return this.exceptionDescription;
    }

    public Variant getProperty(int dispIdMember) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 2, null, null, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    public Variant getProperty(int dispIdMember, Variant[] rgvarg) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 2, rgvarg, null, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    public Variant getProperty(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 2, rgvarg, rgdispidNamedArgs, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof OleAutomation) {
            long address2;
            if (this.objIDispatch == null) {
                return false;
            }
            OleAutomation oleAutomation = (OleAutomation)object;
            if (oleAutomation.objIDispatch == null) {
                return false;
            }
            long address1 = this.objIDispatch.getAddress();
            return address1 == (address2 = oleAutomation.objIDispatch.getAddress());
        }
        return false;
    }

    public Variant invoke(int dispIdMember) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 1, null, null, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    public Variant invoke(int dispIdMember, Variant[] rgvarg) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 1, rgvarg, null, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    public Variant invoke(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, 1, rgvarg, rgdispidNamedArgs, pVarResult);
        return result2 == 0 ? pVarResult : null;
    }

    private int invoke(int dispIdMember, int wFlags, Variant[] rgvarg, int[] rgdispidNamedArgs, Variant pVarResult) {
        int i2;
        int offset;
        if (this.objIDispatch == null) {
            return -2147467259;
        }
        DISPPARAMS pDispParams = new DISPPARAMS();
        if (rgvarg != null && rgvarg.length > 0) {
            pDispParams.cArgs = rgvarg.length;
            pDispParams.rgvarg = OS.GlobalAlloc(64, VARIANT.sizeof * rgvarg.length);
            offset = 0;
            i2 = rgvarg.length - 1;
            while (i2 >= 0) {
                rgvarg[i2].getData(pDispParams.rgvarg + (long)offset);
                offset += VARIANT.sizeof;
                --i2;
            }
        }
        if (rgdispidNamedArgs != null && rgdispidNamedArgs.length > 0) {
            pDispParams.cNamedArgs = rgdispidNamedArgs.length;
            pDispParams.rgdispidNamedArgs = OS.GlobalAlloc(64, 4 * rgdispidNamedArgs.length);
            offset = 0;
            i2 = rgdispidNamedArgs.length;
            while (i2 > 0) {
                OS.MoveMemory(pDispParams.rgdispidNamedArgs + (long)offset, new int[]{rgdispidNamedArgs[i2 - 1]}, 4);
                offset += 4;
                --i2;
            }
        }
        EXCEPINFO excepInfo = new EXCEPINFO();
        int[] pArgErr = new int[1];
        long pVarResultAddress = 0L;
        if (pVarResult != null) {
            pVarResultAddress = OS.GlobalAlloc(64, VARIANT.sizeof);
        }
        int result2 = this.objIDispatch.Invoke(dispIdMember, new GUID(), 2048, wFlags, pDispParams, pVarResultAddress, excepInfo, pArgErr);
        if (pVarResultAddress != 0L) {
            pVarResult.setData(pVarResultAddress);
            COM.VariantClear(pVarResultAddress);
            OS.GlobalFree(pVarResultAddress);
        }
        if (pDispParams.rgdispidNamedArgs != 0L) {
            OS.GlobalFree(pDispParams.rgdispidNamedArgs);
        }
        if (pDispParams.rgvarg != 0L) {
            int offset2 = 0;
            int i3 = 0;
            int length = rgvarg.length;
            while (i3 < length) {
                COM.VariantClear(pDispParams.rgvarg + (long)offset2);
                offset2 += VARIANT.sizeof;
                ++i3;
            }
            OS.GlobalFree(pDispParams.rgvarg);
        }
        this.manageExcepinfo(result2, excepInfo);
        return result2;
    }

    public void invokeNoReply(int dispIdMember) {
        int result2 = this.invoke(dispIdMember, 1, null, null, null);
        if (result2 != 0) {
            OLE.error(1014, result2);
        }
    }

    public void invokeNoReply(int dispIdMember, Variant[] rgvarg) {
        int result2 = this.invoke(dispIdMember, 1, rgvarg, null, null);
        if (result2 != 0) {
            OLE.error(1014, result2);
        }
    }

    public void invokeNoReply(int dispIdMember, Variant[] rgvarg, int[] rgdispidNamedArgs) {
        int result2 = this.invoke(dispIdMember, 1, rgvarg, rgdispidNamedArgs, null);
        if (result2 != 0) {
            OLE.error(1014, result2);
        }
    }

    private void manageExcepinfo(int hResult, EXCEPINFO excepInfo) {
        if (hResult == 0) {
            this.exceptionDescription = "No Error";
            return;
        }
        if (hResult == -2147352567) {
            if (excepInfo.bstrDescription != 0L) {
                int size = COM.SysStringByteLen(excepInfo.bstrDescription);
                char[] buffer = new char[(size + 1) / 2];
                OS.MoveMemory(buffer, excepInfo.bstrDescription, size);
                this.exceptionDescription = new String(buffer);
            } else {
                this.exceptionDescription = "OLE Automation Error Exception ";
                if (excepInfo.wCode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + excepInfo.wCode;
                } else if (excepInfo.scode != 0) {
                    this.exceptionDescription = String.valueOf(this.exceptionDescription) + "code = " + excepInfo.scode;
                }
            }
        } else {
            this.exceptionDescription = "OLE Automation Error HResult : " + hResult;
        }
        if (excepInfo.bstrDescription != 0L) {
            COM.SysFreeString(excepInfo.bstrDescription);
        }
        if (excepInfo.bstrHelpFile != 0L) {
            COM.SysFreeString(excepInfo.bstrHelpFile);
        }
        if (excepInfo.bstrSource != 0L) {
            COM.SysFreeString(excepInfo.bstrSource);
        }
    }

    public boolean setProperty(int dispIdMember, Variant rgvarg) {
        Variant pVarResult;
        int result2;
        Variant[] rgvarg2 = new Variant[]{rgvarg};
        int[] rgdispidNamedArgs = new int[]{-3};
        int dwFlags = 4;
        if ((rgvarg.getType() & 0x4000) == 16384) {
            dwFlags = 8;
        }
        return (result2 = this.invoke(dispIdMember, dwFlags, rgvarg2, rgdispidNamedArgs, pVarResult = new Variant())) == 0;
    }

    public boolean setProperty(int dispIdMember, Variant[] rgvarg) {
        int[] rgdispidNamedArgs = new int[]{-3};
        int dwFlags = 4;
        int i2 = 0;
        while (i2 < rgvarg.length) {
            if ((rgvarg[i2].getType() & 0x4000) == 16384) {
                dwFlags = 8;
            }
            ++i2;
        }
        Variant pVarResult = new Variant();
        int result2 = this.invoke(dispIdMember, dwFlags, rgvarg, rgdispidNamedArgs, pVarResult);
        return result2 == 0;
    }
}

