/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.xhtmlrenderer.util.Uu;

public class Util {
    private PrintWriter pw = null;
    private boolean on = true;

    public Util(PrintWriter writer) {
        this.pw = writer;
    }

    public Util(OutputStream out) {
        this.pw = new PrintWriter(out);
    }

    public void print(Object o2) {
        this.println(o2, false);
    }

    public void println(Object o2) {
        this.println(o2, true);
    }

    public void println(Object o2, boolean line2) {
        if (o2 == null) {
            this.ps("null");
            return;
        }
        if (o2 instanceof Object[]) {
            this.print_array((Object[])o2);
            return;
        }
        if (o2 instanceof int[]) {
            this.print_array((int[])o2);
        }
        if (o2 instanceof String) {
            this.ps((String)o2, line2);
            return;
        }
        if (o2 instanceof Exception) {
            this.ps(Util.stack_to_string((Exception)o2));
            return;
        }
        if (o2 instanceof Vector) {
            this.print_vector((Vector)o2);
            return;
        }
        if (o2 instanceof Hashtable) {
            this.print_hashtable((Hashtable)o2);
            return;
        }
        if (o2 instanceof Date) {
            this.print_date((Date)o2);
            return;
        }
        if (o2 instanceof Calendar) {
            this.print_calendar((Calendar)o2);
            return;
        }
        this.ps(o2.toString(), line2);
    }

    public void print_vector(Vector v2) {
        this.ps("vector: size=" + v2.size());
        for (int i2 = 0; i2 < v2.size(); ++i2) {
            this.ps(v2.elementAt(i2).toString());
        }
    }

    public void print_array(int[][] array) {
        this.print("array: size=" + array.length + " by " + array[0].length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            for (int j2 = 0; j2 < array[i2].length; ++j2) {
                this.ps(array[i2][j2] + " ", false);
            }
            this.print("");
        }
    }

    public void print_array(Object[] array) {
        this.print("array: size=" + array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.ps(" " + array[i2].toString(), false);
        }
    }

    public void print_array(int[] array) {
        this.print("array: size=" + array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.ps(" " + array[i2], false);
        }
    }

    public void print_hashtable(Hashtable h2) {
        this.print("hashtable size=" + h2.size());
        Enumeration keys2 = h2.keys();
        while (keys2.hasMoreElements()) {
            String key2 = (String)keys2.nextElement();
            this.print(key2 + " = ");
            this.print(h2.get(key2).toString());
        }
    }

    public void print_array(byte[] array) {
        this.print("byte array: size = " + array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            this.print("" + array[i2]);
        }
    }

    public void print_date(Date date) {
        DateFormat date_format = DateFormat.getDateTimeInstance(1, 1);
        this.print(date_format.format(date));
    }

    public void print_calendar(Calendar cal) {
        this.print(cal.getTime());
    }

    public void printUnixtime(long sec) {
        this.print(new Date(sec * 1000L));
    }

    public void setOn(boolean on) {
        this.on = on;
    }

    public void setPrintWriter(PrintWriter writer) {
        this.pw = writer;
    }

    private void ps(String s2) {
        this.ps(s2, true);
    }

    private void ps(String s2, boolean line2) {
        if (!this.on) {
            return;
        }
        if (line2) {
            if (this.pw == null) {
                System.out.println(s2);
            } else {
                this.pw.println(s2);
            }
        } else if (this.pw == null) {
            System.out.print(s2);
        } else {
            this.pw.print(s2);
        }
    }

    public static String file_to_string(String filename) throws FileNotFoundException, IOException {
        File file = new File(filename);
        return Util.file_to_string(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void string_to_file(String text2, File file) throws IOException {
        FileWriter writer = null;
        writer = new FileWriter(file);
        try {
            int n2;
            StringReader reader = new StringReader(text2);
            char[] buf = new char[1000];
            while ((n2 = reader.read(buf, 0, 1000)) != -1) {
                writer.write(buf, 0, n2);
            }
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public static int string_to_int(String str) {
        return Integer.parseInt(str);
    }

    public static String stack_to_string(Exception e2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e2.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String stack_to_string(Throwable e2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e2.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public static String inputstream_to_string(InputStream in) throws IOException {
        int n2;
        InputStreamReader reader = new InputStreamReader(in);
        StringWriter writer = new StringWriter();
        char[] buf = new char[1000];
        while ((n2 = ((Reader)reader).read(buf, 0, 1000)) != -1) {
            writer.write(buf, 0, n2);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String file_to_string(File file) throws IOException {
        String str;
        FileReader reader = null;
        StringWriter writer = null;
        try {
            int n2;
            reader = new FileReader(file);
            writer = new StringWriter();
            char[] buf = new char[1000];
            while ((n2 = reader.read(buf, 0, 1000)) != -1) {
                writer.write(buf, 0, n2);
            }
            str = writer.toString();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return str;
    }

    public static String replace(String source, String target, String replacement) {
        StringBuffer output = new StringBuffer();
        int n2 = 0;
        while (true) {
            int off;
            if ((off = source.indexOf(target, n2)) == -1) break;
            output.append(source.substring(n2, off));
            output.append(replacement);
            n2 = off + target.length();
        }
        output.append(source.substring(n2));
        return output.toString();
    }

    public static String[] vector_to_strings(Vector v2) {
        int len = v2.size();
        String[] ret = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = v2.elementAt(i2).toString();
        }
        return ret;
    }

    public static String[] list_to_strings(List l2) {
        int len = l2.size();
        String[] ret = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            ret[i2] = l2.get(i2).toString();
        }
        return ret;
    }

    public static List toList(Object[] array) {
        return Util.to_list(array);
    }

    public static List to_list(Object[] array) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        for (int i2 = 0; i2 < array.length; ++i2) {
            list2.add(array[i2]);
        }
        return list2;
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException ex) {
            Uu.p(Util.stack_to_string(ex));
        }
    }

    public static void center(JFrame frame) {
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((int)((screen_size.getWidth() - (double)frame.getWidth()) / 2.0), (int)((screen_size.getHeight() - (double)frame.getHeight()) / 2.0));
    }

    public static void center(JDialog frame) {
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((int)((screen_size.getWidth() - (double)frame.getWidth()) / 2.0), (int)((screen_size.getHeight() - (double)frame.getHeight()) / 2.0));
    }

    public static boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e2) {
            return false;
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNullOrEmpty(String str, boolean trim) {
        return str == null || str.length() == 0 || trim && str.trim().length() == 0;
    }

    public static boolean isEqual(String str1, String str2) {
        return str1 == str2 || str1 != null && str1.equals(str2);
    }

    public static boolean isEqual(String str1, String str2, boolean ignoreCase) {
        return str1 == str2 || str1 != null && (ignoreCase ? str1.equalsIgnoreCase(str2) : str1.equals(str2));
    }
}

