/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;

public final class Region
extends Resource {
    public int handle;

    public Region() {
        this(null);
    }

    public Region(Device device) {
        super(device);
        this.handle = OS.gdk_region_new();
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    Region(Device device, int n) {
        super(device);
        this.handle = n;
    }

    public void add(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        int n = OS.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_union(this.handle, n);
        OS.gdk_region_destroy(n);
    }

    public void add(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void add(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        OS.gdk_region_union_with_rect(this.handle, gdkRectangle);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_union(this.handle, region.handle);
    }

    public boolean contains(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_point_in(this.handle, n, n2);
    }

    public boolean contains(Point point) {
        if (point == null) {
            SWT.error(4);
        }
        return this.contains(point.x, point.y);
    }

    @Override
    void destroy() {
        OS.gdk_region_destroy(this.handle);
        this.handle = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region region = (Region)object;
        return this.handle == region.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gdk_region_get_clipbox(this.handle, gdkRectangle);
        return new Rectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
    }

    public static Region gtk_new(Device device, int n) {
        return new Region(device, n);
    }

    public int hashCode() {
        return this.handle;
    }

    public void intersect(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.intersect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void intersect(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        int n5 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_intersect(this.handle, n5);
        OS.gdk_region_destroy(n5);
    }

    public void intersect(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_intersect(this.handle, region.handle);
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        return OS.gdk_region_rect_in(this.handle, gdkRectangle) != 1;
    }

    public boolean intersects(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        return this.intersects(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.gdk_region_empty(this.handle);
    }

    public void subtract(int[] nArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length < 6) {
            return;
        }
        int n = OS.gdk_region_polygon(nArray, nArray.length / 2, 0);
        OS.gdk_region_subtract(this.handle, n);
        OS.gdk_region_destroy(n);
    }

    public void subtract(Rectangle rectangle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.subtract(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void subtract(int n, int n2, int n3, int n4) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (n3 < 0 || n4 < 0) {
            SWT.error(5);
        }
        GdkRectangle gdkRectangle = new GdkRectangle();
        gdkRectangle.x = n;
        gdkRectangle.y = n2;
        gdkRectangle.width = n3;
        gdkRectangle.height = n4;
        int n5 = OS.gdk_region_rectangle(gdkRectangle);
        OS.gdk_region_subtract(this.handle, n5);
        OS.gdk_region_destroy(n5);
    }

    public void subtract(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.gdk_region_subtract(this.handle, region.handle);
    }

    public void translate(int n, int n2) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.gdk_region_offset(this.handle, n, n2);
    }

    public void translate(Point point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        this.translate(point.x, point.y);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

