/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optimization.direct;

import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;

@Deprecated
public class MultivariateFunctionPenaltyAdapter
implements MultivariateFunction {
    private final MultivariateFunction bounded;
    private final double[] lower;
    private final double[] upper;
    private final double offset;
    private final double[] scale;

    public MultivariateFunctionPenaltyAdapter(MultivariateFunction bounded, double[] lower, double[] upper, double offset, double[] scale2) {
        MathUtils.checkNotNull(lower);
        MathUtils.checkNotNull(upper);
        MathUtils.checkNotNull(scale2);
        if (lower.length != upper.length) {
            throw new DimensionMismatchException(lower.length, upper.length);
        }
        if (lower.length != scale2.length) {
            throw new DimensionMismatchException(lower.length, scale2.length);
        }
        for (int i2 = 0; i2 < lower.length; ++i2) {
            if (upper[i2] >= lower[i2]) continue;
            throw new NumberIsTooSmallException(upper[i2], (Number)lower[i2], true);
        }
        this.bounded = bounded;
        this.lower = (double[])lower.clone();
        this.upper = (double[])upper.clone();
        this.offset = offset;
        this.scale = (double[])scale2.clone();
    }

    public double value(double[] point) {
        for (int i2 = 0; i2 < this.scale.length; ++i2) {
            if (!(point[i2] < this.lower[i2]) && !(point[i2] > this.upper[i2])) continue;
            double sum = 0.0;
            for (int j2 = i2; j2 < this.scale.length; ++j2) {
                double overshoot = point[j2] < this.lower[j2] ? this.scale[j2] * (this.lower[j2] - point[j2]) : (point[j2] > this.upper[j2] ? this.scale[j2] * (point[j2] - this.upper[j2]) : 0.0);
                sum += FastMath.sqrt(overshoot);
            }
            return this.offset + sum;
        }
        return this.bounded.value(point);
    }
}

