/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.fluent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

class InternalByteArrayEntity
extends AbstractHttpEntity
implements Cloneable {
    private final byte[] b;
    private final int off;
    private final int len;

    public InternalByteArrayEntity(byte[] b2, ContentType contentType) {
        Args.notNull(b2, "Source byte array");
        this.b = b2;
        this.off = 0;
        this.len = this.b.length;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] b2, int off, int len, ContentType contentType) {
        Args.notNull(b2, "Source byte array");
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        this.b = b2;
        this.off = off;
        this.len = len;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public InternalByteArrayEntity(byte[] b2) {
        this(b2, null);
    }

    public InternalByteArrayEntity(byte[] b2, int off, int len) {
        this(b2, off, len, null);
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.b, this.off, this.len);
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "Output stream");
        outStream.write(this.b, this.off, this.len);
        outStream.flush();
    }

    @Override
    public boolean isStreaming() {
        return false;
    }
}

