/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class FillLayout
extends Layout {
    public int type = 256;
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int spacing = 0;

    public FillLayout() {
    }

    public FillLayout(int type2) {
        this.type = type2;
    }

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        int maxWidth = 0;
        int maxHeight = 0;
        int i2 = 0;
        while (i2 < count) {
            Control child = children[i2];
            int w2 = wHint;
            int h2 = hHint;
            if (count > 0) {
                if (this.type == 256 && wHint != -1) {
                    w2 = Math.max(0, (wHint - (count - 1) * this.spacing) / count);
                }
                if (this.type == 512 && hHint != -1) {
                    h2 = Math.max(0, (hHint - (count - 1) * this.spacing) / count);
                }
            }
            Point size = this.computeChildSize(child, w2, h2, flushCache);
            maxWidth = Math.max(maxWidth, size.x);
            maxHeight = Math.max(maxHeight, size.y);
            ++i2;
        }
        int width = 0;
        int height = 0;
        if (this.type == 256) {
            width = count * maxWidth;
            if (count != 0) {
                width += (count - 1) * this.spacing;
            }
            height = maxHeight;
        } else {
            width = maxWidth;
            height = count * maxHeight;
            if (count != 0) {
                height += (count - 1) * this.spacing;
            }
        }
        width += this.marginWidth * 2;
        height += this.marginHeight * 2;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    Point computeChildSize(Control control, int wHint, int hHint, boolean flushCache) {
        FillData data2 = (FillData)control.getLayoutData();
        if (data2 == null) {
            data2 = new FillData();
            control.setLayoutData(data2);
        }
        Point size = null;
        if (wHint == -1 && hHint == -1) {
            size = data2.computeSize(control, wHint, hHint, flushCache);
        } else {
            int trimY;
            int trimX;
            if (control instanceof Scrollable) {
                Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                trimX = rect.width;
                trimY = rect.height;
            } else {
                trimX = trimY = control.getBorderWidth() * 2;
            }
            int w2 = wHint == -1 ? wHint : Math.max(0, wHint - trimX);
            int h2 = hHint == -1 ? hHint : Math.max(0, hHint - trimY);
            size = data2.computeSize(control, w2, h2, flushCache);
        }
        return size;
    }

    @Override
    protected boolean flushCache(Control control) {
        Object data2 = control.getLayoutData();
        if (data2 != null) {
            ((FillData)data2).flushCache();
        }
        return true;
    }

    String getName() {
        String string2 = this.getClass().getName();
        int index = string2.lastIndexOf(46);
        if (index == -1) {
            return string2;
        }
        return string2.substring(index + 1, string2.length());
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return;
        }
        int width = rect.width - this.marginWidth * 2;
        int height = rect.height - this.marginHeight * 2;
        if (this.type == 256) {
            int x2 = rect.x + this.marginWidth;
            int extra = (width -= (count - 1) * this.spacing) % count;
            int y2 = rect.y + this.marginHeight;
            int cellWidth = width / count;
            int i2 = 0;
            while (i2 < count) {
                Control child = children[i2];
                int childWidth = cellWidth;
                if (i2 == 0) {
                    childWidth += extra / 2;
                } else if (i2 == count - 1) {
                    childWidth += (extra + 1) / 2;
                }
                child.setBounds(x2, y2, childWidth, height);
                x2 += childWidth + this.spacing;
                ++i2;
            }
        } else {
            int x3 = rect.x + this.marginWidth;
            int cellHeight = (height -= (count - 1) * this.spacing) / count;
            int y3 = rect.y + this.marginHeight;
            int extra = height % count;
            int i3 = 0;
            while (i3 < count) {
                Control child = children[i3];
                int childHeight = cellHeight;
                if (i3 == 0) {
                    childHeight += extra / 2;
                } else if (i3 == count - 1) {
                    childHeight += (extra + 1) / 2;
                }
                child.setBounds(x3, y3, width, childHeight);
                y3 += childHeight + this.spacing;
                ++i3;
            }
        }
    }

    public String toString() {
        String string2 = String.valueOf(this.getName()) + " {";
        string2 = String.valueOf(string2) + "type=" + (this.type == 512 ? "SWT.VERTICAL" : "SWT.HORIZONTAL") + " ";
        if (this.marginWidth != 0) {
            string2 = String.valueOf(string2) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string2 = String.valueOf(string2) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.spacing != 0) {
            string2 = String.valueOf(string2) + "spacing=" + this.spacing + " ";
        }
        string2 = string2.trim();
        string2 = String.valueOf(string2) + "}";
        return string2;
    }
}

