/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import gde.device.TrailTypes;
import gde.histo.cache.DataTypes;
import gde.histo.cache.HistoVault;
import gde.histo.cache.PointType;
import java.util.HashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="compartmentType", propOrder={"trails"})
public class CompartmentType {
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=HistoVault.PointsTypeAdapter.class)
    protected HashMap<Integer, PointType> trails;
    @XmlAttribute(required=true)
    protected int id;
    @XmlAttribute(required=true)
    protected String text;
    @XmlAttribute(required=true)
    protected DataTypes dataType;
    @XmlAttribute
    protected String outlierPoints;
    @XmlAttribute
    protected String scrappedPoints;

    public CompartmentType() {
    }

    public CompartmentType(int newId, String newText, DataTypes newDataType) {
        this.id = newId;
        this.text = newText;
        this.dataType = newDataType;
    }

    public void addPoint(TrailTypes newTrailType, int newValue) {
        PointType newPoint = new PointType(newTrailType.ordinal(), newTrailType.name(), newValue);
        this.getTrails().put(newTrailType.ordinal(), newPoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.trails != null) {
            for (PointType dataPoint : this.trails.values()) {
                sb.append(dataPoint.getName().toLowerCase()).append("=").append(dataPoint.getValue()).append(" ");
            }
        }
        return sb.toString();
    }

    public HashMap<Integer, PointType> getTrails() {
        if (this.trails == null) {
            this.trails = new HashMap();
        }
        return this.trails;
    }

    public void setTrails(HashMap<Integer, PointType> value) {
        this.trails = value;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        this.text = value;
    }

    public DataTypes getDataType() {
        return this.dataType;
    }

    public void setDataType(DataTypes value) {
        this.dataType = value;
    }

    public String getOutlierPoints() {
        return this.outlierPoints;
    }

    public void setOutlierPoints(String value) {
        this.outlierPoints = value;
    }

    public String getScrappedPoints() {
        return this.scrappedPoints;
    }

    public void setScrappedPoints(String value) {
        this.scrappedPoints = value;
    }
}

