/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.device.IDevice;
import gde.histo.cache.HistoVault;
import gde.histo.cache.VaultCollector;
import gde.histo.utils.SecureHash;
import gde.log.Logger;
import gde.utils.StringHelper;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ExtendedVault
extends HistoVault
implements Comparable<ExtendedVault> {
    private static final String $CLASS_NAME = ExtendedVault.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final String SHA1_DELIMITER = ",";
    private static final String timestampFormat = "yyyy-MM-dd HH:mm:ss";
    private final Path loadFilePath;
    private final String loadObjectDirectory;
    private Path loadLinkPath;

    public static String getVaultDirectoryName(IDevice device, Settings settings, int channelNumber, String vaultReaderSettings) {
        String d = SHA1_DELIMITER;
        String tmpSubDirectoryLongKey = GDE.VERSION_NUMBER + SHA1_DELIMITER + device.getDeviceConfiguration().getFileSha1Hash() + SHA1_DELIMITER + channelNumber + SHA1_DELIMITER + settings.getDataFilePath() + SHA1_DELIMITER + settings.getSamplingTimespan_ms() + SHA1_DELIMITER + settings.getMinmaxQuantileDistance() + SHA1_DELIMITER + settings.getAbsoluteTransitionLevel() + SHA1_DELIMITER + settings.isCanonicalQuantiles() + SHA1_DELIMITER + settings.isSymmetricToleranceInterval() + SHA1_DELIMITER + settings.getOutlierToleranceSpread() + SHA1_DELIMITER + vaultReaderSettings;
        log.fine(() -> device.getName() + " " + SecureHash.sha1(tmpSubDirectoryLongKey) + " " + tmpSubDirectoryLongKey);
        return SecureHash.sha1(tmpSubDirectoryLongKey);
    }

    public static String getVaultName(Path newLogFileName, long newFileLastModified_ms, long newFileLength, int newLogRecordSetOrdinal, IDevice device, Settings settings, int channelNumber, String vaultReaderSettings) {
        String d = SHA1_DELIMITER;
        String vaultDirectoryName = ExtendedVault.getVaultDirectoryName(device, settings, channelNumber, vaultReaderSettings);
        return SecureHash.sha1(vaultDirectoryName + SHA1_DELIMITER + String.valueOf(newLogFileName.getFileName()) + SHA1_DELIMITER + newFileLastModified_ms + SHA1_DELIMITER + newFileLength + SHA1_DELIMITER + newLogRecordSetOrdinal);
    }

    public static ExtendedVault createExtendedVault(HistoVault histoVault, VaultCollector truss) {
        return new ExtendedVault(histoVault, truss.getVault().loadLinkPath, truss.getVault().loadFilePath, truss.getVault().loadObjectDirectory);
    }

    public ExtendedVault(String objectDirectory, Path filePath, long fileLastModified_ms, long fileLength, int fileVersion, int logRecordSetSize, int logRecordSetOrdinal, String logRecordSetBaseName, String logDeviceName, Analyzer analyzer, long logStartTimestamp_ms, int logChannelNumber, String logObjectKey, String vaultReaderSettings) {
        this.loadFilePath = filePath;
        this.loadObjectDirectory = objectDirectory;
        this.loadLinkPath = Paths.get("", new String[0]);
        this.vaultDataExplorerVersion = "" + GDE.VERSION_NUMBER;
        this.vaultDeviceName = analyzer.getActiveDevice().getName();
        this.vaultDeviceKey = analyzer.getActiveDevice().getDeviceConfiguration().getFileSha1Hash();
        this.vaultChannelNumber = analyzer.getActiveChannel().getNumber();
        this.vaultObjectKey = analyzer.getSettings().getActiveObjectKey();
        this.vaultSamplingTimespan_ms = analyzer.getSettings().getSamplingTimespan_ms();
        this.logLinkPath = "";
        this.logFilePath = filePath.toString().replace(GDE.FILE_SEPARATOR, "/");
        this.logFileLastModified = fileLastModified_ms;
        this.logFileLength = fileLength;
        this.logFileVersion = fileVersion;
        this.logObjectDirectory = objectDirectory;
        this.logRecordSetSize = logRecordSetSize;
        this.logRecordSetOrdinal = logRecordSetOrdinal;
        this.logRecordsetBaseName = logRecordSetBaseName;
        this.logDeviceName = logDeviceName;
        this.logChannelNumber = logChannelNumber;
        this.logObjectKey = logObjectKey;
        this.logStartTimestamp_ms = logStartTimestamp_ms;
        this.vaultDirectory = ExtendedVault.getVaultDirectoryName(analyzer.getActiveDevice(), analyzer.getSettings(), analyzer.getActiveChannel().getNumber(), vaultReaderSettings);
        this.vaultName = ExtendedVault.getVaultName(filePath, fileLastModified_ms, fileLength, logRecordSetOrdinal, analyzer.getActiveDevice(), analyzer.getSettings(), analyzer.getActiveChannel().getNumber(), vaultReaderSettings);
        this.vaultCreated_ms = System.currentTimeMillis();
        this.vaultReaderSettings = vaultReaderSettings;
        log.finer(() -> String.format("HistoVault.ctor  objectDirectory=%s  path=%s  lastModified=%s  logRecordSetOrdinal=%d  logRecordSetBaseName=%s  startTimestamp_ms=%d   channelConfigNumber=%d   objectKey=%s", objectDirectory, filePath.getFileName().toString(), logRecordSetBaseName, StringHelper.getFormatedTime("yyyy-MM-dd HH:mm:ss.SSS", this.logFileLastModified), StringHelper.getFormatedTime("yyyy-MM-dd HH:mm:ss.SSS", this.logStartTimestamp_ms), logChannelNumber, logObjectKey));
        log.finer(() -> String.format("vaultDirectory=%s  vaultName=%s", this.vaultDirectory, this.vaultName));
    }

    private ExtendedVault(HistoVault histoVault, Path loadLinkPath, Path loadFilePath, String loadObjectDirectory) {
        this.loadFilePath = loadFilePath;
        this.loadObjectDirectory = loadObjectDirectory;
        this.loadLinkPath = loadLinkPath;
        this.vaultName = histoVault.vaultName;
        this.vaultDirectory = histoVault.vaultDirectory;
        this.vaultCreated_ms = histoVault.vaultCreated_ms;
        this.vaultReaderSettings = histoVault.vaultReaderSettings;
        this.vaultDataExplorerVersion = histoVault.vaultDataExplorerVersion;
        this.vaultDeviceKey = histoVault.vaultDeviceKey;
        this.vaultDeviceName = histoVault.vaultDeviceName;
        this.vaultChannelNumber = histoVault.vaultChannelNumber;
        this.vaultObjectKey = histoVault.vaultObjectKey;
        this.vaultSamplingTimespan_ms = histoVault.vaultSamplingTimespan_ms;
        this.logLinkPath = histoVault.logLinkPath;
        this.logFilePath = histoVault.logFilePath;
        this.logFileLastModified = histoVault.logFileLastModified;
        this.logFileLength = histoVault.logFileLength;
        this.logFileVersion = histoVault.logFileVersion;
        this.logObjectDirectory = histoVault.logObjectDirectory;
        this.logRecordSetSize = histoVault.logRecordSetSize;
        this.logRecordSetOrdinal = histoVault.logRecordSetOrdinal;
        this.logRecordsetBaseName = histoVault.logRecordsetBaseName;
        this.logDeviceName = histoVault.logDeviceName;
        this.logChannelNumber = histoVault.logChannelNumber;
        this.logObjectKey = histoVault.logObjectKey;
        this.logStartTimestamp_ms = histoVault.logStartTimestamp_ms;
        this.measurements = histoVault.measurements;
        this.settlements = histoVault.settlements;
        this.scores = histoVault.scores;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        String d = ", ";
        sb.append(this.loadLinkPath).append(", ");
        sb.append(this.loadFilePath).append(", ");
        return sb.toString();
    }

    public String getStartTimeStampFormatted() {
        return StringHelper.getFormatedTime(timestampFormat, this.logStartTimestamp_ms);
    }

    public String getLoadFileExtension() {
        String extension = "";
        int i = this.loadFilePath.toString().lastIndexOf(46);
        if (i > 0) {
            extension = this.loadFilePath.toString().substring(i + 1);
        }
        return extension;
    }

    public String getLoadFileName() {
        return this.loadFilePath.getFileName().toString();
    }

    public Path getLoadFileAsPath() {
        return this.loadFilePath;
    }

    public Path getVaultDirectoryPath() {
        return Paths.get(this.vaultDirectory, new String[0]);
    }

    public Path getVaultFileName() {
        return Paths.get(this.vaultName, new String[0]);
    }

    public String getRectifiedObjectKey() {
        return this.logObjectKey.isEmpty() ? this.loadObjectDirectory : this.logObjectKey;
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + this.logChannelNumber;
        hashCode = 31 * hashCode + (this.logDeviceName == null ? 0 : this.logDeviceName.hashCode());
        hashCode = 31 * hashCode + (int)(this.logStartTimestamp_ms ^ this.logStartTimestamp_ms >>> 32);
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoVault other = (HistoVault)obj;
        if (this.logChannelNumber != other.logChannelNumber) {
            return false;
        }
        if (this.logDeviceName == null ? other.logDeviceName != null : !this.logDeviceName.equals(other.logDeviceName)) {
            return false;
        }
        return this.logStartTimestamp_ms == other.logStartTimestamp_ms;
    }

    @Override
    public int compareTo(ExtendedVault o) {
        return Long.compare(o.logStartTimestamp_ms, this.logStartTimestamp_ms);
    }

    public static String getSha1Delimiter() {
        return SHA1_DELIMITER;
    }

    public String getLoadFilePath() {
        return this.loadFilePath.toString();
    }

    public Path getLoadLinkPath() {
        return this.loadLinkPath;
    }

    public void setLoadLinkPath(Path loadLinkPath) {
        this.loadLinkPath = loadLinkPath;
    }

    public String getLoadObjectDirectory() {
        return this.loadObjectDirectory;
    }

    public boolean isTruss() {
        return this.getMeasurements().isEmpty();
    }
}

