/*
 * Decompiled with CFR 0.152.
 */
package gde.device.powerbox;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementType;
import gde.device.powerbox.CoreAdapter;
import gde.device.powerbox.TelemetryData;
import gde.exception.DataInconsitsentException;
import gde.exception.DataTypeException;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;

public class CoreDataReader {
    static Logger log = Logger.getLogger(CoreDataReader.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static StringBuffer sb;
    static final DataExplorer application;
    static final Channels channels;
    static final TreeSet<TelemetryData.TelemetrySensor> sensorData;
    static long startTimeStamp;

    public static RecordSet read(String filePath, CoreAdapter device, String recordNameExtend, Integer channelConfigNumber, boolean isRaw) throws NotSupportedFileFormatException, IOException, DataInconsitsentException, DataTypeException {
        RecordSet recordSet;
        block52: {
            recordSet = null;
            Channel activeChannel = null;
            String dateTime = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new File(filePath).lastModified());
            boolean isOutdated = false;
            int lineNumber = 0;
            int activeChannelConfigNumber = 1;
            Object recordSetNameExtend = device.getRecordSetStemNameReplacement();
            double time_ms = 0.0;
            String appVer = "";
            String tcFwVer = "";
            String scFwVer = "";
            String modelName = "";
            boolean isSensorTable = false;
            boolean isStartLogEntries = false;
            long startTime_ms = 0L;
            int[] points = null;
            long lastEntryTime_ms = 0L;
            try {
                activeChannel = channelConfigNumber == null ? channels.getActiveChannel() : (Channel)channels.get((Object)channelConfigNumber);
                if (activeChannel == null) break block52;
                GDE.getUiNotification().setStatusMessage(Messages.getString((String)"GDE_MSGT0594") + filePath);
                GDE.getUiNotification().setProgress(0);
                activeChannelConfigNumber = activeChannel.getNumber();
                if (GDE.isWithUi()) {
                    channels.switchChannel(activeChannel.getNumber(), "");
                    application.getMenuToolBar().updateChannelSelector();
                    activeChannel = channels.getActiveChannel();
                }
                Object recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                int measurementSize = device.getNumberOfMeasurements(activeChannelConfigNumber);
                int dataBlockSize = device.getDataBlockSize(InputTypes.FILE_IO);
                log.log(Level.FINE, "measurementSize = " + measurementSize + "; dataBlockSize = " + dataBlockSize);
                if (measurementSize < Math.abs(dataBlockSize)) {
                    throw new DevicePropertiesInconsistenceException(Messages.getString((String)"GDE_MSGE0041", (Object[])new String[]{filePath}));
                }
                sensorData.clear();
                int line = 0;
                try {
                    String searchPath = filePath.substring(0, filePath.lastIndexOf(GDE.FILE_SEPARATOR));
                    String filter = filePath.substring(filePath.lastIndexOf(GDE.FILE_SEPARATOR) + 1, filePath.lastIndexOf(95) - 3);
                    List logFiles = FileUtils.getFileListing((File)new File(searchPath), (int)0, (String)filter);
                    int numberLogFiles = logFiles.size();
                    int numberProcessedLogFiles = 1;
                    for (File logFile : logFiles) {
                        int progress;
                        Object strLine;
                        log.log(Level.INFO, logFile.getAbsolutePath());
                        line = 0;
                        FileInputStream fis = new FileInputStream(logFile);
                        InputStreamReader in = new InputStreamReader((InputStream)fis, "ISO-8859-1");
                        BufferedReader br = new BufferedReader(in);
                        while ((strLine = br.readLine()) != null) {
                            ++line;
                            if (((String)(strLine = ((String)strLine).trim())).length() == 0 || ((String)strLine).startsWith("#")) {
                                if (((String)strLine).startsWith("#AppVer")) {
                                    appVer = ((String)strLine).substring(8).trim();
                                    continue;
                                }
                                if (((String)strLine).startsWith("#TCfwVer")) {
                                    tcFwVer = ((String)strLine).substring(9).trim();
                                    continue;
                                }
                                if (((String)strLine).startsWith("#SCfwVer")) {
                                    scFwVer = ((String)strLine).substring(9).trim();
                                    continue;
                                }
                                if (((String)strLine).startsWith("#Model=")) {
                                    modelName = ((String)strLine).substring(7, ((String)strLine).indexOf(64)).trim();
                                    continue;
                                }
                                if (((String)strLine).startsWith("#SensorsTable")) {
                                    isSensorTable = true;
                                    isStartLogEntries = false;
                                    log.log(Level.INFO, "SensorsTable");
                                    continue;
                                }
                                if (!((String)strLine).startsWith("#Time")) continue;
                                if (isSensorTable) {
                                    recordSetNameExtend = device.getRecordSetStateNameReplacement(1);
                                    if (recordNameExtend.length() > 0) {
                                        recordSetNameExtend = (String)recordSetNameExtend + " [" + recordNameExtend + "]";
                                    }
                                    recordSetName = activeChannel.size() + 1 + ") " + (String)recordSetNameExtend;
                                    int index = 0;
                                    Vector<String> vecRecordNames = new Vector<String>();
                                    HashMap<Integer, Record.DataType> mapRecordType = new HashMap<Integer, Record.DataType>();
                                    for (TelemetryData.TelemetrySensor telemetrySensor : sensorData) {
                                        boolean isActualgps = false;
                                        for (TelemetryData.TelemetryVar telemetryVar : telemetrySensor.getVariables()) {
                                            String newRecordName = telemetryVar.getName().trim();
                                            while (vecRecordNames.contains(newRecordName)) {
                                                newRecordName = String.format("%s %s", newRecordName, telemetrySensor.getName());
                                                telemetryVar.setName(newRecordName);
                                            }
                                            vecRecordNames.add(newRecordName);
                                            if (log.isLoggable(Level.INFO)) {
                                                log.log(Level.INFO, String.format("add new record = %s [%s]", newRecordName, telemetryVar.getUnit()));
                                            }
                                            if (telemetryVar.getDataType() == 9 && !telemetrySensor.getName().equals("Core") && !telemetrySensor.getName().equals("Atom")) {
                                                if (telemetryVar.getName().toLowerCase().startsWith("lon") || telemetryVar.getName().toLowerCase().startsWith("l\u00e4n")) {
                                                    isActualgps = true;
                                                    mapRecordType.put(index, Record.DataType.GPS_LATITUDE);
                                                    telemetryVar.unit = "\u00b0";
                                                } else if (telemetryVar.getName().toLowerCase().startsWith("lat") || telemetryVar.getName().toLowerCase().startsWith("breit")) {
                                                    isActualgps = true;
                                                    mapRecordType.put(index, Record.DataType.GPS_LONGITUDE);
                                                    telemetryVar.unit = "\u00b0";
                                                }
                                            } else if (isActualgps && telemetryVar.getUnit().contains("\u00b0") && telemetryVar.getParam() == 10) {
                                                mapRecordType.put(index, Record.DataType.GPS_AZIMUTH);
                                            } else if ((telemetryVar.getName().toLowerCase().endsWith("hoehe") || telemetryVar.getName().toLowerCase().contains("h\u00f6he") || telemetryVar.getName().toLowerCase().contains("height") || telemetryVar.getName().toLowerCase().contains("alt")) && telemetryVar.getUnit().equals("m")) {
                                                mapRecordType.put(index, Record.DataType.GPS_ALTITUDE);
                                            } else if ((telemetryVar.getName().toLowerCase().contains("speed") || telemetryVar.getName().toLowerCase().contains("geschw")) && (telemetryVar.getUnit().equals("km/h") || telemetryVar.getUnit().equals("kmh") || telemetryVar.getUnit().equals("kph") || telemetryVar.getUnit().equals("m/s"))) {
                                                mapRecordType.put(index, Record.DataType.GPS_SPEED);
                                            }
                                            if (log.isLoggable(Level.FINE)) {
                                                log.log(Level.FINE, "param = " + telemetryVar.getParam());
                                            }
                                            device.setMeasurementName(activeChannelConfigNumber, index, telemetryVar.getName());
                                            device.setMeasurementUnit(activeChannelConfigNumber, index, telemetryVar.getUnit());
                                            ++index;
                                        }
                                    }
                                    String[] recordNames = vecRecordNames.toArray(new String[0]);
                                    String[] recordSymbols = new String[recordNames.length];
                                    String[] recordUnits = new String[recordNames.length];
                                    for (int i = 0; i < recordNames.length; ++i) {
                                        MeasurementType measurementType = device.getMeasurement(activeChannelConfigNumber, i);
                                        recordSymbols[i] = measurementType.getSymbol();
                                        recordUnits[i] = measurementType.getUnit();
                                    }
                                    recordSet = RecordSet.createRecordSet((String)recordSetName, (IDevice)device, (int)activeChannelConfigNumber, (String[])recordNames, (String[])recordSymbols, (String[])recordUnits, (double)device.getTimeStep_ms(), (boolean)isRaw, (boolean)true, (boolean)true);
                                    for (Map.Entry entry : mapRecordType.entrySet()) {
                                        recordSet.get(((Integer)entry.getKey()).intValue()).setDataType((Record.DataType)entry.getValue());
                                    }
                                    recordSetName = recordSet.getName();
                                    try {
                                        isOutdated = Integer.parseInt(dateTime.split("-")[0]) <= 2000;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    activeChannel.put(recordSetName, (Object)recordSet);
                                    if (log.isLoggable(Level.FINE)) {
                                        log.log(Level.FINE, device.getNumberOfMeasurements(activeChannelConfigNumber) + " - " + recordSet.size());
                                    }
                                    points = new int[recordNames.length];
                                }
                                try {
                                    startTime_ms = Long.parseLong(((String)strLine).substring(8).trim(), 16) * 1000L;
                                    isSensorTable = false;
                                    isStartLogEntries = true;
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, logFile.getName() + " line # " + line + " failed parsing " + ((String)strLine).substring(8));
                                }
                                continue;
                            }
                            if (isSensorTable) {
                                strLine = "000000000;" + (String)strLine;
                            } else if (isStartLogEntries && ((String)strLine).startsWith(":")) {
                                try {
                                    long entryTime_ms = startTime_ms + (long)(Integer.parseInt(((String)strLine).substring(1, 3)) * 1000);
                                    strLine = String.format("%09d;%s", entryTime_ms, ((String)strLine).substring(4));
                                    if (entryTime_ms > lastEntryTime_ms) {
                                        recordSet.addPoints(points, time_ms);
                                        if (lastEntryTime_ms != 0L) {
                                            time_ms += (double)(entryTime_ms - lastEntryTime_ms);
                                        }
                                        lastEntryTime_ms = entryTime_ms;
                                    }
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, logFile.getName() + " line # " + line + " failed parsing " + (String)strLine);
                                }
                            }
                            ArrayList<String> array = new ArrayList<String>();
                            array.addAll(Arrays.asList(((String)strLine).replace("|", ";").split(";")));
                            if (array == null || array.size() <= 0) continue;
                            if (array.size() == 4) {
                                array.add("");
                                continue;
                            }
                            CoreDataReader.parseLineParams(array.toArray(new String[5]), recordSet, points, logFile.getName(), line);
                        }
                        in.close();
                        if ((progress = numberProcessedLogFiles++ * 100 / numberLogFiles) > 90 || progress <= GDE.getUiNotification().getProgressPercentage()) continue;
                        GDE.getUiNotification().setProgress(progress);
                    }
                }
                catch (Exception e) {
                    TelemetryData.log.log(Level.SEVERE, e.getMessage(), e);
                    DataExplorer.getInstance().openMessageDialogAsync(Messages.getString((String)"GDE_MSGE2952", (Object[])new String[]{filePath, String.valueOf(line)}));
                }
                GDE.getUiNotification().setProgress(99);
                activeChannel.setActiveRecordSet((String)recordSetName);
                activeChannel.applyTemplate((String)recordSetName, true);
                device.updateVisibilityStatus((RecordSet)activeChannel.get(recordSetName), true);
                if (!isOutdated) {
                    long startTimeStamp = (long)((double)new File(filePath).lastModified() - ((RecordSet)activeChannel.get(recordSetName)).getMaxTime_ms());
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(startTimeStamp));
                    ((RecordSet)activeChannel.get(recordSetName)).setStartTimeStamp(startTimeStamp);
                    activeChannel.setFileDescription(dateTime.substring(0, 10) + activeChannel.getFileDescription().substring(10));
                } else {
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(device.getName() + " - " + Messages.getString((String)"GDE_MSGT0129") + new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss").format(new Date()));
                }
                ((RecordSet)activeChannel.get(recordSetName)).descriptionAppendFilename(filePath.substring(filePath.lastIndexOf(47) + 1));
                if (modelName.length() > 2) {
                    ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(Messages.getString((String)"GDE_MSGT2964", (Object[])new String[]{((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription(), modelName}));
                }
                ((RecordSet)activeChannel.get(recordSetName)).setRecordSetDescription(((RecordSet)activeChannel.get(recordSetName)).getRecordSetDescription() + "\n#AppVer=" + appVer + " #TCfwVer=" + tcFwVer + " #SCfwVer=" + scFwVer);
                ((RecordSet)activeChannel.get(recordSetName)).checkAllDisplayable();
                ((RecordSet)activeChannel.get(recordSetName)).updateVisibleAndDisplayableRecordsForTable();
                GDE.getUiNotification().setProgress(100);
                if (GDE.isWithUi()) {
                    activeChannel.switchRecordSet((String)recordSetName);
                }
            }
            catch (Exception e) {
                if (activeChannel != null && activeChannel.size() > 0) {
                    String recordSetName = activeChannel.getFirstRecordSetName();
                    activeChannel.setActiveRecordSet(recordSetName);
                    device.updateVisibilityStatus((RecordSet)activeChannel.get((Object)recordSetName), true);
                    ((RecordSet)activeChannel.get((Object)recordSetName)).checkAllDisplayable();
                    GDE.getUiNotification().setProgress(100);
                    if (GDE.isWithUi()) {
                        activeChannel.switchRecordSet(recordSetName);
                    }
                }
                String msg = filePath + " - " + Messages.getString((String)"GDE_MSGE0045", (Object[])new Object[]{e.getMessage(), lineNumber});
                log.log(Level.WARNING, msg, e);
                application.openMessageDialog(msg);
            }
        }
        return recordSet;
    }

    static void parseLineParams(String[] params, RecordSet recordSet, int[] points, String fileName, int lineNumber) {
        boolean ST_TIME = false;
        boolean ST_DEVICE_ID = true;
        int ST_PARAM_NUM = 2;
        int ST_START_INDEX = 3;
        int ST_DECIMALS = 4;
        int ST_VALUES = 5;
        int ST_SENSOR = 6;
        int ST_LABEL = 7;
        int ST_UNIT = 8;
        int state = 0;
        long timestamp = 0L;
        long deviceId = 0L;
        int paramId = 0;
        int dataType = 0;
        int decimals = 0;
        String sensor = "";
        String label = "";
        String unit = "";
        if (params == null) {
            return;
        }
        for (String param : params) {
            try {
                switch (state) {
                    case 0: {
                        timestamp = Long.parseLong(param);
                        state = 1;
                        break;
                    }
                    case 1: {
                        try {
                            deviceId = Long.parseLong(!param.startsWith(" ") || !param.endsWith("0") ? param.replace(' ', '0') : param);
                        }
                        catch (Exception e) {
                            log.log(Level.WARNING, "skip | param = " + param);
                        }
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (param == null) break;
                        paramId = Integer.parseInt(param.trim());
                        if (timestamp == 0L) {
                            state = 6;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    case 6: {
                        sensor = param;
                        if (timestamp == 0L && paramId == 0) {
                            if (TelemetryData.log.isLoggable(Level.INFO)) {
                                TelemetryData.log.log(Level.INFO, "adding sensor " + sensor);
                            }
                            TelemetryData.TelemetrySensor telemetrySensor = new TelemetryData.TelemetrySensor(deviceId, sensor);
                            sensorData.add(telemetrySensor);
                        }
                        state = 7;
                        break;
                    }
                    case 7: {
                        label = param.trim();
                        state = 8;
                        break;
                    }
                    case 8: {
                        unit = param;
                        state = 4;
                        break;
                    }
                    case 4: {
                        TelemetryData.TelemetrySensor s;
                        decimals = Integer.parseInt(param);
                        TelemetryData.TelemetryVar var = new TelemetryData.TelemetryVar(paramId, label, unit, decimals);
                        if (label.toLowerCase().startsWith("lon") || label.toLowerCase().startsWith("l\u00e4n") || label.toLowerCase().startsWith("lat") || label.toLowerCase().startsWith("brei")) {
                            var.setDataType(9);
                        }
                        if ((s = CoreDataReader.getSensor(deviceId)) != null) {
                            if (TelemetryData.log.isLoggable(Level.FINER)) {
                                TelemetryData.log.log(Level.FINER, String.format("%s %03d add variable %s[%s] ID=%d", s.getName(), deviceId, var.name, unit, paramId));
                            }
                            s.addVariable(var);
                        }
                        return;
                    }
                    case 3: {
                        state = 5;
                        break;
                    }
                    case 5: {
                        int val = 0;
                        try {
                            if (param.startsWith("0x")) {
                                switch (param.length()) {
                                    case 10: {
                                        dataType = 9;
                                        val = Integer.parseInt(param.substring(2), 16) / 10;
                                        break;
                                    }
                                    default: {
                                        dataType = 1;
                                        val = Integer.valueOf(param.substring(2), 16).shortValue();
                                        break;
                                    }
                                }
                            } else {
                                state = 5;
                                break;
                            }
                            TelemetryData.TelemetryVar sensorVar = CoreDataReader.getSensor(deviceId).getVar(paramId);
                            if (sensorVar != null) {
                                int pontsIndex = recordSet.get((Object)sensorVar.name).getOrdinal();
                                points[pontsIndex] = dataType == 9 ? val : val * 1000 / (int)Math.pow(10.0, sensorVar.decimals);
                            }
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, fileName + " line # " + lineNumber + " failed parsing " + param);
                        }
                        if (startTimeStamp == 0L) {
                            if (TelemetryData.log.isLoggable(Level.FINER)) {
                                TelemetryData.log.log(Level.FINER, "set startTimeStamp = " + timestamp);
                            }
                            startTimeStamp = timestamp;
                        }
                        paramId += dataType == 9 ? 2 : 1;
                        state = 5;
                    }
                }
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, fileName + " line # " + lineNumber + " failed parsing " + param);
            }
        }
    }

    private static TelemetryData.TelemetrySensor getSensor(long id) {
        for (TelemetryData.TelemetrySensor s : sensorData) {
            if (s.id != id) continue;
            return s;
        }
        return null;
    }

    static {
        application = DataExplorer.getInstance();
        channels = Channels.getInstance();
        sensorData = new TreeSet();
        startTimeStamp = 0L;
    }
}

