/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.comm.DeviceCommPort;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.graupner.UltraDuoPlusDialog;
import gde.device.graupner.Ultramat;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Logger;

public class UltramatSerialPort
extends DeviceCommPort {
    static final String $CLASS_NAME = UltramatSerialPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    static final byte[] RESET_CONFIG = new byte[]{12, 65, 55, 48, 48, 48, 48, 68, 56, 13};
    static final byte[] RESET = new byte[]{12, 67, 48, 48, 48, 48, 48, 68, 51, 13};
    static final byte[] READ_MEMORY_NAME = new byte[]{12, 56, 48, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MEMORY_NAME = new byte[]{12, 48, 48};
    static final byte[] READ_MEMORY_SETUP = new byte[]{12, 56, 49, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MEMORY_SETUP = new byte[]{12, 48, 49};
    static final byte[] READ_MEMORY_STEP_CHARGE_SETUP = new byte[]{12, 56, 50, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_STEP_CHARGE_SETUP = new byte[]{12, 48, 50};
    static final byte[] READ_MEMORY_CYCLE_DATA = new byte[]{12, 56, 51, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_CYCLE_DATA = new byte[]{12, 48, 51};
    static final byte[] READ_MEMORY_TRACE_DATA = new byte[]{12, 56, 52, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_TRACE_DATA = new byte[]{12, 48, 52};
    static final byte[] READ_TIRE_HEATER = new byte[]{12, 56, 53, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_TIRE_HEATER = new byte[]{12, 48, 53};
    static final byte[] READ_MOTOR_RUN = new byte[]{12, 56, 54, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_MOTOR_RUN = new byte[]{12, 48, 54};
    static final byte[] READ_CHANNEL_SETUP = new byte[]{12, 56, 55, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_CHANNEL_SETUP = new byte[]{12, 48, 55};
    static final byte[] READ_DEVICE_IDENTIFIER_NAME = new byte[]{12, 56, 56, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_DEVICE_IDENTIFIER_NAME = new byte[]{12, 48, 56};
    static final byte[] READ_GRAPHICS_DATA = new byte[]{12, 56, 57, 48, 48, 48, 48, 48, 48, 13};
    static final byte[] WRITE_GRAPHICS_DATA = new byte[]{12, 48, 57};
    static int SIZE_MEMORY_SETUP = 28;
    static final int SIZE_MEMORY_STEP_CHARGE_SETUP = 20;
    static int SIZE_MEMORY_TRACE = 6;
    static int SIZE_MEMORY_CYCLE = 121;
    static int SIZE_CHANNEL_1_SETUP = 16;
    static final int SIZE_CHANNEL_2_SETUP = 4;
    static final int SIZE_TIRE_HEATER_SETUP = 8;
    static final int SIZE_MOTOR_RUN_SETUP = 17;
    static final int xferErrorLimit = 15;
    boolean isInSync = false;
    boolean isDataMissmatchWarningWritten = false;
    int dataCheckSumOffset = 0;
    boolean isCmdMissmatchWarningWritten = false;
    int cmdCheckSumOffset = 0;

    public UltramatSerialPort(Ultramat currentDevice, DataExplorer currentApplication) {
        super((IDevice)currentDevice, currentApplication);
        switch (currentDevice.getDeviceTypeIdentifier()) {
            case UltraDuoPlus40: {
                SIZE_CHANNEL_1_SETUP = 19;
                SIZE_MEMORY_SETUP = 27;
                break;
            }
            case UltraDuoPlus45: {
                SIZE_CHANNEL_1_SETUP = 19;
                SIZE_MEMORY_TRACE = 5;
                break;
            }
            case UltraDuoPlus50: {
                SIZE_CHANNEL_1_SETUP = 16;
                SIZE_MEMORY_TRACE = 5;
                SIZE_MEMORY_SETUP = 27;
                break;
            }
            default: {
                SIZE_CHANNEL_1_SETUP = 16;
            }
        }
    }

    public UltramatSerialPort(DeviceConfiguration deviceConfiguration) {
        super(deviceConfiguration);
    }

    public synchronized byte[] getData(boolean checkBeginEndSignature) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.device.getDataBlockSize(InputTypes.SERIAL_IO))];
        byte[] answer = new byte[]{0};
        try {
            answer = new byte[data.length];
            answer = this.read(data, 3000);
            while (answer[0] != 12) {
                this.isInSync = false;
                for (int i = 1; i < answer.length; ++i) {
                    if (answer[i] != 12) continue;
                    System.arraycopy(answer, i, data, 0, data.length - i);
                    answer = new byte[i];
                    answer = this.read(answer, 1000);
                    System.arraycopy(answer, 0, data, data.length - i, i);
                    this.isInSync = true;
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "getData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                this.addXferError();
                log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "getData", "=====> unable to synchronize received data, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of transfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                answer = new byte[data.length];
                answer = this.read(answer, 3000);
            }
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "getData", StringHelper.convert2CharString((byte[])data));
            if (checkBeginEndSignature && (data[0] != 12 || data[data.length - 1] != 13)) {
                this.addXferError();
                log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "getData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                data = this.getData(true);
            }
            if (checkBeginEndSignature && !this.isChecksumOK(data)) {
                this.addXferError();
                log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "getData", "=====> checksum error occured, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                data = this.getData(true);
            }
        }
        catch (Exception e) {
            if (!(e instanceof TimeOutException)) {
                log.logp(java.util.logging.Level.SEVERE, $CLASS_NAME, "getData", e.getMessage(), e);
            }
            throw e;
        }
        return data;
    }

    public synchronized String readDeviceUserName() throws IOException, TimeOutException, SerialPortException {
        byte[] answer = this.readConfigData(READ_DEVICE_IDENTIFIER_NAME, 23, 2);
        return String.format("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", answer[1], answer[2], answer[3], answer[4], answer[5], answer[6], answer[7], answer[8], answer[9], answer[10], answer[11], answer[12], answer[13], answer[14], answer[15], answer[16]);
    }

    public synchronized String readChannelData(int channelNumber) throws IOException, TimeOutException, SerialPortException {
        if (channelNumber == 1) {
            return new String(this.readConfigData(READ_CHANNEL_SETUP, SIZE_CHANNEL_1_SETUP * 4 + 7, channelNumber)).substring(1, SIZE_CHANNEL_1_SETUP * 4 + 1);
        }
        if (channelNumber == 2) {
            return new String(this.readConfigData(READ_CHANNEL_SETUP, 23, channelNumber)).substring(1, 17);
        }
        return "";
    }

    public synchronized String readMemoryName(int number) throws IOException, TimeOutException, SerialPortException {
        byte[] answer = this.readConfigData(READ_MEMORY_NAME, 23, number);
        for (int i = 1; i < answer.length - 1; ++i) {
            if (answer[i] >= 31 && answer[i] <= 126) continue;
            answer[i] = 32;
        }
        return String.format("%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c%c", answer[1], answer[2], answer[3], answer[4], answer[5], answer[6], answer[7], answer[8], answer[9], answer[10], answer[11], answer[12], answer[13], answer[14], answer[15], answer[16]);
    }

    public synchronized String readMemorySetup(int number) throws IOException, TimeOutException, SerialPortException {
        switch (((Ultramat)this.device).getDeviceTypeIdentifier()) {
            case UltraDuoPlus40: 
            case UltraDuoPlus50: {
                return new String(this.readConfigData(READ_MEMORY_SETUP, SIZE_MEMORY_SETUP * 4 + 3, number)).substring(1, SIZE_MEMORY_SETUP * 4 + 1);
            }
        }
        return new String(this.readConfigData(READ_MEMORY_SETUP, SIZE_MEMORY_SETUP * 4 + 7, number)).substring(1, SIZE_MEMORY_SETUP * 4 + 1);
    }

    public synchronized String readMemoryTrace(int number) throws IOException, TimeOutException, SerialPortException {
        return new String(this.readConfigData(READ_MEMORY_TRACE_DATA, SIZE_MEMORY_TRACE * 4 + 7, number)).substring(1, SIZE_MEMORY_TRACE * 4 + 1);
    }

    public synchronized String readMemoryCycle(int number) throws IOException, TimeOutException, SerialPortException {
        return new String(this.readConfigData(READ_MEMORY_CYCLE_DATA, SIZE_MEMORY_CYCLE * 4 + 7, number)).substring(1, SIZE_MEMORY_CYCLE * 4 + 1);
    }

    public synchronized String readMemoryStepChargeSetup(int number) throws IOException, TimeOutException, SerialPortException {
        return new String(this.readConfigData(READ_MEMORY_STEP_CHARGE_SETUP, 87, number)).substring(1, 81);
    }

    public synchronized byte[] readConfigData(byte[] type, int expectedDataSize, int index) throws IOException, TimeOutException, SerialPortException {
        String $METHOD_NAME = "readConfigData";
        log.logp(java.util.logging.Level.FINEST, $CLASS_NAME, "readConfigData", "entry");
        byte[] readBuffer = new byte[expectedDataSize];
        if (this.isConnected()) {
            byte[] writeBuffer = type;
            byte[] num = String.format("%02X", index).getBytes();
            System.arraycopy(num, 0, writeBuffer, 3, 2);
            byte[] checkSum = this.getChecksum(writeBuffer);
            System.arraycopy(checkSum, 0, writeBuffer, 5, 4);
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", "write = " + StringHelper.convert2CharString((byte[])writeBuffer));
            this.write(writeBuffer);
            byte[] answer = this.read(readBuffer, 3000);
            while (answer[0] != 12) {
                this.isInSync = false;
                for (int i = 1; i < answer.length; ++i) {
                    if (answer[i] != 12) continue;
                    System.arraycopy(answer, i, readBuffer, 0, readBuffer.length - i);
                    answer = new byte[i];
                    answer = this.read(answer, 1000);
                    System.arraycopy(answer, 0, readBuffer, readBuffer.length - i, i);
                    this.isInSync = true;
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", "----> receive sync finished");
                    break;
                }
                if (this.isInSync) break;
                this.addXferError();
                log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "readConfigData", "=====> unable to synchronize received data, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                answer = new byte[expectedDataSize];
                answer = this.read(answer, 3000);
            }
            if (readBuffer[0] != 12 || readBuffer[readBuffer.length - 1] != 6 || !this.isCommandChecksumOK(readBuffer)) {
                this.addXferError();
                log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "readConfigData", "=====> data start or end does not match, number of errors = " + this.getXferErrors());
                if (this.getXferErrors() > 15) {
                    throw new SerialPortException("Number of tranfer error exceed the acceptable limit of 15");
                }
                this.write(RESET);
                readBuffer = this.readConfigData(type, expectedDataSize, index);
            }
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", "readBuffer = " + StringHelper.convert2CharString((byte[])readBuffer));
        }
        return readBuffer;
    }

    public synchronized void readGraphicsData(byte[][] graphicsRecordSetData, int channelNumber, UltraDuoPlusDialog dialog) throws IOException, TimeOutException, SerialPortException {
        String $METHOD_NAME = "readConfigData";
        log.logp(java.util.logging.Level.FINEST, $CLASS_NAME, "readConfigData", "entry");
        Vector<Byte> graphicsData = new Vector<Byte>();
        int redPoints = 0;
        int numBytes = 1;
        dialog.setGraphicsDataReadProgress(redPoints);
        if (this.isConnected()) {
            for (int i = 0; i < 3; ++i) {
                int j;
                byte[] writeBuffer = READ_GRAPHICS_DATA;
                byte[] num = String.format("%d%X", i, channelNumber).getBytes();
                System.arraycopy(num, 0, writeBuffer, 3, 2);
                byte[] checkSum = this.getChecksum(writeBuffer);
                System.arraycopy(checkSum, 0, writeBuffer, 5, 4);
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", "write = " + StringHelper.convert2CharString((byte[])writeBuffer));
                this.write(writeBuffer);
                byte[] readBuffer = new byte[9];
                byte[] answer = this.read(readBuffer, 3000);
                int numOfPoints = Integer.parseInt(String.format("%c%c%c%c", answer[1], answer[2], answer[3], answer[4]), 16);
                int timeStep_sec = Integer.parseInt(String.format("%c%c%c%c", answer[5], answer[6], answer[7], answer[8]), 16);
                numBytes = numOfPoints * 3 * 4 + 27 + 5;
                for (byte b : answer) {
                    graphicsData.add(b);
                }
                dialog.setGraphicsDataReadProgress((redPoints += 9) * 100 / numBytes);
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", String.format("numOfPoints = %d; timeStep_sec = %d", numOfPoints, timeStep_sec));
                readBuffer = new byte[numOfPoints];
                for (j = 0; j < 4; ++j) {
                    for (byte b : answer = this.read(readBuffer, 5000)) {
                        graphicsData.add(b);
                    }
                    dialog.setGraphicsDataReadProgress((redPoints += numOfPoints) * 100 / numBytes);
                }
                readBuffer = new byte[1];
                while (readBuffer[0] != 6) {
                    answer = this.read(readBuffer, 1000);
                    graphicsData.add(answer[0]);
                    dialog.setGraphicsDataReadProgress(++redPoints * 100 / numBytes);
                }
                readBuffer = new byte[graphicsData.size()];
                for (j = 0; j < readBuffer.length; ++j) {
                    readBuffer[j] = (Byte)graphicsData.elementAt(j);
                }
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "readConfigData", "readBuffer = " + StringHelper.convert2CharString((byte[])readBuffer));
                graphicsRecordSetData[i] = (byte[])readBuffer.clone();
                graphicsData.clear();
            }
            dialog.setGraphicsDataReadProgress(redPoints * 100 / numBytes);
        }
    }

    public synchronized void writeConfigData(byte[] type, byte[] configData, int index) throws IOException, TimeOutException {
        String $METHOD_NAME = "writeConfigData";
        log.logp(java.util.logging.Level.FINEST, $CLASS_NAME, "writeConfigData", "entry");
        byte[] writeBuffer = new byte[configData.length + 10];
        if (this.isConnected()) {
            System.arraycopy(type, 0, writeBuffer, 0, 3);
            writeBuffer[writeBuffer.length - 1] = 13;
            byte[] num = String.format("%02X", index).getBytes();
            System.arraycopy(num, 0, writeBuffer, 3, 2);
            System.arraycopy(configData, 0, writeBuffer, 5, configData.length);
            byte[] checkSum = this.getChecksum(writeBuffer);
            System.arraycopy(checkSum, 0, writeBuffer, writeBuffer.length - 5, 4);
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "writeConfigData", "answer = " + StringHelper.convert2CharString((byte[])writeBuffer));
            this.write(writeBuffer);
            byte[] answer = this.read(new byte[1], 3000);
            log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "writeConfigData", "answer = " + StringHelper.convert2CharString((byte[])answer));
            if (answer[0] == 21) {
                log.log(java.util.logging.Level.WARNING, "Writing UltraDuoPlus configuration type (" + new String(type) + ") data failed!");
                throw new IOException("Writing UltraDuoPlus configuration type (" + new String(type) + ") data failed!");
            }
        }
    }

    private synchronized boolean isChecksumOK(byte[] buffer) {
        int buffer_check_sum;
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        int length = buffer.length;
        int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)(length - 6));
        if (check_sum == (buffer_check_sum = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)buffer[length - 5]), Character.valueOf((char)buffer[length - 4]), Character.valueOf((char)buffer[length - 3]), Character.valueOf((char)buffer[length - 2])), 16)) || check_sum == buffer_check_sum - this.dataCheckSumOffset) {
            isOK = true;
        } else if (!this.isDataMissmatchWarningWritten) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "isChecksumOK", "check sum missmatch detected, calculates check_sum = " + check_sum + "; delta to data contained delta = " + (buffer_check_sum - check_sum));
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "isChecksumOK", StringHelper.convert2CharString((byte[])buffer));
            this.isDataMissmatchWarningWritten = true;
            this.dataCheckSumOffset = buffer_check_sum - check_sum;
            isOK = true;
        }
        return isOK;
    }

    private synchronized boolean isCommandChecksumOK(byte[] buffer) {
        int buffer_check_sum;
        String $METHOD_NAME = "isChecksumOK";
        boolean isOK = false;
        int length = buffer.length;
        int check_sum = Checksum.ADD((byte[])buffer, (int)1, (int)(length - 7));
        if (check_sum == (buffer_check_sum = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)buffer[length - 6]), Character.valueOf((char)buffer[length - 5]), Character.valueOf((char)buffer[length - 4]), Character.valueOf((char)buffer[length - 3])), 16)) || check_sum == buffer_check_sum - this.cmdCheckSumOffset) {
            isOK = true;
        } else if (!this.isDataMissmatchWarningWritten) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "isChecksumOK", "check sum missmatch detected, calculates check_sum = " + check_sum + "; delta to data contained delta = " + (buffer_check_sum - check_sum));
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "isChecksumOK", StringHelper.convert2CharString((byte[])buffer));
            this.isDataMissmatchWarningWritten = true;
            this.dataCheckSumOffset = buffer_check_sum - check_sum;
            isOK = true;
        }
        return isOK;
    }

    private synchronized byte[] getChecksum(byte[] buffer) {
        String $METHOD_NAME = "getChecksum";
        String check_sum = String.format("%04X", Checksum.ADD((byte[])buffer, (int)1, (int)(buffer.length - 6)));
        log.logp(java.util.logging.Level.FINER, $CLASS_NAME, "getChecksum", "Check_sum char[]= " + check_sum);
        return check_sum.getBytes();
    }

    public synchronized Vector<byte[]> readMemoryCycleData(int memoryNumber) throws SerialPortException, IOException, TimeOutException {
        Vector<byte[]> result = new Vector<byte[]>();
        String memoryCycleData = this.readMemoryCycle(memoryNumber);
        for (int i = 0; i < 11; ++i) {
            int startIndex = i * 44;
            int endIndex = (i + 1) * 44;
            result.add(memoryCycleData.substring(startIndex, endIndex).getBytes());
        }
        return result;
    }

    public synchronized void writeMemoryCycleData(int memoryNumber, Vector<byte[]> cyclesData) throws SerialPortException, IOException, TimeOutException {
        StringBuilder sb = new StringBuilder();
        for (byte[] bytes : cyclesData) {
            sb.append(new String(bytes));
        }
        log.log(Level.FINER, sb.toString());
        this.writeConfigData(WRITE_CYCLE_DATA, sb.toString().getBytes(), memoryNumber);
    }
}

