/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import gde.log.Logger;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class WatchDir {
    private static final String $CLASS_NAME = WatchDir.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    public static final long DELAY = 222L;
    private final WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final boolean recursive;
    private boolean trace = false;
    private boolean hasChangedLogFiles = false;
    private Predicate<Path> logFileFilter;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.trace) {
            Path prev = this.keys.get(key);
            if (prev == null) {
                System.out.format("register: %s\n", dir);
            } else if (!dir.equals(prev)) {
                System.out.format("update: %s -> %s\n", prev, dir);
            }
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatchDir.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    WatchDir(List<Path> dirs, boolean recursive, Predicate<Path> logFileFilter) throws IOException {
        this.recursive = recursive;
        this.logFileFilter = logFileFilter;
        if (recursive) {
            for (Path dir : dirs) {
                if (FileUtils.checkDirectoryExist(dir.toString())) {
                    log.log(Level.FINE, "Watching tree ", dir);
                    this.registerAll(dir);
                    continue;
                }
                log.log(Level.WARNING, "Watching tree does not exist", dir);
            }
        } else {
            for (Path dir : dirs) {
                if (FileUtils.checkDirectoryExist(dir.toString())) {
                    log.log(Level.FINE, "Watching dir ", dir);
                    this.register(dir);
                    continue;
                }
                log.log(Level.WARNING, "Watching dir does not exist", dir);
            }
        }
        log.log(Level.FINE, "All paths registered.");
    }

    public void processEvents() {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                try {
                    this.watcher.close();
                    log.log(Level.FINER, "terminated by InterruptedException");
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                }
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                System.err.println("WatchKey not recognized!!");
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = WatchDir.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                log.finer(() -> String.format("%s: %s", event.kind().name(), child));
                if (this.recursive && kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    try {
                        if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerAll(child);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                boolean isValidChange = Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS) ? true : this.logFileFilter.test(child);
                this.hasChangedLogFiles |= isValidChange;
                if (!isValidChange) continue;
                DirectoryNotification.addAndShow(child);
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    public synchronized boolean hasChangedLogFilesThenReset() {
        boolean result = this.hasChangedLogFiles;
        this.hasChangedLogFiles = false;
        return result;
    }

    public boolean hasChangedLogFiles() {
        return this.hasChangedLogFiles;
    }

    public void setChangedLogFiles(boolean hasChangedLogFiles) {
        this.hasChangedLogFiles = hasChangedLogFiles;
    }

    public String toString() {
        return "WatchDir [keys=" + String.valueOf(this.keys) + ", recursive=" + this.recursive + ", hasChangedLogFiles=" + this.hasChangedLogFiles + "]";
    }

    private static final class DirectoryNotification {
        private static final String $CLASS_NAME = DirectoryNotification.class.getName();
        private static final Logger log = Logger.getLogger($CLASS_NAME);
        private static final int color = 9;
        private static DirectoryNotification directoryNotification;
        private TimerTask timerTask;
        private final Set<Path> paths = new HashSet<Path>();

        public static synchronized void addAndShow(Path logFilePath) {
            if (DirectoryNotification.refreshInstance()) {
                // empty if block
            }
            DirectoryNotification.directoryNotification.paths.add(logFilePath);
            log.finest(() -> String.valueOf(directoryNotification) + " " + logFilePath.toString());
        }

        private static synchronized boolean refreshInstance() {
            if (directoryNotification == null || DirectoryNotification.directoryNotification.timerTask.scheduledExecutionTime() < System.currentTimeMillis() - 11L) {
                directoryNotification = new DirectoryNotification();
                log.log(Level.FINE, "new instance created " + String.valueOf(directoryNotification));
                return true;
            }
            return false;
        }

        private DirectoryNotification() {
            final Timer timer = new Timer("timer");
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    this.showStatusMessage(timer);
                }
            };
            timer.schedule(this.timerTask, 222L);
        }

        private void showStatusMessage(Timer timer) {
            String concatenatedNames = this.paths.stream().map(Path::getFileName).map(Path::toString).sorted().collect(Collectors.joining(" | "));
            DataExplorer.getInstance().getPresentHistoExplorer().setVolatileStatusMessage(Messages.getString("GDE_MSGT0800") + concatenatedNames, 9);
            timer.cancel();
        }
    }
}

