/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.Analyzer;
import gde.data.RecordSet;
import gde.device.ChannelType;
import gde.device.SettlementType;
import gde.device.TransitionAmountType;
import gde.device.TransitionCalculusType;
import gde.device.TransitionFigureType;
import gde.device.TransitionGroupType;
import gde.histo.settlements.AmountEvaluator;
import gde.histo.settlements.CalculusEvaluator;
import gde.histo.settlements.FigureEvaluator;
import gde.histo.settlements.SettlementRecord;
import gde.histo.transitions.GroupTransitions;
import gde.histo.transitions.Transition;
import gde.log.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class TransitionTableMapper {
    private static final String $CLASS_NAME = TransitionTableMapper.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final RecordSet recordSet;
    private final Analyzer analyzer;
    private final ChannelType channel;

    public TransitionTableMapper(RecordSet recordSet, Analyzer analyzer) {
        this.recordSet = recordSet;
        this.analyzer = analyzer;
        this.channel = analyzer.getActiveDevice().getDeviceConfiguration().getChannel(recordSet.getChannelConfigNumber());
    }

    public synchronized String[] defineRowWithSettlements(int index, String[] dataTableRow) {
        SettlementTypes settlementTypes = this.defineActiveAndDisplayableSettlements();
        HashMap<Integer, TransitionGroupType> transitionGroups = this.channel.getTransitionGroups();
        int tableColumnsSize = this.recordSet.getVisibleAndDisplayableRecordsForTable().size() + 1;
        String[] tableRow = Arrays.copyOf(dataTableRow, tableColumnsSize + settlementTypes.size() + transitionGroups.size());
        GroupTransitions histoTransitions = this.recordSet.getHistoTransitions();
        SettlementRecords settlements = this.determineSettlements(histoTransitions, settlementTypes.values());
        int columnIndex = tableColumnsSize;
        for (SettlementRecord settlementRecord : settlements.values()) {
            Double value = settlementRecord.getTranslatedValue(index);
            if (value != null) {
                tableRow[columnIndex] = String.format("%.3f", value);
            }
            ++columnIndex;
        }
        for (Map.Entry entry : transitionGroups.entrySet()) {
            Transition transition;
            GroupTransitions.TransitionChronicle transitionChronicle = this.recordSet.getHistoTransitions().get((Integer)entry.getKey());
            if (transitionChronicle != null && (transition = transitionChronicle.get((long)this.recordSet.getTime_ms(index))) != null) {
                tableRow[columnIndex] = Integer.toString(transition.getTransitionType().getTransitionId());
            }
            ++columnIndex;
        }
        return tableRow;
    }

    public SettlementTypes defineActiveAndDisplayableSettlements() {
        SettlementTypes channelSettlements = new SettlementTypes(this.channel.getSettlements());
        Iterator<Map.Entry<Integer, SettlementType>> iterator = channelSettlements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SettlementType> entry = iterator.next();
            if (entry.getValue().isActive() && this.hasTransitions(entry.getValue())) continue;
            iterator.remove();
        }
        log.finer(() -> "settlementTypes.size=" + this.channel.getSettlements().size() + " size=" + channelSettlements.size());
        return channelSettlements;
    }

    private boolean hasTransitions(SettlementType settlementType) {
        int transitionGroupId;
        GroupTransitions histoTransitions = this.recordSet.getHistoTransitions();
        if (histoTransitions.isEmpty()) {
            return false;
        }
        TransitionFigureType transitionFigureType = settlementType.getEvaluation().getTransitionFigure();
        TransitionAmountType transitionAmountType = settlementType.getEvaluation().getTransitionAmount();
        TransitionCalculusType calculationType = settlementType.getEvaluation().getTransitionCalculus();
        if (transitionFigureType != null) {
            transitionGroupId = transitionFigureType.getTransitionGroupId();
        } else if (transitionAmountType != null) {
            transitionGroupId = transitionAmountType.getTransitionGroupId();
        } else if (calculationType != null) {
            transitionGroupId = calculationType.getTransitionGroupId();
        } else {
            throw new UnsupportedOperationException();
        }
        GroupTransitions.TransitionChronicle transitionChronicle = histoTransitions.get(transitionGroupId);
        return transitionChronicle != null;
    }

    private SettlementRecords determineSettlements(GroupTransitions transitions, Collection<SettlementType> settlementTypes) {
        SettlementRecords histoSettlements = new SettlementRecords();
        for (SettlementType settlementType : settlementTypes) {
            Object evaluator;
            if (settlementType.getEvaluation() == null) continue;
            SettlementRecord record = new SettlementRecord(settlementType, this.recordSet, this.analyzer.getActiveChannel().getNumber());
            histoSettlements.put(settlementType.getName(), record);
            if (transitions.isEmpty()) continue;
            TransitionFigureType transitionFigureType = settlementType.getEvaluation().getTransitionFigure();
            TransitionAmountType transitionAmountType = settlementType.getEvaluation().getTransitionAmount();
            TransitionCalculusType calculationType = settlementType.getEvaluation().getTransitionCalculus();
            if (transitionFigureType != null) {
                evaluator = new FigureEvaluator(record);
                for (Transition transition : transitions.get(transitionFigureType.getTransitionGroupId()).values()) {
                    ((FigureEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            if (transitionAmountType != null) {
                evaluator = new AmountEvaluator(record, this.analyzer);
                for (Transition transition : transitions.get(transitionAmountType.getTransitionGroupId()).values()) {
                    ((AmountEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            if (calculationType != null) {
                evaluator = new CalculusEvaluator(record, this.analyzer);
                for (Transition transition : transitions.get(calculationType.getTransitionGroupId()).values()) {
                    ((CalculusEvaluator)evaluator).addFromTransition(transition);
                }
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return histoSettlements;
    }

    public static final class SettlementTypes {
        private final LinkedHashMap<Integer, SettlementType> settlementTypes;

        public SettlementTypes(LinkedHashMap<Integer, SettlementType> settlements) {
            this.settlementTypes = new LinkedHashMap<Integer, SettlementType>(settlements);
        }

        public SettlementType get(int settlementId) {
            return this.settlementTypes.get(settlementId);
        }

        public SettlementType put(int settlementId, SettlementType settlementType) {
            return this.settlementTypes.put(settlementId, settlementType);
        }

        public Set<Map.Entry<Integer, SettlementType>> entrySet() {
            return this.settlementTypes.entrySet();
        }

        public int size() {
            return this.settlementTypes.size();
        }

        public Collection<SettlementType> values() {
            return this.settlementTypes.values();
        }

        public String toString() {
            return "SettlementTypes [settlementTypes=" + String.valueOf(this.settlementTypes) + ", size()=" + this.size() + "]";
        }
    }

    public static final class SettlementRecords {
        private final LinkedHashMap<String, SettlementRecord> settlementRecords = new LinkedHashMap();

        public SettlementRecord get(String settlementName) {
            return this.settlementRecords.get(settlementName);
        }

        public SettlementRecord put(String settlementName, SettlementRecord settlementType) {
            return this.settlementRecords.put(settlementName, settlementType);
        }

        public Collection<SettlementRecord> values() {
            return this.settlementRecords.values();
        }

        public Set<Map.Entry<String, SettlementRecord>> entrySet() {
            return this.settlementRecords.entrySet();
        }

        public String toString() {
            return "SettlementRecords [settlementRecords=" + String.valueOf(this.settlementRecords) + ", size()=" + this.settlementRecords.size() + "]";
        }
    }
}

