/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.ChannelTypes;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.exception.DataInconsitsentException;
import gde.exception.GDEInternalException;
import gde.exception.NotSupportedFileFormatException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.menu.MenuToolBar;
import gde.utils.FileUtils;
import gde.utils.OperatingSystemHelper;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class OsdReaderWriter {
    static final Logger log = Logger.getLogger(OsdReaderWriter.class.getName());
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();

    public static HashMap<String, String> getHeader(InputStream inputStream) throws IOException, NotSupportedFileFormatException {
        String exceptionMessageFilePath = "";
        return OsdReaderWriter.readHeader(exceptionMessageFilePath, new DataInputStream(FileUtils.wrapIfZipStream(inputStream)));
    }

    public static HashMap<String, String> getHeader(String filePath) throws FileNotFoundException, IOException, NotSupportedFileFormatException {
        try (FileInputStream inputStream = new FileInputStream(new File(filePath));){
            String exceptionMessageFilePath = filePath.replace('\\', '/');
            HashMap<String, String> hashMap = OsdReaderWriter.readHeader(exceptionMessageFilePath, new DataInputStream(FileUtils.wrapIfZipStream(inputStream)));
            return hashMap;
        }
    }

    protected static HashMap<String, String> readHeader(String filePath, DataInputStream data_in) throws IOException, NotSupportedFileFormatException {
        int version;
        HashMap<String, String> header = new HashMap<String, String>();
        int headerCounter = GDE.OSD_FORMAT_HEADER_KEYS.length + 1;
        String line = data_in.readUTF();
        line = line.substring(0, line.length() - 1);
        log.log(Level.FINE, line);
        if (!line.startsWith("DataExplorer version : ") && !line.startsWith("OpenSerialData version : ")) {
            throw new NotSupportedFileFormatException(filePath);
        }
        String sVersion = line.startsWith("DataExplorer version : ") ? line.substring("DataExplorer version : ".length(), "DataExplorer version : ".length() + 1).trim() : line.substring("OpenSerialData version : ".length(), "OpenSerialData version : ".length() + 1).trim();
        try {
            version = Integer.valueOf(sVersion);
        }
        catch (NumberFormatException e) {
            log.log(Level.SEVERE, "can not interprete red version information " + sVersion);
            throw new NotSupportedFileFormatException(filePath);
        }
        switch (version) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                header.put("DataExplorer version : ", "" + version);
                boolean isHeaderComplete = false;
                block8: while (!isHeaderComplete && headerCounter-- > 0) {
                    line = line.substring(0, (line = data_in.readUTF()).length() > 0 ? line.length() - 1 : 0);
                    log.log(Level.FINE, line);
                    for (String headerKey : GDE.OSD_FORMAT_HEADER_KEYS) {
                        if (!line.startsWith(headerKey)) continue;
                        log.log(Level.FINE, line);
                        header.put(headerKey, line.substring(headerKey.length()));
                        if (!line.startsWith("NumberRecordSets : ")) continue block8;
                        int lastReordNumber = headerCounter = Integer.valueOf(header.get("NumberRecordSets : ").trim()).intValue();
                        while (headerCounter-- > 0) {
                            switch (version) {
                                case 1: 
                                case 2: 
                                case 3: {
                                    line = data_in.readUTF();
                                    line = line.substring(0, line.length() - 1);
                                    break;
                                }
                                default: {
                                    int length = data_in.readInt();
                                    byte[] bytes = new byte[length];
                                    data_in.readFully(bytes);
                                    line = new String(bytes, "UTF8");
                                    line = line.substring(0, line.length() - 1);
                                }
                            }
                            if (!line.startsWith("RecordSetName : ")) continue;
                            log.log(Level.FINE, line);
                            header.put(lastReordNumber - headerCounter + " RecordSetName : ", line.substring("RecordSetName : ".length()));
                        }
                        isHeaderComplete = true;
                        continue block8;
                    }
                }
                break;
            }
            default: {
                throw new NotSupportedFileFormatException(filePath);
            }
        }
        return header;
    }

    public static RecordSet read(String filePath) throws FileNotFoundException, IOException, NotSupportedFileFormatException, DataInconsitsentException {
        return OsdReaderWriter.read(filePath, new RecordSetSelector(new OsdReaderWriter()));
    }

    public static RecordSet read(String filePath, String recordSetName) throws FileNotFoundException, IOException, NotSupportedFileFormatException, DataInconsitsentException {
        return OsdReaderWriter.read(filePath, new RecordSetSelector(new OsdReaderWriter(), recordSetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RecordSet read(String filePath, RecordSetSelector recordSetSelector) throws FileNotFoundException, IOException, NotSupportedFileFormatException, DataInconsitsentException {
        String objectKey;
        filePath = filePath.replace('\\', '/');
        ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));
        ZipEntry zip_entry = zip_input.getNextEntry();
        FileInputStream file_input = null;
        DataInputStream data_in = null;
        if (zip_entry != null) {
            data_in = new DataInputStream(zip_input);
        } else {
            zip_input.close();
            zip_input = null;
            file_input = new FileInputStream(new File(filePath));
            data_in = new DataInputStream(file_input);
        }
        String channelConfig = "";
        String recordSetName = "";
        int recordDataSize = 0;
        long recordSetDataPointer = 0L;
        Channel channel = null;
        RecordSet recordSet = null;
        HashMap<String, String> header = OsdReaderWriter.getHeader(filePath);
        ChannelTypes channelType = ChannelTypes.valueOf(header.get("Channel/Configuration Type : ").trim());
        String string = objectKey = header.get("ObjectKey : ") != null ? header.get("ObjectKey : ") : "";
        while (!data_in.readUTF().startsWith("NumberRecordSets : ")) {
            log.log(Level.FINE, "skip");
        }
        List<HashMap<String, String>> recordSetsInfo = OsdReaderWriter.readRecordSetsInfo4AllVersions(data_in, header);
        try {
            for (HashMap<String, String> recordSetInfo : recordSetsInfo) {
                channelConfig = recordSetInfo.get("Channel/Configuration Name: ");
                recordSetName = recordSetInfo.get("RecordSetName : ");
                recordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
                recordDataSize = Long.valueOf(recordSetInfo.get("RecordDataSize : ")).intValue();
                channelConfig = Analyzer.getInstance().getActiveDevice().crossCheckChannelConfig(channelConfig, recordSetInfo);
                channel = (Channel)channels.get(channels.getChannelNumber(channelConfig));
                if (channel == null) {
                    try {
                        channel = (Channel)channels.get(Integer.valueOf(channelConfig.substring(channelConfig.length() - 1)));
                        channelConfig = channel.getChannelConfigKey();
                        recordSetInfo.put("Channel/Configuration Name: ", channelConfig);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (channel == null) {
                    try {
                        channel = (Channel)channels.get(channels.getChannelNumber(channelConfig.split(" ")[0]));
                        channelConfig = channel.getChannelConfigKey();
                        recordSetInfo.put("Channel/Configuration Name: ", channelConfig);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (channel == null) {
                    String msg = Messages.getString("GDE_MSGI0018", new Object[]{recordSetName}) + " " + Messages.getString("GDE_MSGI0019") + "\n" + Messages.getString("GDE_MSGI0020");
                    DataExplorer.getInstance().openMessageDialogAsync(msg);
                    channel = channels.addChannel(channelConfig, channelType, Analyzer.getInstance());
                }
                channels.setActiveChannelNumber(channel.getNumber());
                application.selectObjectKey(objectKey);
                channelConfig = channelConfig.contains(":") ? channelConfig.split(":")[1].trim() : channelConfig.trim();
                channelConfig = channelConfig.contains(" ") ? channelConfig.split(" ")[0].trim() : channelConfig.trim();
                recordSet = OsdReaderWriter.buildRecordSet(recordSetName, channel.getNumber(), recordSetInfo, true, Analyzer.getInstance());
                channel.put(recordSetName, recordSet);
                if (recordSetSelector.isBestFitFound()) continue;
                recordSetSelector.setBestFit(channel.getNumber(), channelConfig, recordSetName);
            }
            MenuToolBar menuToolBar = application.getMenuToolBar();
            if (menuToolBar != null) {
                menuToolBar.updateChannelSelector();
                menuToolBar.updateRecordSetSelectCombo();
            }
            long unreadDataPointer = -1L;
            for (HashMap<String, String> recordSetInfo : recordSetsInfo) {
                channelConfig = recordSetInfo.get("Channel/Configuration Name: ");
                recordSetName = recordSetInfo.get("RecordSetName : ");
                recordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
                recordDataSize = Long.valueOf(recordSetInfo.get("RecordDataSize : ")).intValue();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "recordDataSize = " + recordDataSize);
                }
                recordSetDataPointer = Long.valueOf(recordSetInfo.get("RecordSetDataPointer : "));
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "recordSetDataPointer = " + recordSetDataPointer);
                }
                channel = (Channel)channels.get(channels.getChannelNumber(channelConfig));
                recordSet = (RecordSet)channel.get(recordSetName);
                int numberRecordAndTimeStamp = recordSet.getNoneCalculationRecordNames().length + (recordSet.isTimeStepConstant() ? 0 : 1);
                recordSet.setFileDataPointerAndSize(recordSetDataPointer, recordDataSize, 4 * numberRecordAndTimeStamp * recordDataSize);
                if (recordSetSelector.isBestFitFound() && !recordSetSelector.isMatchToBestFit(channel.getNumber(), recordSetName)) {
                    if (unreadDataPointer <= -1L) {
                        unreadDataPointer = recordSetDataPointer;
                    }
                    if (!log.isLoggable(Level.FINER)) continue;
                    log.log(Level.FINER, String.format("skipped  channelConfigName=%-22s recordSetName=%-40s unreadDataPointer=%,d", channelConfig, recordSetName, unreadDataPointer));
                    continue;
                }
                if (unreadDataPointer > -1L) {
                    unreadDataPointer = OsdReaderWriter.skipData(data_in, recordSetDataPointer, unreadDataPointer);
                }
                long startTime = new Date().getTime();
                byte[] buffer = new byte[recordSet.getFileDataBytesSize()];
                data_in.readFully(buffer);
                recordSet.getDevice().addDataBufferAsRawDataPoints(recordSet, buffer, recordDataSize, GDE.isWithUi());
                recordSet.updateVisibleAndDisplayableRecordsForTable();
                if (log.isLoggable(Level.TIME)) {
                    log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime("mm:ss:SSS", new Date().getTime() - startTime));
                }
                if (application.getMenuToolBar() == null) continue;
                OsdReaderWriter.displayRecordSet(filePath, header.get("FileComment : "), channelConfig, recordSetName);
            }
            Channel activeChannel = channels.getActiveChannel();
            IDevice device = Analyzer.getInstance().getActiveDevice();
            if (activeChannel != null && device != null && device.useChannelWithSyncedDescription()) {
                activeChannel.syncFileDescription(activeChannel, activeChannel.getFileDescription());
            }
            RecordSet recordSet2 = recordSet;
            return recordSet2;
        }
        finally {
            if (zip_input != null) {
                zip_input.closeEntry();
                data_in.close();
                zip_input.close();
            } else if (file_input != null) {
                data_in.close();
                file_input.close();
            }
            data_in = null;
            file_input = null;
            zip_input = null;
        }
    }

    private static long skipData(DataInputStream data_in, long recordSetDataPointer, long unreadDataPointer) throws IOException, EOFException {
        long toSkip = recordSetDataPointer - unreadDataPointer;
        while (toSkip > 0L) {
            if ((toSkip -= data_in.skip(toSkip)) <= 0L) continue;
            if (log.isLoggable(Level.INFO)) {
                log.log(Level.INFO, "toSkip=" + toSkip);
            }
            if (data_in.available() != 0) continue;
            throw new EOFException("recordDataSize / recordSetDataPointer do not match the actual file size");
        }
        unreadDataPointer = -1L;
        return unreadDataPointer;
    }

    private static void displayRecordSet(String filePath, String fileDescription, String channelConfigName, String recordSetName) {
        Channel channel = (Channel)channels.get(channels.getChannelNumber(channelConfigName));
        channel.setFileName(filePath);
        channel.setFileDescription(fileDescription);
        channel.setSaved(true);
        String displayRecordSetName = recordSetName.length() <= 40 ? recordSetName : recordSetName.substring(0, 40);
        channels.switchChannel(channels.getChannelNumber(channelConfigName), displayRecordSetName);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "channelConfigName=" + channelConfigName, "  recordSetName=" + recordSetName);
        }
    }

    protected static RecordSet buildRecordSet(String recordSetName, int channelNumber, HashMap<String, String> recordSetInfo, boolean adjustObjectKey, Analyzer analyzer) {
        RecordSet recordSet;
        String recordSetComment = recordSetInfo.get("RecordSetComment : ");
        String recordSetProperties = recordSetInfo.get("RecordSetProperties : ");
        String[] recordsProperties = StringHelper.splitString(recordSetInfo.get("RecordProperties : "), "|:-:|", "RecordProperties : ");
        IDevice device = analyzer.getActiveDevice();
        if (device.isVariableMeasurementSize()) {
            int existingNumberMeasurements = device.getDeviceConfiguration().getMeasurementNames(channelNumber).length;
            if (recordsProperties.length != existingNumberMeasurements) {
                for (int i = recordsProperties.length; i < existingNumberMeasurements; ++i) {
                    device.removeMeasurementFromChannel(channelNumber, device.getMeasurement(channelNumber, recordsProperties.length));
                }
            }
            String[] recordNames = new String[recordsProperties.length];
            String[] recordSymbols = new String[recordsProperties.length];
            String[] recordUnits = new String[recordsProperties.length];
            for (int i = 0; i < recordsProperties.length; ++i) {
                HashMap<String, String> recordProperties = StringHelper.splitString(recordsProperties[i], "|-|", Record.propertyKeys);
                MeasurementType gdeMeasurement = device.getMeasurement(channelNumber, i);
                recordNames[i] = recordProperties.get("_name");
                gdeMeasurement.setName(recordNames[i]);
                recordUnits[i] = recordProperties.getOrDefault("_unit", "");
                gdeMeasurement.setUnit(recordUnits[i]);
                recordSymbols[i] = recordProperties.getOrDefault("_symbol", "");
                gdeMeasurement.setSymbol(recordSymbols[i]);
                gdeMeasurement.setActive(Boolean.valueOf(recordProperties.get("_isActive")));
            }
            recordSet = RecordSet.createRecordSet(recordSetName, analyzer, channelNumber, recordNames, recordSymbols, recordUnits, true, true, true);
        } else {
            recordSet = RecordSet.createRecordSet(recordSetName, analyzer, channelNumber, true, true, true);
        }
        recordSet.setRecordSetDescription(recordSetComment);
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder().append(recordSet.getName()).append(" - ");
            for (String recordProps : recordsProperties) {
                sb.append(StringHelper.splitString(recordProps, "|-|", Record.propertyKeys).get(Record.propertyKeys[0])).append(",");
            }
            log.log(Level.FINE, sb.toString());
        }
        String[] recordKeys = device.crossCheckMeasurements(recordsProperties, recordSet);
        for (int i = 0; i < recordKeys.length; ++i) {
            Record record = recordSet.get(recordKeys[i]);
            if (record != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, record.getName() + " - setSerializedProperties " + String.valueOf(recordsProperties[i].subSequence(6, recordsProperties[i].indexOf(124))));
                }
                record.setSerializedProperties(recordsProperties[i]);
                record.setSerializedDeviceSpecificProperties(recordsProperties[i]);
                continue;
            }
            log.log(Level.WARNING, String.format("After cross checking initial recordSet names with recordsProperties a record with name %s could not be found!", recordKeys[i]));
            for (int j = 0; j < recordKeys.length; ++j) {
                log.log(Level.WARNING, String.format("%20s - %s", recordKeys[j], recordsProperties[j].subSequence(6, recordsProperties[j].indexOf(124))));
            }
        }
        device.applyMeasurementSpecialties(recordsProperties, recordSet);
        recordSet.setDeserializedProperties(recordSetProperties);
        recordSet.setSaved(true);
        return recordSet;
    }

    private static List<HashMap<String, String>> readRecordSetsInfo4AllVersions(DataInputStream data_in, HashMap<String, String> header) throws NumberFormatException, IOException, UnsupportedEncodingException {
        ArrayList<HashMap<String, String>> recordSetsInfo = new ArrayList<HashMap<String, String>>();
        for (int i = 0; i < Integer.valueOf(header.get("NumberRecordSets : ").trim()); ++i) {
            String line;
            switch (Integer.valueOf(header.get("DataExplorer version : "))) {
                case 1: 
                case 2: 
                case 3: {
                    line = data_in.readUTF();
                    line = line.substring(0, line.length() - 1);
                    break;
                }
                default: {
                    int length = data_in.readInt();
                    byte[] bytes = new byte[length];
                    data_in.readFully(bytes);
                    line = new String(bytes, "UTF8");
                    line = line.substring(0, line.length() - 1);
                }
            }
            recordSetsInfo.add(OsdReaderWriter.getRecordSetProperties(line));
        }
        return recordSetsInfo;
    }

    public static String getRecordSetName(String recordSetProperties) {
        return recordSetProperties.substring(0, recordSetProperties.indexOf("||::||"));
    }

    public static HashMap<String, String> getRecordSetProperties(String recordSetProperties) {
        return StringHelper.splitString(recordSetProperties, "||::||", GDE.OSD_FORMAT_DATA_KEYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(String fullQualifiedFilePath, Channel activeChannel, int useVersion) throws FileNotFoundException, IOException {
        fullQualifiedFilePath = fullQualifiedFilePath.replace('\\', '/');
        if (activeChannel != null && fullQualifiedFilePath != null && useVersion != 0) {
            ZipOutputStream file_out = new ZipOutputStream(new FileOutputStream(new File(fullQualifiedFilePath)));
            file_out.putNextEntry(new ZipEntry(fullQualifiedFilePath.substring(fullQualifiedFilePath.lastIndexOf(47) + 1)));
            DataOutputStream data_out = new DataOutputStream(file_out);
            IDevice activeDevice = application.getActiveDevice();
            boolean isObjectOriented = application.isObjectoriented();
            int filePointer = 0;
            try {
                activeChannel.checkAndLoadData();
                String versionString = "DataExplorer version : " + useVersion + "\n";
                data_out.writeUTF(versionString);
                filePointer += 2 + versionString.getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + versionString.getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                String creationString = "Created : " + Instant.now().toString() + "\n";
                data_out.writeUTF(creationString);
                filePointer += 2 + creationString.getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + creationString.getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                StringBuilder sb = new StringBuilder();
                sb.append("FileComment : ").append(activeChannel.getFileDescription()).append("\n");
                data_out.writeUTF(sb.toString());
                filePointer += 2 + sb.toString().getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + sb.toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                sb = new StringBuilder();
                sb.append("DeviceName : ").append(activeDevice.getName()).append("\n");
                data_out.writeUTF(sb.toString());
                filePointer += 2 + sb.toString().getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + sb.toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                sb = new StringBuilder();
                sb.append("Channel/Configuration Type : ").append(activeChannel.getType().name()).append("\n");
                data_out.writeUTF(sb.toString());
                filePointer += 2 + sb.toString().getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + sb.toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                sb = new StringBuilder();
                sb.append("ObjectKey : ").append(activeChannel.getObjectKey()).append("\n");
                data_out.writeUTF(sb.toString());
                filePointer += 2 + sb.toString().getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + sb.toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                sb = new StringBuilder();
                sb.append("NumberRecordSets : ").append(activeChannel.size()).append("\n");
                data_out.writeUTF(sb.toString());
                filePointer += 2 + sb.toString().getBytes("UTF8").length;
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "line lenght = " + (2 + sb.toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                }
                StringBuilder[] sbs = new StringBuilder[activeChannel.size()];
                String[] recordSetNames = activeChannel.getRecordSetNames();
                for (int i = 0; i < activeChannel.size(); ++i) {
                    RecordSet recordSet;
                    Channel recordSetChannel;
                    Channel channel = recordSetChannel = activeChannel.getType().equals((Object)ChannelTypes.TYPE_OUTLET) ? activeChannel : (Channel)Channels.getInstance().get(activeChannel.findChannelOfRecordSet(recordSetNames[i]));
                    if (recordSetChannel == null || (recordSet = (RecordSet)recordSetChannel.get(recordSetNames[i])) == null) continue;
                    sbs[i] = new StringBuilder();
                    sbs[i].append("RecordSetName : ").append(recordSet.getName()).append("||::||").append("Channel/Configuration Name: ").append(recordSetChannel.getNumber()).append(" : ").append(recordSet.getChannelConfigName()).append("||::||").append("RecordSetComment : ").append(recordSet.getRecordSetDescription()).append("||::||").append("RecordSetProperties : ").append(recordSet.getSerializeProperties()).append("||::||");
                    for (String recordKey : recordSet.getRecordNames()) {
                        sbs[i].append("RecordProperties : ").append(recordSet.get(recordKey).getSerializeProperties());
                    }
                    sbs[i].append("||::||").append("RecordDataSize : ").append(String.format("%10s", recordSet.getRecordDataSize(true))).append("||::||");
                    filePointer += 4 + sbs[i].toString().getBytes("UTF8").length;
                    filePointer += "RecordSetDataPointer : ".toString().getBytes("UTF8").length + 10 + "\n".toString().getBytes("UTF8").length;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "line lenght = " + (4 + sbs[i].toString().getBytes("UTF8").length + "RecordSetDataPointer : ".toString().getBytes("UTF8").length + 10 + "\n".toString().getBytes("UTF8").length) + " filePointer = " + filePointer);
                    }
                    if (!log.isLoggable(Level.FINE)) continue;
                    StringBuilder sb1 = new StringBuilder().append(recordSet.getName()).append(" - ");
                    for (String recordKey : recordSet.getRecordNames()) {
                        sb1.append(recordKey).append(",");
                    }
                    log.log(Level.FINE, sb1.toString());
                }
                HashMap<CallSite, Integer> recordSizes = new HashMap<CallSite, Integer>();
                for (int i = 0; i < activeChannel.size(); ++i) {
                    RecordSet recordSet;
                    Channel recordSetChannel;
                    Channel channel = recordSetChannel = activeChannel.getType().equals((Object)ChannelTypes.TYPE_OUTLET) ? activeChannel : (Channel)Channels.getInstance().get(activeChannel.findChannelOfRecordSet(recordSetNames[i]));
                    if (recordSetChannel == null || (recordSet = (RecordSet)recordSetChannel.get(recordSetNames[i])) == null) continue;
                    recordSet.resetZoomAndMeasurement();
                    sbs[i].append("RecordSetDataPointer : ").append(String.format("%10s", filePointer)).append("\n");
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, sbs[i].toString());
                    }
                    data_out.writeInt(sbs[i].toString().getBytes("UTF8").length);
                    data_out.write(sbs[i].toString().getBytes("UTF8"));
                    int sizeRecord = recordSet.getRecordDataSize(true);
                    recordSizes.put((CallSite)((Object)(recordSetChannel.getNumber() + "_" + recordSetNames[i])), sizeRecord);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, recordSetChannel.getNumber() + "_" + recordSetNames[i] + "=" + sizeRecord);
                    }
                    int dataSizeRecord = 4 * sizeRecord;
                    int dataSizeRecords = dataSizeRecord * recordSet.getNoneCalculationRecordNames().length;
                    int dataSizeRecordsTimeStamp = dataSizeRecord + dataSizeRecords;
                    filePointer += recordSet.isTimeStepConstant() ? dataSizeRecords : dataSizeRecordsTimeStamp;
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, (recordSet.isTimeStepConstant() ? dataSizeRecords : dataSizeRecordsTimeStamp) + " filePointer = " + filePointer);
                }
                long startTime = new Date().getTime();
                for (int i = 0; i < activeChannel.size(); ++i) {
                    int j;
                    RecordSet recordSet;
                    Channel recordSetChannel;
                    Channel channel = recordSetChannel = activeChannel.getType().equals((Object)ChannelTypes.TYPE_OUTLET) ? activeChannel : (Channel)Channels.getInstance().get(activeChannel.findChannelOfRecordSet(recordSetNames[i]));
                    if (recordSetChannel == null || (recordSet = (RecordSet)recordSetChannel.get(recordSetNames[i])) == null) continue;
                    if (!recordSet.hasDisplayableData()) {
                        recordSet.loadFileData(recordSetChannel.getFullQualifiedFileName(), GDE.isWithUi());
                    }
                    String[] noneCalculationRecordNames = recordSet.getNoneCalculationRecordNames();
                    int sizeRecord = (Integer)recordSizes.get(recordSetChannel.getNumber() + "_" + recordSetNames[i]);
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, recordSetChannel.getNumber() + "_" + recordSetNames[i] + "=" + sizeRecord);
                    }
                    int dataSizeRecord = 4 * sizeRecord;
                    int dataSizeRecords = dataSizeRecord * noneCalculationRecordNames.length;
                    int dataSizeRecordsTimeStamp = dataSizeRecord + dataSizeRecords;
                    byte[] buffer = new byte[recordSet.isTimeStepConstant() ? dataSizeRecords : dataSizeRecordsTimeStamp];
                    byte[] bytes = new byte[4];
                    int l = 0;
                    if (!recordSet.isTimeStepConstant()) {
                        j = 0;
                        while (j < sizeRecord) {
                            long timeStamp = recordSet.getTime(j);
                            bytes[0] = (byte)(timeStamp >>> 24 & 0xFFL);
                            bytes[1] = (byte)(timeStamp >>> 16 & 0xFFL);
                            bytes[2] = (byte)(timeStamp >>> 8 & 0xFFL);
                            bytes[3] = (byte)(timeStamp >>> 0 & 0xFFL);
                            System.arraycopy(bytes, 0, buffer, l, 4);
                            ++j;
                            l += 4;
                        }
                    }
                    if (recordSet.isRaw()) {
                        for (j = 0; j < sizeRecord; ++j) {
                            int k = 0;
                            while (k < noneCalculationRecordNames.length) {
                                int point = recordSet.get(noneCalculationRecordNames[k]).realGet(j);
                                bytes[0] = (byte)(point >>> 24 & 0xFF);
                                bytes[1] = (byte)(point >>> 16 & 0xFF);
                                bytes[2] = (byte)(point >>> 8 & 0xFF);
                                bytes[3] = (byte)(point >>> 0 & 0xFF);
                                System.arraycopy(bytes, 0, buffer, l, 4);
                                ++k;
                                l += 4;
                            }
                        }
                    } else {
                        IDevice device = recordSet.getDevice();
                        for (int j2 = 0; j2 < sizeRecord; ++j2) {
                            int k = 0;
                            while (k < noneCalculationRecordNames.length) {
                                Record record = recordSet.get(noneCalculationRecordNames[k]);
                                int point = Double.valueOf(device.reverseTranslateValue(record, (double)record.realGet(j2).intValue() / 1000.0) * 1000.0).intValue();
                                bytes[0] = (byte)(point >>> 24 & 0xFF);
                                bytes[1] = (byte)(point >>> 16 & 0xFF);
                                bytes[2] = (byte)(point >>> 8 & 0xFF);
                                bytes[3] = (byte)(point >>> 0 & 0xFF);
                                System.arraycopy(bytes, 0, buffer, l, 4);
                                ++k;
                                l += 4;
                            }
                        }
                    }
                    data_out.write(buffer, 0, buffer.length);
                    recordSet.setSaved(!fullQualifiedFilePath.contains("~TempFile"));
                }
                if (!log.isLoggable(Level.TIME)) return;
                log.log(Level.TIME, "write time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
                return;
            }
            finally {
                data_out.flush();
                file_out.closeEntry();
                data_out.close();
                data_out = null;
                file_out.close();
                file_out = null;
                if (isObjectOriented && !fullQualifiedFilePath.contains("~TempFile")) {
                    OperatingSystemHelper.createFileLink(fullQualifiedFilePath, application.getObjectFilePath() + fullQualifiedFilePath.substring(fullQualifiedFilePath.lastIndexOf(47) + 1));
                }
            }
        }
        GDEInternalException e = new GDEInternalException(Messages.getString("GDE_MSGE0009") + String.valueOf(activeChannel) + ", " + fullQualifiedFilePath + ", " + useVersion);
        DataExplorer.getInstance().openMessageDialogAsync(e.getClass().getSimpleName() + " - " + e.getMessage());
    }

    public static synchronized void readRecordSetsData(RecordSet recordSet, String filePath, boolean doUpdateProgressBar) throws FileNotFoundException, IOException, DataInconsitsentException {
        filePath = filePath.replace('\\', '/');
        ZipInputStream zip_input = new ZipInputStream(new FileInputStream(new File(filePath)));
        ZipEntry zip_entry = zip_input.getNextEntry();
        RandomAccessFile random_in = null;
        FilterInputStream data_in = null;
        try {
            long recordSetFileDataPointer = recordSet.getFileDataPointer();
            int recordFileDataSize = recordSet.getFileDataSize();
            long startTime = new Date().getTime();
            int dataSizeRecord = 4 * recordFileDataSize;
            int dataSizeRecords = dataSizeRecord * recordSet.getNoneCalculationRecordNames().length;
            int dataSizeRecordsTimeStamp = dataSizeRecord + dataSizeRecords;
            byte[] buffer = new byte[recordSet.isTimeStepConstant() ? dataSizeRecords : dataSizeRecordsTimeStamp];
            if (zip_entry != null) {
                data_in = new DataInputStream(zip_input);
                data_in.skip(recordSetFileDataPointer);
                ((DataInputStream)data_in).readFully(buffer);
            } else {
                zip_input.close();
                zip_input = null;
                random_in = new RandomAccessFile(new File(filePath), "r");
                random_in.seek(recordSetFileDataPointer);
                random_in.readFully(buffer);
            }
            recordSet.getDevice().addDataBufferAsRawDataPoints(recordSet, buffer, recordFileDataSize, doUpdateProgressBar);
            recordSet.updateVisibleAndDisplayableRecordsForTable();
            if (log.isLoggable(Level.TIME)) {
                log.log(Level.TIME, "read time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (DataInconsitsentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        finally {
            if (zip_input != null && data_in != null) {
                zip_input.closeEntry();
                data_in.close();
                zip_input.close();
            } else if (random_in != null) {
                random_in.close();
            }
            data_in = null;
            random_in = null;
            zip_input = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateObjectKey(String oldObjectKey, String newObjectKey) {
        FilterInputStream data_in = null;
        DataOutputStream data_out = null;
        ZipInputStream zip_input = null;
        ZipOutputStream zip_out = null;
        try {
            List<File> files = FileUtils.getFileListing(new File(Settings.getInstance().getDataFilePath()), 1);
            Iterator<File> iterator = files.iterator();
            while (iterator.hasNext()) {
                File file = iterator.next();
                try {
                    String actualFilePath = file.getAbsolutePath();
                    if (actualFilePath.endsWith("osd") && actualFilePath.equals(OperatingSystemHelper.getLinkContainedFilePath(actualFilePath))) {
                        log.finer(() -> String.format("working with %s", file.getName()));
                        if (file.getAbsolutePath().contains("Blade")) {
                            System.out.println();
                        }
                        if (oldObjectKey.equals(OsdReaderWriter.getHeader(file.getCanonicalPath()).get("ObjectKey : "))) {
                            log.fine(() -> String.format("found file with given object key %s", file.getName()));
                            continue;
                        }
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, file.getAbsolutePath(), e);
                }
                catch (NotSupportedFileFormatException e) {
                    log.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
                catch (Throwable t) {
                    log.log(Level.WARNING, t.getLocalizedMessage(), t);
                }
            }
            iterator = files.iterator();
            while (iterator.hasNext()) {
                String filePath = iterator.next().getPath().replace('\\', '/');
                log.fine(() -> String.format("renaming object key of %s", filePath));
                String tmpFilePath = FileUtils.renameFile(filePath, "tmp");
                File tmpFile = new File(tmpFilePath);
                File updatedFile = new File(filePath);
                try {
                    int version;
                    zip_input = new ZipInputStream(new FileInputStream(tmpFile));
                    ZipEntry zip_entry = zip_input.getNextEntry();
                    data_in = zip_entry != null ? new DataInputStream(zip_input) : new DataInputStream(new FileInputStream(tmpFile));
                    zip_out = new ZipOutputStream(new FileOutputStream(updatedFile));
                    zip_out.putNextEntry(new ZipEntry(filePath.substring(filePath.lastIndexOf(47) + 1)));
                    data_out = new DataOutputStream(zip_out);
                    long filePointer = 0L;
                    Object tmpData = ((DataInputStream)data_in).readUTF();
                    String line = ((String)tmpData).substring(0, ((String)tmpData).length() - 1);
                    log.finer(() -> String.format("OSD first line = %s", line));
                    if (!line.startsWith("DataExplorer version : ") && !line.startsWith("OpenSerialData version : ")) {
                        throw new NotSupportedFileFormatException(filePath);
                    }
                    data_out.writeUTF((String)tmpData);
                    filePointer += (long)((String)tmpData).getBytes("UTF8").length;
                    String stringVersion = line.startsWith("DataExplorer version : ") ? line.substring("DataExplorer version : ".length(), "DataExplorer version : ".length() + 1).trim() : line.substring("OpenSerialData version : ".length(), "OpenSerialData version : ".length() + 1).trim();
                    try {
                        version = Integer.valueOf(stringVersion);
                    }
                    catch (NumberFormatException e) {
                        log.log(Level.SEVERE, "can not interprete red version information " + stringVersion);
                        throw new NotSupportedFileFormatException(filePath);
                    }
                    while (!((String)(tmpData = ((DataInputStream)data_in).readUTF())).startsWith("ObjectKey : ")) {
                        data_out.writeUTF((String)tmpData);
                        filePointer += (long)((String)tmpData).getBytes("UTF8").length;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("ObjectKey : ").append(newObjectKey).append("\n");
                    data_out.writeUTF(sb.toString());
                    filePointer += (long)(2 + sb.toString().getBytes("UTF8").length);
                    tmpData = ((DataInputStream)data_in).readUTF();
                    data_out.writeUTF((String)tmpData);
                    filePointer += (long)((String)tmpData).getBytes("UTF8").length;
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, "filePointer = " + filePointer);
                    }
                    int numberRecordSets = 0;
                    if (!((String)tmpData).startsWith("NumberRecordSets : ")) {
                        throw new NotSupportedFileFormatException(String.format("File %s does not contain number of record sets!", filePath));
                    }
                    numberRecordSets = Integer.valueOf(((String)tmpData).substring("NumberRecordSets : ".length()).trim());
                    int deltaSizeObjectKey = newObjectKey.getBytes("UTF8").length - oldObjectKey.getBytes("UTF8").length;
                    block31: while (numberRecordSets-- > 0) {
                        long dataPointer;
                        switch (version) {
                            case 1: 
                            case 2: 
                            case 3: {
                                tmpData = ((DataInputStream)data_in).readUTF();
                                dataPointer = Long.parseLong(((String)tmpData).substring(((String)tmpData).length() - 11).trim());
                                tmpData = ((String)tmpData).substring(0, ((String)tmpData).length() - 11) + String.format("%10s\n", dataPointer + (long)deltaSizeObjectKey);
                                data_out.writeUTF((String)tmpData);
                                continue block31;
                            }
                        }
                        int length = ((DataInputStream)data_in).readInt();
                        byte[] bytes = new byte[length];
                        ((DataInputStream)data_in).readFully(bytes);
                        tmpData = new String(bytes);
                        dataPointer = Long.parseLong(((String)tmpData).substring(((String)tmpData).length() - 11).trim());
                        tmpData = ((String)tmpData).substring(0, ((String)tmpData).length() - 11) + String.format("%10s\n", dataPointer + (long)deltaSizeObjectKey);
                        data_out.writeInt(((String)tmpData).getBytes("UTF8").length);
                        data_out.write(((String)tmpData).getBytes("UTF8"));
                    }
                    byte[] buffer = new byte[4096];
                    int len = 0;
                    while ((len = ((DataInputStream)data_in).read(buffer)) > 0) {
                        data_out.write(buffer, 0, len);
                    }
                    FileUtils.renameFile(tmpFilePath, "bak");
                }
                catch (FileNotFoundException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                    DataExplorer.getInstance().openMessageDialog(Messages.getString("GDE_MSGE0038", new Object[]{e.getMessage()}));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                    try {
                        if (zip_out != null) {
                            zip_out.closeEntry();
                            if (data_out != null) {
                                data_out.flush();
                                data_out.close();
                                data_out = null;
                            }
                            zip_out.close();
                            zip_out = null;
                        }
                        if (updatedFile.exists() && updatedFile.delete()) {
                            log.log(Level.WARNING, "failed to delete " + filePath);
                        }
                        if (data_in != null) {
                            data_in.close();
                            data_in = null;
                        }
                    }
                    catch (IOException e1) {
                        log.log(Level.WARNING, e1.getMessage(), e1);
                    }
                    FileUtils.renameFile(tmpFilePath, "osd");
                }
                finally {
                    try {
                        if (zip_out != null) {
                            zip_out.closeEntry();
                            if (data_out != null) {
                                data_out.flush();
                                data_out.close();
                                data_out = null;
                            }
                            zip_out.close();
                            zip_out = null;
                        }
                        if (data_in == null) continue;
                        data_in.close();
                        data_in = null;
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private final class RecordSetSelector {
        private boolean isFixed;
        private int channelNumber = application.getActiveChannel().getNumber();
        private String channelName = application.getActiveChannel().getChannelConfigKey();
        private String recordSetNameTrunk = null;

        RecordSetSelector(OsdReaderWriter osdReaderWriter, String newRecordSetName) {
            this(osdReaderWriter);
            this.recordSetNameTrunk = newRecordSetName.length() <= 40 ? newRecordSetName : newRecordSetName.substring(0, 40);
        }

        RecordSetSelector(OsdReaderWriter osdReaderWriter) {
        }

        void setBestFit(int newChannelNumber, String newChannelName, String newRecordSetName) {
            if (!this.isFixed) {
                String newNameTrunk;
                String string = newNameTrunk = newRecordSetName.length() <= 40 ? newRecordSetName : newRecordSetName.substring(0, 40);
                if (Settings.getInstance().isFirstRecordSetChoice()) {
                    this.isFixed = true;
                    this.channelNumber = newChannelNumber;
                    this.recordSetNameTrunk = newNameTrunk;
                } else if (this.recordSetNameTrunk == null) {
                    if (this.channelNumber == newChannelNumber) {
                        this.isFixed = true;
                        this.channelNumber = newChannelNumber;
                        this.recordSetNameTrunk = newNameTrunk;
                    }
                } else if (this.recordSetNameTrunk.equals(newNameTrunk)) {
                    this.isFixed = true;
                    this.channelNumber = newChannelNumber;
                    this.recordSetNameTrunk = newNameTrunk;
                } else if (this.channelName.equals(newChannelName)) {
                    throw new UnsupportedOperationException("channel number does not match but the channel name does");
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, String.format("isFixed isFirstRecordSetChoice=%b  recordSetNameTrunk=%-22s  channelNumber=%d  channelName=%-22s", Settings.getInstance().isFirstRecordSetChoice(), this.recordSetNameTrunk, this.channelNumber, this.channelName));
                }
            }
        }

        boolean isBestFitFound() {
            return this.isFixed;
        }

        boolean isMatchToBestFit(int newChannelNumber, String newRecordSetName) {
            if (this.isFixed) {
                return this.recordSetNameTrunk.equals(newRecordSetName.length() <= 40 ? newRecordSetName : newRecordSetName.substring(0, 40)) && this.channelNumber == newChannelNumber;
            }
            return false;
        }
    }
}

