/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.Styleable;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;

public class AnonymousBlockBox
extends BlockBox {
    private List _openInlineBoxes;

    public AnonymousBlockBox(Element element) {
        this.setElement(element);
    }

    @Override
    public void layout(LayoutContext c2) {
        this.layoutInlineChildren(c2, 0, this.calcInitialBreakAtLine(c2), true);
    }

    @Override
    public int getContentWidth() {
        return this.getContainingBlock().getContentWidth();
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        Box result2 = super.find(cssCtx, absX, absY, findAnonymous);
        if (!findAnonymous && result2 == this) {
            return this.getParent();
        }
        return result2;
    }

    public List getOpenInlineBoxes() {
        return this._openInlineBoxes;
    }

    public void setOpenInlineBoxes(List openInlineBoxes) {
        this._openInlineBoxes = openInlineBoxes;
    }

    @Override
    public boolean isSkipWhenCollapsingMargins() {
        for (Styleable styleable : this.getInlineContent()) {
            CalculatedStyle style = styleable.getStyle();
            if (style.isFloated() || style.isAbsolute() || style.isFixed() || style.isRunning()) continue;
            return false;
        }
        return true;
    }

    public void provideSiblingMarginToFloats(int margin) {
        for (Styleable styleable : this.getInlineContent()) {
            BlockBox b2;
            if (!(styleable instanceof BlockBox) || !(b2 = (BlockBox)styleable).isFloated()) continue;
            b2.getFloatedBoxData().setMarginFromSibling(margin);
        }
    }

    @Override
    public boolean isMayCollapseMarginsWithChildren() {
        return false;
    }

    @Override
    public void styleText(LayoutContext c2) {
        this.styleText(c2, this.getParent().getStyle());
    }

    @Override
    public BlockBox copyOf() {
        throw new IllegalArgumentException("cannot be copied");
    }
}

