/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.messages.Messages;
import gde.ui.ParameterConfigControl;
import gde.ui.SWTResourceManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StepChargeComposite
extends ScrolledComposite {
    static final Logger log = Logger.getLogger(StepChargeComposite.class.getName());
    private Group stepChargeGroup;
    private Canvas stepChargeCanvas;
    private Composite stepAdjustmentComposite;
    private int valueC1;
    private int valueC2;
    private int valueC3;
    private int valueC4;
    private int valueA1;
    private int valueA2;
    private int valueA3;
    private int valueA4;
    private boolean impulseValue1;
    private boolean impulseValue2;
    private boolean impulseValue3;
    private boolean impulseValue4;
    private boolean reflexValue1;
    private boolean reflexValue2;
    private boolean reflexValue3;
    private boolean reflexValue4;
    private Button reflexStep1;
    private Button reflexStep2;
    private Button reflexStep3;
    private Button reflexStep4;
    private Button impulsStep1;
    private Button impulsStep2;
    private Button impulsStep3;
    private Button impulsStep4;
    private Text stepTextC1;
    private Text stepTextA1;
    private Text stepTextC2;
    private Text stepTextA2;
    private Text stepTextC3;
    private Text stepTextA3;
    private Text stepTextC4;
    private Text stepTextA4;
    private CLabel stepLabel;
    private Group stepGroup1;
    private Group stepGroup2;
    private Group stepGroup3;
    private Group stepGroup4;
    private Slider stepSliderC1;
    private Slider stepSliderA1;
    private Slider stepSliderC2;
    private Slider stepSliderA2;
    private Slider stepSliderC3;
    private Slider stepSliderA3;
    private Slider stepSliderC4;
    private Slider stepSliderA4;
    private ParameterConfigControl peakConfigControl;
    private ParameterConfigControl cutOffTempControl;
    private ParameterConfigControl trickleCurrentControl;
    private Button dischargeCheck;
    private Composite configComposite;
    private final Composite parent;

    public static void main(String[] args) {
        StepChargeComposite.showGUI();
    }

    public static void showGUI() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        StepChargeComposite inst = new StepChargeComposite((Composite)shell, 0);
        Point size = inst.getSize();
        shell.setLayout((Layout)new FillLayout());
        shell.layout();
        if (size.x == 0 && size.y == 0) {
            inst.pack();
            shell.pack();
        } else {
            Rectangle shellBounds = shell.computeTrim(0, 0, size.x, size.y);
            shell.setSize(shellBounds.width, shellBounds.height);
        }
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public StepChargeComposite(Composite parent, int style) {
        super(parent, style);
        SWTResourceManager.registerResourceUser((Widget)this);
        this.parent = parent;
        this.initGUI();
        this.configComposite.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                if (evt.index == 0) {
                    StepChargeComposite.this.parent.notifyListeners(13, new Event());
                }
            }
        });
    }

    public void setStepChargeValues(int capacity, int current, int[] stepValues) {
        if (!this.isDisposed()) {
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder("setStepChargeValues - Step values = ");
                for (int i : stepValues) {
                    sb.append(i).append(",").append(" ");
                }
                log.log(Level.FINE, sb.toString());
                log.log(Level.FINE, "setStepChargeValues - capacity = " + capacity + " current = " + current);
            }
            this.initCapacity(capacity, stepValues[0], stepValues[1], stepValues[2], stepValues[3]);
            this.initCurrent(current, stepValues[4], stepValues[5], stepValues[6], stepValues[7]);
            this.impulseValue1 = stepValues[8] == 1;
            this.impulsStep1.setSelection(this.impulseValue1);
            this.impulseValue2 = stepValues[9] == 1;
            this.impulsStep2.setSelection(this.impulseValue2);
            this.impulseValue3 = stepValues[10] == 1;
            this.impulsStep3.setSelection(this.impulseValue3);
            this.impulseValue4 = stepValues[11] == 1;
            this.impulsStep4.setSelection(this.impulseValue4);
            this.reflexValue1 = stepValues[12] == 1;
            this.reflexStep1.setSelection(this.reflexValue1);
            this.reflexValue2 = stepValues[13] == 1;
            this.reflexStep2.setSelection(this.reflexValue2);
            this.reflexValue3 = stepValues[14] == 1;
            this.reflexStep3.setSelection(this.reflexValue3);
            this.reflexValue4 = stepValues[15] == 1;
            this.reflexStep4.setSelection(this.reflexValue4);
            this.dischargeCheck.setSelection(stepValues[16] == 1);
            this.trickleCurrentControl.getSlider().setSelection(stepValues[17]);
            Event evt = new Event();
            evt.data = new Object();
            this.trickleCurrentControl.getSlider().notifyListeners(13, evt);
            this.peakConfigControl.getSlider().setSelection(stepValues[18]);
            this.peakConfigControl.getSlider().notifyListeners(13, evt);
            this.cutOffTempControl.getSlider().setSelection(stepValues[19]);
            this.cutOffTempControl.getSlider().notifyListeners(13, evt);
        }
    }

    public int[] getStepChargeValues(int[] stepValues) {
        stepValues[0] = this.valueC1;
        stepValues[1] = this.valueC2;
        stepValues[2] = this.valueC3;
        stepValues[3] = this.valueC4;
        stepValues[4] = this.valueA1 * 10;
        stepValues[5] = this.valueA2 * 10;
        stepValues[6] = this.valueA3 * 10;
        stepValues[7] = this.valueA4 * 10;
        stepValues[8] = this.impulseValue1 && !this.reflexValue1 ? 1 : 0;
        stepValues[9] = this.impulseValue2 && !this.reflexValue2 ? 1 : 0;
        stepValues[10] = this.impulseValue3 && !this.reflexValue3 ? 1 : 0;
        stepValues[11] = this.impulseValue4 && !this.reflexValue4 ? 1 : 0;
        stepValues[12] = this.reflexValue1 && !this.impulseValue1 ? 1 : 0;
        stepValues[13] = this.reflexValue2 && !this.impulseValue2 ? 1 : 0;
        stepValues[14] = this.reflexValue3 && !this.impulseValue3 ? 1 : 0;
        stepValues[15] = this.reflexValue4 && !this.impulseValue4 ? 1 : 0;
        stepValues[16] = this.dischargeCheck.getSelection() ? 1 : 0;
        stepValues[17] = this.trickleCurrentControl.getSlider().getSelection();
        stepValues[18] = this.peakConfigControl.getSlider().getSelection();
        stepValues[19] = this.cutOffTempControl.getSlider().getSelection();
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder("getStepChargeValues - Step values = ");
            for (int i : stepValues) {
                sb.append(i).append(",").append(" ");
            }
            log.log(Level.FINE, sb.toString());
        }
        return stepValues;
    }

    private void initCurrent(int initialCurrent, int currentStep1, int currentStep2, int currentStep3, int currentStep4) {
        if (currentStep4 == 0) {
            currentStep4 = initialCurrent / 100 * 120;
            currentStep1 = initialCurrent / 100 * 100;
            currentStep2 = initialCurrent / 100 * 200;
            currentStep3 = initialCurrent / 100 * 150;
        }
        this.valueA1 = currentStep1 / 10;
        this.stepSliderA1.setSelection(this.valueA1);
        this.stepSliderA1.redraw();
        this.stepTextA1.setText(String.format("%.2f", (double)this.valueA1 / 100.0));
        this.valueA2 = currentStep2 / 10;
        this.stepSliderA2.setSelection(this.valueA2);
        this.stepSliderA2.redraw();
        this.stepTextA2.setText(String.format("%.2f", (double)this.valueA2 / 100.0));
        this.valueA3 = currentStep3 / 10;
        this.stepSliderA3.setSelection(this.valueA3);
        this.stepSliderA3.redraw();
        this.stepTextA3.setText(String.format("%.2f", (double)this.valueA3 / 100.0));
        this.valueA4 = currentStep4 / 10;
        this.stepSliderA4.setSelection(this.valueA4);
        this.stepSliderA4.redraw();
        this.stepTextA4.setText(String.format("%.2f", (double)this.valueA4 / 100.0));
        this.stepChargeCanvas.redraw();
    }

    public void initCapacity(int initialCapacity, int capacityStep1, int capacityStep2, int capacityStep3, int capacityStep4) {
        if (capacityStep4 == 0) {
            capacityStep1 = initialCapacity / 100 * 10;
            capacityStep2 = initialCapacity / 100 * 60;
            capacityStep3 = initialCapacity / 100 * 80;
            capacityStep4 = (initialCapacity + 70) * 111 / 10000 * 100;
        }
        this.valueC1 = capacityStep1;
        this.stepSliderC1.setSelection(this.valueC1);
        this.stepSliderC1.redraw();
        this.stepTextC1.setText(String.format("%d", this.valueC1));
        this.valueC2 = capacityStep2;
        this.stepSliderC2.setSelection(this.valueC2);
        this.stepSliderC2.redraw();
        this.stepTextC2.setText(String.format("%d", this.valueC2));
        this.valueC3 = capacityStep3;
        this.stepSliderC3.setSelection(this.valueC3);
        this.stepSliderC3.redraw();
        this.stepTextC3.setText(String.format("%d", this.valueC3));
        this.valueC4 = capacityStep4;
        this.stepSliderC4.setSelection(this.valueC4);
        this.stepSliderC4.redraw();
        this.stepTextC4.setText(String.format("%d", this.valueC4));
        this.stepChargeCanvas.redraw();
    }

    private void initGUI() {
        try {
            FillLayout thisLayout = new FillLayout(256);
            this.setLayout((Layout)thisLayout);
            this.setSize(620, 380);
            this.stepChargeGroup = new Group((Composite)this, 0);
            FormLayout stepChargeGroupLayout = new FormLayout();
            this.stepChargeGroup.setLayout((Layout)stepChargeGroupLayout);
            FormData stepChargeCanvasLData = new FormData();
            stepChargeCanvasLData.width = 594;
            stepChargeCanvasLData.height = 180;
            stepChargeCanvasLData.top = new FormAttachment(0, 1000, 5);
            stepChargeCanvasLData.left = new FormAttachment(0, 1000, 5);
            stepChargeCanvasLData.right = new FormAttachment(1000, 1000, -5);
            stepChargeCanvasLData.bottom = new FormAttachment(0, 1000, 130);
            this.stepChargeCanvas = new Canvas((Composite)this.stepChargeGroup, 526336);
            this.stepChargeCanvas.setLayoutData((Object)stepChargeCanvasLData);
            this.stepChargeCanvas.setBackground(SWTResourceManager.getColor((int)250, (int)249, (int)230));
            this.stepChargeCanvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent evt) {
                    log.log(Level.FINEST, "stepChargeCanvas.paintControl, event=" + String.valueOf(evt));
                    Rectangle canvasBounds = StepChargeComposite.this.stepChargeCanvas.getClientArea();
                    if (canvasBounds.width > 0 && canvasBounds.height > 0) {
                        Image canvasImage = new Image((Device)Display.getDefault(), canvasBounds.width, canvasBounds.height);
                        GC canvasImageGC = new GC((Drawable)canvasImage);
                        canvasImageGC.setBackground(SWTResourceManager.getColor((int)250, (int)249, (int)230));
                        canvasImageGC.fillRectangle(canvasBounds);
                        canvasImageGC.setForeground(SWTResourceManager.getColor((int)1));
                        canvasImageGC.setFont(SWTResourceManager.getFont((String)"Sans Serife", (int)(GDE.WIDGET_FONT_SIZE + 6), (int)1));
                        canvasImageGC.setBackground(SWTResourceManager.getColor((int)5));
                        int maxCurrent = StepChargeComposite.this.stepSliderA1.getSelection() > 500 || StepChargeComposite.this.stepSliderA2.getSelection() > 500 || StepChargeComposite.this.stepSliderA3.getSelection() > 500 || StepChargeComposite.this.stepSliderA4.getSelection() > 500 ? (StepChargeComposite.this.stepSliderA1.getSelection() > 1000 || StepChargeComposite.this.stepSliderA2.getSelection() > 1000 || StepChargeComposite.this.stepSliderA3.getSelection() > 1000 || StepChargeComposite.this.stepSliderA4.getSelection() > 1000 ? 2000 : 1000) : 500;
                        int rightEdge1 = canvasBounds.width * (100 + StepChargeComposite.this.stepSliderC1.getSelection()) / (100 + StepChargeComposite.this.stepSliderC4.getSelection() == 0 ? 1 : 100 + StepChargeComposite.this.stepSliderC4.getSelection());
                        int centerPos1x = rightEdge1 / 2;
                        int centerPos1Y = canvasBounds.height - StepChargeComposite.this.valueA1 * canvasBounds.height / maxCurrent / 2;
                        canvasImageGC.fillRectangle(new Rectangle(0, canvasBounds.height - StepChargeComposite.this.valueA1 * canvasBounds.height / maxCurrent, rightEdge1, canvasBounds.height));
                        canvasImageGC.setForeground(SWTResourceManager.getColor((int)1));
                        if (centerPos1x < rightEdge1 && centerPos1Y < canvasBounds.height - 4) {
                            canvasImageGC.drawString("1", centerPos1x - 4, centerPos1Y - 4);
                        }
                        int rightEdge2 = canvasBounds.width * (100 + StepChargeComposite.this.stepSliderC2.getSelection()) / (100 + StepChargeComposite.this.stepSliderC4.getSelection() == 0 ? 1 : 100 + StepChargeComposite.this.stepSliderC4.getSelection()) - rightEdge1;
                        int centerPos2x = rightEdge1 + rightEdge2 / 2;
                        int centerPos2y = canvasBounds.height - StepChargeComposite.this.valueA2 * canvasBounds.height / maxCurrent / 2;
                        canvasImageGC.setBackground(SWTResourceManager.getColor((int)9));
                        log.log(Level.FINEST, "valueA2 = " + StepChargeComposite.this.valueA2);
                        canvasImageGC.fillRectangle(new Rectangle(rightEdge1, canvasBounds.height - StepChargeComposite.this.valueA2 * canvasBounds.height / maxCurrent, rightEdge2, canvasBounds.height));
                        if (centerPos2x < rightEdge1 + rightEdge2 && centerPos2y < canvasBounds.height - 4) {
                            canvasImageGC.drawString("2", centerPos2x - 4, centerPos2y - 4);
                        }
                        int rightEdge3 = canvasBounds.width * (100 + StepChargeComposite.this.stepSliderC3.getSelection()) / (100 + StepChargeComposite.this.stepSliderC4.getSelection() == 0 ? 1 : 100 + StepChargeComposite.this.stepSliderC4.getSelection()) - rightEdge2 - rightEdge1;
                        int centerPos3x = rightEdge1 + rightEdge2 + rightEdge3 / 2;
                        int centerPos3Y = canvasBounds.height - StepChargeComposite.this.valueA3 * canvasBounds.height / maxCurrent / 2;
                        canvasImageGC.setBackground(SWTResourceManager.getColor((int)3));
                        canvasImageGC.fillRectangle(new Rectangle(rightEdge1 + rightEdge2, canvasBounds.height - StepChargeComposite.this.valueA3 * canvasBounds.height / maxCurrent, rightEdge3, canvasBounds.height));
                        if (centerPos3x < rightEdge1 + rightEdge2 + rightEdge3 && centerPos3Y < canvasBounds.height - 4) {
                            canvasImageGC.drawString("3", centerPos3x - 4, centerPos3Y - 4);
                        }
                        int rightEdge4 = canvasBounds.width * (100 + StepChargeComposite.this.stepSliderC4.getSelection()) / (100 + StepChargeComposite.this.stepSliderC4.getSelection() == 0 ? 1 : 100 + StepChargeComposite.this.stepSliderC4.getSelection());
                        int centerPos4x = rightEdge1 + rightEdge2 + rightEdge3 + (rightEdge4 - rightEdge3 - rightEdge2 - rightEdge1) / 2;
                        int centerPos4Y = canvasBounds.height - StepChargeComposite.this.valueA4 * canvasBounds.height / maxCurrent / 2;
                        canvasImageGC.setBackground(SWTResourceManager.getColor((int)15));
                        canvasImageGC.fillRectangle(new Rectangle(rightEdge1 + rightEdge2 + rightEdge3, canvasBounds.height - StepChargeComposite.this.valueA4 * canvasBounds.height / maxCurrent, rightEdge4, canvasBounds.height));
                        if (centerPos4x < rightEdge4 && centerPos4Y < canvasBounds.height - 4) {
                            canvasImageGC.drawString("4", centerPos4x - 4, centerPos4Y - 4);
                        }
                        canvasImageGC.dispose();
                        evt.gc.drawImage(canvasImage, 0, 0);
                        canvasImage.dispose();
                    }
                }
            });
            this.stepAdjustmentComposite = new Composite((Composite)this.stepChargeGroup, 0);
            FillLayout stepAdjustmentCompositeLayout = new FillLayout(256);
            FormData stepAdjustmentCompositeLData = new FormData();
            stepAdjustmentCompositeLData.left = new FormAttachment(0, 1000, 5);
            stepAdjustmentCompositeLData.top = new FormAttachment(0, 1000, 130);
            stepAdjustmentCompositeLData.bottom = new FormAttachment(1000, 1000, -140);
            stepAdjustmentCompositeLData.right = new FormAttachment(1000, 1000, -5);
            this.stepAdjustmentComposite.setLayoutData((Object)stepAdjustmentCompositeLData);
            this.stepAdjustmentComposite.setLayout((Layout)stepAdjustmentCompositeLayout);
            this.stepGroup1 = new Group(this.stepAdjustmentComposite, 0);
            this.stepGroup1.setLayout((Layout)new FillLayout(512));
            this.stepGroup1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepGroup1.setText(Messages.getString((String)"GDE_MSGT2343", (Object[])new String[]{"1"}));
            this.stepLabel = new CLabel((Composite)this.stepGroup1, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2344"));
            this.stepTextC1 = new Text((Composite)this.stepGroup1, 0x1000800);
            this.stepTextC1.setEditable(false);
            this.stepTextC1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderC1 = new Slider((Composite)this.stepGroup1, 2048);
            this.stepSliderC1.setMinimum(0);
            this.stepSliderC1.setMaximum(9810);
            this.stepSliderC1.setIncrement(10);
            this.stepSliderC1.setSelection(250);
            this.valueC1 = 100 + this.stepSliderC1.getSelection();
            this.stepSliderC1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderC1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueC1 = 100 + StepChargeComposite.this.stepSliderC1.getSelection();
                    StepChargeComposite.this.stepTextC1.setText(String.format("%d", StepChargeComposite.this.valueC1));
                    if (StepChargeComposite.this.valueC1 > StepChargeComposite.this.valueC2) {
                        StepChargeComposite.this.valueC2 = StepChargeComposite.this.valueC1;
                        StepChargeComposite.this.stepSliderC2.setSelection(StepChargeComposite.this.valueC2);
                        StepChargeComposite.this.stepSliderC2.redraw();
                    }
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.stepLabel = new CLabel((Composite)this.stepGroup1, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2345"));
            this.stepTextA1 = new Text((Composite)this.stepGroup1, 0x1000800);
            this.stepTextA1.setEditable(false);
            this.stepTextA1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderA1 = new Slider((Composite)this.stepGroup1, 2048);
            this.stepSliderA1.setMinimum(0);
            this.stepSliderA1.setMaximum(2000);
            this.stepSliderA1.setIncrement(1);
            this.stepSliderA1.setSelection(520);
            this.valueA1 = 10 + this.stepSliderA1.getSelection();
            this.stepSliderA1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderA1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueA1 = 10 + StepChargeComposite.this.stepSliderA1.getSelection();
                    StepChargeComposite.this.stepTextA1.setText(String.format("%.2f", (double)StepChargeComposite.this.valueA1 / 100.0));
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.impulsStep1 = new Button((Composite)this.stepGroup1, 16416);
            this.impulsStep1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.impulsStep1.setText(Messages.getString((String)"GDE_MSGT2346"));
            this.impulsStep1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "impulsStep1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.impulseValue1 = StepChargeComposite.this.impulsStep1.getSelection();
                    if (StepChargeComposite.this.impulseValue1) {
                        StepChargeComposite.this.reflexStep1.setSelection(false);
                    }
                }
            });
            this.reflexStep1 = new Button((Composite)this.stepGroup1, 16416);
            this.reflexStep1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reflexStep1.setText(Messages.getString((String)"GDE_MSGT2347"));
            this.reflexStep1.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reflexStep1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.reflexValue1 = StepChargeComposite.this.reflexStep1.getSelection();
                    if (StepChargeComposite.this.reflexValue1) {
                        StepChargeComposite.this.impulsStep1.setSelection(false);
                    }
                }
            });
            this.stepGroup1.layout();
            this.stepGroup2 = new Group(this.stepAdjustmentComposite, 0);
            this.stepGroup2.setLayout((Layout)new FillLayout(512));
            this.stepGroup2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepGroup2.setText(Messages.getString((String)"GDE_MSGT2343", (Object[])new String[]{"2"}));
            this.stepLabel = new CLabel((Composite)this.stepGroup2, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2344"));
            this.stepTextC2 = new Text((Composite)this.stepGroup2, 0x1000800);
            this.stepTextC2.setEditable(false);
            this.stepTextC2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderC2 = new Slider((Composite)this.stepGroup2, 2048);
            this.stepSliderC2.setMinimum(0);
            this.stepSliderC2.setMaximum(9810);
            this.stepSliderC2.setIncrement(10);
            this.stepSliderC2.setSelection(150);
            this.valueC2 = 100 + this.stepSliderC2.getSelection();
            this.stepSliderC2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderC2.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueC2 = 100 + StepChargeComposite.this.stepSliderC2.getSelection();
                    StepChargeComposite.this.stepTextC2.setText(String.format("%d", StepChargeComposite.this.valueC2));
                    if (StepChargeComposite.this.valueC2 < StepChargeComposite.this.valueC1) {
                        StepChargeComposite.this.valueC1 = StepChargeComposite.this.valueC2;
                        StepChargeComposite.this.stepSliderC1.setSelection(StepChargeComposite.this.valueC1);
                        StepChargeComposite.this.stepSliderC1.redraw();
                    }
                    if (StepChargeComposite.this.valueC2 > StepChargeComposite.this.valueC3) {
                        StepChargeComposite.this.valueC3 = StepChargeComposite.this.valueC2;
                        StepChargeComposite.this.stepSliderC3.setSelection(StepChargeComposite.this.valueC3);
                        StepChargeComposite.this.stepSliderC3.redraw();
                    }
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.stepLabel = new CLabel((Composite)this.stepGroup2, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2345"));
            this.stepTextA2 = new Text((Composite)this.stepGroup2, 0x1000800);
            this.stepTextA2.setEditable(false);
            this.stepTextA2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderA2 = new Slider((Composite)this.stepGroup2, 2048);
            this.stepSliderA2.setMinimum(0);
            this.stepSliderA2.setMaximum(2000);
            this.stepSliderA2.setIncrement(1);
            this.stepSliderA2.setSelection(520);
            this.valueA2 = 10 + this.stepSliderA2.getSelection();
            this.stepSliderA2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderA2.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueA2 = 10 + StepChargeComposite.this.stepSliderA2.getSelection();
                    StepChargeComposite.this.stepTextA2.setText(String.format("%.2f", (double)StepChargeComposite.this.valueA2 / 100.0));
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.impulsStep2 = new Button((Composite)this.stepGroup2, 16416);
            this.impulsStep2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.impulsStep2.setText(Messages.getString((String)"GDE_MSGT2346"));
            this.impulsStep2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "impulsStep2.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.impulseValue2 = StepChargeComposite.this.impulsStep2.getSelection();
                    if (StepChargeComposite.this.impulseValue2) {
                        StepChargeComposite.this.reflexStep2.setSelection(false);
                    }
                }
            });
            this.reflexStep2 = new Button((Composite)this.stepGroup2, 16416);
            this.reflexStep2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reflexStep2.setText(Messages.getString((String)"GDE_MSGT2347"));
            this.reflexStep2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reflexStep2.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.reflexValue2 = StepChargeComposite.this.reflexStep2.getSelection();
                    if (StepChargeComposite.this.reflexValue2) {
                        StepChargeComposite.this.impulsStep2.setSelection(false);
                    }
                }
            });
            this.stepGroup2.layout();
            this.stepGroup3 = new Group(this.stepAdjustmentComposite, 0);
            this.stepGroup3.setLayout((Layout)new FillLayout(512));
            this.stepGroup3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepGroup3.setText(Messages.getString((String)"GDE_MSGT2343", (Object[])new String[]{"3"}));
            this.stepLabel = new CLabel((Composite)this.stepGroup3, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2344"));
            this.stepTextC3 = new Text((Composite)this.stepGroup3, 0x1000800);
            this.stepTextC3.setEditable(false);
            this.stepTextC3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderC3 = new Slider((Composite)this.stepGroup3, 2048);
            this.stepSliderC3.setMinimum(0);
            this.stepSliderC3.setMaximum(9810);
            this.stepSliderC3.setIncrement(10);
            this.stepSliderC3.setSelection(150);
            this.valueC3 = 100 + this.stepSliderC3.getSelection();
            this.stepSliderC3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderC1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueC3 = 100 + StepChargeComposite.this.stepSliderC3.getSelection();
                    StepChargeComposite.this.stepTextC3.setText(String.format("%d", StepChargeComposite.this.valueC3));
                    if (StepChargeComposite.this.valueC3 < StepChargeComposite.this.valueC2) {
                        StepChargeComposite.this.valueC2 = StepChargeComposite.this.valueC3;
                        StepChargeComposite.this.stepSliderC2.setSelection(StepChargeComposite.this.valueC2);
                        StepChargeComposite.this.stepSliderC2.redraw();
                    }
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.stepLabel = new CLabel((Composite)this.stepGroup3, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2345"));
            this.stepTextA3 = new Text((Composite)this.stepGroup3, 0x1000800);
            this.stepTextA3.setEditable(false);
            this.stepTextA3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderA3 = new Slider((Composite)this.stepGroup3, 2048);
            this.stepSliderA3.setMinimum(0);
            this.stepSliderA3.setMaximum(2000);
            this.stepSliderA3.setIncrement(1);
            this.stepSliderA3.setSelection(520);
            this.valueA3 = 10 + this.stepSliderA3.getSelection();
            this.stepSliderA3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderA3.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueA3 = 10 + StepChargeComposite.this.stepSliderA3.getSelection();
                    StepChargeComposite.this.stepTextA3.setText(String.format("%.2f", (double)StepChargeComposite.this.valueA3 / 100.0));
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.impulsStep3 = new Button((Composite)this.stepGroup3, 16416);
            this.impulsStep3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.impulsStep3.setText(Messages.getString((String)"GDE_MSGT2346"));
            this.impulsStep3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "impulsStep3.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.impulseValue3 = StepChargeComposite.this.impulsStep3.getSelection();
                    if (StepChargeComposite.this.impulseValue3) {
                        StepChargeComposite.this.reflexStep3.setSelection(false);
                    }
                }
            });
            this.reflexStep3 = new Button((Composite)this.stepGroup3, 16416);
            this.reflexStep3.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reflexStep3.setText(Messages.getString((String)"GDE_MSGT2347"));
            this.reflexStep3.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reflexStep3.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.reflexValue3 = StepChargeComposite.this.reflexStep3.getSelection();
                    if (StepChargeComposite.this.reflexValue3) {
                        StepChargeComposite.this.impulsStep3.setSelection(false);
                    }
                }
            });
            this.stepGroup3.layout();
            this.stepGroup4 = new Group(this.stepAdjustmentComposite, 0);
            this.stepGroup4.setLayout((Layout)new FillLayout(512));
            this.stepGroup4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepGroup4.setText(Messages.getString((String)"GDE_MSGT2343", (Object[])new String[]{"4"}));
            this.stepLabel = new CLabel((Composite)this.stepGroup4, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2344"));
            this.stepTextC4 = new Text((Composite)this.stepGroup4, 0x1000800);
            this.stepTextC4.setEditable(false);
            this.stepTextC4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderC4 = new Slider((Composite)this.stepGroup4, 2048);
            this.stepSliderC4.setMinimum(0);
            this.stepSliderC4.setMaximum(9810);
            this.stepSliderC4.setIncrement(10);
            this.stepSliderC4.setSelection(450);
            this.valueC4 = 100 + this.stepSliderC4.getSelection();
            this.stepSliderC4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderC1.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueC4 = 100 + StepChargeComposite.this.stepSliderC4.getSelection();
                    StepChargeComposite.this.stepTextC4.setText(String.format("%d", StepChargeComposite.this.valueC4));
                    if (StepChargeComposite.this.valueC4 < StepChargeComposite.this.valueC3) {
                        StepChargeComposite.this.valueC3 = StepChargeComposite.this.valueC4;
                        StepChargeComposite.this.stepSliderC3.setSelection(StepChargeComposite.this.valueC3);
                        StepChargeComposite.this.stepSliderC3.redraw();
                    }
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.stepLabel = new CLabel((Composite)this.stepGroup4, 0x1000000);
            this.stepLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepLabel.setText(Messages.getString((String)"GDE_MSGT2345"));
            this.stepTextA4 = new Text((Composite)this.stepGroup4, 0x1000800);
            this.stepTextA4.setEditable(false);
            this.stepTextA4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.stepSliderA4 = new Slider((Composite)this.stepGroup4, 2048);
            this.stepSliderA4.setMinimum(0);
            this.stepSliderA4.setMaximum(2000);
            this.stepSliderA4.setIncrement(1);
            this.stepSliderA4.setSelection(520);
            this.valueA4 = 10 + this.stepSliderA4.getSelection();
            this.stepSliderA4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "stepSliderA4.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.valueA4 = 10 + StepChargeComposite.this.stepSliderA4.getSelection();
                    StepChargeComposite.this.stepTextA4.setText(String.format("%.2f", (double)StepChargeComposite.this.valueA4 / 100.0));
                    if (evt.detail != 0) {
                        StepChargeComposite.this.stepChargeCanvas.redraw();
                    }
                }
            });
            this.impulsStep4 = new Button((Composite)this.stepGroup4, 16416);
            this.impulsStep4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.impulsStep4.setText(Messages.getString((String)"GDE_MSGT2346"));
            this.impulsStep4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "impulsStep4.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.impulseValue4 = StepChargeComposite.this.impulsStep4.getSelection();
                    if (StepChargeComposite.this.impulseValue4) {
                        StepChargeComposite.this.reflexStep4.setSelection(false);
                    }
                }
            });
            this.reflexStep4 = new Button((Composite)this.stepGroup4, 16416);
            this.reflexStep4.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.reflexStep4.setText(Messages.getString((String)"GDE_MSGT2347"));
            this.reflexStep4.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "reflexStep4.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.reflexValue4 = StepChargeComposite.this.reflexStep4.getSelection();
                    if (StepChargeComposite.this.reflexValue4) {
                        StepChargeComposite.this.impulsStep4.setSelection(false);
                    }
                }
            });
            this.stepGroup4.layout();
            this.configComposite = new Composite((Composite)this.stepChargeGroup, 0);
            RowLayout configCompositeLayout = new RowLayout(256);
            FormData configCompositeLData = new FormData();
            configCompositeLData.left = new FormAttachment(0, 1000, 5);
            configCompositeLData.top = new FormAttachment(1000, 1000, -140);
            configCompositeLData.right = new FormAttachment(1000, 1000, -5);
            configCompositeLData.bottom = new FormAttachment(1000, 1000, -5);
            this.configComposite.setLayoutData((Object)configCompositeLData);
            this.configComposite.setLayout((Layout)configCompositeLayout);
            this.configComposite.setBackground(this.stepChargeGroup.getBackground());
            Composite spacer = new Composite(this.configComposite, 0);
            RowData spacerLData = new RowData();
            spacerLData.width = 30;
            spacerLData.height = 20;
            spacer.setLayoutData((Object)spacerLData);
            this.dischargeCheck = new Button(this.configComposite, 16416);
            RowData dischargeCheckLData = new RowData();
            dischargeCheckLData.width = 500;
            dischargeCheckLData.height = 20;
            this.dischargeCheck.setLayoutData((Object)dischargeCheckLData);
            this.dischargeCheck.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
            this.dischargeCheck.setText(Messages.getString((String)"GDE_MSGT2348"));
            this.dischargeCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    log.log(Level.FINEST, "dischargeCheck.widgetSelected, event=" + String.valueOf(evt));
                    StepChargeComposite.this.parent.notifyListeners(13, new Event());
                }
            });
            int[] tricleCurrentValue = new int[]{50};
            this.trickleCurrentControl = new ParameterConfigControl(this.configComposite, tricleCurrentValue, 0, "%d", Messages.getString((String)"GDE_MSGT2279"), 220, "0 - 500 [mA]", 120, false, 50, 150, 0, 500);
            this.trickleCurrentControl.getSlider().notifyListeners(13, new Event());
            int[] peakSensityValue = new int[]{5};
            this.peakConfigControl = new ParameterConfigControl(this.configComposite, peakSensityValue, 0, "%d", "Peak Empfindlichkeit", 220, "0 - 15 [mV/Z]", 120, false, 50, 150, 0, 15);
            this.peakConfigControl.getSlider().notifyListeners(13, new Event());
            int[] cutOffTempValue = new int[]{80};
            this.cutOffTempControl = new ParameterConfigControl(this.configComposite, cutOffTempValue, 0, "%d", "Abschalttemperatur", 220, "10 - 80 [\u00b0C]", 120, false, 50, 150, 10, 80);
            this.cutOffTempControl.getSlider().notifyListeners(13, new Event());
            this.setContent((Control)this.stepChargeGroup);
            this.stepChargeGroup.setSize(620, 490);
            this.addControlListener(new ControlListener(){

                public void controlResized(ControlEvent evt) {
                    log.log(Level.FINEST, "scrolledMemoryComposite.controlResized, event=" + String.valueOf(evt));
                    StepChargeComposite.this.stepChargeGroup.setSize(StepChargeComposite.this.getClientArea().width, 490);
                }

                public void controlMoved(ControlEvent evt) {
                    log.log(Level.FINEST, "scrolledMemoryComposite.controlMoved, event=" + String.valueOf(evt));
                    StepChargeComposite.this.stepChargeGroup.setSize(StepChargeComposite.this.getClientArea().width, 490);
                }
            });
            this.layout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

