/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.device.graupner.MemoryType;
import gde.device.graupner.ObjectFactory;
import gde.device.graupner.UltraDuoPlusDialog;
import gde.device.graupner.UltraDuoPlusType;
import gde.device.graupner.Ultramat;
import gde.device.graupner.UltramatSerialPort;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.utils.StringHelper;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UltraDuoPlusSychronizer
extends Thread {
    static final Logger log = Logger.getLogger(UltraDuoPlusSychronizer.class.getName());
    final UltraDuoPlusDialog dialog;
    final UltramatSerialPort serialPort;
    final UltraDuoPlusType ultraDuoPlusSetup;
    final SYNC_TYPE syncType;
    final long startTime;

    public UltraDuoPlusSychronizer(UltraDuoPlusDialog useDialog, UltramatSerialPort useSerialPort, UltraDuoPlusType useUltraDuoPlusSetup, SYNC_TYPE useSyncType) {
        super(UltraDuoPlusSychronizer.class.getSimpleName() + "/Applications/" + useSyncType.toString());
        this.dialog = useDialog;
        this.serialPort = useSerialPort;
        this.ultraDuoPlusSetup = useUltraDuoPlusSetup;
        this.syncType = useSyncType;
        this.startTime = new Date().getTime();
    }

    @Override
    public void run() {
        try {
            switch (this.syncType.ordinal()) {
                case 0: {
                    this.syncRead();
                    break;
                }
                case 1: {
                    this.syncWrite();
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (TimeOutException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void syncRead() throws IOException, TimeOutException, SerialPortException {
        if (this.serialPort.isConnected()) {
            MemoryType cellMemory;
            if (this.dialog != null) {
                this.dialog.setBackupRetoreButtons(false);
            }
            List<MemoryType> cellMemories = this.ultraDuoPlusSetup.getMemory();
            Iterator<MemoryType> iterator = cellMemories.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                cellMemory = iterator.next();
                if (!cellMemory.isSynced()) {
                    cellMemory.setName(this.serialPort.readMemoryName(i));
                    cellMemory.setSynced(true);
                }
                log.log(Level.FINE, "read memory name " + i + " time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
                ++i;
            }
            if (this.ultraDuoPlusSetup.getChannelData1() == null || !this.ultraDuoPlusSetup.getChannelData1().isSynced()) {
                UltraDuoPlusType.ChannelData1 channelData1 = new ObjectFactory().createUltraDuoPlusTypeChannelData1();
                channelData1.setValue(this.serialPort.readChannelData(1));
                this.ultraDuoPlusSetup.setChannelData1(channelData1);
            }
            if (!(this.dialog == null || this.dialog.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.dialog.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45 || this.ultraDuoPlusSetup.getChannelData2() != null && this.ultraDuoPlusSetup.getChannelData2().isSynced())) {
                UltraDuoPlusType.ChannelData2 channelData2 = new ObjectFactory().createUltraDuoPlusTypeChannelData2();
                channelData2.setValue(this.serialPort.readChannelData(2));
                this.ultraDuoPlusSetup.setChannelData2(channelData2);
            }
            log.log(Level.FINE, "read basics time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
            iterator = cellMemories.iterator();
            i = 1;
            while (iterator.hasNext()) {
                cellMemory = iterator.next();
                if (!cellMemory.getSetupData().isSynced()) {
                    MemoryType.SetupData setupData = cellMemory.getSetupData();
                    setupData.setValue(this.serialPort.readMemorySetup(i));
                    cellMemory.setSetupData(setupData);
                    setupData.setSynced(true);
                }
                log.log(Level.FINE, "read memory setup" + i + " time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
                ++i;
            }
            iterator = cellMemories.iterator();
            i = 1;
            while (iterator.hasNext()) {
                cellMemory = iterator.next();
                if (cellMemory.getStepChargeData() == null || !cellMemory.getStepChargeData().isSynced()) {
                    MemoryType.StepChargeData stepChargeData = cellMemory.getStepChargeData();
                    stepChargeData = stepChargeData == null ? new ObjectFactory().createMemoryTypeStepChargeData() : stepChargeData;
                    stepChargeData.setValue(this.serialPort.readMemoryStepChargeSetup(i));
                    cellMemory.setStepChargeData(stepChargeData);
                    stepChargeData.setSynced(true);
                }
                log.log(Level.FINE, "read memory step charge data " + i + " time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
                ++i;
            }
            log.log(Level.FINE, "read complete memory setup time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
            if (this.dialog != null) {
                this.dialog.setBackupRetoreButtons(true);
            }
        }
    }

    private void syncWrite() throws IOException, TimeOutException {
        if (this.serialPort.isConnected()) {
            if (this.dialog != null) {
                this.dialog.setBackupRetoreButtons(false);
            }
            if (this.ultraDuoPlusSetup.isChanged()) {
                this.serialPort.writeConfigData(UltramatSerialPort.WRITE_DEVICE_IDENTIFIER_NAME, this.ultraDuoPlusSetup.getIdentifierName().getBytes(), 0);
                this.ultraDuoPlusSetup.changed = null;
            }
            this.serialPort.writeConfigData(UltramatSerialPort.WRITE_CHANNEL_SETUP, this.ultraDuoPlusSetup.getChannelData1().getValue().getBytes(), 1);
            this.ultraDuoPlusSetup.getChannelData1().changed = null;
            if (this.dialog != null && this.dialog.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.dialog.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 && this.ultraDuoPlusSetup.getChannelData2().isChanged()) {
                this.serialPort.writeConfigData(UltramatSerialPort.WRITE_CHANNEL_SETUP, this.ultraDuoPlusSetup.getChannelData2().getValue().getBytes(), 2);
                this.ultraDuoPlusSetup.getChannelData2().changed = null;
            }
            List<MemoryType> cellMemories = this.ultraDuoPlusSetup.getMemory();
            Iterator<MemoryType> iterator = cellMemories.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                MemoryType cellMemory = iterator.next();
                if (cellMemory.isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_NAME, cellMemory.getName().getBytes(), i + 1);
                    this.ultraDuoPlusSetup.getMemory().get((int)i).changed = null;
                }
                if (cellMemory.getSetupData().isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_SETUP, cellMemory.getSetupData().getValue().getBytes(), i + 1);
                    this.ultraDuoPlusSetup.getMemory().get((int)i).getSetupData().changed = null;
                }
                if (cellMemory.getStepChargeData() != null && cellMemory.getStepChargeData().isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_STEP_CHARGE_SETUP, cellMemory.getStepChargeData().getValue().getBytes(), i + 1);
                    this.ultraDuoPlusSetup.getMemory().get((int)i).getStepChargeData().changed = null;
                }
                if (cellMemory.getTraceData() != null && cellMemory.getTraceData().isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_TRACE_DATA, cellMemory.getTraceData().getValue().getBytes(), i + 1);
                    this.ultraDuoPlusSetup.getMemory().get((int)i).getTraceData().changed = null;
                }
                if (cellMemory.getCycleData() != null && cellMemory.getCycleData().isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_CYCLE_DATA, cellMemory.getCycleData().getValue().getBytes(), i + 1);
                    this.ultraDuoPlusSetup.getMemory().get((int)i).getCycleData().changed = null;
                }
                ++i;
            }
            Iterator<UltraDuoPlusType.TireHeaterData> tireIterator = this.ultraDuoPlusSetup.getTireHeaterData().iterator();
            int i2 = 0;
            while (tireIterator.hasNext()) {
                UltraDuoPlusType.TireHeaterData tireHeaterData = tireIterator.next();
                if (tireHeaterData != null && tireHeaterData.isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_TIRE_HEATER, tireHeaterData.getValue().getBytes(), i2 + 1);
                    this.ultraDuoPlusSetup.getTireHeaterData().get((int)i2).changed = null;
                }
                ++i2;
            }
            Iterator<UltraDuoPlusType.MotorRunData> motorIterator = this.ultraDuoPlusSetup.getMotorRunData().iterator();
            int i3 = 0;
            while (motorIterator.hasNext()) {
                UltraDuoPlusType.MotorRunData motorRunData = motorIterator.next();
                if (motorRunData != null && motorRunData.isChanged()) {
                    this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MOTOR_RUN, motorRunData.getValue().getBytes(), i3 + 1);
                    this.ultraDuoPlusSetup.getMotorRunData().get((int)i3).changed = null;
                }
                ++i3;
            }
            log.log(Level.FINE, "complete update (write) time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - this.startTime)));
            if (this.dialog != null) {
                this.dialog.setBackupRetoreButtons(true);
            }
        }
    }

    public static enum SYNC_TYPE {
        READ,
        WRITE;

    }
}

