/*
 * Decompiled with CFR 0.152.
 */
package gde.device.junsi.modbus;

import gde.io.DataParser;
import java.util.ArrayList;

public class ChargerStatus {
    int timeStamp;
    int outputPower;
    short outputCurrent;
    short inputVoltage;
    short outputVoltage;
    int outputCapacity;
    short internalTemperature;
    short externalTemperature;
    CellVoltages cellVoltages;
    CellBalances cellBalances;
    CellResistances cellResistances;
    short cellTotalResistance;
    short effectiveResistance;
    short cycleCount;
    short controlStatus;
    short runStatus;
    byte errorStatusHigh;
    byte errorStatusLow;
    short dialogBoxId;
    CellCapacities cellCapacities;

    public ChargerStatus(byte[] chargerStatusBuffer) {
        this.timeStamp = DataParser.parse2Int((byte[])chargerStatusBuffer, (int)0);
        this.outputPower = DataParser.parse2Int((byte[])chargerStatusBuffer, (int)4);
        this.outputCurrent = DataParser.parse2Short((byte)chargerStatusBuffer[8], (byte)chargerStatusBuffer[9]);
        this.inputVoltage = DataParser.parse2Short((byte)chargerStatusBuffer[10], (byte)chargerStatusBuffer[11]);
        this.outputVoltage = DataParser.parse2Short((byte)chargerStatusBuffer[12], (byte)chargerStatusBuffer[13]);
        this.outputCapacity = DataParser.parse2Int((byte[])chargerStatusBuffer, (int)14);
        this.internalTemperature = DataParser.parse2Short((byte)chargerStatusBuffer[18], (byte)chargerStatusBuffer[19]);
        this.externalTemperature = DataParser.parse2Short((byte)chargerStatusBuffer[20], (byte)chargerStatusBuffer[21]);
        byte[] chargerVoltageBuffer = new byte[32];
        System.arraycopy(chargerStatusBuffer, 22, chargerVoltageBuffer, 0, chargerVoltageBuffer.length);
        this.cellVoltages = new CellVoltages(this, chargerVoltageBuffer);
        byte[] cellBalanceBuffer = new byte[16];
        System.arraycopy(chargerStatusBuffer, 54, cellBalanceBuffer, 0, cellBalanceBuffer.length);
        this.cellBalances = new CellBalances(this, cellBalanceBuffer);
        byte[] cellResistanceBuffer = new byte[32];
        System.arraycopy(chargerStatusBuffer, 70, cellResistanceBuffer, 0, cellResistanceBuffer.length);
        this.cellResistances = new CellResistances(this, cellResistanceBuffer);
        this.cellTotalResistance = DataParser.parse2Short((byte)chargerStatusBuffer[102], (byte)chargerStatusBuffer[103]);
        this.effectiveResistance = DataParser.parse2Short((byte)chargerStatusBuffer[104], (byte)chargerStatusBuffer[105]);
        this.cycleCount = DataParser.parse2Short((byte)chargerStatusBuffer[106], (byte)chargerStatusBuffer[107]);
        this.controlStatus = DataParser.parse2Short((byte)chargerStatusBuffer[108], (byte)chargerStatusBuffer[109]);
        this.runStatus = DataParser.parse2Short((byte)chargerStatusBuffer[110], (byte)chargerStatusBuffer[111]);
        this.errorStatusLow = chargerStatusBuffer[112];
        this.errorStatusHigh = chargerStatusBuffer[113];
        this.dialogBoxId = DataParser.parse2Short((byte)chargerStatusBuffer[114], (byte)chargerStatusBuffer[115]);
        byte[] cellCapacityBuffer = new byte[32];
        System.arraycopy(chargerStatusBuffer, 116, cellCapacityBuffer, 0, cellCapacityBuffer.length);
        this.cellCapacities = new CellCapacities(this, cellCapacityBuffer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("\n");
        sb.append(String.format("outputPower \t\t = %d", this.outputPower)).append("\n");
        sb.append(String.format("inputVoltage \t\t = %d", this.inputVoltage)).append("\n");
        sb.append(String.format("outputVoltage \t\t = %d", this.outputVoltage)).append("\n");
        sb.append(String.format("outputCapacity \t\t = %d", this.outputCapacity)).append("\n");
        sb.append(String.format("internalTemperature \t = %d", this.internalTemperature)).append("\n");
        sb.append(String.format("externalTemperature \t = %d", this.externalTemperature)).append("\n");
        sb.append(String.format("cellTotalResistance \t = %d", this.cellTotalResistance)).append("\n");
        sb.append(String.format("effectiveResistance \t = %d", this.effectiveResistance)).append("\n");
        sb.append(String.format("cycleCount \t\t = %d", this.cycleCount)).append("\n");
        sb.append(String.format("controlStatus \t\t = %d", this.controlStatus)).append("\n");
        sb.append(String.format("runStatus \t\t = %d", this.runStatus)).append("\n");
        sb.append(String.format("errorStatus \t\t = %s", this.getStatusInfo())).append("\n");
        sb.append(String.format("dialogBoxId \t\t = %d", this.dialogBoxId)).append("\n");
        return sb.toString();
    }

    public static int getSize() {
        return 174;
    }

    public String getStatusInfo() {
        try {
            return String.format("errorStatus \t\t\t= %02d%02d (%s)", this.errorStatusHigh, this.errorStatusLow, ErrorStatus.VALUES[this.errorStatusHigh]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public int getOutputPower() {
        return this.outputPower;
    }

    public short getInputVoltage() {
        return this.inputVoltage;
    }

    public short getOutputVoltage() {
        return this.outputVoltage;
    }

    public int getOutputCapacity() {
        return this.outputCapacity;
    }

    public short getInternalTemperature() {
        return this.internalTemperature;
    }

    public short getExternalTemperature() {
        return this.externalTemperature;
    }

    public CellVoltages getCellVoltages() {
        return this.cellVoltages;
    }

    public CellBalances getCellBalances() {
        return this.cellBalances;
    }

    public CellResistances getCellResistances() {
        return this.cellResistances;
    }

    public short getCellTotalResistance() {
        return this.cellTotalResistance;
    }

    public short getEffectiveResistance() {
        return this.effectiveResistance;
    }

    public short getCycleCount() {
        return this.cycleCount;
    }

    public short getControlStatus() {
        return this.controlStatus;
    }

    public short getRunStatus() {
        return this.runStatus;
    }

    public short getErrorStatus() {
        return Short.valueOf(this.getStatusInfo());
    }

    public short getDialogBoxId() {
        return this.dialogBoxId;
    }

    public CellCapacities getCellCapacities() {
        return this.cellCapacities;
    }

    class CellVoltages {
        short cellVoltage01;
        short cellVoltage02;
        short cellVoltage03;
        short cellVoltage04;
        short cellVoltage05;
        short cellVoltage06;
        short cellVoltage07;
        short cellVoltage08;
        short cellVoltage09;
        short cellVoltage10;
        short cellVoltage11;
        short cellVoltage12;
        short cellVoltage13;
        short cellVoltage14;
        short cellVoltage15;
        short cellVoltage16;

        CellVoltages(ChargerStatus this$0, byte[] cellVoltageBuffer) {
            this.cellVoltage01 = DataParser.parse2Short((byte)cellVoltageBuffer[0], (byte)cellVoltageBuffer[1]);
            this.cellVoltage02 = DataParser.parse2Short((byte)cellVoltageBuffer[2], (byte)cellVoltageBuffer[3]);
            this.cellVoltage03 = DataParser.parse2Short((byte)cellVoltageBuffer[4], (byte)cellVoltageBuffer[5]);
            this.cellVoltage04 = DataParser.parse2Short((byte)cellVoltageBuffer[6], (byte)cellVoltageBuffer[7]);
            this.cellVoltage05 = DataParser.parse2Short((byte)cellVoltageBuffer[8], (byte)cellVoltageBuffer[9]);
            this.cellVoltage06 = DataParser.parse2Short((byte)cellVoltageBuffer[10], (byte)cellVoltageBuffer[11]);
            this.cellVoltage07 = DataParser.parse2Short((byte)cellVoltageBuffer[12], (byte)cellVoltageBuffer[13]);
            this.cellVoltage08 = DataParser.parse2Short((byte)cellVoltageBuffer[14], (byte)cellVoltageBuffer[15]);
            this.cellVoltage09 = DataParser.parse2Short((byte)cellVoltageBuffer[16], (byte)cellVoltageBuffer[17]);
            this.cellVoltage10 = DataParser.parse2Short((byte)cellVoltageBuffer[18], (byte)cellVoltageBuffer[19]);
            this.cellVoltage11 = DataParser.parse2Short((byte)cellVoltageBuffer[20], (byte)cellVoltageBuffer[21]);
            this.cellVoltage12 = DataParser.parse2Short((byte)cellVoltageBuffer[22], (byte)cellVoltageBuffer[23]);
            this.cellVoltage13 = DataParser.parse2Short((byte)cellVoltageBuffer[24], (byte)cellVoltageBuffer[25]);
            this.cellVoltage14 = DataParser.parse2Short((byte)cellVoltageBuffer[26], (byte)cellVoltageBuffer[27]);
            this.cellVoltage15 = DataParser.parse2Short((byte)cellVoltageBuffer[28], (byte)cellVoltageBuffer[29]);
            this.cellVoltage16 = DataParser.parse2Short((byte)cellVoltageBuffer[30], (byte)cellVoltageBuffer[31]);
        }
    }

    class CellBalances {
        byte cellBalance01;
        byte cellBalance02;
        byte cellBalance03;
        byte cellBalance04;
        byte cellBalance05;
        byte cellBalance06;
        byte cellBalance07;
        byte cellBalance08;
        byte cellBalance09;
        byte cellBalance10;
        byte cellBalance11;
        byte cellBalance12;
        byte cellBalance13;
        byte cellBalance14;
        byte cellBalance15;
        byte cellBalance16;

        CellBalances(ChargerStatus this$0, byte[] cellBalanceBuffer) {
            this.cellBalance01 = cellBalanceBuffer[0];
            this.cellBalance02 = cellBalanceBuffer[1];
            this.cellBalance03 = cellBalanceBuffer[2];
            this.cellBalance04 = cellBalanceBuffer[3];
            this.cellBalance05 = cellBalanceBuffer[4];
            this.cellBalance06 = cellBalanceBuffer[5];
            this.cellBalance07 = cellBalanceBuffer[6];
            this.cellBalance08 = cellBalanceBuffer[7];
            this.cellBalance09 = cellBalanceBuffer[8];
            this.cellBalance10 = cellBalanceBuffer[9];
            this.cellBalance11 = cellBalanceBuffer[10];
            this.cellBalance12 = cellBalanceBuffer[11];
            this.cellBalance13 = cellBalanceBuffer[12];
            this.cellBalance14 = cellBalanceBuffer[13];
            this.cellBalance15 = cellBalanceBuffer[14];
            this.cellBalance16 = cellBalanceBuffer[15];
        }
    }

    class CellResistances {
        short cellResistance01;
        short cellResistance02;
        short cellResistance03;
        short cellResistance04;
        short cellResistance05;
        short cellResistance06;
        short cellResistance07;
        short cellResistance08;
        short cellResistance09;
        short cellResistance10;
        short cellResistance11;
        short cellResistance12;
        short cellResistance13;
        short cellResistance14;
        short cellResistance15;
        short cellResistance16;

        CellResistances(ChargerStatus this$0, byte[] cellResistanceBuffer) {
            this.cellResistance01 = DataParser.parse2Short((byte)cellResistanceBuffer[0], (byte)cellResistanceBuffer[1]);
            this.cellResistance02 = DataParser.parse2Short((byte)cellResistanceBuffer[2], (byte)cellResistanceBuffer[3]);
            this.cellResistance03 = DataParser.parse2Short((byte)cellResistanceBuffer[4], (byte)cellResistanceBuffer[5]);
            this.cellResistance04 = DataParser.parse2Short((byte)cellResistanceBuffer[6], (byte)cellResistanceBuffer[7]);
            this.cellResistance05 = DataParser.parse2Short((byte)cellResistanceBuffer[8], (byte)cellResistanceBuffer[9]);
            this.cellResistance06 = DataParser.parse2Short((byte)cellResistanceBuffer[10], (byte)cellResistanceBuffer[11]);
            this.cellResistance07 = DataParser.parse2Short((byte)cellResistanceBuffer[12], (byte)cellResistanceBuffer[13]);
            this.cellResistance08 = DataParser.parse2Short((byte)cellResistanceBuffer[14], (byte)cellResistanceBuffer[15]);
            this.cellResistance09 = DataParser.parse2Short((byte)cellResistanceBuffer[16], (byte)cellResistanceBuffer[17]);
            this.cellResistance10 = DataParser.parse2Short((byte)cellResistanceBuffer[18], (byte)cellResistanceBuffer[19]);
            this.cellResistance11 = DataParser.parse2Short((byte)cellResistanceBuffer[20], (byte)cellResistanceBuffer[21]);
            this.cellResistance12 = DataParser.parse2Short((byte)cellResistanceBuffer[22], (byte)cellResistanceBuffer[23]);
            this.cellResistance13 = DataParser.parse2Short((byte)cellResistanceBuffer[24], (byte)cellResistanceBuffer[25]);
            this.cellResistance14 = DataParser.parse2Short((byte)cellResistanceBuffer[26], (byte)cellResistanceBuffer[27]);
            this.cellResistance15 = DataParser.parse2Short((byte)cellResistanceBuffer[28], (byte)cellResistanceBuffer[29]);
            this.cellResistance16 = DataParser.parse2Short((byte)cellResistanceBuffer[30], (byte)cellResistanceBuffer[31]);
        }
    }

    class CellCapacities {
        short cellCapacity01;
        short cellCapacity02;
        short cellCapacity03;
        short cellCapacity04;
        short cellCapacity05;
        short cellCapacity06;
        short cellCapacity07;
        short cellCapacity08;
        short cellCapacity09;
        short cellCapacity10;
        short cellCapacity11;
        short cellCapacity12;
        short cellCapacity13;
        short cellCapacity14;
        short cellCapacity15;
        short cellCapacity16;

        CellCapacities(ChargerStatus this$0, byte[] cellCapacityBuffer) {
            this.cellCapacity01 = DataParser.parse2Short((byte)cellCapacityBuffer[0], (byte)cellCapacityBuffer[1]);
            this.cellCapacity02 = DataParser.parse2Short((byte)cellCapacityBuffer[2], (byte)cellCapacityBuffer[3]);
            this.cellCapacity03 = DataParser.parse2Short((byte)cellCapacityBuffer[4], (byte)cellCapacityBuffer[5]);
            this.cellCapacity04 = DataParser.parse2Short((byte)cellCapacityBuffer[6], (byte)cellCapacityBuffer[7]);
            this.cellCapacity05 = DataParser.parse2Short((byte)cellCapacityBuffer[8], (byte)cellCapacityBuffer[9]);
            this.cellCapacity06 = DataParser.parse2Short((byte)cellCapacityBuffer[10], (byte)cellCapacityBuffer[11]);
            this.cellCapacity07 = DataParser.parse2Short((byte)cellCapacityBuffer[12], (byte)cellCapacityBuffer[13]);
            this.cellCapacity08 = DataParser.parse2Short((byte)cellCapacityBuffer[14], (byte)cellCapacityBuffer[15]);
            this.cellCapacity09 = DataParser.parse2Short((byte)cellCapacityBuffer[16], (byte)cellCapacityBuffer[17]);
            this.cellCapacity10 = DataParser.parse2Short((byte)cellCapacityBuffer[18], (byte)cellCapacityBuffer[19]);
            this.cellCapacity11 = DataParser.parse2Short((byte)cellCapacityBuffer[20], (byte)cellCapacityBuffer[21]);
            this.cellCapacity12 = DataParser.parse2Short((byte)cellCapacityBuffer[22], (byte)cellCapacityBuffer[23]);
            this.cellCapacity13 = DataParser.parse2Short((byte)cellCapacityBuffer[24], (byte)cellCapacityBuffer[25]);
            this.cellCapacity14 = DataParser.parse2Short((byte)cellCapacityBuffer[26], (byte)cellCapacityBuffer[27]);
            this.cellCapacity15 = DataParser.parse2Short((byte)cellCapacityBuffer[28], (byte)cellCapacityBuffer[29]);
            this.cellCapacity16 = DataParser.parse2Short((byte)cellCapacityBuffer[30], (byte)cellCapacityBuffer[31]);
        }
    }

    static enum ErrorStatus {
        HC_OK,
        HC_CHECK_WAIT,
        HC_ERR_VIN_OVER,
        HC_ERR_VIN_LOW,
        HC_ERR_VOUT_OVER,
        HC_ERR_BAT_LOW,
        HC_ERR_BAT_OVER,
        HC_ERR_COUT_OVER,
        HC_ERR_COUT_LOW,
        HC_ERR_CIN_OVER,
        HC_ERR_CIN_LOW,
        HC_ERR_TEMP_OVER,
        HC_ERR_TEMP_LOW,
        HC_ERR_CHECK,
        HC_ERR_GND,
        HC_ERR_POLARITY,
        HC_ERR_CONTROL,
        HC_ERR_TIMEOVER,
        HC_ERR_CAP,
        HC_ERR_TEMP,
        HC_ERR_CURRENT_NULL,
        HC_ERR_CELLS_LINE,
        HC_ERR_CELLS_LOW,
        HC_ERR_CELLS_OVER,
        HC_ERR_CELLS_L_VOUT,
        HC_ERR_CELLS_O_VOUT,
        HC_ERR_CELLS_SET,
        HC_ERR_CELLS_SET_LOW,
        HC_ERR_CELLS_SET_OVER,
        HC_ERR_BAL_PORT,
        HC_ERR_NO_BAL,
        HC_ERR_CELLS_AUTO,
        HC_ERR_AWD,
        HC_ERR_SYN_IMBAL,
        HC_ERR_REG_NO_LOAD,
        HC_ERR_CH_OCCUPIED,
        HC_ERR_REG_CAP,
        HC_NULL;

        public static String[] VALUES;

        private static String[] getValues() {
            ArrayList<String> list = new ArrayList<String>();
            for (ErrorStatus element : ErrorStatus.values()) {
                list.add(element.name());
            }
            return list.toArray(new String[0]);
        }

        static {
            VALUES = ErrorStatus.getValues();
        }
    }
}

