/*
 * Decompiled with CFR 0.152.
 */
package gde.device.elprog;

import gde.device.CheckSumTypes;
import gde.device.FormatTypes;
import gde.device.InputTypes;
import gde.exception.DevicePropertiesInconsistenceException;
import gde.io.DataParser;
import java.util.logging.Logger;

public class PulsarDataParser
extends DataParser {
    static Logger log = Logger.getLogger(DataParser.class.getName());
    protected double integratedEnergy = 0.0;
    protected final int offset;
    protected int intermediateState;

    public PulsarDataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, int useDataSize, int offset) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useDataSize);
        this.offset = offset;
    }

    public PulsarDataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, FormatTypes useCheckSumFormatType, int useDataSize, FormatTypes useDataFormatType, boolean doMultiply1000, int offset) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useCheckSumFormatType, useDataSize, useDataFormatType, doMultiply1000);
        this.offset = offset;
    }

    public PulsarDataParser(int useTimeFactor, String useLeaderChar, String useSeparator, CheckSumTypes useCheckSumType, FormatTypes useCheckSumFormatType, int useDataSize, FormatTypes useDataFormatType, boolean doMultiply1000) {
        super(useTimeFactor, useLeaderChar, useSeparator, useCheckSumType, useCheckSumFormatType, useDataSize, useDataFormatType, doMultiply1000);
        this.offset = 2;
    }

    public void parse(String inputLine, int lineNum) throws DevicePropertiesInconsistenceException {
        String[] strValues = inputLine.split(this.separator);
        String strValue = strValues[0].trim();
        switch (inputLine.charAt(0)) {
            default: {
                this.state = strValue.charAt(3);
                this.valueSize = 40;
                this.values = new int[Math.abs(this.device.getDataBlockSize(InputTypes.FILE_IO))];
                int[] tmpValues = new int[this.valueSize];
                for (int i = 0; i < this.valueSize - this.offset - 1; ++i) {
                    strValue = strValues[i + this.offset].trim();
                    try {
                        int n = tmpValues[i] = strValue.length() > 0 ? Integer.parseInt(strValue) : 0;
                        if (i < 5) continue;
                        tmpValues[i] = (strValue = strValues[++i + this.offset].trim()).length() > 0 && !strValue.equals(":") ? Integer.parseInt(strValue) : 100;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        tmpValues[i] = 0;
                    }
                }
                int maxVotage = Integer.MIN_VALUE;
                int minVotage = Integer.MAX_VALUE;
                this.values[0] = tmpValues[0];
                this.values[1] = tmpValues[1];
                this.values[2] = tmpValues[3] * 1000;
                this.values[3] = Double.valueOf((double)this.values[0] / 1000.0 * ((double)this.values[1] / 1000.0) * 1000.0).intValue();
                this.values[4] = Double.valueOf(this.integratedEnergy += ((double)this.values[0] / 1000.0 * (double)this.values[1] / 1000.0 / 3600.0 + 0.5) * 1000.0).intValue();
                this.values[5] = tmpValues[2];
                this.values[6] = tmpValues[4];
                int i = 0;
                int j = 0;
                while (i < 16) {
                    this.values[i + 8] = tmpValues[j + 5];
                    if (this.values[i + 8] > 0) {
                        maxVotage = this.values[i + 8] > maxVotage ? this.values[i + 8] : maxVotage;
                        minVotage = this.values[i + 8] < minVotage ? this.values[i + 8] : minVotage;
                    }
                    ++i;
                    j += 2;
                }
                this.values[7] = (maxVotage != Integer.MIN_VALUE && minVotage != Integer.MAX_VALUE ? maxVotage - minVotage : 0) * 1000;
                i = 0;
                j = 0;
                while (i < 16) {
                    this.values[i + 40] = tmpValues[j + 6];
                    ++i;
                    j += 2;
                }
                strValue = strValues[0].trim();
                if (strValue.charAt(8) == '_') break;
                this.intermediateState = strValue.charAt(8);
                break;
            }
            case '!': {
                strValues = inputLine.substring(1).split(this.separator);
                for (int i = 0; i < 16; ++i) {
                    try {
                        this.values[i + 24] = strValues[i].length() > 0 ? Integer.parseInt(strValues[i]) * 100 : 0;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        this.values[i + 24] = 0;
                    }
                }
            }
        }
    }

    public int[] getValues(int[] existingPoints) {
        for (int i = 0; i < existingPoints.length && i < this.values.length; ++i) {
            if (existingPoints[i] == 0) continue;
            this.values[i] = existingPoints[i];
        }
        return this.values;
    }
}

