/*
 * Decompiled with CFR 0.152.
 */
package gde.comm;

import org.usb4java.ConfigDescriptor;
import org.usb4java.Context;
import org.usb4java.DescriptorUtils;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class DumpDevicesLibUsb {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpConfigurationDescriptors(Device device, int numConfigurations) {
        for (byte i = 0; i < numConfigurations; i = (byte)(i + 1)) {
            ConfigDescriptor descriptor = new ConfigDescriptor();
            int result = LibUsb.getConfigDescriptor((Device)device, (byte)i, (ConfigDescriptor)descriptor);
            if (result < 0) {
                System.out.println(new LibUsbException("Unable to read config descriptor", result).getMessage());
                continue;
            }
            try {
                System.out.println(descriptor.dump().replaceAll("(?m)^", "  "));
                continue;
            }
            finally {
                try {
                    LibUsb.freeConfigDescriptor((ConfigDescriptor)descriptor);
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void dumpDevice(Device device) {
        Device parent;
        int address = LibUsb.getDeviceAddress((Device)device);
        int busNumber = LibUsb.getBusNumber((Device)device);
        System.out.println(String.format("Device %03d/%03d", busNumber, address));
        int portNumber = LibUsb.getPortNumber((Device)device);
        if (portNumber != 0) {
            System.out.println("Connected to port: " + portNumber);
        }
        if ((parent = LibUsb.getParent((Device)device)) != null) {
            int parentAddress = LibUsb.getDeviceAddress((Device)parent);
            int parentBusNumber = LibUsb.getBusNumber((Device)parent);
            System.out.println(String.format("Parent: %03d/%03d", parentBusNumber, parentAddress));
        }
        System.out.println("Speed: " + DescriptorUtils.getSpeedName((int)LibUsb.getDeviceSpeed((Device)device)));
        DeviceDescriptor descriptor = new DeviceDescriptor();
        int result = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)descriptor);
        if (result < 0) {
            throw new LibUsbException("Unable to read device descriptor", result);
        }
        DeviceHandle handle = new DeviceHandle();
        result = LibUsb.open((Device)device, (DeviceHandle)handle);
        if (result < 0) {
            System.out.println(String.format("Unable to open device: %s. Continuing without device handle.", LibUsb.strError((int)result)));
            handle = null;
        }
        System.out.print(descriptor.dump(handle));
        DumpDevicesLibUsb.dumpConfigurationDescriptors(device, descriptor.bNumConfigurations());
        if (handle != null) {
            LibUsb.close((DeviceHandle)handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Context context = new Context();
        int result = LibUsb.init((Context)context);
        if (result < 0) {
            throw new LibUsbException("Unable to initialize libusb", result);
        }
        DeviceList list = new DeviceList();
        result = LibUsb.getDeviceList((Context)context, (DeviceList)list);
        if (result < 0) {
            throw new LibUsbException("Unable to get device list", result);
        }
        try {
            for (Device device : list) {
                DumpDevicesLibUsb.dumpDevice(device);
            }
        }
        finally {
            LibUsb.freeDeviceList((DeviceList)list, (boolean)true);
        }
        LibUsb.exit((Context)context);
    }
}

