/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.datasources;

import gde.Analyzer;
import gde.GDE;
import gde.data.Channel;
import gde.device.IDevice;
import gde.exception.NotSupportedFileFormatException;
import gde.histo.datasources.HistoSet;
import gde.histo.datasources.SourceDataSet;
import gde.histo.datasources.SourceFolders;
import gde.histo.datasources.WatchDir;
import gde.log.Logger;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;

public final class DirectoryScanner {
    private static final String $CLASS_NAME = DirectoryScanner.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final int SLOW_FOLDER_LIMIT_MS = 222;
    private static WatchDir watchDir;
    private static Thread watchDirThread;
    private final SourceFoldersBuilder sourceFoldersBuilder;
    private final Analyzer analyzer;
    private final CheckedPredicate<HistoSet.RebuildStep> sourceFileValidator;

    public static Path getActiveFolder4Ui() {
        return new DirectoryScanner(Analyzer.getInstance()).getActiveFolder();
    }

    public Path getActiveFolder() {
        IDevice device = this.analyzer.getActiveDevice();
        String activeObjectKey = this.analyzer.getSettings().getActiveObjectKey();
        String subPathData = activeObjectKey.isEmpty() ? device.getDeviceConfiguration().getPureDeviceName(device.getName()) : activeObjectKey;
        return Paths.get(this.analyzer.getSettings().getDataFilePath(), new String[0]).resolve(subPathData);
    }

    public DirectoryScanner(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.sourceFoldersBuilder = new SourceFoldersBuilder(analyzer);
        this.sourceFileValidator = analyzer.getSettings().isSourceFileListenerActive() ? r -> this.validateDirectoryFiles((HistoSet.RebuildStep)((Object)r)) : r -> this.validateDirectoryPaths((HistoSet.RebuildStep)((Object)r));
        this.initialize();
    }

    public void initialize() {
        this.sourceFoldersBuilder.initialize();
    }

    private void initializeWatchDir(List<Path> sourceLogPaths) {
        DirectoryScanner.closeWatchDir();
        final SourceFolders sourceFolders = this.sourceFoldersBuilder.sourceFolders;
        Predicate<Path> workableFileDecider = new Predicate<Path>(){

            @Override
            public boolean test(Path filePath) {
                Set<SourceFolders.DirectoryType> directoryTypes = sourceFolders.getMap().entrySet().stream().filter(e -> filePath.startsWith((Path)e.getKey())).map(e -> (Set)e.getValue()).flatMap(Collection::stream).collect(Collectors.toSet());
                SourceDataSet sourceDataSet = SourceDataSet.createSourceDataSet(filePath, DirectoryScanner.this.analyzer);
                return sourceDataSet != null && sourceDataSet.isWorkableFile(directoryTypes, sourceFolders);
            }
        };
        try {
            boolean recursive = true;
            watchDir = new WatchDir(sourceLogPaths, recursive, workableFileDecider);
            watchDirThread = new Thread(watchDir::processEvents, "watchDir");
            try {
                watchDirThread.start();
                log.log(Level.FINEST, "watchDir thread started");
            }
            catch (RuntimeException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static void closeWatchDir() {
        if (watchDirThread != null) {
            try {
                watchDirThread.interrupt();
                watchDirThread.join();
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public HistoSet.RebuildStep isValidated(HistoSet.RebuildStep rebuildStep) throws IOException, NotSupportedFileFormatException {
        if (this.sourceFileValidator.test(rebuildStep)) {
            return rebuildStep;
        }
        if (rebuildStep.isEqualOrBiggerThan(HistoSet.RebuildStep.B_HISTOVAULTS)) {
            return rebuildStep;
        }
        return HistoSet.RebuildStep.B_HISTOVAULTS;
    }

    private boolean validateDirectoryFiles(HistoSet.RebuildStep rebuildStep) throws IOException, NotSupportedFileFormatException {
        boolean isValid;
        this.sourceFoldersBuilder.validateAndBuild(rebuildStep);
        boolean bl = isValid = !this.sourceFoldersBuilder.isMajorChange();
        if (watchDir == null || !isValid) {
            this.initializeWatchDir(this.sourceFoldersBuilder.sourceFolders.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
        log.log(Level.FINER, "hasChangedLogFiles=", watchDir.hasChangedLogFiles());
        return isValid && !watchDir.hasChangedLogFilesThenReset();
    }

    private boolean validateDirectoryPaths(HistoSet.RebuildStep rebuildStep) throws IOException, NotSupportedFileFormatException {
        this.sourceFoldersBuilder.validateAndBuild(rebuildStep);
        return !this.sourceFoldersBuilder.isMajorChange();
    }

    public int getValidatedFoldersCount() {
        if (this.sourceFoldersBuilder.sourceFolders != null) {
            return this.sourceFoldersBuilder.sourceFolders.getFoldersCount();
        }
        return 0;
    }

    public SourceFolders getSourceFolders() {
        return this.sourceFoldersBuilder.sourceFolders;
    }

    public boolean isSlowFolderAccess() {
        return this.sourceFoldersBuilder.isSlowFolderAccess;
    }

    public boolean isChannelChangeOnly() {
        return this.sourceFoldersBuilder.isChannelChangeOnly;
    }

    private static final class SourceFoldersBuilder {
        private static final Logger log = Logger.getLogger(SourceFoldersBuilder.class.getName());
        private final EnumSet<SourceFolders.DirectoryType> validatedDirectoryTypes = EnumSet.noneOf(SourceFolders.DirectoryType.class);
        private final Analyzer analyzer;
        private IDevice validatedDevice = null;
        private Channel validatedChannel = null;
        private String validatedObjectKey = "";
        private SourceFolders sourceFolders = null;
        private boolean isSlowFolderAccess = false;
        private boolean isMajorChange = false;
        private boolean isChannelChangeOnly = false;

        public SourceFoldersBuilder(Analyzer analyzer) {
            this.analyzer = analyzer;
            this.sourceFolders = new SourceFolders(analyzer);
        }

        public void initialize() {
            this.validatedDirectoryTypes.clear();
            this.validatedDevice = null;
            this.validatedObjectKey = "";
            this.isSlowFolderAccess = false;
            this.isMajorChange = false;
            this.isChannelChangeOnly = false;
        }

        public boolean validateAndBuild(HistoSet.RebuildStep rebuildStep) throws IOException, NotSupportedFileFormatException {
            IDevice lastDevice = this.validatedDevice;
            Channel lastChannel = this.validatedChannel;
            EnumSet<SourceFolders.DirectoryType> lastDirectoryTypes = EnumSet.copyOf(this.validatedDirectoryTypes);
            String lastObjectKey = this.validatedObjectKey;
            boolean isFirstCall = lastDevice == null;
            this.isMajorChange = rebuildStep == HistoSet.RebuildStep.A_HISTOSET || isFirstCall;
            this.validatedDevice = this.analyzer.getActiveDevice();
            boolean isNewDevice = lastDevice != null && this.validatedDevice != null ? !lastDevice.getName().equals(this.validatedDevice.getName()) : this.validatedDevice != null;
            this.isMajorChange = this.isMajorChange || isNewDevice;
            this.validatedDirectoryTypes.clear();
            this.validatedDirectoryTypes.addAll(SourceFolders.DirectoryType.getValidDirectoryTypes(this.validatedDevice, this.analyzer.getSettings()));
            this.isMajorChange = this.isMajorChange || !lastDirectoryTypes.equals(this.validatedDirectoryTypes);
            this.validatedObjectKey = this.analyzer.getSettings().getActiveObjectKey();
            boolean bl = this.isMajorChange = this.isMajorChange || !lastObjectKey.equals(this.validatedObjectKey);
            if (this.isMajorChange) {
                long nanoTime = System.nanoTime();
                Consumer<String> signaler = this.isSlowFolderAccess ? s -> GDE.getUiNotification().setStatusMessage((String)s) : s -> {};
                this.sourceFolders.defineDirectories(signaler);
                long foldersCount = this.sourceFolders.values().stream().mapToInt(Collection::size).sum();
                long elapsed_ms = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTime);
                this.isSlowFolderAccess = elapsed_ms / (foldersCount + 3L) > 222L;
                log.fine(() -> "slowFolderAccess=" + this.isSlowFolderAccess + "  numberOfFolders=" + foldersCount + " in " + elapsed_ms + " [ms]");
            }
            this.validatedChannel = this.analyzer.getActiveChannel();
            this.isChannelChangeOnly = !this.isMajorChange && HistoSet.RebuildStep.B_HISTOVAULTS.isEqualOrBiggerThan(rebuildStep) && !lastChannel.equals(this.validatedChannel);
            this.isMajorChange = this.isMajorChange || !lastChannel.equals(this.validatedChannel);
            return true;
        }

        public boolean isMajorChange() {
            return this.isMajorChange;
        }
    }

    @FunctionalInterface
    static interface CheckedPredicate<U> {
        public boolean test(U var1) throws IOException, NotSupportedFileFormatException;
    }
}

