/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.xml.XmlDomWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XfaForm {
    private Xml2SomTemplate templateSom;
    private Node templateNode;
    private Xml2SomDatasets datasetsSom;
    private Node datasetsNode;
    private AcroFieldsSearch acroFieldsSom;
    private PdfReader reader;
    private boolean xfaPresent;
    private Document domDocument;
    private boolean changed;
    public static final String XFA_DATA_SCHEMA = "http://www.xfa.org/schema/xfa-data/1.0/";

    public XfaForm() {
    }

    public static PdfObject getXfaObject(PdfReader reader) {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return null;
        }
        return PdfReader.getPdfObjectRelease(af.get(PdfName.XFA));
    }

    public XfaForm(PdfReader reader) throws IOException, ParserConfigurationException, SAXException {
        this.reader = reader;
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa == null) {
            this.xfaPresent = false;
            return;
        }
        this.xfaPresent = true;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            for (int k2 = 1; k2 < ar.size(); k2 += 2) {
                PdfObject ob = ar.getDirectObject(k2);
                if (!(ob instanceof PRStream)) continue;
                byte[] b2 = PdfReader.getStreamBytes((PRStream)ob);
                bout.write(b2);
            }
        } else if (xfa instanceof PRStream) {
            byte[] b3 = PdfReader.getStreamBytes((PRStream)xfa);
            bout.write(b3);
        }
        bout.close();
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        fact.setNamespaceAware(true);
        DocumentBuilder db = fact.newDocumentBuilder();
        this.domDocument = db.parse(new ByteArrayInputStream(bout.toByteArray()));
        this.extractNodes();
    }

    private void extractNodes() {
        Map<String, Node> xfaNodes = XfaForm.extractXFANodes(this.domDocument);
        if (xfaNodes.containsKey("template")) {
            this.templateNode = xfaNodes.get("template");
            this.templateSom = new Xml2SomTemplate(this.templateNode);
        }
        if (xfaNodes.containsKey("datasets")) {
            this.datasetsNode = xfaNodes.get("datasets");
            Node dataNode = this.findDataNode(this.datasetsNode);
            this.datasetsSom = new Xml2SomDatasets(dataNode != null ? dataNode : this.datasetsNode.getFirstChild());
        }
        if (this.datasetsNode == null) {
            this.createDatasetsNode(this.domDocument.getFirstChild());
        }
    }

    private Node findDataNode(Node datasetsNode) {
        NodeList childNodes = datasetsNode.getChildNodes();
        for (int i2 = 0; i2 < childNodes.getLength(); ++i2) {
            if (!childNodes.item(i2).getNodeName().equals("xfa:data")) continue;
            return childNodes.item(i2);
        }
        return null;
    }

    public static Map<String, Node> extractXFANodes(Document domDocument) {
        HashMap<String, Node> xfaNodes = new HashMap<String, Node>();
        Node n2 = domDocument.getFirstChild();
        while (n2.getChildNodes().getLength() == 0) {
            n2 = n2.getNextSibling();
        }
        for (n2 = n2.getFirstChild(); n2 != null; n2 = n2.getNextSibling()) {
            if (n2.getNodeType() != 1) continue;
            String s2 = n2.getLocalName();
            xfaNodes.put(s2, n2);
        }
        return xfaNodes;
    }

    private void createDatasetsNode(Node n2) {
        while (n2.getChildNodes().getLength() == 0) {
            n2 = n2.getNextSibling();
        }
        if (n2 != null) {
            Element e2 = n2.getOwnerDocument().createElement("xfa:datasets");
            e2.setAttribute("xmlns:xfa", XFA_DATA_SCHEMA);
            this.datasetsNode = e2;
            n2.appendChild(this.datasetsNode);
        }
    }

    public static void setXfa(XfaForm form2, PdfReader reader, PdfWriter writer) throws IOException {
        PdfDictionary af = (PdfDictionary)PdfReader.getPdfObjectRelease(reader.getCatalog().get(PdfName.ACROFORM));
        if (af == null) {
            return;
        }
        PdfObject xfa = XfaForm.getXfaObject(reader);
        if (xfa.isArray()) {
            PdfArray ar = (PdfArray)xfa;
            int t2 = -1;
            int d2 = -1;
            for (int k2 = 0; k2 < ar.size(); k2 += 2) {
                PdfString s2 = ar.getAsString(k2);
                if ("template".equals(s2.toString())) {
                    t2 = k2 + 1;
                }
                if (!"datasets".equals(s2.toString())) continue;
                d2 = k2 + 1;
            }
            if (t2 > -1 && d2 > -1) {
                reader.killXref(ar.getAsIndirectObject(t2));
                reader.killXref(ar.getAsIndirectObject(d2));
                PdfStream tStream = new PdfStream(XfaForm.serializeDoc(form2.templateNode));
                tStream.flateCompress(writer.getCompressionLevel());
                ar.set(t2, writer.addToBody(tStream).getIndirectReference());
                PdfStream dStream = new PdfStream(XfaForm.serializeDoc(form2.datasetsNode));
                dStream.flateCompress(writer.getCompressionLevel());
                ar.set(d2, writer.addToBody(dStream).getIndirectReference());
                af.put(PdfName.XFA, new PdfArray(ar));
                return;
            }
        }
        reader.killXref(af.get(PdfName.XFA));
        PdfStream str = new PdfStream(XfaForm.serializeDoc(form2.domDocument));
        str.flateCompress(writer.getCompressionLevel());
        PdfIndirectReference ref = writer.addToBody(str).getIndirectReference();
        af.put(PdfName.XFA, ref);
    }

    public void setXfa(PdfWriter writer) throws IOException {
        XfaForm.setXfa(this, this.reader, writer);
    }

    public static byte[] serializeDoc(Node n2) throws IOException {
        XmlDomWriter xw = new XmlDomWriter();
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        xw.setOutput(fout, null);
        xw.setCanonical(false);
        xw.write(n2);
        fout.close();
        return fout.toByteArray();
    }

    public boolean isXfaPresent() {
        return this.xfaPresent;
    }

    public Document getDomDocument() {
        return this.domDocument;
    }

    public String findFieldName(String name, AcroFields af) {
        Map<String, AcroFields.Item> items = af.getFields();
        if (items.containsKey(name)) {
            return name;
        }
        if (this.acroFieldsSom == null) {
            this.acroFieldsSom = items.isEmpty() && this.xfaPresent ? new AcroFieldsSearch(this.datasetsSom.getName2Node().keySet()) : new AcroFieldsSearch(items.keySet());
        }
        if (this.acroFieldsSom.getAcroShort2LongName().containsKey(name)) {
            return this.acroFieldsSom.getAcroShort2LongName().get(name);
        }
        return this.acroFieldsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public String findDatasetsName(String name) {
        if (this.datasetsSom.getName2Node().containsKey(name)) {
            return name;
        }
        return this.datasetsSom.inverseSearchGlobal(Xml2Som.splitParts(name));
    }

    public Node findDatasetsNode(String name) {
        if (name == null) {
            return null;
        }
        if ((name = this.findDatasetsName(name)) == null) {
            return null;
        }
        return this.datasetsSom.getName2Node().get(name);
    }

    public static String getNodeText(Node n2) {
        if (n2 == null) {
            return "";
        }
        return XfaForm.getNodeText(n2, "");
    }

    private static String getNodeText(Node n2, String name) {
        for (Node n22 = n2.getFirstChild(); n22 != null; n22 = n22.getNextSibling()) {
            if (n22.getNodeType() == 1) {
                name = XfaForm.getNodeText(n22, name);
                continue;
            }
            if (n22.getNodeType() != 3) continue;
            name = name + n22.getNodeValue();
        }
        return name;
    }

    public void setNodeText(Node n2, String text2) {
        if (n2 == null) {
            return;
        }
        Node nc = null;
        while ((nc = n2.getFirstChild()) != null) {
            n2.removeChild(nc);
        }
        if (n2.getAttributes().getNamedItemNS(XFA_DATA_SCHEMA, "dataNode") != null) {
            n2.getAttributes().removeNamedItemNS(XFA_DATA_SCHEMA, "dataNode");
        }
        n2.appendChild(this.domDocument.createTextNode(text2));
        this.changed = true;
    }

    public void setXfaPresent(boolean xfaPresent) {
        this.xfaPresent = xfaPresent;
    }

    public void setDomDocument(Document domDocument) {
        this.domDocument = domDocument;
        this.extractNodes();
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public void setReader(PdfReader reader) {
        this.reader = reader;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed2) {
        this.changed = changed2;
    }

    public Xml2SomTemplate getTemplateSom() {
        return this.templateSom;
    }

    public void setTemplateSom(Xml2SomTemplate templateSom) {
        this.templateSom = templateSom;
    }

    public Xml2SomDatasets getDatasetsSom() {
        return this.datasetsSom;
    }

    public void setDatasetsSom(Xml2SomDatasets datasetsSom) {
        this.datasetsSom = datasetsSom;
    }

    public AcroFieldsSearch getAcroFieldsSom() {
        return this.acroFieldsSom;
    }

    public void setAcroFieldsSom(AcroFieldsSearch acroFieldsSom) {
        this.acroFieldsSom = acroFieldsSom;
    }

    public Node getDatasetsNode() {
        return this.datasetsNode;
    }

    public void fillXfaForm(File file) throws IOException {
        this.fillXfaForm(file, false);
    }

    public void fillXfaForm(File file, boolean readOnly) throws IOException {
        this.fillXfaForm(new FileInputStream(file), readOnly);
    }

    public void fillXfaForm(InputStream is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputStream is, boolean readOnly) throws IOException {
        this.fillXfaForm(new InputSource(is), readOnly);
    }

    public void fillXfaForm(InputSource is) throws IOException {
        this.fillXfaForm(is, false);
    }

    public void fillXfaForm(InputSource is, boolean readOnly) throws IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document newdoc = db.parse(is);
            this.fillXfaForm(newdoc.getDocumentElement(), readOnly);
        }
        catch (ParserConfigurationException e2) {
            throw new ExceptionConverter(e2);
        }
        catch (SAXException e3) {
            throw new ExceptionConverter(e3);
        }
    }

    public void fillXfaForm(Node node) {
        this.fillXfaForm(node, false);
    }

    public void fillXfaForm(Node node, boolean readOnly) {
        NodeList list2;
        if (readOnly) {
            NodeList nodeList = this.domDocument.getElementsByTagName("field");
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                ((Element)nodeList.item(i2)).setAttribute("access", "readOnly");
            }
        }
        NodeList allChilds = this.datasetsNode.getChildNodes();
        int len = allChilds.getLength();
        Node data2 = null;
        for (int k2 = 0; k2 < len; ++k2) {
            Node n2 = allChilds.item(k2);
            if (n2.getNodeType() != 1 || !n2.getLocalName().equals("data") || !XFA_DATA_SCHEMA.equals(n2.getNamespaceURI())) continue;
            data2 = n2;
            break;
        }
        if (data2 == null) {
            data2 = this.datasetsNode.getOwnerDocument().createElementNS(XFA_DATA_SCHEMA, "xfa:data");
            this.datasetsNode.appendChild(data2);
        }
        if ((list2 = data2.getChildNodes()).getLength() == 0) {
            data2.appendChild(this.domDocument.importNode(node, true));
        } else {
            Node firstNode = this.getFirstElementNode(data2);
            if (firstNode != null) {
                data2.replaceChild(this.domDocument.importNode(node, true), firstNode);
            }
        }
        this.extractNodes();
        this.setChanged(true);
    }

    private Node getFirstElementNode(Node src) {
        Node result2 = null;
        NodeList list2 = src.getChildNodes();
        for (int i2 = 0; i2 < list2.getLength(); ++i2) {
            if (list2.item(i2).getNodeType() != 1) continue;
            result2 = list2.item(i2);
            break;
        }
        return result2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Xml2SomTemplate
    extends Xml2Som {
        private boolean dynamicForm;
        private int templateLevel;

        public Xml2SomTemplate(Node n2) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.templateLevel = 0;
            this.inverseSearch = new HashMap();
            this.processTemplate(n2, null);
        }

        public String getFieldType(String s2) {
            Node ui;
            Node n2 = (Node)this.name2Node.get(s2);
            if (n2 == null) {
                return null;
            }
            if ("exclGroup".equals(n2.getLocalName())) {
                return "exclGroup";
            }
            for (ui = n2.getFirstChild(); !(ui == null || ui.getNodeType() == 1 && "ui".equals(ui.getLocalName())); ui = ui.getNextSibling()) {
            }
            if (ui == null) {
                return null;
            }
            for (Node type2 = ui.getFirstChild(); type2 != null; type2 = type2.getNextSibling()) {
                if (type2.getNodeType() != 1 || "extras".equals(type2.getLocalName()) && "picture".equals(type2.getLocalName())) continue;
                return type2.getLocalName();
            }
            return null;
        }

        private void processTemplate(Node n2, HashMap<String, Integer> ff) {
            if (ff == null) {
                ff = new HashMap();
            }
            HashMap<String, Integer> ss = new HashMap<String, Integer>();
            for (Node n22 = n2.getFirstChild(); n22 != null; n22 = n22.getNextSibling()) {
                if (n22.getNodeType() != 1) continue;
                String s2 = n22.getLocalName();
                if ("subform".equals(s2)) {
                    Integer i2;
                    Node name = n22.getAttributes().getNamedItem("name");
                    String nn = "#subform";
                    boolean annon = true;
                    if (name != null) {
                        nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                        annon = false;
                    }
                    if (annon) {
                        i2 = this.anform;
                        ++this.anform;
                    } else {
                        i2 = (Integer)ss.get(nn);
                        i2 = i2 == null ? Integer.valueOf(0) : Integer.valueOf(i2 + 1);
                        ss.put(nn, i2);
                    }
                    this.stack.push(nn + "[" + i2.toString() + "]");
                    ++this.templateLevel;
                    if (annon) {
                        this.processTemplate(n22, ff);
                    } else {
                        this.processTemplate(n22, null);
                    }
                    --this.templateLevel;
                    this.stack.pop();
                    continue;
                }
                if ("field".equals(s2) || "exclGroup".equals(s2)) {
                    Node name = n22.getAttributes().getNamedItem("name");
                    if (name == null) continue;
                    String nn = Xml2SomTemplate.escapeSom(name.getNodeValue());
                    Integer i3 = ff.get(nn);
                    i3 = i3 == null ? Integer.valueOf(0) : Integer.valueOf(i3 + 1);
                    ff.put(nn, i3);
                    this.stack.push(nn + "[" + i3.toString() + "]");
                    String unstack = this.printStack();
                    this.order.add(unstack);
                    this.inverseSearchAdd(unstack);
                    this.name2Node.put(unstack, n22);
                    this.stack.pop();
                    continue;
                }
                if (this.dynamicForm || this.templateLevel <= 0 || !"occur".equals(s2)) continue;
                int initial = 1;
                int min = 1;
                int max = 1;
                Node a2 = n22.getAttributes().getNamedItem("initial");
                if (a2 != null) {
                    try {
                        initial = Integer.parseInt(a2.getNodeValue().trim());
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if ((a2 = n22.getAttributes().getNamedItem("min")) != null) {
                    try {
                        min = Integer.parseInt(a2.getNodeValue().trim());
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                if ((a2 = n22.getAttributes().getNamedItem("max")) != null) {
                    try {
                        max = Integer.parseInt(a2.getNodeValue().trim());
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                if (initial == min && min == max) continue;
                this.dynamicForm = true;
            }
        }

        public boolean isDynamicForm() {
            return this.dynamicForm;
        }

        public void setDynamicForm(boolean dynamicForm) {
            this.dynamicForm = dynamicForm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcroFieldsSearch
    extends Xml2Som {
        private HashMap<String, String> acroShort2LongName;

        public AcroFieldsSearch(Collection<String> items) {
            this.inverseSearch = new HashMap();
            this.acroShort2LongName = new HashMap();
            Iterator<String> i$ = items.iterator();
            while (i$.hasNext()) {
                String string2;
                String itemName = string2 = i$.next();
                String itemShort = AcroFieldsSearch.getShortName(itemName);
                this.acroShort2LongName.put(itemShort, itemName);
                AcroFieldsSearch.inverseSearchAdd(this.inverseSearch, AcroFieldsSearch.splitParts(itemShort), itemName);
            }
        }

        public HashMap<String, String> getAcroShort2LongName() {
            return this.acroShort2LongName;
        }

        public void setAcroShort2LongName(HashMap<String, String> acroShort2LongName) {
            this.acroShort2LongName = acroShort2LongName;
        }
    }

    public static class Xml2SomDatasets
    extends Xml2Som {
        public Xml2SomDatasets(Node n2) {
            this.order = new ArrayList();
            this.name2Node = new HashMap();
            this.stack = new Stack2();
            this.anform = 0;
            this.inverseSearch = new HashMap();
            this.processDatasetsInternal(n2);
        }

        public Node insertNode(Node n2, String shortName) {
            Stack2<String> stack = Xml2SomDatasets.splitParts(shortName);
            Document doc = n2.getOwnerDocument();
            Node n22 = null;
            n2 = n2.getFirstChild();
            while (n2.getNodeType() != 1) {
                n2 = n2.getNextSibling();
            }
            for (int k2 = 0; k2 < stack.size(); ++k2) {
                String s2;
                String part = (String)stack.get(k2);
                int idx = part.lastIndexOf(91);
                String name = part.substring(0, idx);
                idx = Integer.parseInt(part.substring(idx + 1, part.length() - 1));
                int found = -1;
                for (n22 = n2.getFirstChild(); !(n22 == null || n22.getNodeType() == 1 && (s2 = Xml2SomDatasets.escapeSom(n22.getLocalName())).equals(name) && ++found == idx); n22 = n22.getNextSibling()) {
                }
                while (found < idx) {
                    n22 = doc.createElementNS(null, name);
                    n22 = n2.appendChild(n22);
                    Attr attr = doc.createAttributeNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
                    attr.setNodeValue("dataGroup");
                    n22.getAttributes().setNamedItemNS(attr);
                    ++found;
                }
                n2 = n22;
            }
            Xml2SomDatasets.inverseSearchAdd(this.inverseSearch, stack, shortName);
            this.name2Node.put(shortName, n22);
            this.order.add(shortName);
            return n22;
        }

        private static boolean hasChildren(Node n2) {
            Node dataNodeN = n2.getAttributes().getNamedItemNS(XfaForm.XFA_DATA_SCHEMA, "dataNode");
            if (dataNodeN != null) {
                String dataNode = dataNodeN.getNodeValue();
                if ("dataGroup".equals(dataNode)) {
                    return true;
                }
                if ("dataValue".equals(dataNode)) {
                    return false;
                }
            }
            if (!n2.hasChildNodes()) {
                return false;
            }
            for (Node n22 = n2.getFirstChild(); n22 != null; n22 = n22.getNextSibling()) {
                if (n22.getNodeType() != 1) continue;
                return true;
            }
            return false;
        }

        private void processDatasetsInternal(Node n2) {
            if (n2 != null) {
                HashMap<String, Integer> ss = new HashMap<String, Integer>();
                for (Node n22 = n2.getFirstChild(); n22 != null; n22 = n22.getNextSibling()) {
                    if (n22.getNodeType() != 1) continue;
                    String s2 = Xml2SomDatasets.escapeSom(n22.getLocalName());
                    Integer i2 = (Integer)ss.get(s2);
                    i2 = i2 == null ? Integer.valueOf(0) : Integer.valueOf(i2 + 1);
                    ss.put(s2, i2);
                    this.stack.push(s2 + "[" + i2.toString() + "]");
                    if (Xml2SomDatasets.hasChildren(n22)) {
                        this.processDatasetsInternal(n22);
                    }
                    String unstack = this.printStack();
                    this.order.add(unstack);
                    this.inverseSearchAdd(unstack);
                    this.name2Node.put(unstack, n22);
                    this.stack.pop();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Xml2Som {
        protected ArrayList<String> order;
        protected HashMap<String, Node> name2Node;
        protected HashMap<String, InverseStore> inverseSearch;
        protected Stack2<String> stack;
        protected int anform;

        public static String escapeSom(String s2) {
            if (s2 == null) {
                return "";
            }
            int idx = s2.indexOf(46);
            if (idx < 0) {
                return s2;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                sb.append('\\');
                last = idx;
                idx = s2.indexOf(46, idx + 1);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        public static String unescapeSom(String s2) {
            int idx = s2.indexOf(92);
            if (idx < 0) {
                return s2;
            }
            StringBuffer sb = new StringBuffer();
            int last = 0;
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                last = idx + 1;
                idx = s2.indexOf(92, idx + 1);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        protected String printStack() {
            if (this.stack.empty()) {
                return "";
            }
            StringBuffer s2 = new StringBuffer();
            for (int k2 = 0; k2 < this.stack.size(); ++k2) {
                s2.append('.').append((String)this.stack.get(k2));
            }
            return s2.substring(1);
        }

        public static String getShortName(String s2) {
            int idx = s2.indexOf(".#subform[");
            if (idx < 0) {
                return s2;
            }
            int last = 0;
            StringBuffer sb = new StringBuffer();
            while (idx >= 0) {
                sb.append(s2.substring(last, idx));
                idx = s2.indexOf("]", idx + 10);
                if (idx < 0) {
                    return sb.toString();
                }
                last = idx + 1;
                idx = s2.indexOf(".#subform[", last);
            }
            sb.append(s2.substring(last));
            return sb.toString();
        }

        public void inverseSearchAdd(String unstack) {
            Xml2Som.inverseSearchAdd(this.inverseSearch, this.stack, unstack);
        }

        public static void inverseSearchAdd(HashMap<String, InverseStore> inverseSearch, Stack2<String> stack, String unstack) {
            String last = stack.peek();
            InverseStore store = inverseSearch.get(last);
            if (store == null) {
                store = new InverseStore();
                inverseSearch.put(last, store);
            }
            for (int k2 = stack.size() - 2; k2 >= 0; --k2) {
                InverseStore store2;
                last = (String)stack.get(k2);
                int idx = store.part.indexOf(last);
                if (idx < 0) {
                    store.part.add(last);
                    store2 = new InverseStore();
                    store.follow.add(store2);
                } else {
                    store2 = (InverseStore)store.follow.get(idx);
                }
                store = store2;
            }
            store.part.add("");
            store.follow.add(unstack);
        }

        public String inverseSearchGlobal(ArrayList<String> parts) {
            if (parts.isEmpty()) {
                return null;
            }
            InverseStore store = this.inverseSearch.get(parts.get(parts.size() - 1));
            if (store == null) {
                return null;
            }
            for (int k2 = parts.size() - 2; k2 >= 0; --k2) {
                String part = parts.get(k2);
                int idx = store.part.indexOf(part);
                if (idx < 0) {
                    if (store.isSimilar(part)) {
                        return null;
                    }
                    return store.getDefaultName();
                }
                store = (InverseStore)store.follow.get(idx);
            }
            return store.getDefaultName();
        }

        public static Stack2<String> splitParts(String name) {
            String part;
            while (name.startsWith(".")) {
                name = name.substring(1);
            }
            Stack2<String> parts = new Stack2<String>();
            int last = 0;
            int pos = 0;
            while (true) {
                pos = last;
                while ((pos = name.indexOf(46, pos)) >= 0 && name.charAt(pos - 1) == '\\') {
                    ++pos;
                }
                if (pos < 0) break;
                part = name.substring(last, pos);
                if (!part.endsWith("]")) {
                    part = part + "[0]";
                }
                parts.add(part);
                last = pos + 1;
            }
            part = name.substring(last);
            if (!part.endsWith("]")) {
                part = part + "[0]";
            }
            parts.add(part);
            return parts;
        }

        public ArrayList<String> getOrder() {
            return this.order;
        }

        public void setOrder(ArrayList<String> order) {
            this.order = order;
        }

        public HashMap<String, Node> getName2Node() {
            return this.name2Node;
        }

        public void setName2Node(HashMap<String, Node> name2Node) {
            this.name2Node = name2Node;
        }

        public HashMap<String, InverseStore> getInverseSearch() {
            return this.inverseSearch;
        }

        public void setInverseSearch(HashMap<String, InverseStore> inverseSearch) {
            this.inverseSearch = inverseSearch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Stack2<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -7451476576174095212L;

        public T peek() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(this.size() - 1);
        }

        public T pop() {
            if (this.size() == 0) {
                throw new EmptyStackException();
            }
            Object ret = this.get(this.size() - 1);
            this.remove(this.size() - 1);
            return (T)ret;
        }

        public T push(T item2) {
            this.add(item2);
            return item2;
        }

        public boolean empty() {
            return this.size() == 0;
        }
    }

    public static class InverseStore {
        protected ArrayList<String> part = new ArrayList();
        protected ArrayList<Object> follow = new ArrayList();

        public String getDefaultName() {
            InverseStore store = this;
            Object obj;
            while (!((obj = store.follow.get(0)) instanceof String)) {
                store = (InverseStore)obj;
            }
            return (String)obj;
        }

        public boolean isSimilar(String name) {
            int idx = name.indexOf(91);
            name = name.substring(0, idx + 1);
            for (int k2 = 0; k2 < this.part.size(); ++k2) {
                if (!this.part.get(k2).startsWith(name)) continue;
                return true;
            }
            return false;
        }
    }
}

