/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

class MouseNavigator {
    private final StyledText parent;
    boolean navigationActivated = false;
    private GC gc;
    private static final int CIRCLE_RADIUS = 15;
    private static final int CENTRAL_POINT_RADIUS = 2;
    private Point originalMouseLocation;
    private final Listener mouseDownListener;
    private final Listener mouseUpListener;
    private final Listener paintListener;
    private final Listener mouseMoveListener;
    private final Listener focusOutListener;
    private boolean hasHBar;
    private boolean hasVBar;
    private Cursor previousCursor;

    MouseNavigator(StyledText styledText) {
        if (styledText == null) {
            SWT.error(4);
        }
        if (styledText.isDisposed()) {
            SWT.error(24);
        }
        this.parent = styledText;
        this.mouseDownListener = event -> this.onMouseDown(event);
        this.parent.addListener(3, this.mouseDownListener);
        this.mouseUpListener = event -> this.onMouseUp(event);
        this.parent.addListener(4, this.mouseUpListener);
        this.paintListener = event -> this.onPaint(event);
        this.parent.addListener(9, this.paintListener);
        this.mouseMoveListener = event -> this.onMouseMove(event);
        this.parent.addListener(5, this.mouseMoveListener);
        this.focusOutListener = event -> this.onFocusOut(event);
        this.parent.addListener(16, this.focusOutListener);
    }

    void onMouseDown(Event e2) {
        if (e2.button != 2 || this.navigationActivated) {
            return;
        }
        if (!this.parent.isVisible() || !this.parent.getEnabled() || this.parent.middleClickPressed) {
            return;
        }
        this.initBarState();
        if (!this.hasHBar && !this.hasVBar) {
            return;
        }
        this.navigationActivated = true;
        this.previousCursor = this.parent.getCursor();
        this.parent.setCursor(this.parent.getDisplay().getSystemCursor(0));
        this.originalMouseLocation = this.getMouseLocation();
        this.parent.redraw();
    }

    private void initBarState() {
        this.hasHBar = this.computeHasHorizontalBar();
        this.hasVBar = this.computeHasVerticalBar();
    }

    private boolean computeHasHorizontalBar() {
        boolean exceedHorizontalSpace;
        ScrollBar horizontalBar = this.parent.getHorizontalBar();
        boolean hasHorizontalBar = horizontalBar != null && horizontalBar.isVisible();
        boolean bl = exceedHorizontalSpace = this.parent.computeSize((int)-1, (int)-1).x > this.parent.getSize().x;
        return hasHorizontalBar && exceedHorizontalSpace;
    }

    private boolean computeHasVerticalBar() {
        boolean exceedVerticalSpace;
        ScrollBar verticalBar = this.parent.getVerticalBar();
        boolean hasVerticalBar = verticalBar != null && verticalBar.isEnabled();
        boolean bl = exceedVerticalSpace = this.parent.computeSize((int)-1, (int)-1).y > this.parent.getSize().y;
        return hasVerticalBar && exceedVerticalSpace;
    }

    private void onMouseUp(Event e2) {
        if (this.computeDist() < 15 && this.computeDist() >= 0) {
            return;
        }
        this.deactivate();
    }

    public int computeDist() {
        if (this.originalMouseLocation == null) {
            return -1;
        }
        Point mouseLocation = this.getMouseLocation();
        int deltaX = this.originalMouseLocation.x - mouseLocation.x;
        int deltaY = this.originalMouseLocation.y - mouseLocation.y;
        int dist = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        return dist;
    }

    private void deactivate() {
        this.parent.setCursor(this.previousCursor);
        this.navigationActivated = false;
        this.originalMouseLocation = null;
        this.parent.redraw();
    }

    private void onFocusOut(Event e2) {
        this.deactivate();
    }

    private void onMouseMove(Event e2) {
        ScrollBar bar;
        if (!this.navigationActivated) {
            return;
        }
        Point mouseLocation = this.getMouseLocation();
        int deltaX = this.originalMouseLocation.x - mouseLocation.x;
        int deltaY = this.originalMouseLocation.y - mouseLocation.y;
        int dist = (int)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        if (dist < 15) {
            return;
        }
        this.parent.setRedraw(false);
        if (this.hasHBar) {
            bar = this.parent.getHorizontalBar();
            bar.setSelection((int)((double)bar.getSelection() - (double)deltaX * 0.1));
            this.fireSelectionEvent(e2, bar);
        }
        if (this.hasVBar) {
            bar = this.parent.getVerticalBar();
            bar.setSelection((int)((double)bar.getSelection() - (double)deltaY * 0.1));
            this.fireSelectionEvent(e2, bar);
        }
        this.parent.setRedraw(true);
        this.parent.redraw();
    }

    private void fireSelectionEvent(Event e2, ScrollBar bar) {
        Event event = new Event();
        event.widget = bar;
        event.display = this.parent.getDisplay();
        event.type = 13;
        event.time = e2.time;
        Listener[] listenerArray = bar.getListeners(13);
        int n2 = listenerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Listener selectionListener = listenerArray[n3];
            selectionListener.handleEvent(event);
            ++n3;
        }
    }

    private Point getMouseLocation() {
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        Point relativeCursorLocation = this.parent.toControl(cursorLocation);
        return relativeCursorLocation;
    }

    private void onPaint(Event e2) {
        if (!this.navigationActivated) {
            return;
        }
        Rectangle rect = this.parent.getClientArea();
        if (rect.width == 0 || rect.height == 0) {
            return;
        }
        this.gc = e2.gc;
        this.gc.setAntialias(1);
        this.gc.setAdvanced(true);
        Color oldForegroundColor = this.gc.getForeground();
        Color oldBackgroundColor = this.gc.getBackground();
        this.gc.setBackground(this.parent.getForeground());
        this.drawCircle();
        this.drawCentralPoint();
        this.drawArrows();
        this.gc.setForeground(oldForegroundColor);
        this.gc.setBackground(oldBackgroundColor);
    }

    private void drawCircle() {
        this.gc.setBackground(this.parent.getBackground());
        this.gc.setForeground(this.parent.getForeground());
        this.gc.setAlpha(200);
        this.gc.fillOval(this.originalMouseLocation.x - 15, this.originalMouseLocation.y - 15, 30, 30);
        this.gc.setBackground(this.parent.getForeground());
        this.gc.setAlpha(255);
        this.gc.drawOval(this.originalMouseLocation.x - 15, this.originalMouseLocation.y - 15, 30, 30);
    }

    private void drawCentralPoint() {
        this.gc.fillOval(this.originalMouseLocation.x - 2, this.originalMouseLocation.y - 2, 4, 4);
    }

    private void drawArrows() {
        this.gc.setLineWidth(2);
        if (this.hasHBar) {
            this.drawHorizontalArrows();
        }
        if (this.hasVBar) {
            this.drawVerticalArrows();
        }
    }

    private void drawHorizontalArrows() {
        int[] points = new int[]{this.originalMouseLocation.x - 6, this.originalMouseLocation.y + 3, this.originalMouseLocation.x - 9, this.originalMouseLocation.y, this.originalMouseLocation.x - 6, this.originalMouseLocation.y - 3};
        this.gc.drawPolyline(points);
        points[0] = this.originalMouseLocation.x + 7;
        points[1] = this.originalMouseLocation.y + 3;
        points[2] = this.originalMouseLocation.x + 10;
        points[3] = this.originalMouseLocation.y;
        points[4] = this.originalMouseLocation.x + 7;
        points[5] = this.originalMouseLocation.y - 3;
        this.gc.drawPolyline(points);
    }

    private void drawVerticalArrows() {
        int[] points = new int[]{this.originalMouseLocation.x - 3, this.originalMouseLocation.y - 6, this.originalMouseLocation.x, this.originalMouseLocation.y - 10, this.originalMouseLocation.x + 3, this.originalMouseLocation.y - 6};
        this.gc.drawPolyline(points);
        points[0] = this.originalMouseLocation.x - 3;
        points[1] = this.originalMouseLocation.y + 7;
        points[2] = this.originalMouseLocation.x;
        points[3] = this.originalMouseLocation.y + 11;
        points[4] = this.originalMouseLocation.x + 3;
        points[5] = this.originalMouseLocation.y + 7;
        this.gc.drawPolyline(points);
    }

    void dispose() {
        if (this.parent.isDisposed()) {
            return;
        }
        this.parent.removeListener(3, this.mouseDownListener);
        this.parent.removeListener(4, this.mouseUpListener);
        this.parent.removeListener(9, this.paintListener);
        this.parent.removeListener(5, this.mouseMoveListener);
        this.parent.removeListener(7, this.focusOutListener);
    }
}

