/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.swing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PrinterGraphics;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.simple.XHTMLPanel;
import org.xhtmlrenderer.swing.Java2DOutputDevice;
import org.xhtmlrenderer.swing.ScaleChangeEvent;
import org.xhtmlrenderer.swing.ScaleChangeListener;

public class ScalableXHTMLPanel
extends XHTMLPanel {
    public static final int SCALE_POLICY_NONE = 0;
    public static final int SCALE_POLICY_FIT_WIDTH = 1;
    public static final int SCALE_POLICY_FIT_HEIGHT = 2;
    public static final int SCALE_POLICY_FIT_WHOLE = 3;
    private static final long serialVersionUID = 1L;
    private int scalePolicy = 0;
    private double scale = -1.0;
    private ArrayList scListeners = new ArrayList();
    private Dimension lastLayoutSize = null;

    public ScalableXHTMLPanel() {
    }

    public ScalableXHTMLPanel(UserAgentCallback uac) {
        super(uac);
    }

    @Override
    public void setDocument(Document doc, String url) {
        this.resetScaleAccordingToPolicy();
        this.lastLayoutSize = null;
        super.setDocument(doc, url);
    }

    @Override
    public void setDocument(InputStream stream, String url) throws Exception {
        this.resetScaleAccordingToPolicy();
        this.lastLayoutSize = null;
        super.setDocument(stream, url);
    }

    private void resetScaleAccordingToPolicy() {
        if (this.getScalePolicy() != 0) {
            this.scale = -1.0;
        }
    }

    @Override
    public Box find(int x2, int y2) {
        Point p2 = this.convertFromScaled(x2, y2);
        Layer l2 = this.getRootLayer();
        if (l2 != null) {
            return l2.find(this.getLayoutContext(), p2.x, p2.y, false);
        }
        return null;
    }

    public void setScale(double newScale) throws IllegalArgumentException {
        if (newScale <= 0.0) {
            throw new IllegalArgumentException("Only positive scales are allowed.");
        }
        this.scale = newScale;
        this.scalePolicy = 0;
        this.lastLayoutSize = null;
        this.repaint(this.getFixedRectangle());
        this.scaleChanged();
    }

    public double getScale() {
        return this.scale;
    }

    public void addScaleChangeListener(ScaleChangeListener scl) {
        this.scListeners.add(scl);
    }

    public void removeScaleChangeListener(ScaleChangeListener scl) {
        this.scListeners.remove(scl);
    }

    private void scaleChanged() {
        ScaleChangeEvent evt = new ScaleChangeEvent(this, this.scale);
        for (int i2 = 0; i2 < this.scListeners.size(); ++i2) {
            ScaleChangeListener scl = (ScaleChangeListener)this.scListeners.get(i2);
            scl.scaleChanged(evt);
        }
    }

    @Override
    protected void doRender(RenderingContext c2, Layer root2) {
        Graphics2D g2 = ((Java2DOutputDevice)c2.getOutputDevice()).getGraphics();
        if (!(g2 instanceof PrinterGraphics) && this.isOpaque()) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        AffineTransform current = g2.getTransform();
        PaintingInfo pI = root2.getMaster().getPaintingInfo();
        Dimension layoutSize = pI.getOuterMarginCorner();
        this.calculateScaleAccordingToPolicy(layoutSize);
        if (this.lastLayoutSize == null) {
            this.lastLayoutSize = layoutSize;
            this.setPreferredSize(new Dimension((int)((double)this.lastLayoutSize.width * this.scale), (int)((double)this.lastLayoutSize.height * this.scale)));
            this.revalidate();
        }
        g2.transform(AffineTransform.getScaleInstance(this.scale, this.scale));
        super.doRender(c2, root2);
        g2.setTransform(current);
    }

    protected void calculateScaleAccordingToPolicy(Dimension layoutSize) {
        Rectangle viewportBounds = this.getFixedRectangle();
        if (this.getScalePolicy() == 0) {
            if (this.scale == -1.0) {
                this.scale = 1.0;
            }
            return;
        }
        double xScale = viewportBounds.width < layoutSize.width ? (double)viewportBounds.width / (double)layoutSize.width : 1.0;
        double yScale = viewportBounds.height < layoutSize.height ? (double)viewportBounds.height / (double)layoutSize.height : 1.0;
        this.scale = this.getScalePolicy() == 1 ? xScale : (this.getScalePolicy() == 2 ? yScale : Math.min(xScale, yScale));
    }

    protected Point convertToScaled(Point origin) {
        if (this.scale <= 0.0) {
            return origin;
        }
        return new Point((int)((double)origin.x * this.scale), (int)((double)origin.y * this.scale));
    }

    protected Point convertFromScaled(Point origin) {
        if (this.scale <= 0.0) {
            return origin;
        }
        return new Point((int)((double)origin.x / this.scale), (int)((double)origin.y / this.scale));
    }

    protected Point convertToScaled(int x2, int y2) {
        if (this.scale <= 0.0) {
            return new Point(x2, y2);
        }
        return new Point((int)((double)x2 * this.scale), (int)((double)y2 * this.scale));
    }

    protected Point convertFromScaled(int x2, int y2) {
        if (this.scale <= 0.0) {
            return new Point(x2, y2);
        }
        return new Point((int)((double)x2 / this.scale), (int)((double)y2 / this.scale));
    }

    public int getScalePolicy() {
        return this.scalePolicy;
    }

    public void setScalePolicy(int scalePolicy) {
        this.scalePolicy = scalePolicy;
        this.lastLayoutSize = null;
        this.repaint(this.getFixedRectangle());
    }
}

