/*
 * Decompiled with CFR 0.152.
 */
package gde.device.renschler;

import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.PropertyType;
import gde.device.renschler.Picolario;
import gde.device.renschler.PicolarioDialog;
import gde.device.renschler.PicolarioSerialPort;
import gde.exception.DataInconsitsentException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.CalculationThread;
import gde.utils.QuasiLinearRegression;
import java.util.Vector;
import java.util.logging.Logger;

public class DataGathererThread
extends Thread {
    static final Logger log = Logger.getLogger(DataGathererThread.class.getName());
    DataExplorer application;
    String[] datagramNumbers;
    final String RECORD_SET_NAME = Messages.getString((String)"GDE_MSGT1220");
    final String configKey;
    final PicolarioSerialPort serialPort;
    final PicolarioDialog dialog;
    final Picolario device;
    CalculationThread calculationThread;
    boolean threadStop = false;

    public DataGathererThread(DataExplorer currentApplication, Picolario currentDevice, PicolarioSerialPort currentSerialPort, String[] useDatagramNumbers) {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = currentDevice;
        this.serialPort = currentSerialPort;
        this.dialog = (PicolarioDialog)currentDevice.getDialog();
        this.datagramNumbers = useDatagramNumbers;
        this.configKey = currentDevice.getChannelNameReplacement(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isPortOpenedByMe = false;
        try {
            log.log(Level.FINE, "entry data gatherer");
            Channel channel = Channels.getInstance().getActiveChannel();
            String[] measurements = this.device.getMeasurementNamesReplacements(channel.getNumber());
            this.dialog.resetDataSetsLabel();
            if (!this.serialPort.isConnected()) {
                this.serialPort.open();
                isPortOpenedByMe = true;
            }
            for (int j = 0; j < this.datagramNumbers.length && !this.threadStop; ++j) {
                this.dialog.resetTelegramLabel();
                this.dialog.setAlreadyRedDataSets(this.datagramNumbers[j]);
                Vector<byte[]> data = this.serialPort.getData(Integer.valueOf(this.datagramNumbers[j]), this.device);
                String recordSetKey = channel.getNextRecordSetNumber() + this.RECORD_SET_NAME;
                channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)this.application.getActiveDevice(), (int)channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                log.log(Level.FINE, recordSetKey + " created");
                if (channel.getActiveRecordSet() == null) {
                    Channels.getInstance().getActiveChannel().setActiveRecordSet(recordSetKey);
                }
                RecordSet recordSet = (RecordSet)channel.get((Object)recordSetKey);
                byte[] dataBuffer = new byte[recordSet.size()];
                int[] points = new int[this.device.getNumberOfMeasurements(1)];
                for (byte[] reveivedBuffer : data) {
                    for (int i = 0; i < reveivedBuffer.length / 3; ++i) {
                        System.arraycopy(reveivedBuffer, i * 3, dataBuffer, 0, 3);
                        recordSet.addPoints(this.device.convertDataBytes(points, dataBuffer));
                    }
                }
                PropertyType property = recordSet.get((Object)measurements[2]).getProperty(CalculationThread.REGRESSION_INTERVAL_SEC);
                int regressionInterval = property != null ? Integer.valueOf(property.getValue()) : 4;
                this.calculationThread = new QuasiLinearRegression(recordSet, measurements[1], measurements[2], regressionInterval);
                try {
                    this.calculationThread.start();
                }
                catch (RuntimeException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
                this.application.getMenuToolBar().addRecordSetName(recordSetKey);
                if (channel.getRecordSetNames().length <= 1 || this.dialog.isDoSwtichRecordSet()) {
                    channel.switchRecordSet(recordSetKey);
                }
                ((RecordSet)channel.get((Object)recordSetKey)).setAllDisplayable();
                channel.applyTemplate(recordSetKey, true);
            }
            this.dialog.enableReadButtons();
            log.log(Level.FINE, "exit data gatherer");
        }
        catch (DataInconsitsentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0028", (Object[])new Object[]{((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()}));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialog(this.dialog.getDialogShell(), Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{e.getClass().getSimpleName(), e.getMessage()}));
        }
        finally {
            if (isPortOpenedByMe) {
                this.serialPort.close();
            }
            this.dialog.resetButtons();
        }
    }

    public void setThreadStop(boolean enable) {
        this.threadStop = enable;
        this.serialPort.setTransmitFinished(true);
    }
}

