/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabFolderDrawData
extends DrawData {
    public int tabsWidth;
    public int tabsHeight;
    public Rectangle tabsArea;
    public int selectedX;
    public int selectedWidth;
    public int spacing;

    public TabFolderDrawData() {
        this.state = new int[1];
        if (SWT.getPlatform().equals("gtk")) {
            this.spacing = -2;
        }
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n = theme.notebookHandle;
        int n2 = OS.gtk_widget_get_style(n);
        int n3 = gC.getGCData().drawable;
        theme.transferClipping(gC, n2);
        int n4 = rectangle.x;
        int n5 = rectangle.y;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        n7 -= this.tabsHeight;
        int n8 = this.selectedX;
        int n9 = this.selectedWidth;
        int n10 = 2;
        if ((this.style & 0x400) != 0) {
            n10 = 3;
        } else {
            n5 += this.tabsHeight;
        }
        byte[] byArray = Converter.wcsToMbcs(null, "notebook", true);
        OS.gtk_paint_box_gap(n2, n3, this.getStateType(0), 2, null, n, byArray, n4, n5, n6, n7, n10, n8, n9);
        if (this.tabsArea != null) {
            this.tabsArea.x = rectangle.x;
            this.tabsArea.y = rectangle.y;
            this.tabsArea.width = rectangle.width;
            this.tabsArea.height = this.tabsHeight;
            if ((this.style & 0x400) != 0) {
                this.tabsArea.y += rectangle.height - this.tabsHeight;
            }
        }
    }

    @Override
    int getStateType(int n) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

