/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class VarioBlock
extends DataBlock {
    private short altitudeInTenthOfMeter;
    private short deltaInIntervalOf250MsInTenthOfMeter;
    private short deltaInIntervalOf500MsInTenthOfMeter;
    private short deltaInIntervalOf1000MsInTenthOfMeter;
    private short deltaInIntervalOf2000MsInTenthOfMeter;
    private short deltaInIntervalOf3000MsInTenthOfMeter;

    public VarioBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("Altitude V");
        this.measurementNames.add("Climb V");
        this.measurementUnits.add("m");
        this.measurementUnits.add("m/s");
        this.measurementFactors.add(0.1);
        this.measurementFactors.add(0.1);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof VarioBlock) {
            VarioBlock vario = (VarioBlock)block;
            return vario.altitudeInTenthOfMeter != this.altitudeInTenthOfMeter && vario.deltaInIntervalOf250MsInTenthOfMeter != this.deltaInIntervalOf250MsInTenthOfMeter && vario.deltaInIntervalOf500MsInTenthOfMeter != this.deltaInIntervalOf500MsInTenthOfMeter && vario.deltaInIntervalOf1000MsInTenthOfMeter != this.deltaInIntervalOf1000MsInTenthOfMeter && vario.deltaInIntervalOf2000MsInTenthOfMeter != this.deltaInIntervalOf2000MsInTenthOfMeter && vario.deltaInIntervalOf3000MsInTenthOfMeter != this.deltaInIntervalOf3000MsInTenthOfMeter;
        }
        return false;
    }

    public short getAltitudeInTenthOfMeter() {
        return this.altitudeInTenthOfMeter;
    }

    public short getDeltaInIntervalOf250MsInTenthOfMeter() {
        return this.deltaInIntervalOf250MsInTenthOfMeter;
    }

    public short getDeltaInIntervalOf500MsInTenthOfMeter() {
        return this.deltaInIntervalOf500MsInTenthOfMeter;
    }

    public short getDeltaInIntervalOf1000MsInTenthOfMeter() {
        return this.deltaInIntervalOf1000MsInTenthOfMeter;
    }

    public short getDeltaInIntervalOf2000MsInTenthOfMeter() {
        return this.deltaInIntervalOf2000MsInTenthOfMeter;
    }

    public short getDeltaInIntervalOf3000MsInTenthOfMeter() {
        return this.deltaInIntervalOf3000MsInTenthOfMeter;
    }

    private void decode(byte[] rawData) {
        this.altitudeInTenthOfMeter = Shorts.fromBytes(rawData[6], rawData[7]);
        this.deltaInIntervalOf250MsInTenthOfMeter = Shorts.fromBytes(rawData[8], rawData[9]);
        this.deltaInIntervalOf500MsInTenthOfMeter = Shorts.fromBytes(rawData[10], rawData[11]);
        this.deltaInIntervalOf1000MsInTenthOfMeter = Shorts.fromBytes(rawData[12], rawData[13]);
        this.deltaInIntervalOf2000MsInTenthOfMeter = Shorts.fromBytes(rawData[14], rawData[15]);
        this.deltaInIntervalOf3000MsInTenthOfMeter = Shorts.fromBytes(rawData[16], rawData[17]);
        this.measurementValues.add(Integer.valueOf(this.getAltitudeInTenthOfMeter()));
        this.measurementValues.add(Integer.valueOf(this.getDeltaInIntervalOf250MsInTenthOfMeter()));
    }
}

