/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.cmaps;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfString;

public abstract class AbstractCMap {
    private String cmapName;
    private String registry;
    private String ordering;
    private int supplement;

    public String getName() {
        return this.cmapName;
    }

    void setName(String cmapName) {
        this.cmapName = cmapName;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String registry) {
        this.registry = registry;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int supplement) {
        this.supplement = supplement;
    }

    abstract void addChar(PdfString var1, PdfObject var2);

    void addRange(PdfString from, PdfString to, PdfObject code) {
        byte[] a2;
        byte[] a1 = AbstractCMap.decodeStringToByte(from);
        if (a1.length != (a2 = AbstractCMap.decodeStringToByte(to)).length || a1.length == 0) {
            throw new IllegalArgumentException("Invalid map.");
        }
        byte[] sout = null;
        if (code instanceof PdfString) {
            sout = AbstractCMap.decodeStringToByte((PdfString)code);
        }
        int start = AbstractCMap.byteArrayToInt(a1);
        int end = AbstractCMap.byteArrayToInt(a2);
        for (int k2 = start; k2 <= end; ++k2) {
            AbstractCMap.intToByteArray(k2, a1);
            PdfString s2 = new PdfString(a1);
            s2.setHexWriting(true);
            if (code instanceof PdfArray) {
                this.addChar(s2, ((PdfArray)code).getPdfObject(k2 - start));
                continue;
            }
            if (code instanceof PdfNumber) {
                int nn = ((PdfNumber)code).intValue() + k2 - start;
                this.addChar(s2, new PdfNumber(nn));
                continue;
            }
            if (!(code instanceof PdfString)) continue;
            PdfString s1 = new PdfString(sout);
            s1.setHexWriting(true);
            int n2 = sout.length - 1;
            sout[n2] = (byte)(sout[n2] + 1);
            this.addChar(s2, s1);
        }
    }

    private static void intToByteArray(int v2, byte[] b2) {
        for (int k2 = b2.length - 1; k2 >= 0; --k2) {
            b2[k2] = (byte)v2;
            v2 >>>= 8;
        }
    }

    private static int byteArrayToInt(byte[] b2) {
        int v2 = 0;
        for (int k2 = 0; k2 < b2.length; ++k2) {
            v2 <<= 8;
            v2 |= b2[k2] & 0xFF;
        }
        return v2;
    }

    public static byte[] decodeStringToByte(PdfString s2) {
        byte[] b2 = s2.getBytes();
        byte[] br = new byte[b2.length];
        System.arraycopy(b2, 0, br, 0, b2.length);
        return br;
    }

    public String decodeStringToUnicode(PdfString ps) {
        if (ps.isHexWriting()) {
            return PdfEncodings.convertToString(ps.getBytes(), "UnicodeBigUnmarked");
        }
        return ps.toUnicodeString();
    }
}

