/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.binding.ExpressionHelperBase;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.collections.ArrayChangeListener;
import javafx.collections.ObservableArray;

public abstract class ArrayListenerHelper<T extends ObservableArray<T>>
extends ExpressionHelperBase {
    protected final T observable;

    public static <T extends ObservableArray<T>> ArrayListenerHelper addListener(ArrayListenerHelper arrayListenerHelper, T t2, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? new SingleInvalidation<T>(t2, invalidationListener) : arrayListenerHelper.addListener(invalidationListener);
    }

    public static ArrayListenerHelper removeListener(ArrayListenerHelper arrayListenerHelper, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? null : arrayListenerHelper.removeListener(invalidationListener);
    }

    public static <T extends ObservableArray<T>> ArrayListenerHelper addListener(ArrayListenerHelper arrayListenerHelper, T t2, ArrayChangeListener arrayChangeListener) {
        if (arrayChangeListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? new SingleChange<T>(t2, arrayChangeListener) : arrayListenerHelper.addListener(arrayChangeListener);
    }

    public static ArrayListenerHelper removeListener(ArrayListenerHelper arrayListenerHelper, ArrayChangeListener arrayChangeListener) {
        if (arrayChangeListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? null : arrayListenerHelper.removeListener(arrayChangeListener);
    }

    public static void fireValueChangedEvent(ArrayListenerHelper arrayListenerHelper, boolean bl, int n2, int n3) {
        if (arrayListenerHelper != null && (n2 < n3 || bl)) {
            arrayListenerHelper.fireValueChangedEvent(bl, n2, n3);
        }
    }

    public static boolean hasListeners(ArrayListenerHelper arrayListenerHelper) {
        return arrayListenerHelper != null;
    }

    public ArrayListenerHelper(T t2) {
        this.observable = t2;
    }

    protected abstract ArrayListenerHelper addListener(InvalidationListener var1);

    protected abstract ArrayListenerHelper removeListener(InvalidationListener var1);

    protected abstract ArrayListenerHelper addListener(ArrayChangeListener<T> var1);

    protected abstract ArrayListenerHelper removeListener(ArrayChangeListener<T> var1);

    protected abstract void fireValueChangedEvent(boolean var1, int var2, int var3);

    private static class SingleInvalidation<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private final InvalidationListener listener;

        private SingleInvalidation(T t2, InvalidationListener invalidationListener) {
            super(t2);
            this.listener = invalidationListener;
        }

        @Override
        protected ArrayListenerHelper addListener(InvalidationListener invalidationListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, invalidationListener);
        }

        @Override
        protected ArrayListenerHelper removeListener(InvalidationListener invalidationListener) {
            return invalidationListener.equals(this.listener) ? null : this;
        }

        @Override
        protected ArrayListenerHelper addListener(ArrayChangeListener arrayChangeListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, arrayChangeListener);
        }

        @Override
        protected ArrayListenerHelper removeListener(ArrayChangeListener arrayChangeListener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent(boolean bl, int n2, int n3) {
            try {
                this.listener.invalidated(this.observable);
            }
            catch (Exception exception) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
            }
        }
    }

    private static class SingleChange<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private final ArrayChangeListener listener;

        private SingleChange(T t2, ArrayChangeListener arrayChangeListener) {
            super(t2);
            this.listener = arrayChangeListener;
        }

        @Override
        protected ArrayListenerHelper addListener(InvalidationListener invalidationListener) {
            return new Generic<ObservableArray>(this.observable, invalidationListener, this.listener);
        }

        @Override
        protected ArrayListenerHelper removeListener(InvalidationListener invalidationListener) {
            return this;
        }

        @Override
        protected ArrayListenerHelper addListener(ArrayChangeListener arrayChangeListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, arrayChangeListener);
        }

        @Override
        protected ArrayListenerHelper removeListener(ArrayChangeListener arrayChangeListener) {
            return arrayChangeListener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent(boolean bl, int n2, int n3) {
            try {
                this.listener.onChanged(this.observable, bl, n2, n3);
            }
            catch (Exception exception) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
            }
        }
    }

    private static class Generic<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private InvalidationListener[] invalidationListeners;
        private ArrayChangeListener[] changeListeners;
        private int invalidationSize;
        private int changeSize;
        private boolean locked;

        private Generic(T t2, InvalidationListener invalidationListener, InvalidationListener invalidationListener2) {
            super(t2);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener, invalidationListener2};
            this.invalidationSize = 2;
        }

        private Generic(T t2, ArrayChangeListener arrayChangeListener, ArrayChangeListener arrayChangeListener2) {
            super(t2);
            this.changeListeners = new ArrayChangeListener[]{arrayChangeListener, arrayChangeListener2};
            this.changeSize = 2;
        }

        private Generic(T t2, InvalidationListener invalidationListener, ArrayChangeListener arrayChangeListener) {
            super(t2);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ArrayChangeListener[]{arrayChangeListener};
            this.changeSize = 1;
        }

        @Override
        protected Generic addListener(InvalidationListener invalidationListener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{invalidationListener};
                this.invalidationSize = 1;
            } else {
                int n2 = this.invalidationListeners.length;
                if (this.locked) {
                    int n3 = this.invalidationSize < n2 ? n2 : n2 * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n3);
                } else if (this.invalidationSize == n2) {
                    this.invalidationSize = Generic.trim(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == n2) {
                        int n4 = n2 * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n4);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = invalidationListener;
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper removeListener(InvalidationListener invalidationListener) {
            if (this.invalidationListeners != null) {
                for (int i2 = 0; i2 < this.invalidationSize; ++i2) {
                    if (!invalidationListener.equals(this.invalidationListeners[i2])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1) {
                            return new SingleChange<ObservableArray>(this.observable, this.changeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0) {
                        return new SingleInvalidation<ObservableArray>(this.observable, this.invalidationListeners[1 - i2]);
                    }
                    int n2 = this.invalidationSize - i2 - 1;
                    InvalidationListener[] invalidationListenerArray = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(invalidationListenerArray, 0, this.invalidationListeners, 0, i2 + 1);
                    }
                    if (n2 > 0) {
                        System.arraycopy(invalidationListenerArray, i2 + 1, this.invalidationListeners, i2, n2);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper addListener(ArrayChangeListener<T> arrayChangeListener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayChangeListener[]{arrayChangeListener};
                this.changeSize = 1;
            } else {
                int n2 = this.changeListeners.length;
                if (this.locked) {
                    int n3 = this.changeSize < n2 ? n2 : n2 * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, n3);
                } else if (this.changeSize == n2) {
                    this.changeSize = Generic.trim(this.changeSize, this.changeListeners);
                    if (this.changeSize == n2) {
                        int n4 = n2 * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, n4);
                    }
                }
                this.changeListeners[this.changeSize++] = arrayChangeListener;
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper removeListener(ArrayChangeListener<T> arrayChangeListener) {
            if (this.changeListeners != null) {
                for (int i2 = 0; i2 < this.changeSize; ++i2) {
                    if (!arrayChangeListener.equals(this.changeListeners[i2])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1) {
                            return new SingleInvalidation<ObservableArray>(this.observable, this.invalidationListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0) {
                        return new SingleChange<ObservableArray>(this.observable, this.changeListeners[1 - i2]);
                    }
                    int n2 = this.changeSize - i2 - 1;
                    ArrayChangeListener[] arrayChangeListenerArray = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ArrayChangeListener[this.changeListeners.length];
                        System.arraycopy(arrayChangeListenerArray, 0, this.changeListeners, 0, i2 + 1);
                    }
                    if (n2 > 0) {
                        System.arraycopy(arrayChangeListenerArray, i2 + 1, this.changeListeners, i2, n2);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChangedEvent(boolean bl, int n2, int n3) {
            InvalidationListener[] invalidationListenerArray = this.invalidationListeners;
            int n4 = this.invalidationSize;
            ArrayChangeListener[] arrayChangeListenerArray = this.changeListeners;
            int n5 = this.changeSize;
            try {
                int n6;
                this.locked = true;
                for (n6 = 0; n6 < n4; ++n6) {
                    try {
                        invalidationListenerArray[n6].invalidated(this.observable);
                        continue;
                    }
                    catch (Exception exception) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
                    }
                }
                for (n6 = 0; n6 < n5; ++n6) {
                    try {
                        arrayChangeListenerArray[n6].onChanged(this.observable, bl, n2, n3);
                        continue;
                    }
                    catch (Exception exception) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
                    }
                }
            }
            finally {
                this.locked = false;
            }
        }
    }
}

