/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.transform;

import java.io.Serializable;
import org.apache.commons.math3.analysis.FunctionUtils;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.transform.RealTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.apache.commons.math3.transform.TransformUtils;
import org.apache.commons.math3.util.ArithmeticUtils;

public class FastHadamardTransformer
implements RealTransformer,
Serializable {
    static final long serialVersionUID = 20120211L;

    public double[] transform(double[] f2, TransformType type2) {
        if (type2 == TransformType.FORWARD) {
            return this.fht(f2);
        }
        return TransformUtils.scaleArray(this.fht(f2), 1.0 / (double)f2.length);
    }

    public double[] transform(UnivariateFunction f2, double min, double max, int n2, TransformType type2) {
        return this.transform(FunctionUtils.sample(f2, min, max, n2), type2);
    }

    public int[] transform(int[] f2) {
        return this.fht(f2);
    }

    protected double[] fht(double[] x2) throws MathIllegalArgumentException {
        int n2 = x2.length;
        int halfN = n2 / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n2);
        }
        double[] yPrevious = new double[n2];
        double[] yCurrent = (double[])x2.clone();
        for (int j2 = 1; j2 < n2; j2 <<= 1) {
            int twoI;
            int i2;
            double[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i2 = 0; i2 < halfN; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i2 = halfN; i2 < n2; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI - n2] - yPrevious[twoI - n2 + 1];
            }
        }
        return yCurrent;
    }

    protected int[] fht(int[] x2) throws MathIllegalArgumentException {
        int n2 = x2.length;
        int halfN = n2 / 2;
        if (!ArithmeticUtils.isPowerOfTwo(n2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NOT_POWER_OF_TWO, n2);
        }
        int[] yPrevious = new int[n2];
        int[] yCurrent = (int[])x2.clone();
        for (int j2 = 1; j2 < n2; j2 <<= 1) {
            int twoI;
            int i2;
            int[] yTmp = yCurrent;
            yCurrent = yPrevious;
            yPrevious = yTmp;
            for (i2 = 0; i2 < halfN; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI] + yPrevious[twoI + 1];
            }
            for (i2 = halfN; i2 < n2; ++i2) {
                twoI = 2 * i2;
                yCurrent[i2] = yPrevious[twoI - n2] - yPrevious[twoI - n2 + 1];
            }
        }
        return yCurrent;
    }
}

