/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.device.graupner.PackageLoss;
import gde.device.graupner.PackageLossDeque;
import gde.log.Level;
import java.util.logging.Logger;

public class BackChannelPackageLoss {
    static final Logger log = Logger.getLogger(BackChannelPackageLoss.class.getSimpleName());
    private final PackageLoss lostPackages = new PackageLoss();
    private final PackageLossDeque reverseChannelPackageLossCounter = new PackageLossDeque(100);
    private int consecutiveLossCounter = 0;

    public void trackPackageLoss(boolean isAvailable, int[] points) {
        if (isAvailable) {
            this.reverseChannelPackageLossCounter.add(1);
            points[0] = this.reverseChannelPackageLossCounter.getPercentage() * 1000;
        } else {
            this.reverseChannelPackageLossCounter.add(0);
            points[0] = this.reverseChannelPackageLossCounter.getPercentage() * 1000;
            ++this.consecutiveLossCounter;
        }
        ++this.lostPackages.numberTrackedSamples;
    }

    public boolean updateLossStatistics() {
        if (this.consecutiveLossCounter > 0) {
            this.lostPackages.add(this.consecutiveLossCounter);
            this.consecutiveLossCounter = 0;
            return true;
        }
        return false;
    }

    public void finalUpdateLossStatistics() {
        this.lostPackages.percentage = (double)this.lostPackages.lossTotal * 100.0 / (double)(this.lostPackages.numberTrackedSamples - this.consecutiveLossCounter);
        log.log(Level.INFO, String.format("lostPackages = (%d) %d of %d percentage = %3.1f", this.lostPackages.lossTotal + this.consecutiveLossCounter, this.lostPackages.lossTotal, this.lostPackages.numberTrackedSamples, this.lostPackages.percentage));
    }

    public int getLossTotal() {
        return this.lostPackages.lossTotal + this.consecutiveLossCounter;
    }

    public PackageLoss getLostPackages() {
        return this.lostPackages;
    }

    public String toString() {
        return super.toString() + "  [lossTotal=" + this.lostPackages.lossTotal + ", consecutiveLossCounter=" + this.consecutiveLossCounter + "]";
    }
}

