/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.languages;

import com.itextpdf.text.pdf.Glyph;
import com.itextpdf.text.pdf.languages.GlyphRepositioner;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class IndicGlyphRepositioner
implements GlyphRepositioner {
    IndicGlyphRepositioner() {
    }

    @Override
    public void repositionGlyphs(List<Glyph> glyphList) {
        for (int i2 = 0; i2 < glyphList.size(); ++i2) {
            Glyph glyph = glyphList.get(i2);
            Glyph nextGlyph = this.getNextGlyph(glyphList, i2);
            if (nextGlyph == null || !this.getCharactersToBeShiftedLeftByOnePosition().contains(nextGlyph.chars)) continue;
            glyphList.set(i2, nextGlyph);
            glyphList.set(i2 + 1, glyph);
            ++i2;
        }
    }

    abstract List<String> getCharactersToBeShiftedLeftByOnePosition();

    private Glyph getNextGlyph(List<Glyph> glyphs, int currentIndex) {
        if (currentIndex + 1 < glyphs.size()) {
            return glyphs.get(currentIndex + 1);
        }
        return null;
    }
}

