/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.mdlviewer.swt;

import de.treichels.hott.decoder.HoTTDecoderKt;
import de.treichels.hott.mdlviewer.swt.Launcher;
import de.treichels.hott.mdlviewer.swt.SWTResourceManager;
import de.treichels.hott.mdlviewer.swt.SwtMdlBrowser;
import de.treichels.hott.mdlviewer.swt.dialogs.SelectFromMemoryDialog;
import de.treichels.hott.mdlviewer.swt.dialogs.SelectFromSdCardDialog;
import de.treichels.hott.mdlviewer.swt.dialogs.SelectFromTransmitterDialog;
import de.treichels.hott.messages.Messages;
import de.treichels.hott.model.BaseModel;
import de.treichels.hott.report.html.HTMLReport;
import de.treichels.hott.report.pdf.PDFReport;
import de.treichels.hott.report.xml.XMLReport;
import de.treichels.hott.util.Util;
import java.io.File;
import java.io.FileWriter;
import java.util.prefs.Preferences;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.jetbrains.annotations.NonNls;

class MdlTabItemComposite
extends Composite {
    @NonNls
    private static final String MDL = ".mdl";
    @NonNls
    private static final String PDF = ".pdf";
    @NonNls
    private static final String HTML = ".html";
    @NonNls
    private static final String XML = ".xml";
    @NonNls
    private static final String LAST_SAVE_DIR = "lastSaveDir";
    @NonNls
    private static final String LAST_LOAD_DIR = "lastLoadDir";
    private static final Preferences PREFS = Preferences.userNodeForPackage(MdlTabItemComposite.class);
    private BaseModel model = null;
    private final Browser browser;
    private final Button saveMdlButton;
    private final MenuItem saveMdlMenuItem;
    private final MenuItem reloadMenuItem;

    public MdlTabItemComposite(Composite parent) {
        super(parent, 0);
        GridLayout tabItemCompositeLayout = new GridLayout();
        tabItemCompositeLayout.numColumns = 3;
        this.setLayout(tabItemCompositeLayout);
        this.setBackground(new Color(Display.getDefault(), 250, 249, 211));
        Font font = SWTResourceManager.getFont(SwtMdlBrowser.WIDGET_FONT_SIZE);
        HTMLReport.INSTANCE.setSuppressExceptions(false);
        final Button loadMdlButton = new Button(this, 0x1000008);
        GridData loadMdlButtonLData = new GridData();
        loadMdlButtonLData.widthHint = 180;
        loadMdlButtonLData.heightHint = 26;
        loadMdlButtonLData.verticalAlignment = 1;
        loadMdlButtonLData.grabExcessHorizontalSpace = true;
        loadMdlButtonLData.horizontalAlignment = 2;
        loadMdlButton.setLayoutData(loadMdlButtonLData);
        loadMdlButton.setFont(font);
        loadMdlButton.setText(Messages.getString("Load", new Object[0]));
        loadMdlButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("loadMdlButton.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.loadFromFile();
            }
        });
        final Label mdlVersionLabel = new Label(this, 0x1000000);
        GridData mdlVersionLabelLData = new GridData();
        mdlVersionLabelLData.horizontalAlignment = 2;
        mdlVersionLabelLData.heightHint = 26;
        mdlVersionLabelLData.verticalAlignment = 1;
        mdlVersionLabelLData.grabExcessHorizontalSpace = true;
        mdlVersionLabel.setLayoutData(mdlVersionLabelLData);
        mdlVersionLabel.setBackground(this.getBackground());
        mdlVersionLabel.setForeground(loadMdlButton.getForeground());
        mdlVersionLabel.setFont(font);
        mdlVersionLabel.setText("Version: " + Launcher.Companion.getInstance().getVersion().substring(0, 9));
        this.saveMdlButton = new Button(this, 0x1000008);
        GridData saveMdlButtonLData = new GridData();
        saveMdlButtonLData.horizontalAlignment = 2;
        saveMdlButtonLData.widthHint = 180;
        saveMdlButtonLData.heightHint = 26;
        saveMdlButtonLData.verticalAlignment = 1;
        saveMdlButtonLData.grabExcessHorizontalSpace = true;
        this.saveMdlButton.setLayoutData(saveMdlButtonLData);
        this.saveMdlButton.setFont(font);
        this.saveMdlButton.setText(Messages.getString("Save", new Object[0]));
        this.saveMdlButton.setEnabled(false);
        this.saveMdlButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("saveMdlButton.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.save();
            }
        });
        this.addControlListener(new ControlAdapter(){

            @Override
            public void controlMoved(ControlEvent e2) {
                super.controlMoved(e2);
                mdlVersionLabel.setBackground(MdlTabItemComposite.this.getBackground());
                mdlVersionLabel.setForeground(loadMdlButton.getForeground());
            }
        });
        this.browser = new Browser(this, 2048);
        GridData viewTextLData = new GridData();
        viewTextLData.grabExcessHorizontalSpace = true;
        viewTextLData.verticalAlignment = 4;
        viewTextLData.grabExcessVerticalSpace = true;
        viewTextLData.horizontalSpan = 4;
        viewTextLData.horizontalAlignment = 4;
        this.browser.setLayoutData(viewTextLData);
        Menu contextMenu = new Menu(this.browser);
        this.browser.setMenu(contextMenu);
        this.browser.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent evt) {
                switch (evt.keyCode) {
                    case 0x100000E: {
                        MdlTabItemComposite.this.updateView();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent evt) {
            }
        });
        MenuItem loadMdlFromFileMenuItemMenuItem = new MenuItem(contextMenu, 0);
        loadMdlFromFileMenuItemMenuItem.setText(Messages.getString("LoadFromFile", new Object[0]));
        loadMdlFromFileMenuItemMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("loadMdlMenuItem.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.loadFromFile();
            }
        });
        MenuItem loadMdlFromMemoryMenuItemMenuItem = new MenuItem(contextMenu, 0);
        loadMdlFromMemoryMenuItemMenuItem.setText(Messages.getString("LoadFromMemory", new Object[0]));
        loadMdlFromMemoryMenuItemMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("loadMdlMenuItem.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.loadFromMemory();
            }
        });
        MenuItem loadMdlFromSdCardMenuItemMenuItem = new MenuItem(contextMenu, 0);
        loadMdlFromSdCardMenuItemMenuItem.setText(Messages.getString("LoadFromSdCard", new Object[0]));
        loadMdlFromSdCardMenuItemMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("loadMdlMenuItem.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.loadFromSdCard();
            }
        });
        this.saveMdlMenuItem = new MenuItem(contextMenu, 0);
        this.saveMdlMenuItem.setText(Messages.getString("Save", new Object[0]));
        this.saveMdlMenuItem.setEnabled(false);
        this.saveMdlMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("saveMdlMenuItem.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.save();
            }
        });
        new MenuItem(contextMenu, 2);
        this.reloadMenuItem = new MenuItem(contextMenu, 0);
        this.reloadMenuItem.setText(Messages.getString("Reload", new Object[0]));
        this.reloadMenuItem.setEnabled(false);
        this.reloadMenuItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent evt) {
                if (Util.INSTANCE.getDEBUG()) {
                    System.out.printf("reloadMenuItem.widgetSelected, event=%s%n", evt);
                }
                MdlTabItemComposite.this.updateView();
            }
        });
    }

    private void loadFromFile() {
        File file;
        FileDialog fd = new FileDialog(this.getParent().getShell(), 69636);
        fd.setText(Messages.getString("Load", new Object[0]));
        fd.setFilterExtensions(new String[]{"*.mdl"});
        fd.setFilterNames(new String[]{Messages.getString("MdlFileDescription", new Object[0])});
        fd.setFilterPath(PREFS.get(LAST_LOAD_DIR, System.getProperty(Launcher.Companion.getInstance().getMdlDir().getAbsolutePath())));
        String fileName = fd.open();
        if (fileName != null && fileName.endsWith(MDL) && (file = new File(fileName)).exists() && file.canRead()) {
            PREFS.put(LAST_LOAD_DIR, file.getParentFile().getAbsolutePath());
            BusyIndicator.showWhile(this.getDisplay(), () -> {
                try {
                    this.model = HoTTDecoderKt.decodeFile(file);
                }
                catch (Throwable t2) {
                    this.showError(t2);
                }
            });
            this.saveMdlButton.setEnabled(true);
            this.saveMdlMenuItem.setEnabled(true);
            this.reloadMenuItem.setEnabled(true);
            this.updateView();
        }
    }

    private void loadFromMemory() {
        this.load(new SelectFromMemoryDialog(this.getParent().getShell()));
    }

    private void loadFromSdCard() {
        this.load(new SelectFromSdCardDialog(this.getParent().getShell()));
    }

    private void load(SelectFromTransmitterDialog dialog2) {
        if (dialog2.open() != null) {
            this.model = dialog2.getModel();
            this.saveMdlButton.setEnabled(true);
            this.saveMdlMenuItem.setEnabled(true);
            this.reloadMenuItem.setEnabled(true);
            this.updateView();
        }
    }

    private void save() {
        if (this.model != null) {
            FileDialog fd = new FileDialog(this.getParent().getShell(), 73732);
            fd.setText(Messages.getString("Save", new Object[0]));
            fd.setFilterExtensions(new String[]{"*.pdf", "*.html", "*.xml"});
            fd.setFilterNames(new String[]{"Portable Document Format (*.pdf)", "Hypertext Markup Language (*.html)", "Extensible Markup Language (*.xml)"});
            fd.setFilterPath(PREFS.get(LAST_SAVE_DIR, PREFS.get(LAST_LOAD_DIR, System.getProperty(Launcher.Companion.getInstance().getMdlDir().getAbsolutePath()))));
            fd.setFileName(this.model.getModelName() + PDF);
            fd.setOverwrite(true);
            String fileName = fd.open();
            if (fileName != null && fileName.length() > 4) {
                File file = new File(fileName);
                PREFS.put(LAST_SAVE_DIR, file.getParentFile().getAbsolutePath());
                BusyIndicator.showWhile(this.getDisplay(), () -> {
                    try {
                        if (fileName.endsWith(XML)) {
                            String data1 = XMLReport.INSTANCE.generateXML(this.model);
                            FileWriter fw1 = new FileWriter(file);
                            fw1.write(data1);
                            fw1.close();
                        } else if (fileName.endsWith(HTML)) {
                            String data2 = HTMLReport.INSTANCE.generateHTML(this.model);
                            FileWriter fw2 = new FileWriter(file);
                            fw2.write(data2);
                            fw2.close();
                        } else if (fileName.endsWith(PDF)) {
                            String data3 = HTMLReport.INSTANCE.generateHTML(this.model);
                            PDFReport.INSTANCE.save(file, data3);
                        }
                    }
                    catch (Throwable t2) {
                        this.showError(t2);
                    }
                });
            }
        }
    }

    private void showError(Throwable t2) {
        MessageBox mb = new MessageBox(this.getParent().getShell(), 0);
        mb.setText(t2.getClass().getSimpleName());
        mb.setMessage(t2.getMessage() == null ? t2.getClass().getSimpleName() : t2.getMessage());
        mb.open();
        if (Util.INSTANCE.getDEBUG()) {
            t2.printStackTrace();
        }
    }

    private void updateView() {
        if (this.model != null) {
            BusyIndicator.showWhile(this.getDisplay(), () -> {
                String data2;
                try {
                    data2 = HTMLReport.INSTANCE.generateHTML(this.model);
                }
                catch (Exception e2) {
                    data2 = e2.getMessage();
                }
                this.browser.setText(data2);
                this.browser.setFocus();
            });
        }
    }
}

