/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.GDE;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.WindowsHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;

public class ApplicationLauncher {
    private static final Logger log = Logger.getLogger(ApplicationLauncher.class.getName());
    String fqExecPath = "";

    public ApplicationLauncher(String executable, String[] searchExecutableKeys, String searchLocationInfo) {
        try {
            if (log.isLoggable(Level.FINE)) {
                StringBuilder sb = new StringBuilder();
                for (String searchExecutableKey : searchExecutableKeys) {
                    sb.append(searchExecutableKey).append(",");
                }
                log.log(Level.FINE, "searchExecutableKeys = '" + sb.toString() + "'");
            }
            Vector<String> searchKeyVector = new Vector<String>();
            for (String tmpSearchExecutableKey : searchExecutableKeys) {
                if (tmpSearchExecutableKey == null || tmpSearchExecutableKey.length() <= 4) continue;
                if ((tmpSearchExecutableKey = tmpSearchExecutableKey.replace('\\', '/')).contains("/")) {
                    tmpSearchExecutableKey = tmpSearchExecutableKey.substring(tmpSearchExecutableKey.lastIndexOf(47) + 1);
                }
                searchKeyVector.add(tmpSearchExecutableKey);
            }
            if (GDE.IS_WINDOWS) {
                for (String tmpSearchExecutableKey : searchKeyVector) {
                    String path = WindowsHelper.findApplicationPath(tmpSearchExecutableKey);
                    if (path.length() > 4) {
                        if ((path = path.substring(0, path.toLowerCase().indexOf("exe") + 4)).startsWith("\"")) {
                            path = path.substring(1);
                        }
                        log.log(Level.FINE, "executable = " + path);
                        break;
                    }
                    log.log(Level.WARNING, "failed find executable according key = " + tmpSearchExecutableKey + " method: " + searchLocationInfo);
                }
            } else if (GDE.IS_LINUX) {
                for (String tmpSearchExecutableKey : searchKeyVector) {
                    String line;
                    ArrayList<String> command = new ArrayList<String>();
                    command.add("which");
                    command.add(tmpSearchExecutableKey);
                    Process process = new ProcessBuilder(command).start();
                    process.waitFor();
                    BufferedReader bisr = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    BufferedReader besr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    StringBuilder sb = new StringBuilder();
                    while ((line = bisr.readLine()) != null) {
                        log.log(Level.FINEST, "std.out = " + line);
                        sb.append(line);
                    }
                    while ((line = besr.readLine()) != null) {
                        log.log(Level.FINEST, "std.err = " + line);
                    }
                    if (process.exitValue() != 0) {
                        log.log(Level.WARNING, "failed find executable according key = " + tmpSearchExecutableKey + " method: " + searchLocationInfo);
                    }
                    besr.close();
                    bisr.close();
                    if (process.exitValue() != 0 || sb.length() <= 4) continue;
                    log.log(Level.FINE, "executable = " + sb.toString());
                    break;
                }
            } else if (GDE.IS_MAC) {
                for (String tmpSearchExecutableKey : searchKeyVector) {
                    String appDirectory;
                    if (tmpSearchExecutableKey.toLowerCase().endsWith(".app")) {
                        tmpSearchExecutableKey = tmpSearchExecutableKey.substring(0, tmpSearchExecutableKey.indexOf(".app"));
                    }
                    if (new File(appDirectory = searchLocationInfo).exists()) {
                        String macExecPath = appDirectory + "/Contents/MacOS/" + tmpSearchExecutableKey;
                        if (!FileUtils.checkFileExist(macExecPath)) continue;
                        log.log(Level.FINE, "executable = " + macExecPath);
                        break;
                    }
                    log.log(Level.WARNING, "failed find executable according key = " + tmpSearchExecutableKey + " method: " + searchLocationInfo);
                }
            }
            this.fqExecPath = executable;
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            DataExplorer.getInstance().openMessageDialogAsync(e.getMessage());
        }
    }

    public void execute(List<String> arguments) {
        if (this.isLaunchable()) {
            arguments.add(0, this.fqExecPath);
            if (GDE.IS_WINDOWS) {
                arguments.add(1, "url.dll,FileProtocolHandler");
            }
            for (String string : arguments) {
                log.log(Level.INFO, "'" + string + "'");
            }
            try {
                StringBuilder sb = new StringBuilder();
                boolean isBeginParam = true;
                for (String argument : arguments) {
                    sb.append(argument).append(" ");
                    if (!isBeginParam) continue;
                    sb.append("'");
                    isBeginParam = false;
                }
                sb.deleteCharAt(sb.length() - 1).append("'");
                log.log(Level.FINE, sb.toString());
                new ProcessBuilder(arguments.toArray(new String[1])).start();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                DataExplorer.getInstance().openMessageDialogAsync(e.getMessage());
            }
        }
    }

    public boolean isLaunchable() {
        return this.fqExecPath.length() >= 4;
    }
}

