/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.json;

import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.glassfish.json.JsonMessages;

public class JsonPatchImpl
implements JsonPatch {
    private final JsonArray patch;

    public JsonPatchImpl(JsonArray patch2) {
        this.patch = patch2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != JsonPatchImpl.class) {
            return false;
        }
        return this.patch.equals(((JsonPatchImpl)obj).patch);
    }

    public int hashCode() {
        return this.patch.hashCode();
    }

    public String toString() {
        return this.patch.toString();
    }

    public JsonStructure apply(JsonStructure target) {
        JsonStructure result2 = target;
        for (JsonValue operation : this.patch) {
            if (operation.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new JsonException(JsonMessages.PATCH_MUST_BE_ARRAY());
            }
            result2 = this.apply(result2, (JsonObject)operation);
        }
        return result2;
    }

    @Override
    public JsonArray toJsonArray() {
        return this.patch;
    }

    public static JsonArray diff(JsonStructure source, JsonStructure target) {
        return new DiffGenerator().diff(source, target);
    }

    private JsonStructure apply(JsonStructure target, JsonObject operation) {
        JsonPointer pointer = this.getPointer(operation, "path");
        switch (JsonPatch.Operation.fromOperationName(operation.getString("op"))) {
            case ADD: {
                return pointer.add(target, this.getValue(operation));
            }
            case REPLACE: {
                return pointer.replace(target, this.getValue(operation));
            }
            case REMOVE: {
                return pointer.remove(target);
            }
            case COPY: {
                JsonPointer from = this.getPointer(operation, "from");
                return pointer.add(target, from.getValue(target));
            }
            case MOVE: {
                String dest = operation.getString("path");
                String src = operation.getString("from");
                if (dest.startsWith(src) && src.length() < dest.length()) {
                    throw new JsonException(JsonMessages.PATCH_MOVE_PROPER_PREFIX(src, dest));
                }
                JsonPointer from = this.getPointer(operation, "from");
                if (!from.containsValue(target)) {
                    throw new JsonException(JsonMessages.PATCH_MOVE_TARGET_NULL(src));
                }
                if (pointer.equals(from)) {
                    return target;
                }
                return pointer.add(from.remove(target), from.getValue(target));
            }
            case TEST: {
                if (!this.getValue(operation).equals(pointer.getValue(target))) {
                    throw new JsonException(JsonMessages.PATCH_TEST_FAILED(operation.getString("path"), this.getValue(operation).toString()));
                }
                return target;
            }
        }
        throw new JsonException(JsonMessages.PATCH_ILLEGAL_OPERATION(operation.getString("op")));
    }

    private JsonPointer getPointer(JsonObject operation, String member) {
        JsonString pointerString = operation.getJsonString(member);
        if (pointerString == null) {
            this.missingMember(operation.getString("op"), member);
        }
        return Json.createPointer(pointerString.getString());
    }

    private JsonValue getValue(JsonObject operation) {
        JsonValue value = (JsonValue)operation.get("value");
        if (value == null) {
            this.missingMember(operation.getString("op"), "value");
        }
        return value;
    }

    private void missingMember(String op, String member) {
        throw new JsonException(JsonMessages.PATCH_MEMBER_MISSING(op, member));
    }

    static class DiffGenerator {
        private JsonPatchBuilder builder;

        DiffGenerator() {
        }

        JsonArray diff(JsonStructure source, JsonStructure target) {
            this.builder = Json.createPatchBuilder();
            this.diff("", source, target);
            return this.builder.build().toJsonArray();
        }

        private void diff(String path2, JsonValue source, JsonValue target) {
            if (source.equals(target)) {
                return;
            }
            JsonValue.ValueType s2 = source.getValueType();
            JsonValue.ValueType t2 = target.getValueType();
            if (s2 == JsonValue.ValueType.OBJECT && t2 == JsonValue.ValueType.OBJECT) {
                this.diffObject(path2, (JsonObject)source, (JsonObject)target);
            } else if (s2 == JsonValue.ValueType.ARRAY && t2 == JsonValue.ValueType.ARRAY) {
                this.diffArray(path2, (JsonArray)source, (JsonArray)target);
            } else {
                this.builder.replace(path2, target);
            }
        }

        private void diffObject(String path2, JsonObject source, JsonObject target) {
            source.forEach((key2, value) -> {
                if (target.containsKey(key2)) {
                    this.diff(path2 + '/' + key2, (JsonValue)value, (JsonValue)target.get(key2));
                } else {
                    this.builder.remove(path2 + '/' + key2);
                }
            });
            target.forEach((key2, value) -> {
                if (!source.containsKey(key2)) {
                    this.builder.add(path2 + '/' + key2, (JsonValue)value);
                }
            });
        }

        private void diffArray(String path2, JsonArray source, JsonArray target) {
            int j2;
            int i2;
            int m2 = source.size();
            int n2 = target.size();
            int[][] c2 = new int[m2 + 1][n2 + 1];
            for (i2 = 0; i2 < m2 + 1; ++i2) {
                c2[i2][0] = 0;
            }
            for (i2 = 0; i2 < n2 + 1; ++i2) {
                c2[0][i2] = 0;
            }
            for (i2 = 0; i2 < m2; ++i2) {
                for (j2 = 0; j2 < n2; ++j2) {
                    c2[i2 + 1][j2 + 1] = ((JsonValue)source.get(i2)).equals(target.get(j2)) ? (c2[i2][j2] & 0xFFFFFFFE) + 3 : Math.max(c2[i2 + 1][j2], c2[i2][j2 + 1]) & 0xFFFFFFFE;
                }
            }
            i2 = m2;
            j2 = n2;
            while (i2 > 0 || j2 > 0) {
                if (i2 == 0) {
                    this.builder.add(path2 + '/' + --j2, (JsonValue)target.get(j2));
                    continue;
                }
                if (j2 == 0) {
                    this.builder.remove(path2 + '/' + --i2);
                    continue;
                }
                if ((c2[i2][j2] & 1) == 1) {
                    --i2;
                    --j2;
                    continue;
                }
                int f2 = c2[i2][j2 - 1] >> 1;
                int g2 = c2[i2 - 1][j2] >> 1;
                if (f2 > g2) {
                    this.builder.add(path2 + '/' + --j2, (JsonValue)target.get(j2));
                    continue;
                }
                if (f2 < g2) {
                    this.builder.remove(path2 + '/' + --i2);
                    continue;
                }
                this.diff(path2 + '/' + --i2, (JsonValue)source.get(i2), (JsonValue)target.get(--j2));
            }
        }
    }
}

