/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;

public final class Color
extends Resource {
    public float[] handle;

    Color(Device device) {
        super(device);
    }

    public Color(Device device, int n, int n2, int n3) {
        super(device);
        this.init(n, n2, n3);
        this.init();
    }

    public Color(Device device, RGB rGB) {
        super(device);
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(rGB.red, rGB.green, rGB.blue);
        this.init();
    }

    void destroy() {
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        float[] fArray = color.handle;
        if (this.handle == fArray) {
            return true;
        }
        return this.device == color.device && (int)(this.handle[0] * 255.0f) == (int)(fArray[0] * 255.0f) && (int)(this.handle[1] * 255.0f) == (int)(fArray[1] * 255.0f) && (int)(this.handle[2] * 255.0f) == (int)(fArray[2] * 255.0f);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[2] * 255.0f);
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[1] * 255.0f);
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (int)(this.handle[0] * 255.0f);
    }

    public int hashCode() {
        if (this.isDisposed()) {
            return 0;
        }
        return (int)(this.handle[0] * 255.0f) ^ (int)(this.handle[1] * 255.0f) ^ (int)(this.handle[2] * 255.0f);
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public static Color cocoa_new(Device device, float[] fArray) {
        float[] fArray2 = fArray;
        Color color = new Color(device);
        color.handle = fArray2;
        return color;
    }

    void init(int n, int n2, int n3) {
        if (n > 255 || n < 0 || n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0) {
            SWT.error(5);
        }
        float[] fArray = new float[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f, 1.0f};
        this.handle = fArray;
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }
}

