/*
 * Decompiled with CFR 0.152.
 */
package gde.device.smmodellbau;

import gde.device.smmodellbau.GPSLogger;
import gde.io.DataParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class SetupReaderWriter {
    static final Logger log = Logger.getLogger(SetupReaderWriter.class.getName());
    final DataExplorer application = DataExplorer.getInstance();
    final GPSLogger device;
    final Shell parent;
    static final int TEL_ALARM_HEIGHT = 1;
    static final int TEL_ALARM_SPEED_MAX = 2;
    static final int TEL_ALARM_DISTANCE_MAX = 4;
    static final int TEL_ALARM_TRIP_LENGTH = 8;
    static final int TEL_ALARM_VOLTAGE_RX = 16;
    static final int TEL_ALARM_CURRENT_UL = 32;
    static final int TEL_ALARM_VOLTAGE_START_UL = 64;
    static final int TEL_ALARM_VOLTAGE_UL = 128;
    static final int TEL_ALARM_CAPACITY_UL = 256;
    static final int TEL_ALARM_DISTANCE_MIN = 512;
    static final int TEL_ALARM_SPEED_MIN = 1024;
    int serialNumber = 357;
    short datarate = 0;
    short startModus = 1;
    short timeZone = (short)2;
    short units = 0;
    short varioThreshold = (short)3;
    short varioTon = 0;
    short stopModus = 0;
    short modusDistance = 0;
    short varioThresholdSink = (short)8;
    short daylightSavingModus = 1;
    short telemetryType = 0;
    short rxControl = 0;
    int jetiExMask = -1;
    short varioFactor = 0;
    short frskySensorAddr = (short)6;
    short telemetryAlarms = (short)19;
    short heightAlarm = (short)200;
    short speedMaxAlarm = (short)200;
    short distanceMaxAlarm = (short)500;
    short voltageRxAlarm = (short)450;
    short tripLengthAlarm = (short)50;
    short currentUlAlarm = (short)100;
    short voltageStartUlAlarm = (short)124;
    short voltageUlAlarm = (short)100;
    short capacityUlAlarm = (short)2000;
    short distanceMinAlarm = 0;
    byte serialNumberFix = 0;
    byte robbe_T_Box = 0;
    short varioFilter = 0;
    short speedMinAlarm = (short)30;
    byte language = 0;
    byte hottSpeedType = 0;
    short jetiExMask_UL = 0;
    byte frskyInstanceId = 0;
    byte mLinkAddressVarioTec = 0;
    byte mLinkAddressVoltageRx = (byte)16;
    byte mLinkAddressSpeed = 1;
    byte mLinkAddressVario = 0;
    byte mLinkAddressDirection = (byte)3;
    byte mLinkAddressAirSpeed = 0;
    byte mLinkAddressAltitude = (byte)4;
    byte mLinkAddressFree41 = 0;
    byte mLinkAddressDistance = (byte)7;
    byte mLinkAddressFree42 = 0;
    byte mLinkAddressTripLength = (byte)8;
    byte mLinkAddressFree43 = 0;
    byte mLinkAddressSpeedMax = (byte)2;
    byte mLinkAddressFree44 = 0;
    byte mLinkAddressHeightMax = (byte)5;
    byte mLinkAddressFree45 = 0;
    byte mLinkAddressENL = (byte)9;
    byte mLinkAddressFree46 = 0;
    byte mLinkAddressAccX = (byte)10;
    byte mLinkAddressFree47 = 0;
    byte mLinkAddressAccY = (byte)11;
    byte mLinkAddressFree48 = 0;
    byte mLinkAddressAccZ = (byte)12;
    byte mLinkAddressFree49 = 0;
    byte mLinkAddressFlightDirection = (byte)13;
    byte mLinkAddressFree50 = 0;
    byte mLinkAddressDirectionRel = (byte)14;
    byte smoothAltitudeNulling = 0;
    byte mLinkAddressAltitudeGain = (byte)6;
    byte powerBoxP2BusAdresse = (byte)-68;
    short firmwareVersion = (short)126;
    short modusIGC = 1;
    byte[] startSlotSBUS = new byte[8];
    byte spektrumSensors = 0;
    byte spektrumNumber = 0;
    int fixPositionLatitude = 0;
    int fixPositionLongitude = 0;
    short fixPositionAltitude = 0;
    byte isHottDeadBand = 0;
    byte tekCompensation = 0;
    short betaVersion = 0;
    short hardwareVersion = 0;
    short checkSum;
    short[] setupData = new short[192];

    public SetupReaderWriter(Shell useParent, GPSLogger useDevice) {
        this.parent = useParent;
        this.device = useDevice;
    }

    void loadSetup() {
        FileDialog fd = this.application.openFileOpenDialog(this.parent, Messages.getString((String)"GDE_MSGT2001"), new String[]{"*.ini", "*"}, this.device.getConfigurationFileDirecotry(), this.device.getDefaultConfigurationFileName(), 4);
        GPSLogger.selectedSetupFilePath = fd.getFilterPath() + "/" + fd.getFileName();
        log.log(Level.FINE, "selectedSetupFile = " + GPSLogger.selectedSetupFilePath);
        if (fd.getFileName().length() > 4) {
            try {
                FileInputStream file_input = new FileInputStream(new File(GPSLogger.selectedSetupFilePath));
                DataInputStream data_in = new DataInputStream(file_input);
                byte[] buffer = new byte[192];
                int size = data_in.read(buffer);
                data_in.close();
                if (size != 192) {
                    log.log(Level.SEVERE, "error reading configuration file, data size != 192 Bytes!");
                }
                this.serialNumber = DataParser.parse2UnsignedShort((byte[])buffer, (int)0);
                this.datarate = DataParser.parse2Short((byte[])buffer, (int)2);
                this.startModus = DataParser.parse2Short((byte[])buffer, (int)4);
                this.timeZone = DataParser.parse2Short((byte[])buffer, (int)6);
                this.varioThreshold = DataParser.parse2Short((byte[])buffer, (int)10);
                this.varioTon = DataParser.parse2Short((byte[])buffer, (int)12);
                this.stopModus = DataParser.parse2Short((byte[])buffer, (int)14);
                this.modusDistance = DataParser.parse2Short((byte[])buffer, (int)16);
                this.varioThresholdSink = DataParser.parse2Short((byte[])buffer, (int)18);
                this.daylightSavingModus = DataParser.parse2Short((byte[])buffer, (int)20);
                this.telemetryType = DataParser.parse2Short((byte[])buffer, (int)22);
                this.rxControl = DataParser.parse2Short((byte[])buffer, (int)24);
                this.jetiExMask = DataParser.parse2Int((byte[])buffer, (int)26);
                this.varioFactor = DataParser.parse2Short((byte[])buffer, (int)30);
                this.frskySensorAddr = DataParser.parse2Short((byte[])buffer, (int)32);
                this.telemetryAlarms = DataParser.parse2Short((byte[])buffer, (int)34);
                this.heightAlarm = DataParser.parse2Short((byte[])buffer, (int)36);
                this.speedMaxAlarm = DataParser.parse2Short((byte[])buffer, (int)38);
                this.distanceMaxAlarm = DataParser.parse2Short((byte[])buffer, (int)40);
                this.voltageRxAlarm = DataParser.parse2Short((byte[])buffer, (int)42);
                this.tripLengthAlarm = DataParser.parse2Short((byte[])buffer, (int)44);
                this.currentUlAlarm = DataParser.parse2Short((byte[])buffer, (int)46);
                this.voltageStartUlAlarm = DataParser.parse2Short((byte[])buffer, (int)48);
                this.voltageUlAlarm = DataParser.parse2Short((byte[])buffer, (int)50);
                this.capacityUlAlarm = DataParser.parse2Short((byte[])buffer, (int)52);
                this.distanceMinAlarm = DataParser.parse2Short((byte[])buffer, (int)54);
                this.serialNumberFix = buffer[56];
                this.robbe_T_Box = buffer[57];
                this.varioFilter = DataParser.parse2Short((byte[])buffer, (int)58);
                this.speedMinAlarm = DataParser.parse2Short((byte[])buffer, (int)60);
                this.language = buffer[62];
                this.hottSpeedType = buffer[63];
                this.jetiExMask_UL = DataParser.parse2Short((byte[])buffer, (int)64);
                this.frskyInstanceId = buffer[66];
                this.isHottDeadBand = buffer[67];
                this.tekCompensation = buffer[70];
                this.mLinkAddressVarioTec = buffer[74];
                this.mLinkAddressVoltageRx = buffer[75];
                this.mLinkAddressSpeed = buffer[76];
                this.mLinkAddressVario = buffer[77];
                this.mLinkAddressDirection = buffer[78];
                this.mLinkAddressAirSpeed = buffer[79];
                this.mLinkAddressAltitude = buffer[80];
                this.mLinkAddressDistance = buffer[82];
                this.mLinkAddressTripLength = buffer[84];
                this.mLinkAddressSpeedMax = buffer[86];
                this.mLinkAddressHeightMax = buffer[88];
                this.mLinkAddressENL = buffer[90];
                this.mLinkAddressAccX = buffer[92];
                this.mLinkAddressAccY = buffer[94];
                this.mLinkAddressAccZ = buffer[96];
                this.mLinkAddressFlightDirection = buffer[98];
                this.mLinkAddressDirectionRel = buffer[100];
                this.smoothAltitudeNulling = buffer[101];
                this.mLinkAddressAltitudeGain = buffer[102];
                this.powerBoxP2BusAdresse = buffer[103];
                this.firmwareVersion = DataParser.parse2Short((byte[])buffer, (int)106);
                this.modusIGC = DataParser.parse2Short((byte[])buffer, (int)108);
                System.arraycopy(buffer, 110, this.startSlotSBUS, 0, 8);
                this.spektrumSensors = buffer[118];
                this.spektrumNumber = buffer[119];
                this.fixPositionLatitude = DataParser.parse2Int((byte[])buffer, (int)120);
                this.fixPositionLongitude = DataParser.parse2Int((byte[])buffer, (int)124);
                this.fixPositionAltitude = DataParser.parse2Short((byte[])buffer, (int)128);
                this.betaVersion = DataParser.parse2Short((byte[])buffer, (int)186);
                this.hardwareVersion = DataParser.parse2Short((byte[])buffer, (int)188);
                this.checkSum = (short)(((buffer[191] & 0xFF) << 8) + (buffer[190] & 0xFF));
                byte[] chkBuffer = new byte[190];
                System.arraycopy(buffer, 0, chkBuffer, 0, chkBuffer.length);
                short checkCRC = Checksum.CRC16((byte[])chkBuffer, (int)0);
                if (this.checkSum != checkCRC) {
                    log.log(Level.WARNING, "Checksum missmatch!");
                }
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    void saveSetup() {
        FileDialog fileDialog = this.application.prepareFileSaveDialog(this.parent, Messages.getString((String)"GDE_MSGT2002"), new String[]{"*.ini", "*"}, this.device.getConfigurationFileDirecotry(), this.device.getDefaultConfigurationFileName());
        log.log(Level.FINE, "selectedSetupFile = " + fileDialog.getFileName());
        String setupFilePath = fileDialog.open();
        if (setupFilePath != null && setupFilePath.length() > 4) {
            File setupFile = new File(setupFilePath);
            byte[] buffer = new byte[192];
            short tmpCheckSum = 0;
            try {
                buffer[0] = (byte)(this.serialNumber & 0xFF);
                buffer[1] = (byte)((this.serialNumber & 0xFF00) >> 8);
                buffer[2] = (byte)(this.datarate & 0xFF);
                buffer[3] = (byte)((this.datarate & 0xFF00) >> 8);
                buffer[4] = (byte)(this.startModus & 0xFF);
                buffer[5] = (byte)((this.startModus & 0xFF00) >> 8);
                buffer[6] = (byte)(this.timeZone & 0xFF);
                buffer[7] = (byte)((this.timeZone & 0xFF00) >> 8);
                buffer[10] = (byte)(this.varioThreshold & 0xFF);
                buffer[11] = (byte)((this.varioThreshold & 0xFF00) >> 8);
                buffer[12] = (byte)(this.varioTon & 0xFF);
                buffer[13] = (byte)((this.varioTon & 0xFF00) >> 8);
                buffer[14] = (byte)(this.stopModus & 0xFF);
                buffer[15] = (byte)((this.stopModus & 0xFF00) >> 8);
                buffer[16] = (byte)(this.modusDistance & 0xFF);
                buffer[17] = (byte)((this.modusDistance & 0xFF00) >> 8);
                buffer[18] = (byte)(this.varioThresholdSink & 0xFF);
                buffer[19] = (byte)((this.varioThresholdSink & 0xFF00) >> 8);
                buffer[20] = (byte)(this.daylightSavingModus & 0xFF);
                buffer[21] = (byte)((this.daylightSavingModus & 0xFF00) >> 8);
                buffer[22] = (byte)(this.telemetryType & 0xFF);
                buffer[23] = (byte)((this.telemetryType & 0xFF00) >> 8);
                buffer[24] = (byte)(this.rxControl & 0xFF);
                buffer[25] = (byte)((this.rxControl & 0xFF00) >> 8);
                buffer[26] = (byte)(this.jetiExMask & 0xFF);
                buffer[27] = (byte)((this.jetiExMask & 0xFF00) >> 8);
                buffer[28] = (byte)((this.jetiExMask & 0xFF0000) >> 16);
                buffer[29] = (byte)((this.jetiExMask & 0xFF000000) >> 24);
                buffer[30] = (byte)(this.varioFactor & 0xFF);
                buffer[31] = (byte)((this.varioFactor & 0xFF00) >> 8);
                buffer[32] = (byte)(this.frskySensorAddr & 0xFF);
                buffer[33] = (byte)((this.frskySensorAddr & 0xFF00) >> 8);
                buffer[34] = (byte)(this.telemetryAlarms & 0xFF);
                buffer[35] = (byte)((this.telemetryAlarms & 0xFF00) >> 8);
                buffer[36] = (byte)(this.heightAlarm & 0xFF);
                buffer[37] = (byte)((this.heightAlarm & 0xFF00) >> 8);
                buffer[38] = (byte)(this.speedMaxAlarm & 0xFF);
                buffer[39] = (byte)((this.speedMaxAlarm & 0xFF00) >> 8);
                buffer[40] = (byte)(this.distanceMaxAlarm & 0xFF);
                buffer[41] = (byte)((this.distanceMaxAlarm & 0xFF00) >> 8);
                buffer[42] = (byte)(this.voltageRxAlarm & 0xFF);
                buffer[43] = (byte)((this.voltageRxAlarm & 0xFF00) >> 8);
                buffer[44] = (byte)(this.tripLengthAlarm & 0xFF);
                buffer[45] = (byte)((this.tripLengthAlarm & 0xFF00) >> 8);
                buffer[46] = (byte)(this.currentUlAlarm & 0xFF);
                buffer[47] = (byte)((this.currentUlAlarm & 0xFF00) >> 8);
                buffer[48] = (byte)(this.voltageStartUlAlarm & 0xFF);
                buffer[49] = (byte)((this.voltageStartUlAlarm & 0xFF00) >> 8);
                buffer[50] = (byte)(this.voltageUlAlarm & 0xFF);
                buffer[51] = (byte)((this.voltageUlAlarm & 0xFF00) >> 8);
                buffer[52] = (byte)(this.capacityUlAlarm & 0xFF);
                buffer[53] = (byte)((this.capacityUlAlarm & 0xFF00) >> 8);
                buffer[54] = (byte)(this.distanceMinAlarm & 0xFF);
                buffer[55] = (byte)((this.distanceMinAlarm & 0xFF00) >> 8);
                buffer[56] = this.serialNumberFix;
                buffer[57] = this.robbe_T_Box;
                buffer[58] = (byte)(this.varioFilter & 0xFF);
                buffer[59] = (byte)((this.varioFilter & 0xFF00) >> 8);
                buffer[60] = (byte)(this.speedMinAlarm & 0xFF);
                buffer[61] = (byte)((this.speedMinAlarm & 0xFF00) >> 8);
                buffer[62] = (byte)(this.language & 0xFF);
                buffer[63] = (byte)(this.hottSpeedType & 0xFF);
                buffer[64] = (byte)(this.jetiExMask_UL & 0xFF);
                buffer[65] = (byte)((this.jetiExMask_UL & 0xFF00) >> 8);
                buffer[66] = this.frskyInstanceId;
                buffer[67] = this.isHottDeadBand;
                buffer[70] = this.tekCompensation;
                buffer[74] = this.mLinkAddressVarioTec;
                buffer[75] = this.mLinkAddressVoltageRx;
                buffer[76] = (byte)(this.mLinkAddressSpeed & 0xFF);
                buffer[77] = this.mLinkAddressVario;
                buffer[78] = (byte)(this.mLinkAddressDirection & 0xFF);
                buffer[79] = (byte)(this.mLinkAddressAirSpeed & 0xFF);
                buffer[80] = (byte)(this.mLinkAddressAltitude & 0xFF);
                buffer[81] = 0;
                buffer[82] = (byte)(this.mLinkAddressDistance & 0xFF);
                buffer[83] = 0;
                buffer[84] = (byte)(this.mLinkAddressTripLength & 0xFF);
                buffer[85] = 0;
                buffer[86] = (byte)(this.mLinkAddressSpeedMax & 0xFF);
                buffer[87] = 0;
                buffer[88] = (byte)(this.mLinkAddressHeightMax & 0xFF);
                buffer[89] = 0;
                buffer[90] = (byte)(this.mLinkAddressENL & 0xFF);
                buffer[91] = 0;
                buffer[92] = (byte)(this.mLinkAddressAccX & 0xFF);
                buffer[93] = 0;
                buffer[94] = (byte)(this.mLinkAddressAccY & 0xFF);
                buffer[95] = 0;
                buffer[96] = (byte)(this.mLinkAddressAccZ & 0xFF);
                buffer[97] = 0;
                buffer[98] = (byte)(this.mLinkAddressFlightDirection & 0xFF);
                buffer[99] = 0;
                buffer[100] = (byte)(this.mLinkAddressDirectionRel & 0xFF);
                buffer[101] = this.smoothAltitudeNulling;
                buffer[102] = this.mLinkAddressAltitudeGain;
                buffer[103] = this.powerBoxP2BusAdresse;
                buffer[106] = (byte)(this.firmwareVersion & 0xFF);
                buffer[107] = (byte)((this.firmwareVersion & 0xFF00) >> 8);
                buffer[108] = (byte)(this.modusIGC & 0xFF);
                buffer[109] = (byte)((this.modusIGC & 0xFF00) >> 8);
                System.arraycopy(this.startSlotSBUS, 0, buffer, 110, 8);
                buffer[118] = this.spektrumSensors;
                buffer[119] = this.spektrumNumber;
                buffer[120] = (byte)(this.fixPositionLatitude & 0xFF);
                buffer[121] = (byte)((this.fixPositionLatitude & 0xFF00) >> 8);
                buffer[122] = (byte)((this.fixPositionLatitude & 0xFF0000) >> 16);
                buffer[123] = (byte)((this.fixPositionLatitude & 0xFF000000) >> 24);
                buffer[124] = (byte)(this.fixPositionLongitude & 0xFF);
                buffer[125] = (byte)((this.fixPositionLongitude & 0xFF00) >> 8);
                buffer[126] = (byte)((this.fixPositionLongitude & 0xFF0000) >> 16);
                buffer[127] = (byte)((this.fixPositionLongitude & 0xFF000000) >> 24);
                buffer[128] = (byte)(this.fixPositionAltitude & 0xFF);
                buffer[129] = (byte)((this.fixPositionAltitude & 0xFF00) >> 8);
                buffer[186] = (byte)(this.betaVersion & 0xFF);
                buffer[187] = (byte)((this.betaVersion & 0xFF00) >> 8);
                buffer[188] = (byte)(this.hardwareVersion & 0xFF);
                buffer[189] = (byte)((this.hardwareVersion & 0xFF00) >> 8);
                byte[] chkBuffer = new byte[190];
                System.arraycopy(buffer, 0, chkBuffer, 0, chkBuffer.length);
                tmpCheckSum = Checksum.CRC16((byte[])chkBuffer, (int)0);
                buffer[190] = (byte)(tmpCheckSum & 0xFF);
                buffer[191] = (byte)((tmpCheckSum & 0xFF00) >> 8);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, "$SETUP," + StringHelper.byte2Hex2CharString((byte[])buffer, (int)buffer.length));
                }
                FileOutputStream file_out = new FileOutputStream(setupFile);
                DataOutputStream data_out = new DataOutputStream(file_out);
                data_out.write(buffer);
                data_out.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Error writing setupfile = " + fileDialog.getFileName() + " - " + e.getMessage());
            }
        }
    }

    public void loadSetup(String csvLine) {
        String[] data = csvLine.split(",");
        this.serialNumber = Integer.parseInt(data[1], 16);
        this.datarate = Short.parseShort(data[2], 16);
        this.startModus = Short.parseShort(data[3], 16);
        this.timeZone = Short.parseShort(data[4], 16);
        this.varioThreshold = Short.parseShort(data[6], 16);
        this.varioTon = Short.parseShort(data[7], 16);
        this.stopModus = Short.parseShort(data[8], 16);
        this.modusDistance = Short.parseShort(data[9], 16);
        this.varioThresholdSink = Short.parseShort(data[10], 16);
        this.daylightSavingModus = Short.parseShort(data[11], 16);
        this.telemetryType = Short.parseShort(data[12], 16);
        this.rxControl = Short.parseShort(data[13], 16);
        this.jetiExMask = Short.parseShort(data[14], 16);
        this.varioFactor = Short.parseShort(data[15], 16);
        this.frskySensorAddr = Short.parseShort(data[16], 16);
        this.telemetryAlarms = Short.parseShort(data[17], 16);
        this.heightAlarm = Short.parseShort(data[18], 16);
        this.speedMaxAlarm = Short.parseShort(data[19], 16);
        this.distanceMaxAlarm = Short.parseShort(data[20], 16);
        this.voltageRxAlarm = Short.parseShort(data[21], 16);
        this.tripLengthAlarm = Short.parseShort(data[22], 16);
        this.currentUlAlarm = Short.parseShort(data[23], 16);
        this.voltageStartUlAlarm = Short.parseShort(data[24], 16);
        this.voltageUlAlarm = Short.parseShort(data[25], 16);
        this.capacityUlAlarm = Short.parseShort(data[26], 16);
        this.distanceMinAlarm = Short.parseShort(data[27], 16);
        this.serialNumberFix = Byte.parseByte(data[29], 16);
        this.robbe_T_Box = Byte.parseByte(data[29], 16);
        this.varioFilter = Short.parseShort(data[30], 16);
        this.speedMinAlarm = Short.parseShort(data[31], 16);
        this.language = Byte.parseByte(data[32], 16);
        this.hottSpeedType = Byte.parseByte(data[32], 16);
        this.jetiExMask_UL = Short.parseShort(data[33], 16);
        this.isHottDeadBand = Byte.parseByte(data[34], 16);
        this.mLinkAddressVarioTec = Byte.parseByte(data[2], 16);
        this.mLinkAddressVoltageRx = Byte.parseByte(data[2], 16);
        this.mLinkAddressSpeed = Byte.parseByte(data[2], 16);
        this.mLinkAddressVario = Byte.parseByte(data[2], 16);
        this.mLinkAddressDirection = Byte.parseByte(data[2], 16);
        this.mLinkAddressAirSpeed = Byte.parseByte(data[2], 16);
        this.mLinkAddressAltitude = Byte.parseByte(data[2], 16);
        this.mLinkAddressDistance = Byte.parseByte(data[2], 16);
        this.mLinkAddressTripLength = Byte.parseByte(data[2], 16);
        this.mLinkAddressSpeedMax = Byte.parseByte(data[2], 16);
        this.mLinkAddressHeightMax = Byte.parseByte(data[2], 16);
        this.mLinkAddressENL = Byte.parseByte(data[2], 16);
        this.mLinkAddressAccX = Byte.parseByte(data[2], 16);
        this.mLinkAddressAccY = Byte.parseByte(data[2], 16);
        this.mLinkAddressAccZ = Byte.parseByte(data[2], 16);
        this.mLinkAddressFlightDirection = Byte.parseByte(data[2], 16);
        this.mLinkAddressDirectionRel = Byte.parseByte(data[2], 16);
        this.smoothAltitudeNulling = Byte.parseByte(data[2], 16);
        this.mLinkAddressAltitudeGain = Byte.parseByte(data[2], 16);
        this.powerBoxP2BusAdresse = Byte.parseByte(data[2], 16);
        this.firmwareVersion = Short.parseShort(data[54], 16);
        this.modusIGC = Short.parseShort(data[55], 16);
        this.spektrumSensors = Byte.parseByte(data[2], 16);
        this.spektrumNumber = Byte.parseByte(data[2], 16);
        this.fixPositionLatitude = Integer.parseInt(data[61], 16);
        this.fixPositionLongitude = Integer.parseInt(data[62], 16);
        this.fixPositionAltitude = Short.parseShort(data[63], 16);
        this.betaVersion = Short.parseShort(data[94], 16);
        this.hardwareVersion = Short.parseShort(data[95], 16);
    }

    public int getJetiMeasurementCount() {
        int i;
        int count = 37;
        for (i = 0; i < 32; ++i) {
            count -= (this.jetiExMask & 0xFFFFFFFF) >> i & 1;
        }
        for (i = 0; i < 16; ++i) {
            count -= (this.jetiExMask_UL & 0xFFFF) >> i & 1;
        }
        return count;
    }
}

