/*
 * Decompiled with CFR 0.152.
 */
package gde.device.wb;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.wb.CSV2SerialAdapter;
import gde.device.wb.CSV2SerialAdapterDialog;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.ui.MeasurementControlConfigurable;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CSV2SerialAdapterDialogTabItem
extends CTabItem {
    static final Logger log = Logger.getLogger(CSV2SerialAdapterDialogTabItem.class.getName());
    Composite measurementComposite;
    Button measurement;
    Button inputFileButton;
    Composite buttonComposite;
    Label measurementUnitLabel;
    Label measurementSymbolLabel;
    Label tabItemLabel;
    boolean isVisibilityChanged = false;
    final CTabFolder parent;
    final CSV2SerialAdapter device;
    final DataExplorer application;
    final Channels channels;
    final CSV2SerialAdapterDialog dialog;
    final int channelConfigNumber;
    final List<MeasurementControlConfigurable> measurementControls = new ArrayList<MeasurementControlConfigurable>();

    public CSV2SerialAdapterDialogTabItem(CTabFolder parentTabFolder, CSV2SerialAdapterDialog parentDialog, int useChannelConfigNumber, CSV2SerialAdapter useDevice) {
        super(parentTabFolder, 0);
        this.parent = parentTabFolder;
        this.dialog = parentDialog;
        this.device = useDevice;
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.channelConfigNumber = useChannelConfigNumber;
        this.setText(this.device.getChannelNameReplacement(this.channelConfigNumber));
        this.create();
    }

    void create() {
        final ScrolledComposite scolledComposite = new ScrolledComposite((Composite)this.parent, 512);
        scolledComposite.setLayout((Layout)new FillLayout());
        this.setControl((Control)scolledComposite);
        final Composite mainTabComposite = new Composite((Composite)scolledComposite, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        scolledComposite.setContent((Control)mainTabComposite);
        this.tabItemLabel = new Label(mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.horizontalAlignment = 1;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 20;
        tabItemLabelLData.widthHint = 292;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT1701"));
        List measurementTypes = this.device.getChannelMeasuremtsReplacedNames(this.channelConfigNumber);
        for (int i = 0; i < measurementTypes.size(); ++i) {
            this.measurementControls.add(new MeasurementControlConfigurable(mainTabComposite, (DeviceDialog)this.dialog, this.channelConfigNumber, i, (MeasurementType)measurementTypes.get(i), (IDevice)this.device, 1, " " + i, ""));
        }
        scolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlResized, event=" + String.valueOf(evt));
                int height = 35 + CSV2SerialAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(CSV2SerialAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28;
                Channel channel = (Channel)Channels.getInstance().get((Object)(CSV2SerialAdapterDialogTabItem.this.parent.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }

            public void controlMoved(ControlEvent evt) {
                log.log(Level.FINEST, "scolledComposite.controlMoved, event=" + String.valueOf(evt));
                int height = 35 + CSV2SerialAdapterDialogTabItem.this.device.getChannelMeasuremtsReplacedNames(CSV2SerialAdapterDialogTabItem.this.parent.getSelectionIndex() + 1).size() * 28;
                Channel channel = (Channel)Channels.getInstance().get((Object)(CSV2SerialAdapterDialogTabItem.this.parent.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }
        });
        mainTabComposite.layout();
        this.buttonComposite = new Composite(mainTabComposite, 0);
        GridData buttonCompositeLData = new GridData();
        buttonCompositeLData.verticalAlignment = 1;
        buttonCompositeLData.horizontalAlignment = 1;
        buttonCompositeLData.heightHint = 60;
        buttonCompositeLData.grabExcessHorizontalSpace = true;
        this.buttonComposite.setLayoutData((Object)buttonCompositeLData);
        FormLayout buttonCompositeLayout = new FormLayout();
        this.buttonComposite.setLayout((Layout)buttonCompositeLayout);
        this.inputFileButton = new Button(this.buttonComposite, 0x1000008);
        FormData inputFileButtonLData = new FormData();
        inputFileButtonLData.width = 188;
        inputFileButtonLData.height = 26;
        inputFileButtonLData.left = new FormAttachment(183, 1000, 0);
        inputFileButtonLData.right = new FormAttachment(827, 1000, 0);
        inputFileButtonLData.top = new FormAttachment(150, 1000, 0);
        inputFileButtonLData.bottom = new FormAttachment(1016, 1000, 0);
        buttonCompositeLData.heightHint = 30;
        buttonCompositeLData.widthHint = 292;
        this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
        this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT1702"));
        this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + String.valueOf(evt));
                if (CSV2SerialAdapterDialogTabItem.this.isVisibilityChanged) {
                    String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{CSV2SerialAdapterDialogTabItem.this.device.getPropertiesFileName()});
                    if (CSV2SerialAdapterDialogTabItem.this.application.openYesNoMessageDialog(CSV2SerialAdapterDialogTabItem.this.dialog.getDialogShell(), msg) == 64) {
                        log.log(Level.FINE, "SWT.YES");
                        CSV2SerialAdapterDialogTabItem.this.device.storeDeviceProperties();
                    }
                }
                CSV2SerialAdapterDialogTabItem.this.device.importCsvFiles();
            }
        });
    }
}

