/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.win32.OS;

class Relation {
    Accessible accessible;
    COMObject objIAccessibleRelation;
    int refCount;
    int type;
    Accessible[] targets;
    static final String[] relationTypeString = new String[]{"controlledBy", "controllerFor", "describedBy", "descriptionFor", "embeddedBy", "embeds", "flowsFrom", "flowsTo", "labelFor", "labelledBy", "memberOf", "nodeChildOf", "parentWindowOf", "popupFor", "subwindowOf"};
    static final String[] localizedRelationTypeString = new String[]{SWT.getMessage("SWT_Controlled_By"), SWT.getMessage("SWT_Controller_For"), SWT.getMessage("SWT_Described_By"), SWT.getMessage("SWT_Description_For"), SWT.getMessage("SWT_Embedded_By"), SWT.getMessage("SWT_Embeds"), SWT.getMessage("SWT_Flows_From"), SWT.getMessage("SWT_Flows_To"), SWT.getMessage("SWT_Label_For"), SWT.getMessage("SWT_Labelled_By"), SWT.getMessage("SWT_Member_Of"), SWT.getMessage("SWT_Node_Child_Of"), SWT.getMessage("SWT_Parent_Window_Of"), SWT.getMessage("SWT_Popup_For"), SWT.getMessage("SWT_Subwindow_Of")};

    Relation(Accessible accessible, int type2) {
        this.accessible = accessible;
        this.type = type2;
        this.targets = new Accessible[0];
        this.AddRef();
    }

    long getAddress() {
        if (this.objIAccessibleRelation == null) {
            this.createIAccessibleRelation();
        }
        return this.objIAccessibleRelation.getAddress();
    }

    void createIAccessibleRelation() {
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        this.objIAccessibleRelation = new COMObject(nArray){

            @Override
            public long method0(long[] args2) {
                return Relation.this.QueryInterface(args2[0], args2[1]);
            }

            @Override
            public long method1(long[] args2) {
                return Relation.this.AddRef();
            }

            @Override
            public long method2(long[] args2) {
                return Relation.this.Release();
            }

            @Override
            public long method3(long[] args2) {
                return Relation.this.get_relationType(args2[0]);
            }

            @Override
            public long method4(long[] args2) {
                return Relation.this.get_localizedRelationType(args2[0]);
            }

            @Override
            public long method5(long[] args2) {
                return Relation.this.get_nTargets(args2[0]);
            }

            @Override
            public long method6(long[] args2) {
                return Relation.this.get_target((int)args2[0], args2[1]);
            }

            @Override
            public long method7(long[] args2) {
                return Relation.this.get_targets((int)args2[0], args2[1], args2[2]);
            }
        };
    }

    int QueryInterface(long iid, long ppvObject) {
        GUID guid = new GUID();
        COM.MoveMemory(guid, iid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIAccessibleRelation)) {
            OS.MoveMemory(ppvObject, new long[]{this.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.objIAccessibleRelation != null) {
                this.objIAccessibleRelation.dispose();
            }
            this.objIAccessibleRelation = null;
        }
        return this.refCount;
    }

    int get_relationType(long pbstrRelationType) {
        this.setString(pbstrRelationType, relationTypeString[this.type]);
        return 0;
    }

    int get_localizedRelationType(long pbstrLocalizedRelationType) {
        this.setString(pbstrLocalizedRelationType, localizedRelationTypeString[this.type]);
        return 0;
    }

    int get_nTargets(long pNTargets) {
        OS.MoveMemory(pNTargets, new int[]{this.targets.length}, 4);
        return 0;
    }

    int get_target(int targetIndex, long ppTarget) {
        if (targetIndex < 0 || targetIndex >= this.targets.length) {
            return -2147024809;
        }
        Accessible target = this.targets[targetIndex];
        target.AddRef();
        OS.MoveMemory(ppTarget, new long[]{target.getAddress()}, C.PTR_SIZEOF);
        return 0;
    }

    int get_targets(int maxTargets, long ppTargets, long pNTargets) {
        int count = Math.min(this.targets.length, maxTargets);
        int i2 = 0;
        while (i2 < count) {
            Accessible target = this.targets[i2];
            target.AddRef();
            OS.MoveMemory(ppTargets + (long)(i2 * C.PTR_SIZEOF), new long[]{target.getAddress()}, C.PTR_SIZEOF);
            ++i2;
        }
        OS.MoveMemory(pNTargets, new int[]{count}, 4);
        return 0;
    }

    void addTarget(Accessible target) {
        if (this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length + 1];
        System.arraycopy(this.targets, 0, newTargets, 0, this.targets.length);
        newTargets[this.targets.length] = target;
        this.targets = newTargets;
    }

    boolean containsTarget(Accessible target) {
        int i2 = 0;
        while (i2 < this.targets.length) {
            if (this.targets[i2] == target) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    void removeTarget(Accessible target) {
        if (!this.containsTarget(target)) {
            return;
        }
        Accessible[] newTargets = new Accessible[this.targets.length - 1];
        int j2 = 0;
        int i2 = 0;
        while (i2 < this.targets.length) {
            if (this.targets[i2] != target) {
                newTargets[j2++] = this.targets[i2];
            }
            ++i2;
        }
        this.targets = newTargets;
    }

    boolean hasTargets() {
        return this.targets.length > 0;
    }

    void setString(long psz, String string2) {
        char[] data2 = (String.valueOf(string2) + "\u0000").toCharArray();
        long ptr = COM.SysAllocString(data2);
        OS.MoveMemory(psz, new long[]{ptr}, C.PTR_SIZEOF);
    }
}

