/*
 * Decompiled with CFR 0.152.
 */
package gde.device;

import gde.GDE;
import gde.config.Settings;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import java.util.logging.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public abstract class DeviceDialog
extends Dialog {
    static final Logger log = Logger.getLogger(DeviceDialog.class.getName());
    protected Shell dialogShell;
    protected boolean isFailedConnectionWarned = false;
    protected int shellAlpha;
    protected boolean isAlphaEnabled;
    protected boolean isFadeOut = false;
    protected boolean isInDialog = false;
    protected boolean isClosePossible = true;
    protected String disposeDisabledMessage = Messages.getString("GDE_MSGW0007");
    protected final DataExplorer application;
    public MouseTrackAdapter mouseTrackerEnterFadeOut = new MouseTrackAdapter(){

        public void mouseEnter(MouseEvent evt) {
            log.log(Level.FINE, "mouseEnter, event=" + String.valueOf(evt));
            DeviceDialog.this.fadeOutAplhaBlending();
        }

        public void mouseHover(MouseEvent evt) {
            log.log(Level.FINEST, "mouseHover, event=" + String.valueOf(evt));
        }

        public void mouseExit(MouseEvent evt) {
            log.log(Level.FINEST, "mouseEnter, event=" + String.valueOf(evt));
        }
    };

    public DeviceDialog(Shell parent, int style) {
        super(parent, style);
        this.application = DataExplorer.getInstance();
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
    }

    public DeviceDialog(Shell parent) {
        super(parent, 0);
        this.application = DataExplorer.getInstance();
        this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
        this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
    }

    public abstract void open();

    public void dispose() {
        if (this.isClosePossible) {
            this.dialogShell.dispose();
            if (!this.application.isDisposed()) {
                this.application.setStatusMessage("");
            }
            this.application.resetShellIcon();
        } else if (!this.application.isDisposed()) {
            this.application.setStatusMessage(this.disposeDisabledMessage, 3);
        }
    }

    public void close() {
        this.dispose();
    }

    public void forceDispose() {
        this.dialogShell.dispose();
    }

    public boolean isDisposed() {
        return this.dialogShell != null ? this.dialogShell.isDisposed() : true;
    }

    public void setVisible(boolean value) {
        this.dialogShell.setVisible(value);
    }

    public boolean setFocus() {
        return this.dialogShell != null ? this.dialogShell.setFocus() : false;
    }

    public Shell getDialogShell() {
        Shell shell = GDE.shell;
        try {
            shell = this.dialogShell != null && !this.dialogShell.isDisposed() ? this.dialogShell : shell;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return shell;
    }

    public boolean isClosePossible() {
        return this.isClosePossible;
    }

    public void setClosePossible(boolean enabled) {
        this.isClosePossible = enabled;
    }

    public int getShellAlpha() {
        return this.shellAlpha;
    }

    public void setShellAlpha(int newShellAlpha) {
        if (newShellAlpha > this.shellAlpha) {
            for (int i = this.shellAlpha; i < 254; i += 5) {
                this.dialogShell.setAlpha(i);
            }
            this.dialogShell.setAlpha(253);
            this.isFadeOut = true;
        } else {
            for (int i = 254; i > this.shellAlpha; i -= 5) {
                this.dialogShell.setAlpha(i);
            }
            this.dialogShell.setAlpha(this.shellAlpha);
            this.isFadeOut = false;
        }
    }

    public boolean isAlphaEnabled() {
        return this.isAlphaEnabled;
    }

    public boolean isFailedConnectionWarned() {
        return this.isFailedConnectionWarned;
    }

    public void setFailedConnectionWarned(boolean enabled) {
        this.isFailedConnectionWarned = enabled;
    }

    public void fadeOutAplhaBlending() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "this.isFadeOut = " + this.isFadeOut);
        }
        if (!this.isFadeOut && this.isAlphaEnabled) {
            this.setShellAlpha(254);
        }
    }

    public void fadeOutAplhaBlending(MouseEvent evt, Point outherBoundSize, int left, int right, int top, int bottom) {
        boolean isEnterShellEvt;
        boolean bl = isEnterShellEvt = evt.x < left || evt.x > outherBoundSize.x - right || evt.y < top || evt.y > outherBoundSize.y - bottom;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isEnterShellEvt = " + isEnterShellEvt + " size = " + String.valueOf(outherBoundSize));
        }
        if (!this.isFadeOut && isEnterShellEvt && this.isAlphaEnabled) {
            this.setShellAlpha(254);
        }
    }

    public void fadeInAlpaBlending(MouseEvent evt, Point outherBoundSize, int left, int right, int top, int bottom) {
        boolean isExitShellEvt;
        boolean bl = isExitShellEvt = evt.x < left || evt.x > outherBoundSize.x - right || evt.y < top || evt.y > outherBoundSize.y - bottom;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isExitShellEvt = " + isExitShellEvt + " size = " + String.valueOf(outherBoundSize));
        }
        if (this.isFadeOut && isExitShellEvt && this.isAlphaEnabled) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isExitShellEvt = " + isExitShellEvt + " size = " + String.valueOf(outherBoundSize));
            }
            this.setShellAlpha(this.getShellAlpha());
        }
    }

    public void fadeOutAplhaBlending(MouseEvent evt, Rectangle outherBound, int left, int right, int top, int bottom) {
        boolean isEnterShellEvt;
        boolean bl = isEnterShellEvt = evt.x < left || evt.x > outherBound.width - right || evt.y < top || evt.y > outherBound.height - bottom;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isEnterShellEvt = " + isEnterShellEvt + " size = " + outherBound.width + "," + outherBound.height);
        }
        if (!this.isFadeOut && isEnterShellEvt && this.isAlphaEnabled) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isEnterShellEvt = " + isEnterShellEvt + " size = " + outherBound.width + "," + outherBound.height);
            }
            this.setShellAlpha(254);
        }
    }

    public void fadeInAlpaBlending(MouseEvent evt, Rectangle outherBound, int left, int right, int top, int bottom) {
        boolean isExitShellEvt;
        boolean bl = isExitShellEvt = evt.x < left || evt.x > outherBound.width - right || evt.y < top || evt.y > outherBound.height - bottom;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "isExitShellEvt = " + isExitShellEvt + " size = " + outherBound.width + "," + outherBound.height);
        }
        if (this.isFadeOut && isExitShellEvt && this.isAlphaEnabled) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "isExitShellEvt = " + isExitShellEvt + " size = " + outherBound.width + "," + outherBound.height);
            }
            this.setShellAlpha(this.getShellAlpha());
        }
    }

    public void enableSaveButton(boolean enable) {
    }
}

