/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.guard;

import gde.Analyzer;
import gde.DataAccess;
import gde.config.Settings;
import gde.device.IDevice;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.histo.cache.VaultReaderWriter;
import gde.histo.device.IHistoDevice;
import gde.histo.exclusions.ExclusionData;
import gde.log.Level;
import gde.log.Logger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ObjectVaultIndex {
    private static final String $CLASS_NAME = ObjectVaultIndex.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static final String INDEX_FILENAME_DEVICEORIENTED = "_";
    private final ObjectVaultMap objectVaultMap;

    public static void rebuild(Analyzer analyzer) {
        List<String> cacheDirectoryNames = ObjectVaultIndex.defineCacheDirectoryNames(analyzer);
        Map<String, List<String>> objectKeyIndexMap = ObjectVaultIndex.readIndex(cacheDirectoryNames, analyzer);
        analyzer.getDataAccess().deleteFleetObjects();
        ObjectVaultMap.storeIndex(objectKeyIndexMap, analyzer.getDataAccess());
        log.off(() -> "Fleet directory      size=" + analyzer.getDataAccess().getFleetFileNames(s -> true).size());
    }

    private static List<String> defineCacheDirectoryNames(String deviceName, Analyzer analyzer) {
        ArrayList<String> cacheDirectoryNames = new ArrayList<String>();
        analyzer.setActiveDevice(deviceName);
        IDevice device = analyzer.getActiveDevice();
        ArrayList<String> validReaderSettings = new ArrayList<String>();
        validReaderSettings.add("");
        if (device instanceof IHistoDevice) {
            validReaderSettings.add(((IHistoDevice)((Object)device)).getReaderSettingsCsv());
        }
        for (String vaultReaderSettings : validReaderSettings) {
            for (int j = 1; j <= device.getChannelCount(); ++j) {
                String directoryName = ExtendedVault.getVaultDirectoryName(analyzer.getActiveDevice(), analyzer.getSettings(), j, vaultReaderSettings);
                cacheDirectoryNames.add(directoryName);
            }
        }
        log.off(() -> "Cache directory      size=" + cacheDirectoryNames.size() + " for device " + deviceName);
        return cacheDirectoryNames;
    }

    private static List<String> defineCacheDirectoryNames(Analyzer analyzer) {
        ArrayList<String> cacheDirectoryNames = new ArrayList<String>();
        Set<String> deviceNames = analyzer.getDeviceConfigurations().getAllConfigurations().keySet();
        for (String deviceName : deviceNames) {
            cacheDirectoryNames.addAll(ObjectVaultIndex.defineCacheDirectoryNames(deviceName, analyzer));
        }
        log.off(() -> "cache directories: " + cacheDirectoryNames.size() + "  from deviceNames: " + deviceNames.size());
        return cacheDirectoryNames;
    }

    private static Map<String, List<String>> readIndex(List<String> cacheDirectoryNames, Analyzer analyzer) {
        HashMap<String, List<String>> objectKeyMap = new HashMap<String, List<String>>();
        try {
            for (String directoryName : cacheDirectoryNames) {
                if (!analyzer.getDataAccess().existsCacheDirectory(directoryName)) continue;
                List<Map.Entry<String, String>> vaultIndices = new VaultReaderWriter(analyzer, Optional.empty()).readVaultsIndices(directoryName);
                for (Map.Entry<String, String> e : vaultIndices) {
                    String objectKey;
                    String string = objectKey = e.getKey().isEmpty() ? INDEX_FILENAME_DEVICEORIENTED : e.getKey();
                    if (objectKeyMap.get(objectKey) == null) {
                        objectKeyMap.put(objectKey, new ArrayList());
                    }
                    ((List)objectKeyMap.get(objectKey)).add(e.getValue());
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "read", e);
            return objectKeyMap;
        }
        log.off(() -> "objectKeys       selected=" + objectKeyMap.keySet().size() + "  " + new TreeSet(objectKeyMap.keySet()).toString());
        log.off(() -> "vaults           selected=" + objectKeyMap.values().parallelStream().mapToInt(l -> l.size()).sum());
        return objectKeyMap;
    }

    public ObjectVaultIndex(DataAccess dataAccess, Settings settings) {
        this.objectVaultMap = new ObjectVaultMap(dataAccess, settings);
        log.log(Level.INFO, "vault key index loaded");
    }

    public ObjectVaultIndex(String[] objectKeys, DataAccess dataAccess, Settings settings) {
        this.objectVaultMap = new ObjectVaultMap(objectKeys, dataAccess, settings);
        log.log(Level.INFO, "vault key index loaded for", objectKeys);
    }

    public Set<String> selectDeviceNames() {
        Set<ObjectVaultIndexEntry> vaultIndexes = this.objectVaultMap.getVaultIndexes(s -> true, DetailSelector.createDummyFilter());
        HashSet<String> deviceNames = new HashSet<String>();
        for (ObjectVaultIndexEntry idx : vaultIndexes) {
            deviceNames.add(idx.vaultDeviceName);
        }
        return deviceNames;
    }

    public Set<String> selectDeviceNames(String[] objectKeys, DetailSelector detailSelector) {
        Set<ObjectVaultIndexEntry> vaultIndexes = this.objectVaultMap.getVaultIndexes(objectKeys, detailSelector);
        HashSet<String> deviceNames = new HashSet<String>();
        for (ObjectVaultIndexEntry idx : vaultIndexes) {
            deviceNames.add(idx.vaultDeviceName);
        }
        return deviceNames;
    }

    public Set<VaultKeyPair> selectVaultKeys(DetailSelector detailSelector) {
        Function<String, Boolean> objectSelector = s -> true;
        HashSet<VaultKeyPair> result = new HashSet<VaultKeyPair>();
        for (ObjectVaultIndexEntry idx : this.objectVaultMap.getVaultIndexes(objectSelector, detailSelector)) {
            result.add(new VaultKeyPair(idx.vaultDirectory, idx.vaultName));
        }
        log.off(() -> "Selected      size=" + result.size());
        return result;
    }

    public Set<VaultKeyPair> selectVaultKeys(String[] objectKeys, DetailSelector detailSelector) {
        HashSet<VaultKeyPair> result = new HashSet<VaultKeyPair>();
        for (ObjectVaultIndexEntry idx : this.objectVaultMap.getVaultIndexes(objectKeys, detailSelector)) {
            result.add(new VaultKeyPair(idx.vaultDirectory, idx.vaultName));
        }
        log.off(() -> "Selected      size=" + result.size());
        return result;
    }

    public TreeMap<String, List<VaultKeyPair>> selectGroupedVaultKeys(String objectKey, DetailSelector detailSelector, Function<ObjectVaultIndexEntry, String> classifier) {
        TreeMap<String, List<VaultKeyPair>> result = new TreeMap<String, List<VaultKeyPair>>();
        Set<ObjectVaultIndexEntry> indexEntries = this.objectVaultMap.getVaultIndexes(new String[]{objectKey}, detailSelector);
        for (ObjectVaultIndexEntry idx : indexEntries) {
            String key = classifier.apply(idx);
            if (result.get(key) == null) {
                result.put(key, new ArrayList());
            }
            result.get(key).add(new VaultKeyPair(idx.vaultDirectory, idx.vaultName));
        }
        log.log(Level.INFO, "Size   ", result.size());
        return result;
    }

    public Set<String> selectObjectKeys(Function<String, Boolean> objectSelector) {
        return this.objectVaultMap.getObjectKeys().stream().filter(s -> (Boolean)objectSelector.apply((String)s)).collect(Collectors.toSet());
    }

    public Set<String> selectIndexedObjectKeys() {
        return this.objectVaultMap.getObjectKeys();
    }

    public boolean isEmpty() {
        return this.objectVaultMap.isEmpty();
    }

    static class ObjectVaultMap {
        private static final Logger log = Logger.getLogger(ObjectVaultMap.class.getName());
        private final DataAccess dataAccess;
        private final Settings settings;
        private final Map<String, List<String>> indexMap;

        public ObjectVaultMap(DataAccess dataAccess, Settings settings) {
            this.dataAccess = dataAccess;
            this.settings = settings;
            this.indexMap = this.loadIndex(s -> true);
        }

        public ObjectVaultMap(String[] objectKeys, DataAccess dataAccess, Settings settings) {
            this.dataAccess = dataAccess;
            this.settings = settings;
            List<String> keys = Arrays.asList(objectKeys);
            this.indexMap = this.loadIndex(s -> keys.contains(s));
        }

        public static void storeIndex(Map<String, List<String>> newIndexMap, DataAccess dataAccess) {
            newIndexMap.forEach((objectKey, list) -> {
                try (FileOutputStream outputStream = dataAccess.getFleetOutputStream(Paths.get(objectKey, new String[0]));
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
                    for (String str : list) {
                        writer.write(str + "\n");
                    }
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "write", e);
                }
            });
            log.off(() -> "objects: " + newIndexMap.keySet().toString());
            log.off(() -> "objects count: " + newIndexMap.size() + "  total vaults: " + newIndexMap.values().stream().mapToLong(l -> l.size()).sum());
        }

        private Map<String, List<String>> loadIndex(Function<String, Boolean> objectSelector) {
            HashMap<String, List<String>> objectIndexes = new HashMap<String, List<String>>();
            for (String fileName : this.dataAccess.getFleetFileNames(objectSelector)) {
                ArrayList<String> indexList = new ArrayList<String>();
                try (FileInputStream inputStream = this.dataAccess.getFleetInputStream(Paths.get(fileName, new String[0]));
                     BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty()) continue;
                        indexList.add(line);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "read", e);
                }
                String objectKey = fileName.equals(ObjectVaultIndex.INDEX_FILENAME_DEVICEORIENTED) ? "" : fileName;
                objectIndexes.put(objectKey, indexList);
            }
            log.off(() -> "objects: " + objectIndexes.keySet().toString());
            log.off(() -> "objects count: " + objectIndexes.size() + "  total vaults: " + objectIndexes.values().stream().mapToLong(l -> l.size()).sum());
            return objectIndexes;
        }

        public Set<String> getObjectKeys() {
            Set<String> objectStrings = this.indexMap.keySet();
            if (objectStrings.remove(ObjectVaultIndex.INDEX_FILENAME_DEVICEORIENTED)) {
                objectStrings.add("");
            }
            return objectStrings;
        }

        public Set<ObjectVaultIndexEntry> getVaultIndexes(String[] objectKeys, DetailSelector detailSelector) {
            if (objectKeys.length == 1) {
                return this.getVaultIndexes(objectKeys[0], detailSelector);
            }
            return this.getVaultIndexes((String s) -> Arrays.asList(objectKeys).contains(s), detailSelector);
        }

        public Set<ObjectVaultIndexEntry> getVaultIndexes(String objectKey, DetailSelector detailSelector) {
            HashSet<ObjectVaultIndexEntry> indices = new HashSet<ObjectVaultIndexEntry>();
            Path activeFolder = Paths.get(this.settings.getDataFilePath(), new String[0]).resolve(objectKey);
            ExclusionData exclusionData = new ExclusionData(activeFolder, this.dataAccess);
            boolean isSuppressMode = this.settings.isSuppressMode();
            for (Map.Entry<String, List<String>> e : this.indexMap.entrySet()) {
                if (!objectKey.equals(e.getKey())) continue;
                for (String indexCsv : e.getValue()) {
                    ObjectVaultIndexEntry idx = new ObjectVaultIndexEntry(e.getKey(), indexCsv);
                    if (!detailSelector.apply(idx).booleanValue() || isSuppressMode && exclusionData.isExcluded(idx.getLogFileName())) continue;
                    indices.add(idx);
                }
            }
            return indices;
        }

        public Set<ObjectVaultIndexEntry> getVaultIndexes(Function<String, Boolean> objectSelector, DetailSelector detailSelector) {
            Path dataFilePath = Paths.get(this.settings.getDataFilePath(), new String[0]);
            Function<ObjectVaultIndexEntry, Boolean> isExcludedSelector = idx -> {
                Path activeFolder = dataFilePath.resolve(idx.vaultObjectKey);
                ExclusionData exclusionData = new ExclusionData(activeFolder, this.dataAccess);
                return exclusionData.isExcluded(idx.getLogFileName());
            };
            HashSet<ObjectVaultIndexEntry> indices = new HashSet<ObjectVaultIndexEntry>();
            boolean isSuppressMode = this.settings.isSuppressMode();
            for (Map.Entry<String, List<String>> e : this.indexMap.entrySet()) {
                if (!objectSelector.apply(e.getKey()).booleanValue()) continue;
                for (String indexCsv : e.getValue()) {
                    ObjectVaultIndexEntry idx2 = new ObjectVaultIndexEntry(e.getKey(), indexCsv);
                    if (!detailSelector.apply(idx2).booleanValue() || isSuppressMode && isExcludedSelector.apply(idx2).booleanValue()) continue;
                    indices.add(idx2);
                }
            }
            return indices;
        }

        public boolean isEmpty() {
            return this.indexMap.isEmpty();
        }
    }

    static class DetailSelector
    implements Function<ObjectVaultIndexEntry, Boolean> {
        private final String filterText;
        private final Function<ObjectVaultIndexEntry, Boolean> filterFunction;

        @Override
        public Boolean apply(ObjectVaultIndexEntry t) {
            return this.filterFunction.apply(t);
        }

        static DetailSelector createDummyFilter() {
            return new DetailSelector("", t -> true);
        }

        static DetailSelector createDeviceNameFilter(Collection<String> deviceNames) {
            ArrayList<String> names = new ArrayList<String>(deviceNames);
            Collections.sort(names);
            return new DetailSelector("deviceName:" + names.toString(), t -> names.contains(t.vaultDeviceName));
        }

        static DetailSelector createFunctionFilter(Function<ObjectVaultIndexEntry, Boolean> function) {
            return new DetailSelector("function:" + function.toString(), function);
        }

        private DetailSelector(String filterText, Function<ObjectVaultIndexEntry, Boolean> filterFunction) {
            this.filterText = filterText;
            this.filterFunction = filterFunction;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.filterText == null ? 0 : this.filterText.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DetailSelector other = (DetailSelector)obj;
            return !(this.filterText == null ? other.filterText != null : !this.filterText.equals(other.filterText));
        }
    }

    static class ObjectVaultIndexEntry {
        private static final Logger log = Logger.getLogger(ObjectVaultIndexEntry.class.getName());
        String vaultObjectKey;
        String vaultName;
        String vaultDirectory;
        String vaultReaderSettingsCsv;
        long vaultCreatedMs;
        String vaultDataExplorerVersion;
        String vaultDeviceKey;
        String vaultDeviceName;
        int vaultChannelNumber;
        long vaultSamplingTimespanMs;
        long logFileLastModified;
        long logFileLength;
        int logRecordSetOrdinal;
        String logRecordsetBaseName;
        int logChannelNumber;
        long logStartTimestampMs;
        String logFilePath;

        static Function<HistoVault, ObjectVaultIndexEntry> objectKeyExtractor() {
            return v -> {
                ObjectVaultIndexEntry idx = new ObjectVaultIndexEntry();
                idx.vaultObjectKey = v.getVaultObjectKey();
                idx.vaultName = v.getVaultName();
                idx.vaultDirectory = v.getVaultDirectory();
                idx.vaultReaderSettingsCsv = v.getVaultReaderSettings();
                idx.vaultCreatedMs = v.getVaultCreated_ms();
                idx.vaultDataExplorerVersion = v.getVaultDataExplorerVersion();
                idx.vaultDeviceKey = v.getVaultDeviceKey();
                idx.vaultDeviceName = v.getVaultDeviceName();
                idx.vaultChannelNumber = v.getVaultChannelNumber();
                idx.vaultSamplingTimespanMs = v.getVaultSamplingTimespan_ms();
                idx.logFileLastModified = v.getLogFileLastModified();
                idx.logFileLength = v.getLogFileLength();
                idx.logRecordSetOrdinal = v.getLogRecordSetOrdinal();
                idx.logRecordsetBaseName = v.getLogRecordsetBaseName();
                idx.logChannelNumber = v.getLogChannelNumber();
                idx.logStartTimestampMs = v.getLogStartTimestamp_ms();
                idx.logFilePath = v.getLogFilePath();
                return idx;
            };
        }

        private ObjectVaultIndexEntry() {
        }

        public ObjectVaultIndexEntry(String fieldsCsv) {
            this(fieldsCsv.split(",", 2));
        }

        private ObjectVaultIndexEntry(String[] splitFields) {
            this(splitFields[0].replace("\"", ""), splitFields[1]);
        }

        public ObjectVaultIndexEntry(String objectKey, String attributesCsv) {
            this.vaultObjectKey = objectKey;
            log.log(Level.FINEST, attributesCsv);
            String[] values = attributesCsv.split(",");
            this.vaultName = values[0];
            this.vaultDirectory = values[1];
            this.vaultReaderSettingsCsv = values[2].replace('_', ',');
            this.vaultCreatedMs = Long.parseLong(values[3]);
            this.vaultDataExplorerVersion = values[4];
            this.vaultDeviceKey = values[5];
            this.vaultDeviceName = values[6];
            this.vaultChannelNumber = Integer.parseInt(values[7]);
            this.vaultSamplingTimespanMs = Long.parseLong(values[8]);
            this.logFileLastModified = Long.parseLong(values[9]);
            this.logFileLength = Long.parseLong(values[10]);
            this.logRecordSetOrdinal = Integer.parseInt(values[11]);
            this.logRecordsetBaseName = values[12];
            this.logChannelNumber = Integer.parseInt(values[13]);
            this.logStartTimestampMs = Long.parseLong(values[14]);
            this.logFilePath = values[15];
        }

        public String toString() {
            String d = ",";
            String readerSettings = this.vaultReaderSettingsCsv.replace(',', '_');
            return "\"" + this.vaultObjectKey + "\"" + d + this.vaultName + d + this.vaultDirectory + d + readerSettings + d + this.vaultCreatedMs + d + this.vaultDataExplorerVersion + d + this.vaultDeviceKey + d + this.vaultDeviceName + d + this.vaultChannelNumber + d + this.vaultSamplingTimespanMs + d + this.logFileLastModified + d + this.logFileLength + d + this.logRecordSetOrdinal + d + this.logRecordsetBaseName + d + this.logChannelNumber + d + this.logStartTimestampMs + d + this.logFilePath;
        }

        public String getLogFileName() {
            return Paths.get(this.logFilePath, new String[0]).getFileName().toString();
        }
    }

    public static class VaultKeyPair
    extends AbstractMap.SimpleImmutableEntry<String, String> {
        private static final long serialVersionUID = 8937538273315451095L;

        public VaultKeyPair(String directoryName, String vaultName) {
            super(directoryName, vaultName);
        }
    }
}

