/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.QRCode;

public final class MaskUtil {
    private MaskUtil() {
    }

    public static int applyMaskPenaltyRule1(ByteMatrix matrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(matrix, false);
    }

    public static int applyMaskPenaltyRule2(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height - 1; ++y2) {
            for (int x2 = 0; x2 < width - 1; ++x2) {
                byte value = array[y2][x2];
                if (value != array[y2][x2 + 1] || value != array[y2 + 1][x2] || value != array[y2 + 1][x2 + 1]) continue;
                penalty += 3;
            }
        }
        return penalty;
    }

    public static int applyMaskPenaltyRule3(ByteMatrix matrix) {
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                if (x2 + 6 < width && array[y2][x2] == 1 && array[y2][x2 + 1] == 0 && array[y2][x2 + 2] == 1 && array[y2][x2 + 3] == 1 && array[y2][x2 + 4] == 1 && array[y2][x2 + 5] == 0 && array[y2][x2 + 6] == 1 && (x2 + 10 < width && array[y2][x2 + 7] == 0 && array[y2][x2 + 8] == 0 && array[y2][x2 + 9] == 0 && array[y2][x2 + 10] == 0 || x2 - 4 >= 0 && array[y2][x2 - 1] == 0 && array[y2][x2 - 2] == 0 && array[y2][x2 - 3] == 0 && array[y2][x2 - 4] == 0)) {
                    penalty += 40;
                }
                if (y2 + 6 >= height || array[y2][x2] != 1 || array[y2 + 1][x2] != 0 || array[y2 + 2][x2] != 1 || array[y2 + 3][x2] != 1 || array[y2 + 4][x2] != 1 || array[y2 + 5][x2] != 0 || array[y2 + 6][x2] != 1 || (y2 + 10 >= height || array[y2 + 7][x2] != 0 || array[y2 + 8][x2] != 0 || array[y2 + 9][x2] != 0 || array[y2 + 10][x2] != 0) && (y2 - 4 < 0 || array[y2 - 1][x2] != 0 || array[y2 - 2][x2] != 0 || array[y2 - 3][x2] != 0 || array[y2 - 4][x2] != 0)) continue;
                penalty += 40;
            }
        }
        return penalty;
    }

    public static int applyMaskPenaltyRule4(ByteMatrix matrix) {
        int numDarkCells = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                if (array[y2][x2] != 1) continue;
                ++numDarkCells;
            }
        }
        int numTotalCells = matrix.getHeight() * matrix.getWidth();
        double darkRatio = (double)numDarkCells / (double)numTotalCells;
        return Math.abs((int)(darkRatio * 100.0 - 50.0)) / 5 * 10;
    }

    public static boolean getDataMaskBit(int maskPattern, int x2, int y2) {
        int intermediate;
        if (!QRCode.isValidMaskPattern(maskPattern)) {
            throw new IllegalArgumentException("Invalid mask pattern");
        }
        switch (maskPattern) {
            case 0: {
                intermediate = y2 + x2 & 1;
                break;
            }
            case 1: {
                intermediate = y2 & 1;
                break;
            }
            case 2: {
                intermediate = x2 % 3;
                break;
            }
            case 3: {
                intermediate = (y2 + x2) % 3;
                break;
            }
            case 4: {
                intermediate = (y2 >>> 1) + x2 / 3 & 1;
                break;
            }
            case 5: {
                int temp = y2 * x2;
                intermediate = (temp & 1) + temp % 3;
                break;
            }
            case 6: {
                int temp = y2 * x2;
                intermediate = (temp & 1) + temp % 3 & 1;
                break;
            }
            case 7: {
                int temp = y2 * x2;
                intermediate = temp % 3 + (y2 + x2 & 1) & 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + maskPattern);
            }
        }
        return intermediate == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
        int penalty = 0;
        int numSameBitCells = 0;
        byte prevBit = -1;
        int iLimit = isHorizontal ? matrix.getHeight() : matrix.getWidth();
        int jLimit = isHorizontal ? matrix.getWidth() : matrix.getHeight();
        byte[][] array = matrix.getArray();
        for (int i2 = 0; i2 < iLimit; ++i2) {
            for (int j2 = 0; j2 < jLimit; ++j2) {
                byte bit;
                byte by = bit = isHorizontal ? array[i2][j2] : array[j2][i2];
                if (bit == prevBit) {
                    if (++numSameBitCells == 5) {
                        penalty += 3;
                        continue;
                    }
                    if (numSameBitCells <= 5) continue;
                    ++penalty;
                    continue;
                }
                numSameBitCells = 1;
                prevBit = bit;
            }
            numSameBitCells = 0;
        }
        return penalty;
    }
}

