/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private final SortedMap<Comparable<?>, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator<?> comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuilder outBuffer = new StringBuilder();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable<?> value : this.freqTable.keySet()) {
            outBuffer.append(value);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    public void addValue(Comparable<?> v2) throws MathIllegalArgumentException {
        this.incrementValue(v2, 1L);
    }

    public void addValue(int v2) throws MathIllegalArgumentException {
        this.addValue(Long.valueOf(v2));
    }

    public void addValue(long v2) throws MathIllegalArgumentException {
        this.addValue(Long.valueOf(v2));
    }

    public void addValue(char v2) throws MathIllegalArgumentException {
        this.addValue(Character.valueOf(v2));
    }

    public void incrementValue(Comparable<?> v2, long increment) throws MathIllegalArgumentException {
        Long obj = v2;
        if (v2 instanceof Integer) {
            obj = ((Integer)((Object)v2)).longValue();
        }
        try {
            Long count = (Long)this.freqTable.get(obj);
            if (count == null) {
                this.freqTable.put(obj, increment);
            } else {
                this.freqTable.put(obj, count + increment);
            }
        }
        catch (ClassCastException ex) {
            throw new MathIllegalArgumentException(LocalizedFormats.INSTANCES_NOT_COMPARABLE_TO_EXISTING_VALUES, v2.getClass().getName());
        }
    }

    public void incrementValue(int v2, long increment) throws MathIllegalArgumentException {
        this.incrementValue(Long.valueOf(v2), increment);
    }

    public void incrementValue(long v2, long increment) throws MathIllegalArgumentException {
        this.incrementValue(Long.valueOf(v2), increment);
    }

    public void incrementValue(char v2, long increment) throws MathIllegalArgumentException {
        this.incrementValue(Character.valueOf(v2), increment);
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<Comparable<?>> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public Iterator<Map.Entry<Comparable<?>, Long>> entrySetIterator() {
        return this.freqTable.entrySet().iterator();
    }

    public long getSumFreq() {
        long result2 = 0L;
        Iterator<Long> iterator2 = this.freqTable.values().iterator();
        while (iterator2.hasNext()) {
            result2 += iterator2.next().longValue();
        }
        return result2;
    }

    public long getCount(Comparable<?> v2) {
        if (v2 instanceof Integer) {
            return this.getCount(((Integer)v2).longValue());
        }
        long result2 = 0L;
        try {
            Long count = (Long)this.freqTable.get(v2);
            if (count != null) {
                result2 = count;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return result2;
    }

    public long getCount(int v2) {
        return this.getCount(Long.valueOf(v2));
    }

    public long getCount(long v2) {
        return this.getCount(Long.valueOf(v2));
    }

    public long getCount(char v2) {
        return this.getCount(Character.valueOf(v2));
    }

    public int getUniqueCount() {
        return this.freqTable.keySet().size();
    }

    public double getPct(Comparable<?> v2) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v2) / (double)sumFreq;
    }

    public double getPct(int v2) {
        return this.getPct(Long.valueOf(v2));
    }

    public double getPct(long v2) {
        return this.getPct(Long.valueOf(v2));
    }

    public double getPct(char v2) {
        return this.getPct(Character.valueOf(v2));
    }

    public long getCumFreq(Comparable<?> v2) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (v2 instanceof Integer) {
            return this.getCumFreq(((Integer)v2).longValue());
        }
        Comparator<Comparable<?>> c2 = this.freqTable.comparator();
        if (c2 == null) {
            c2 = new NaturalComparator();
        }
        long result2 = 0L;
        try {
            Long value = (Long)this.freqTable.get(v2);
            if (value != null) {
                result2 = value;
            }
        }
        catch (ClassCastException ex) {
            return result2;
        }
        if (c2.compare(v2, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c2.compare(v2, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator<Comparable<?>> values2 = this.valuesIterator();
        while (values2.hasNext()) {
            Comparable<?> nextValue = values2.next();
            if (c2.compare(v2, nextValue) > 0) {
                result2 += this.getCount(nextValue);
                continue;
            }
            return result2;
        }
        return result2;
    }

    public long getCumFreq(int v2) {
        return this.getCumFreq(Long.valueOf(v2));
    }

    public long getCumFreq(long v2) {
        return this.getCumFreq(Long.valueOf(v2));
    }

    public long getCumFreq(char v2) {
        return this.getCumFreq(Character.valueOf(v2));
    }

    public double getCumPct(Comparable<?> v2) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v2) / (double)sumFreq;
    }

    public double getCumPct(int v2) {
        return this.getCumPct(Long.valueOf(v2));
    }

    public double getCumPct(long v2) {
        return this.getCumPct(Long.valueOf(v2));
    }

    public double getCumPct(char v2) {
        return this.getCumPct(Character.valueOf(v2));
    }

    public List<Comparable<?>> getMode() {
        long mostPopular = 0L;
        for (Long l2 : this.freqTable.values()) {
            long frequency = l2;
            if (frequency <= mostPopular) continue;
            mostPopular = frequency;
        }
        ArrayList modeList = new ArrayList();
        for (Map.Entry<Comparable<?>, Long> ent : this.freqTable.entrySet()) {
            long frequency = ent.getValue();
            if (frequency != mostPopular) continue;
            modeList.add(ent.getKey());
        }
        return modeList;
    }

    public void merge(Frequency other) throws NullArgumentException {
        MathUtils.checkNotNull(other, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        Iterator<Map.Entry<Comparable<?>, Long>> iter = other.entrySetIterator();
        while (iter.hasNext()) {
            Map.Entry<Comparable<?>, Long> entry = iter.next();
            this.incrementValue(entry.getKey(), (long)entry.getValue());
        }
    }

    public void merge(Collection<Frequency> others) throws NullArgumentException {
        MathUtils.checkNotNull(others, LocalizedFormats.NULL_NOT_ALLOWED, new Object[0]);
        for (Frequency freq : others) {
            this.merge(freq);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return !(this.freqTable == null ? other.freqTable != null : !this.freqTable.equals(other.freqTable));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NaturalComparator<T extends Comparable<T>>
    implements Comparator<Comparable<T>>,
    Serializable {
        private static final long serialVersionUID = -3852193713161395148L;

        private NaturalComparator() {
        }

        @Override
        public int compare(Comparable<T> o1, Comparable<T> o2) {
            return o1.compareTo(o2);
        }
    }
}

