/*
 * Decompiled with CFR 0.152.
 */
package gde.device.graupner;

import gde.GDE;
import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DataTypes;
import gde.device.DeviceConfiguration;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementPropertyTypes;
import gde.device.graupner.MemoryType;
import gde.device.graupner.ObjectFactory;
import gde.device.graupner.StepChargeComposite;
import gde.device.graupner.UltraDuoPlusSychronizer;
import gde.device.graupner.UltraDuoPlusType;
import gde.device.graupner.Ultramat;
import gde.device.graupner.UltramatSerialPort;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.log.LogFormatter;
import gde.messages.Messages;
import gde.ui.ParameterConfigControl;
import gde.ui.SWTResourceManager;
import gde.ui.tab.GraphicsWindow;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import gde.utils.WaitTimer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class UltraDuoPlusDialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(UltraDuoPlusDialog.class.getName());
    static final String DEVICE_JAR_NAME = "UltramatUDP";
    static final String STRING_FORMAT_02D = "%02d";
    static final String STRING_FORMAT_02d_s = "%02d - %s";
    static final String STRING_16_BLANK = "                ";
    static final String ULTRA_DUO_PLUS_XSD = "UltraDuoPlus_V02.xsd";
    static final String UDP_CONFIGURATION_SUFFIX = "/UltraDuoPlus_";
    Text userNameText;
    Group baseDeviceSetupGroup;
    Group baseDeviceSetupGroup1;
    Group baseDeviceSetupGroup2;
    CLabel userLabel;
    Button restoreButton;
    Button backupButton;
    Button closeButton;
    Button helpButton;
    Button copyButton;
    CTabFolder mainTabFolder;
    CTabFolder chargeTypeTabFolder;
    CTabItem setupTabItem;
    CTabItem memorySetupTabItem;
    CTabItem chargeTabItem;
    CTabItem dischargeTabItem;
    CTabItem stepChargeTabItem;
    CTabItem memoryCycleDataTabItem;
    ScrolledComposite scrolledchargeComposite;
    Composite boundsComposite;
    Composite deviceComposite;
    Composite dischargeCycleComposite;
    StepChargeComposite stepChargeComposite;
    Group chargeGroup;
    Group dischargeGroup;
    Group cycleGroup;
    Composite memoryBoundsComposite;
    Composite memorySelectComposite;
    Composite memoryDataComposite;
    Composite memoryDataSelectComposite;
    Composite channelSelectComposite;
    CLabel memorySelectLabel;
    CLabel memoryDataSelectLabel;
    CLabel channelSelectLabel;
    CCombo memoryCombo;
    CCombo memoryDataCombo;
    CCombo channelCombo;
    ProgressBar cycleDataProgressBar;
    ProgressBar graphicsDataProgressBar;
    Table dataTable;
    final Ultramat device;
    final UltramatSerialPort serialPort;
    final Channels channels;
    final Settings settings;
    final Listener memoryParameterChangeListener;
    static final String[] cellTypeNames = Messages.getString((String)"GDE_MSGT2246").split(",");
    static final String[] soundTime = new String[]{Messages.getString((String)"GDE_MSGT2241"), "5sec", "15sec", "1min", Messages.getString((String)"GDE_MSGT2240")};
    static final String[] powerOnDisplayType = new String[]{Messages.getString((String)"GDE_MSGT2244"), Messages.getString((String)"GDE_MSGT2245")};
    static final String[] cycleDirectionTypes = Messages.getString((String)"GDE_MSGT2292").split(", ");
    static final String[] offOnType = new String[]{Messages.getString((String)"GDE_MSGT2241"), Messages.getString((String)"GDE_MSGT2240")};
    static final String[] onOffType = new String[]{Messages.getString((String)"GDE_MSGT2240"), Messages.getString((String)"GDE_MSGT2241")};
    static final String[] temperatureDegreeType = new String[]{"\u00b0C", "\u00b0F"};
    static final String[] languageTypes = new String[]{"En", "De", "Fr", "It"};
    static final String[] diableEnableType = new String[]{Messages.getString((String)"GDE_MSGT2243"), Messages.getString((String)"GDE_MSGT2242")};
    static final String[] hourFormatType = new String[]{"12H", "24H"};
    Schema schema;
    JAXBContext jc;
    UltraDuoPlusType ultraDuoPlusSetup;
    UltraDuoPlusSychronizer synchronizerRead;
    UltraDuoPlusSychronizer synchronizerWrite;
    String deviceIdentifierName = "NEW USER NAME";
    int[] channelValues1 = new int[UltramatSerialPort.SIZE_CHANNEL_1_SETUP];
    int[] channelValues2 = new int[4];
    ParameterConfigControl[] channelParameters = new ParameterConfigControl[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + 4];
    static int numberMemories = 40;
    String[] memoryNames = new String[numberMemories];
    int[] memoryValues = new int[UltramatSerialPort.SIZE_MEMORY_SETUP];
    int[] memoryStepValues = new int[20];
    ParameterConfigControl[] memoryParameters = new ParameterConfigControl[UltramatSerialPort.SIZE_MEMORY_SETUP];
    int lastMemorySelectionIndex = -1;
    int lastCellSelectionIndex = -1;
    int memorySelectionIndexData = 1;
    int channelSelectionIndex = 1;
    String[] channelNumbers = new String[]{"1", "2"};
    int parameterSelectHeight = 30;
    int chargeSelectHeight = 11 * this.parameterSelectHeight;
    int dischargeSelectHeight = 5 * this.parameterSelectHeight;
    int cycleSelectHeight = 4 * this.parameterSelectHeight;
    byte[] initialAnswerData = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ConsoleHandler ch = new ConsoleHandler();
        LogFormatter lf = new LogFormatter();
        ch.setFormatter((Formatter)lf);
        ch.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(ch);
        Logger.getLogger("").setLevel(Level.TIME);
        Settings.getInstance();
        String basePath = Settings.getApplHomePath();
        UltramatSerialPort serialPort = null;
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(UltraDuoPlusDialog.class.getClassLoader().getResourceAsStream("resource/UltraDuoPlus_V02.xsd")));
            JAXBContext jc = JAXBContext.newInstance((String)"gde.device.graupner");
            UltraDuoPlusType ultraDuoPlusSetup = new ObjectFactory().createUltraDuoPlusType();
            String deviceIdentifierName = "";
            log.log(Level.TIME, "XSD init time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            serialPort = new UltramatSerialPort(new DeviceConfiguration(basePath + "/Devices/UltraDuoPlus60.xml"));
            if (!serialPort.isConnected()) {
                try {
                    long time = new Date().getTime();
                    serialPort.open();
                    serialPort.write(UltramatSerialPort.RESET_CONFIG);
                    deviceIdentifierName = serialPort.readDeviceUserName();
                    try {
                        Unmarshaller unmarshaller = jc.createUnmarshaller();
                        unmarshaller.setSchema(schema);
                        ultraDuoPlusSetup = (UltraDuoPlusType)unmarshaller.unmarshal(new File(basePath + UDP_CONFIGURATION_SUFFIX + deviceIdentifierName.replace(' ', '_') + ".xml"));
                        log.log(Level.TIME, "read memory setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - time)));
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), e);
                        if (e.getCause() instanceof FileNotFoundException) {
                            ultraDuoPlusSetup = new ObjectFactory().createUltraDuoPlusType();
                            List<MemoryType> cellMemories = ultraDuoPlusSetup.getMemory();
                            if (cellMemories.size() < numberMemories) {
                                for (int i = 0; i < numberMemories; ++i) {
                                    MemoryType cellMemory = new ObjectFactory().createMemoryType();
                                    cellMemory.setSetupData(new ObjectFactory().createMemoryTypeSetupData());
                                    cellMemories.add(cellMemory);
                                }
                            }
                        }
                        throw e;
                    }
                    ultraDuoPlusSetup.setIdentifierName(deviceIdentifierName);
                    UltraDuoPlusSychronizer readSynchronizer = new UltraDuoPlusSychronizer(null, serialPort, ultraDuoPlusSetup, UltraDuoPlusSychronizer.SYNC_TYPE.READ);
                    readSynchronizer.start();
                    readSynchronizer.join();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    return;
                }
                finally {
                    if (serialPort.isConnected()) {
                        serialPort.write(UltramatSerialPort.RESET);
                        serialPort.close();
                    }
                }
            }
            if (ultraDuoPlusSetup != null) {
                ultraDuoPlusSetup.getChannelData1().synced = null;
                ultraDuoPlusSetup.getChannelData2().synced = null;
                for (MemoryType cellMemory : ultraDuoPlusSetup.getMemory()) {
                    cellMemory.synced = null;
                    cellMemory.getSetupData().synced = null;
                    if (cellMemory.getStepChargeData() != null) {
                        cellMemory.getStepChargeData().synced = null;
                    }
                    if (cellMemory.getTraceData() != null) {
                        cellMemory.getTraceData().synced = null;
                    }
                    if (cellMemory.getCycleData() == null) continue;
                    cellMemory.getCycleData().synced = null;
                }
                Iterator<UltraDuoPlusType.TireHeaterData> tireIterator = ultraDuoPlusSetup.getTireHeaterData().iterator();
                while (tireIterator.hasNext()) {
                    tireIterator.next().synced = null;
                }
                Iterator<UltraDuoPlusType.MotorRunData> motorIterator = ultraDuoPlusSetup.getMotorRunData().iterator();
                while (motorIterator.hasNext()) {
                    motorIterator.next().synced = null;
                }
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)ULTRA_DUO_PLUS_XSD);
                marshaller.marshal((Object)ultraDuoPlusSetup, (OutputStream)new FileOutputStream(basePath + UDP_CONFIGURATION_SUFFIX + deviceIdentifierName.replace(' ', '_') + ".xml"));
                log.log(Level.TIME, "write memory setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - GDE.StartTime)));
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    public UltraDuoPlusDialog(Shell parent, Ultramat useDevice) {
        super(parent);
        this.serialPort = useDevice.getCommunicationPort();
        this.device = useDevice;
        this.channels = Channels.getInstance();
        this.settings = Settings.getInstance();
        switch (this.device.getDeviceTypeIdentifier()) {
            case UltraDuoPlus40: {
                numberMemories = 40;
                this.channelNumbers = new String[]{"1"};
                break;
            }
            case UltraDuoPlus45: {
                numberMemories = 45;
                this.channelNumbers = new String[]{"1"};
                break;
            }
            case UltraDuoPlus50: {
                numberMemories = 50;
                this.channelNumbers = new String[]{"1", "2"};
                break;
            }
            case UltraDuoPlus60: {
                numberMemories = 60;
                this.channelNumbers = new String[]{"1", "2"};
                break;
            }
        }
        this.memoryNames = new String[numberMemories];
        this.memoryNames[1] = " initial ";
        this.memoryParameterChangeListener = new Listener(){

            public void handleEvent(Event evt) {
                if (UltraDuoPlusDialog.this.lastMemorySelectionIndex >= 0 && UltraDuoPlusDialog.this.lastMemorySelectionIndex < numberMemories) {
                    if (UltraDuoPlusDialog.this.ultraDuoPlusSetup != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, "memoryComposite.handleEvent, (" + UltraDuoPlusDialog.this.lastMemorySelectionIndex + ")" + UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getName() + " memoryValues[" + evt.index + "] changed");
                        }
                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().setChanged(true);
                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.memoryValues));
                        switch (UltraDuoPlusDialog.this.device.getDeviceTypeIdentifier()) {
                            case UltraDuoPlus50: 
                            case UltraDuoPlus60: {
                                if (UltraDuoPlusDialog.this.memoryValues[0] == 1) {
                                    UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().setChanged(true);
                                    UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.memoryStepValues));
                                    break;
                                }
                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().setChanged(false);
                                break;
                            }
                        }
                    }
                    if (evt.index == 0) {
                        UltraDuoPlusDialog.this.updateBatteryMemoryParameter(UltraDuoPlusDialog.this.memoryValues[0]);
                        UltraDuoPlusDialog.this.updateBatteryParameterValues(0);
                    } else if (evt.index == 1 && UltraDuoPlusDialog.this.memoryValues[0] == 5) {
                        UltraDuoPlusDialog.this.memoryValues[1] = UltraDuoPlusDialog.this.memoryValues[1] > 6 && UltraDuoPlusDialog.this.memoryValues[1] <= 9 ? 6 : (UltraDuoPlusDialog.this.memoryValues[1] > 9 ? 12 : UltraDuoPlusDialog.this.memoryValues[1]);
                        UltraDuoPlusDialog.this.memoryParameters[1].setSliderSelection(UltraDuoPlusDialog.this.memoryValues[1]);
                    } else if (evt.index == 2) {
                        UltraDuoPlusDialog.this.updateBatteryParameterValues(2);
                    } else if (evt.index == 6) {
                        UltraDuoPlusDialog.this.updateBatteryParameterValues(6);
                    }
                    if (UltraDuoPlusDialog.this.ultraDuoPlusSetup != null && log.isLoggable(Level.FINE)) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
                            sb.append(UltraDuoPlusDialog.this.memoryValues[i]).append("[").append(i).append("], ");
                        }
                        log.log(Level.FINE, sb.toString());
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void open() {
        block53: {
            long openStartTime = new Date().getTime();
            try {
                Object object;
                block58: {
                    block56: {
                        block57: {
                            block55: {
                                block52: {
                                    this.application.setCursor(SWTResourceManager.getCursor((int)1));
                                    if (this.serialPort == null || this.serialPort.isConnected()) break block55;
                                    try {
                                        this.serialPort.open();
                                        this.serialPort.write(UltramatSerialPort.RESET);
                                        this.initialAnswerData = this.serialPort.getData(true);
                                        if (this.device.isProcessing(1, this.initialAnswerData) || this.device.isProcessing(2, this.initialAnswerData)) {
                                            this.application.openMessageDialogAsync(null, Messages.getString((String)"GDE_MSGW2201"));
                                            return;
                                        }
                                    }
                                    catch (Exception e) {
                                        log.log(Level.SEVERE, e.getMessage(), e);
                                        this.serialPort.close();
                                        this.application.openMessageDialog(null, Messages.getString((String)"GDE_MSGE0015", (Object[])new Object[]{e.getClass().getSimpleName() + " : " + e.getMessage()}));
                                        this.application.getDeviceSelectionDialog().open();
                                        if (!this.application.getActiveDevice().equals((Object)this.device)) {
                                            if (GDE.shell.isDisposed()) return;
                                            this.application.setCursor(SWTResourceManager.getCursor((int)0));
                                            this.application.resetShellIcon();
                                            if (this.serialPort == null) return;
                                            if (!this.serialPort.isConnected()) return;
                                            try {
                                                this.serialPort.write(UltramatSerialPort.RESET);
                                                return;
                                            }
                                            catch (IOException iOException) {
                                                return;
                                            }
                                            finally {
                                                this.serialPort.close();
                                            }
                                        }
                                        break block52;
                                    }
                                    {
                                        this.serialPort.write(UltramatSerialPort.RESET_CONFIG);
                                        this.deviceIdentifierName = this.serialPort.readDeviceUserName();
                                        this.jc = JAXBContext.newInstance((String)"gde.device.graupner");
                                        this.schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(UltraDuoPlusDialog.class.getClassLoader().getResourceAsStream("resource/UltraDuoPlus_V02.xsd")));
                                        try {
                                            Unmarshaller unmarshaller = this.jc.createUnmarshaller();
                                            unmarshaller.setSchema(this.schema);
                                            this.ultraDuoPlusSetup = (UltraDuoPlusType)unmarshaller.unmarshal(new File(Settings.getApplHomePath() + UDP_CONFIGURATION_SUFFIX + this.deviceIdentifierName.replace(' ', '_') + ".xml"));
                                        }
                                        catch (UnmarshalException e) {
                                            log.log(Level.SEVERE, e.getMessage(), e);
                                            this.createUltraDuoPlusSetup(this.deviceIdentifierName);
                                        }
                                        catch (Exception e) {
                                            if (!(e.getCause() instanceof FileNotFoundException)) {
                                                if (!(e instanceof IllegalArgumentException)) throw e;
                                            }
                                            this.createUltraDuoPlusSetup(this.deviceIdentifierName);
                                        }
                                        this.synchronizerRead = new UltraDuoPlusSychronizer(this, this.serialPort, this.ultraDuoPlusSetup, UltraDuoPlusSychronizer.SYNC_TYPE.READ);
                                        this.synchronizerRead.start();
                                    }
                                }
                                if (this.dialogShell != null) break block56;
                                break block57;
                            }
                            log.log(Level.SEVERE, "serial port == null");
                            break block53;
                        }
                        object = "null";
                        break block58;
                    }
                    object = this.dialogShell.isDisposed();
                }
                log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(object));
                if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                    this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                    SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                    this.dialogShell.setLayout((Layout)new FormLayout());
                    this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                    this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                    this.dialogShell.layout();
                    this.dialogShell.pack();
                    this.dialogShell.setSize(665, GDE.IS_MAC || GDE.IS_OS_ARCH_ARM ? 690 : 675);
                    this.dialogShell.addListener(31, new Listener(){

                        public void handleEvent(Event event) {
                            switch (event.detail) {
                                case 2: {
                                    UltraDuoPlusDialog.this.dialogShell.close();
                                    event.detail = 0;
                                    event.doit = false;
                                }
                            }
                        }
                    });
                    this.dialogShell.addHelpListener(new HelpListener(){

                        public void helpRequested(HelpEvent evt) {
                            log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.application.openHelpDialog(UltraDuoPlusDialog.DEVICE_JAR_NAME, "HelpInfo.html");
                        }
                    });
                    this.dialogShell.addDisposeListener(new DisposeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void widgetDisposed(DisposeEvent evt) {
                            log.finest(() -> "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                            if (UltraDuoPlusDialog.this.serialPort != null && UltraDuoPlusDialog.this.serialPort.isConnected()) {
                                try {
                                    UltraDuoPlusDialog.this.synchronizerRead.join();
                                    try {
                                        String[] date = StringHelper.getDateAndTime((String)"yy:MM:dd:hh:mm").split(":");
                                        switch (UltraDuoPlusDialog.this.device.getDeviceTypeIdentifier()) {
                                            case UltraDuoPlus40: 
                                            case UltraDuoPlus45: {
                                                UltraDuoPlusDialog.this.channelValues1[13] = Integer.parseInt(date[2]);
                                                UltraDuoPlusDialog.this.channelValues1[14] = Integer.parseInt(date[1]);
                                                UltraDuoPlusDialog.this.channelValues1[15] = Integer.parseInt(date[0]);
                                                UltraDuoPlusDialog.this.channelValues1[16] = Integer.parseInt(date[3]);
                                                UltraDuoPlusDialog.this.channelValues1[17] = Integer.parseInt(date[4]);
                                                break;
                                            }
                                            case UltraDuoPlus50: {
                                                UltraDuoPlusDialog.this.channelValues1[10] = Integer.parseInt(date[2]);
                                                UltraDuoPlusDialog.this.channelValues1[11] = Integer.parseInt(date[1]);
                                                UltraDuoPlusDialog.this.channelValues1[12] = Integer.parseInt(date[0]);
                                                UltraDuoPlusDialog.this.channelValues1[13] = Integer.parseInt(date[3]);
                                                UltraDuoPlusDialog.this.channelValues1[14] = Integer.parseInt(date[4]);
                                                break;
                                            }
                                            case UltraDuoPlus60: {
                                                UltraDuoPlusDialog.this.channelValues1[10] = Integer.parseInt(date[2]);
                                                UltraDuoPlusDialog.this.channelValues1[11] = Integer.parseInt(date[1]);
                                                UltraDuoPlusDialog.this.channelValues1[12] = Integer.parseInt(date[0]);
                                                UltraDuoPlusDialog.this.channelValues1[13] = Integer.parseInt(date[3]);
                                                UltraDuoPlusDialog.this.channelValues1[14] = Integer.parseInt(date[4]);
                                                break;
                                            }
                                        }
                                        UltraDuoPlusType.ChannelData1 value = new UltraDuoPlusType.ChannelData1();
                                        value.setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.channelValues1));
                                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.setChannelData1(value, value.getValue().endsWith("1"));
                                        UltraDuoPlusDialog.this.synchronizerWrite = new UltraDuoPlusSychronizer(UltraDuoPlusDialog.this, UltraDuoPlusDialog.this.serialPort, UltraDuoPlusDialog.this.ultraDuoPlusSetup, UltraDuoPlusSychronizer.SYNC_TYPE.WRITE);
                                        UltraDuoPlusDialog.this.synchronizerWrite.start();
                                        UltraDuoPlusDialog.this.synchronizerWrite.join();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    UltraDuoPlusDialog.this.saveConfigUDP(Settings.getApplHomePath() + UltraDuoPlusDialog.UDP_CONFIGURATION_SUFFIX + UltraDuoPlusDialog.this.deviceIdentifierName.replace(' ', '_') + ".xml");
                                    UltraDuoPlusDialog.this.serialPort.write(UltramatSerialPort.RESET);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                                finally {
                                    UltraDuoPlusDialog.this.serialPort.close();
                                    UltraDuoPlusDialog.this.application.resetShellIcon();
                                }
                            }
                        }
                    });
                    this.boundsComposite = new Composite((Composite)this.dialogShell, 0);
                    FormData boundsCompositeLData = new FormData();
                    boundsCompositeLData.left = new FormAttachment(0, 1000, 0);
                    boundsCompositeLData.right = new FormAttachment(1000, 1000, 0);
                    boundsCompositeLData.top = new FormAttachment(0, 1000, 0);
                    boundsCompositeLData.bottom = new FormAttachment(1000, 1000, 0);
                    this.boundsComposite.setLayoutData((Object)boundsCompositeLData);
                    this.boundsComposite.setLayout((Layout)new FormLayout());
                    this.userLabel = new CLabel(this.boundsComposite, 131072);
                    this.userLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.userLabel.setText(Messages.getString((String)"GDE_MSGT2289"));
                    FormData userLabelLData = new FormData();
                    userLabelLData.left = new FormAttachment(0, 1000, 12);
                    userLabelLData.top = new FormAttachment(0, 1000, 7);
                    userLabelLData.width = 280;
                    userLabelLData.height = 20;
                    this.userLabel.setLayoutData((Object)userLabelLData);
                    this.userNameText = new Text(this.boundsComposite, 2052);
                    this.userNameText.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.userNameText.setText(this.deviceIdentifierName);
                    this.userNameText.setTextLimit(16);
                    FormData userNameTextLData = new FormData();
                    userNameTextLData.width = 120;
                    userNameTextLData.height = 16;
                    userNameTextLData.left = new FormAttachment(0, 1000, 305);
                    userNameTextLData.top = new FormAttachment(0, 1000, 7);
                    this.userNameText.setLayoutData((Object)userNameTextLData);
                    this.userNameText.addVerifyListener(new VerifyListener(this){

                        public void verifyText(VerifyEvent evt) {
                            log.finest(() -> "evt.doit = " + (evt.text.length() <= 16));
                            evt.doit = evt.text.length() <= 16;
                        }
                    });
                    this.userNameText.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent evt) {
                            log.finest(() -> "text.keyReleased, event=" + String.valueOf(evt));
                            File oldConfigDataFile = new File(Settings.getApplHomePath() + UltraDuoPlusDialog.UDP_CONFIGURATION_SUFFIX + UltraDuoPlusDialog.this.deviceIdentifierName.replace(' ', '_') + ".xml");
                            if (oldConfigDataFile.exists() && !oldConfigDataFile.delete()) {
                                log.log(Level.WARNING, "could not delete " + oldConfigDataFile.getName());
                            }
                            UltraDuoPlusDialog.this.deviceIdentifierName = (UltraDuoPlusDialog.this.userNameText.getText().trim() + UltraDuoPlusDialog.STRING_16_BLANK).substring(0, 16);
                            UltraDuoPlusDialog.this.ultraDuoPlusSetup.setIdentifierName(UltraDuoPlusDialog.this.deviceIdentifierName);
                            UltraDuoPlusDialog.this.ultraDuoPlusSetup.setChanged(true);
                            int position = UltraDuoPlusDialog.this.userNameText.getCaretPosition();
                            UltraDuoPlusDialog.this.userNameText.setText(UltraDuoPlusDialog.this.deviceIdentifierName.trim());
                            UltraDuoPlusDialog.this.userNameText.setSelection(position);
                        }

                        public void keyPressed(KeyEvent evt) {
                            log.finest(() -> "text.keyPressed, event=" + String.valueOf(evt));
                        }
                    });
                    this.mainTabFolder = new CTabFolder(this.boundsComposite, 2048);
                    this.mainTabFolder.setSimple(false);
                    FormData TabFolderLData = new FormData();
                    TabFolderLData.left = new FormAttachment(0, 1000, 0);
                    TabFolderLData.right = new FormAttachment(1000, 1000, 0);
                    TabFolderLData.top = new FormAttachment(0, 1000, 35);
                    TabFolderLData.bottom = new FormAttachment(1000, 1000, -45);
                    this.mainTabFolder.setLayoutData((Object)TabFolderLData);
                    this.setupTabItem = new CTabItem(this.mainTabFolder, 2048);
                    this.setupTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.setupTabItem.setText(Messages.getString((String)"GDE_MSGT2290"));
                    this.deviceComposite = new Composite((Composite)this.mainTabFolder, 2048);
                    GridLayout deviceCompositeLayout = new GridLayout();
                    deviceCompositeLayout.makeColumnsEqualWidth = true;
                    this.deviceComposite.setLayout((Layout)deviceCompositeLayout);
                    this.setupTabItem.setControl((Control)this.deviceComposite);
                    this.baseDeviceSetupGroup = new Group(this.deviceComposite, 0);
                    GridData group1LData = new GridData();
                    group1LData.horizontalAlignment = 4;
                    group1LData.verticalAlignment = 1;
                    group1LData.widthHint = 580;
                    group1LData.heightHint = this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? 182 : 392;
                    this.baseDeviceSetupGroup.setLayoutData((Object)group1LData);
                    FillLayout baseDeviceSetupCompositeLayout = new FillLayout(512);
                    this.baseDeviceSetupGroup.setLayout((Layout)baseDeviceSetupCompositeLayout);
                    this.baseDeviceSetupGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.baseDeviceSetupGroup.setText(Messages.getString((String)"GDE_MSGT2291"));
                    this.baseDeviceSetupGroup.setForeground(SWTResourceManager.getColor((int)9));
                    if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.channelParameters[4] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 4, Messages.getString((String)"GDE_MSGT2293"), 175, "\u00b0C - \u00b0F", 175, temperatureDegreeType, 50, 150);
                        this.channelParameters[5] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 5, Messages.getString((String)"GDE_MSGT2294"), 175, Messages.getString((String)"GDE_MSGT2240") + " - " + Messages.getString((String)"GDE_MSGT2241"), 175, offOnType, 50, 150);
                        this.channelParameters[6] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 6, Messages.getString((String)"GDE_MSGT2295"), 175, "En - De - Fr - It", 175, languageTypes, 50, 150);
                        this.channelParameters[8] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 8, "", Messages.getString((String)"GDE_MSGT2296"), 175, "120 ~ 150 (12.0 ~ 15.0V)", 175, true, 50, 150, 120, 150, -100, false);
                        this.channelParameters[9] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 9, "", Messages.getString((String)"GDE_MSGT2297"), 175, "50 ~ 400 (5 ~ 40A)", 175, true, 50, 150, 50, 400, -50, false);
                        this.channelParameters[15] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 15, Messages.getString((String)"GDE_MSGT2303"), 175, "12H - 24H", 175, hourFormatType, 50, 150);
                    } else {
                        this.channelParameters[0] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 0, Messages.getString((String)"GDE_MSGT2293"), 175, "\u00b0C - \u00b0F", 175, temperatureDegreeType, 50, 150);
                        this.channelParameters[1] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 1, Messages.getString((String)"GDE_MSGT2294"), 175, Messages.getString((String)"GDE_MSGT2240") + " - " + Messages.getString((String)"GDE_MSGT2241"), 175, offOnType, 50, 150);
                        this.channelParameters[2] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 2, Messages.getString((String)"GDE_MSGT2306"), 175, Messages.getString((String)"GDE_MSGT2313"), 175, soundTime, 50, 150);
                        this.channelParameters[3] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 3, "", Messages.getString((String)"GDE_MSGT2307"), 175, "1 ~ 10", 175, false, 50, 150, 1, 10);
                        this.channelParameters[4] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 4, "", Messages.getString((String)"GDE_MSGT2305"), 175, "1 ~ 15", 175, false, 50, 150, 1, 15);
                        this.channelParameters[5] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 5, Messages.getString((String)"GDE_MSGT2295"), 175, "En - De - Fr - It", 175, languageTypes, 50, 150);
                        this.channelParameters[6] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 6, Messages.getString((String)"GDE_MSGT2308"), 175, Messages.getString((String)"GDE_MSGT2244") + " - " + Messages.getString((String)"GDE_MSGT2245"), 175, powerOnDisplayType, 50, 150);
                        this.channelParameters[8] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 8, "", Messages.getString((String)"GDE_MSGT2296") + "(1)", 175, "120 ~ 150 (12.0 ~ 15.0V)", 175, true, 50, 150, 120, 150, -100, false);
                        this.channelParameters[9] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 9, "", Messages.getString((String)"GDE_MSGT2297") + "(1)", 175, "50 ~ 400 (5 ~ 40A)", 175, true, 50, 150, 50, 400, -50, false);
                        this.channelParameters[10] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 10, "", Messages.getString((String)"GDE_MSGT2296") + "(2)", 175, "120 ~ 150 (12.0 ~ 15.0V)", 175, true, 50, 150, 120, 150, -100, false);
                        this.channelParameters[11] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 11, "", Messages.getString((String)"GDE_MSGT2297") + "(2)", 175, "50 ~ 400 (5 ~ 40A)", 175, true, 50, 150, 50, 400, -50, false);
                        this.channelParameters[12] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 12, "", Messages.getString((String)"GDE_MSGT2315"), 175, "1 - 99%", 175, false, 50, 150, 1, 99, -1, false);
                        this.channelParameters[18] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup, this.channelValues1, 18, Messages.getString((String)"GDE_MSGT2303"), 175, "12H - 24H", 175, hourFormatType, 50, 150);
                    }
                    if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.baseDeviceSetupGroup1 = new Group(this.deviceComposite, 0);
                        GridData group2LData = new GridData();
                        group2LData.verticalAlignment = 1;
                        group2LData.horizontalAlignment = 2;
                        group2LData.widthHint = 600;
                        group2LData.heightHint = 130;
                        this.baseDeviceSetupGroup1.setLayoutData((Object)group2LData);
                        FillLayout composite1Layout = new FillLayout(512);
                        this.baseDeviceSetupGroup1.setLayout((Layout)composite1Layout);
                        this.baseDeviceSetupGroup1.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                        this.baseDeviceSetupGroup1.setText(Messages.getString((String)"GDE_MSGT2304"));
                        this.baseDeviceSetupGroup1.setForeground(SWTResourceManager.getColor((int)9));
                        this.channelParameters[0] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup1, this.channelValues1, 0, Messages.getString((String)"GDE_MSGT2306"), 175, Messages.getString((String)"GDE_MSGT2313"), 175, soundTime, 50, 150);
                        this.channelParameters[1] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup1, this.channelValues1, 1, "", Messages.getString((String)"GDE_MSGT2307"), 175, "1 ~ 10", 175, false, 50, 150, 1, 10);
                        this.channelParameters[2] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup1, this.channelValues1, 2, "", Messages.getString((String)"GDE_MSGT2305"), 175, "1 ~ 15", 175, false, 50, 150, 1, 15);
                        this.channelParameters[3] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup1, this.channelValues1, 3, Messages.getString((String)"GDE_MSGT2308"), 175, Messages.getString((String)"GDE_MSGT2244") + " - " + Messages.getString((String)"GDE_MSGT2245"), 175, powerOnDisplayType, 50, 150);
                        this.baseDeviceSetupGroup2 = new Group(this.deviceComposite, 0);
                        GridData group3LData = new GridData();
                        group3LData.verticalAlignment = 1;
                        group3LData.horizontalAlignment = 2;
                        group3LData.widthHint = 600;
                        group3LData.heightHint = 130;
                        this.baseDeviceSetupGroup2.setLayoutData((Object)group3LData);
                        composite1Layout = new FillLayout(512);
                        this.baseDeviceSetupGroup2.setLayout((Layout)composite1Layout);
                        this.baseDeviceSetupGroup2.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                        this.baseDeviceSetupGroup2.setText(Messages.getString((String)"GDE_MSGT2309"));
                        this.baseDeviceSetupGroup2.setForeground(SWTResourceManager.getColor((int)9));
                        this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + 0] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup2, this.channelValues2, 0, Messages.getString((String)"GDE_MSGT2255"), 175, Messages.getString((String)"GDE_MSGT2313"), 175, soundTime, 50, 150);
                        this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + 1] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup2, this.channelValues2, 1, "", Messages.getString((String)"GDE_MSGT2254"), 175, "1 ~ 10", 175, false, 50, 150, 1, 10);
                        this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + 2] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup2, this.channelValues2, 2, "", Messages.getString((String)"GDE_MSGT2305"), 175, "1 ~ 15", 175, false, 50, 150, 1, 15);
                        this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + 3] = new ParameterConfigControl((Composite)this.baseDeviceSetupGroup2, this.channelValues2, 3, Messages.getString((String)"GDE_MSGT2308"), 175, Messages.getString((String)"GDE_MSGT2244") + " - " + Messages.getString((String)"GDE_MSGT2245"), 175, powerOnDisplayType, 50, 150);
                    }
                    this.memorySetupTabItem = new CTabItem(this.mainTabFolder, 0);
                    this.memorySetupTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memorySetupTabItem.setText(Messages.getString((String)"GDE_MSGT2250"));
                    this.memoryBoundsComposite = new Composite((Composite)this.mainTabFolder, 0);
                    this.memorySetupTabItem.setControl((Control)this.memoryBoundsComposite);
                    this.memoryBoundsComposite.setLayout((Layout)new FormLayout());
                    this.memorySelectComposite = new Composite(this.memoryBoundsComposite, 0);
                    FormData memorySelectLData = new FormData();
                    memorySelectLData.height = GDE.IS_OS_ARCH_ARM ? 170 : 160;
                    memorySelectLData.left = new FormAttachment(0, 1000, 0);
                    memorySelectLData.right = new FormAttachment(1000, 1000, 0);
                    memorySelectLData.top = new FormAttachment(0, 1000, 0);
                    this.memorySelectComposite.setLayoutData((Object)memorySelectLData);
                    RowLayout composite2Layout = new RowLayout(256);
                    this.memorySelectComposite.setLayout((Layout)composite2Layout);
                    this.memorySelectComposite.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.memorySelectLabel = new CLabel(this.memorySelectComposite, 131072);
                    RowData memorySelectLabelLData = new RowData();
                    memorySelectLabelLData.width = 120;
                    memorySelectLabelLData.height = 20;
                    this.memorySelectLabel.setLayoutData((Object)memorySelectLabelLData);
                    this.memorySelectLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memorySelectLabel.setText(Messages.getString((String)"GDE_MSGT2251"));
                    this.memorySelectLabel.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.updateBatterySetup(1);
                    this.memoryCombo = new CCombo(this.memorySelectComposite, 2048);
                    this.memoryCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memoryCombo.setItems(this.memoryNames);
                    this.memoryCombo.setVisibleItemCount(20);
                    this.memoryCombo.setTextLimit(21);
                    RowData memoryComboLData = new RowData();
                    memoryComboLData.width = 165;
                    memoryComboLData.height = GDE.IS_LINUX ? 20 : (GDE.IS_WINDOWS ? 16 : 18);
                    this.memoryCombo.setLayoutData((Object)memoryComboLData);
                    this.memoryCombo.setToolTipText(Messages.getString((String)"GDE_MSGT2252"));
                    this.memoryCombo.select(0);
                    this.memoryCombo.setBackground(SWTResourceManager.getColor((int)1));
                    this.memoryCombo.setEditable(true);
                    this.memoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "memoryCombo.widgetSelected, event=" + String.valueOf(evt));
                            try {
                                int actualSelectionIndex = UltraDuoPlusDialog.this.memoryCombo.getSelectionIndex();
                                if (UltraDuoPlusDialog.this.lastMemorySelectionIndex != actualSelectionIndex) {
                                    if (UltraDuoPlusDialog.this.ultraDuoPlusSetup != null && UltraDuoPlusDialog.this.lastMemorySelectionIndex >= 0 && UltraDuoPlusDialog.this.lastMemorySelectionIndex < numberMemories) {
                                        if (UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().isChanged()) {
                                            UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.memoryValues));
                                            UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_SETUP, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().getValue().getBytes(), UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1);
                                            UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get((int)UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().changed = null;
                                        }
                                        switch (UltraDuoPlusDialog.this.device.getDeviceTypeIdentifier()) {
                                            case UltraDuoPlus50: 
                                            case UltraDuoPlus60: {
                                                if (!UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().isChanged()) break;
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.memoryStepValues));
                                                UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_STEP_CHARGE_SETUP, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().getValue().getBytes(), UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1);
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get((int)UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().changed = null;
                                                break;
                                            }
                                        }
                                        if (UltraDuoPlusDialog.this.copyButton.getSelection()) {
                                            UltraDuoPlusDialog.this.copyButton.setSelection(false);
                                            if (64 == UltraDuoPlusDialog.this.application.openYesNoMessageDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGI2205", (Object[])new Object[]{UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getName(), actualSelectionIndex + 1, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).getName()}))) {
                                                if (log.isLoggable(Level.FINE)) {
                                                    log.log(Level.FINE, "copy memory: (" + (UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1) + ")" + UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getName() + " to (" + (actualSelectionIndex + 1) + ")" + UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).getName());
                                                    StringBuffer sb = new StringBuffer();
                                                    for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
                                                        sb.append(UltraDuoPlusDialog.this.memoryValues[i]).append("[").append(i).append("], ");
                                                    }
                                                    log.log(Level.FINE, sb.toString());
                                                }
                                                UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_NAME, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getName().getBytes(), actualSelectionIndex + 1);
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get((int)UltraDuoPlusDialog.this.lastMemorySelectionIndex).changed = null;
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).setName(UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getName());
                                                UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_SETUP, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().getValue().getBytes(), actualSelectionIndex + 1);
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get((int)UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().changed = null;
                                                UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).getSetupData().setValue(UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getSetupData().getValue());
                                                switch (UltraDuoPlusDialog.this.device.getDeviceTypeIdentifier()) {
                                                    case UltraDuoPlus50: 
                                                    case UltraDuoPlus60: {
                                                        UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_STEP_CHARGE_SETUP, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().getValue().getBytes(), actualSelectionIndex + 1);
                                                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get((int)UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().changed = null;
                                                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).getStepChargeData().setValue(UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).getStepChargeData().getValue());
                                                        break;
                                                    }
                                                }
                                                String newMemoryName = String.format(UltraDuoPlusDialog.STRING_FORMAT_02d_s, actualSelectionIndex + 1, UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(actualSelectionIndex).getName());
                                                UltraDuoPlusDialog.this.memoryCombo.setText(newMemoryName);
                                                UltraDuoPlusDialog.this.memoryNames[actualSelectionIndex] = (newMemoryName + UltraDuoPlusDialog.STRING_16_BLANK).substring(5, 21);
                                                UltraDuoPlusDialog.this.memoryCombo.setItem(actualSelectionIndex, newMemoryName);
                                            }
                                        }
                                    }
                                    UltraDuoPlusDialog.this.updateBatterySetup(actualSelectionIndex);
                                    UltraDuoPlusDialog.this.lastMemorySelectionIndex = actualSelectionIndex;
                                }
                            }
                            catch (Throwable e) {
                                log.log(Level.SEVERE, e.getMessage(), e);
                            }
                        }
                    });
                    this.memoryCombo.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent evt) {
                            log.finest(() -> "memoryCombo.keyReleased, event=" + String.valueOf(evt));
                        }

                        public void keyPressed(KeyEvent evt) {
                            log.finest(() -> "memoryCombo.keyPressed, event=" + String.valueOf(evt));
                            if (evt.character == '\r') {
                                try {
                                    String newMemoryName;
                                    UltraDuoPlusDialog.this.memoryNames[UltraDuoPlusDialog.this.lastMemorySelectionIndex] = newMemoryName = String.format(UltraDuoPlusDialog.STRING_FORMAT_02d_s, UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1, (UltraDuoPlusDialog.this.memoryCombo.getText() + UltraDuoPlusDialog.STRING_16_BLANK).substring(5, 21));
                                    UltraDuoPlusDialog.this.memoryCombo.setText(newMemoryName);
                                    UltraDuoPlusDialog.this.memoryCombo.setItem(UltraDuoPlusDialog.this.lastMemorySelectionIndex, newMemoryName);
                                    UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.lastMemorySelectionIndex).setName(UltraDuoPlusDialog.this.memoryNames[UltraDuoPlusDialog.this.lastMemorySelectionIndex].substring(5));
                                    UltraDuoPlusDialog.this.serialPort.writeConfigData(UltramatSerialPort.WRITE_MEMORY_NAME, UltraDuoPlusDialog.this.memoryNames[UltraDuoPlusDialog.this.lastMemorySelectionIndex].substring(5).getBytes(), UltraDuoPlusDialog.this.lastMemorySelectionIndex + 1);
                                }
                                catch (Exception e) {
                                    UltraDuoPlusDialog.this.application.openMessageDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE0007", (Object[])new String[]{e.getMessage()}));
                                }
                            }
                        }
                    });
                    CLabel filler = new CLabel(this.memorySelectComposite, 131072);
                    filler.setLayoutData((Object)new RowData(140, 20));
                    filler.setText("<---------   ");
                    filler.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.copyButton = new Button(this.memorySelectComposite, 16416);
                    RowData cellTypeSelectLabelLData = new RowData();
                    cellTypeSelectLabelLData.width = 200;
                    cellTypeSelectLabelLData.height = 20;
                    this.copyButton.setLayoutData((Object)cellTypeSelectLabelLData);
                    this.copyButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.copyButton.setText(Messages.getString((String)"GDE_MSGT2288"));
                    this.copyButton.setToolTipText(Messages.getString((String)"GDE_MSGT2256"));
                    this.copyButton.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.memoryParameters[0] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 0, Messages.getString((String)"GDE_MSGT2257"), 175, Messages.getString((String)"GDE_MSGT2246"), 220, cellTypeNames, 50, 150);
                    this.memoryParameters[1] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 1, "", Messages.getString((String)"GDE_MSGT2258"), 175, "1 ~ 6/7/18", 220, false, 50, 150, 1, 18);
                    this.memoryParameters[2] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 2, "", Messages.getString((String)"GDE_MSGT2259"), 175, "100 ~ 65000 mAh", 220, true, 50, 150, 100, 65000, -100, true);
                    this.memoryParameters[3] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 3, STRING_FORMAT_02D, Messages.getString((String)"GDE_MSGT2260"), 100, "", 5, false, 30, 70, 0, 99);
                    this.memoryParameters[4] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 4, STRING_FORMAT_02D, Messages.getString((String)"GDE_MSGT2261"), 60, "", 5, false, 20, 80, 1, 12);
                    this.memoryParameters[5] = new ParameterConfigControl(this.memorySelectComposite, this.memoryValues, 5, STRING_FORMAT_02D, Messages.getString((String)"GDE_MSGT2262"), 55, "", 5, false, 20, 80, 1, 31);
                    this.chargeTypeTabFolder = new CTabFolder(this.memoryBoundsComposite, 2048);
                    this.chargeTypeTabFolder.setSimple(false);
                    FormData chargeTypeTabFolderLData = new FormData();
                    chargeTypeTabFolderLData.left = new FormAttachment(0, 1000, 0);
                    chargeTypeTabFolderLData.right = new FormAttachment(1000, 1000, 0);
                    chargeTypeTabFolderLData.bottom = new FormAttachment(1000, 1000, 0);
                    chargeTypeTabFolderLData.top = new FormAttachment(0, 1000, GDE.IS_OS_ARCH_ARM ? 170 : 160);
                    this.chargeTypeTabFolder.setLayoutData((Object)chargeTypeTabFolderLData);
                    this.chargeTypeTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "restoreButton.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.lastCellSelectionIndex = -1;
                            switch (UltraDuoPlusDialog.this.device.getDeviceTypeIdentifier()) {
                                case UltraDuoPlus50: 
                                case UltraDuoPlus60: {
                                    if (UltraDuoPlusDialog.this.memoryValues[0] != 1) break;
                                    UltraDuoPlusDialog.this.stepChargeComposite.getStepChargeValues(UltraDuoPlusDialog.this.memoryStepValues);
                                    Event changeEvent = new Event();
                                    changeEvent.index = -1;
                                    UltraDuoPlusDialog.this.chargeGroup.notifyListeners(13, changeEvent);
                                    break;
                                }
                            }
                            UltraDuoPlusDialog.this.updateBatteryMemoryParameter(UltraDuoPlusDialog.this.memoryValues[0]);
                        }
                    });
                    this.chargeTabItem = new CTabItem(this.chargeTypeTabFolder, 0);
                    this.chargeTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.chargeTabItem.setText(Messages.getString((String)"GDE_MSGT2298"));
                    this.scrolledchargeComposite = new ScrolledComposite((Composite)this.chargeTypeTabFolder, 2560);
                    FillLayout scrolledMemoryCompositeLayout = new FillLayout();
                    this.scrolledchargeComposite.setLayout((Layout)scrolledMemoryCompositeLayout);
                    this.chargeTabItem.setControl((Control)this.scrolledchargeComposite);
                    this.chargeGroup = new Group((Composite)this.scrolledchargeComposite, 0);
                    FillLayout memoryCompositeLayout = new FillLayout(512);
                    this.chargeGroup.setLayout((Layout)memoryCompositeLayout);
                    this.memoryParameters[6] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 6, "", Messages.getString((String)"GDE_MSGT2263"), 175, "100 ~ 20000 mA", 220, true, 50, 150, 100, 20000, -100, false);
                    this.memoryParameters[11] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 11, "", Messages.getString((String)"GDE_MSGT2265"), 175, Messages.getString((String)"GDE_MSGT2310"), 220, true, 50, 150, 10, 165);
                    this.memoryParameters[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 10, "", Messages.getString((String)"GDE_MSGT2264"), 175, "10 ~ 80\u00b0C", 220, false, 50, 150, 10, 80) : new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 10, "", Messages.getString((String)"GDE_MSGT2264"), 175, "50 ~ 176\u00b0F", 220, false, 50, 150, 50, 176);
                    this.memoryParameters[12] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 12, "", Messages.getString((String)"GDE_MSGT2266"), 175, Messages.getString((String)"GDE_MSGT2238"), 220, false, 50, 150, 10, 905);
                    this.memoryParameters[14] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2267"), 175, "3600 ~ 4200 mV", 220, true, 50, 150, 3600, 4200, -3600, false);
                    this.memoryParameters[9] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 9, "", Messages.getString((String)"GDE_MSGT2279"), 175, Messages.getString((String)"GDE_MSGT2312"), 220, false, 50, 150, 0, 550);
                    this.memoryParameters[26] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 26, "", Messages.getString((String)"GDE_MSGT2276"), 175, "3600 ~ 4000 mV", 220, true, 50, 150, 3600, 4000, -3600, false);
                    this.memoryParameters[7] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 7, "", Messages.getString((String)"GDE_MSGT2277"), 175, "0 ~ 25mV", 220, false, 50, 150, 0, 25);
                    this.memoryParameters[8] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 8, "", Messages.getString((String)"GDE_MSGT2278"), 175, "1 ~ 20min", 220, false, 50, 150, 1, 20);
                    this.memoryParameters[15] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 15, "", Messages.getString((String)"GDE_MSGT2281"), 175, "1 ~ 30min", 220, false, 50, 150, 1, 30);
                    this.memoryParameters[13] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 13, "", Messages.getString((String)"GDE_MSGT2280"), 175, "1 ~ 5", 220, false, 50, 150, 1, 5);
                    this.memoryParameters[16] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 16, Messages.getString((String)"GDE_MSGT2282"), 175, Messages.getString((String)"GDE_MSGT2241") + " - " + Messages.getString((String)"GDE_MSGT2240"), 220, offOnType, 50, 150);
                    this.scrolledchargeComposite.setContent((Control)this.chargeGroup);
                    this.chargeGroup.setSize(620, this.chargeSelectHeight);
                    this.scrolledchargeComposite.addControlListener(new ControlListener(){

                        public void controlResized(ControlEvent evt) {
                            log.finest(() -> "scrolledMemoryComposite.controlResized, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.chargeGroup.setSize(UltraDuoPlusDialog.this.scrolledchargeComposite.getClientArea().width, UltraDuoPlusDialog.this.chargeSelectHeight);
                        }

                        public void controlMoved(ControlEvent evt) {
                            log.finest(() -> "scrolledMemoryComposite.controlMoved, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.chargeGroup.setSize(UltraDuoPlusDialog.this.scrolledchargeComposite.getClientArea().width, UltraDuoPlusDialog.this.chargeSelectHeight);
                        }
                    });
                    this.dischargeTabItem = new CTabItem(this.chargeTypeTabFolder, 0);
                    this.dischargeTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.dischargeTabItem.setText(Messages.getString((String)"GDE_MSGT2300"));
                    this.dischargeCycleComposite = new Composite((Composite)this.chargeTypeTabFolder, 0);
                    RowLayout scrolledComposite1Layout = new RowLayout(512);
                    this.dischargeCycleComposite.setLayout((Layout)scrolledComposite1Layout);
                    this.dischargeTabItem.setControl((Control)this.dischargeCycleComposite);
                    this.dischargeGroup = new Group(this.dischargeCycleComposite, 0);
                    RowData dischargeGroupLData = new RowData(620, this.dischargeSelectHeight);
                    this.dischargeGroup.setLayoutData((Object)dischargeGroupLData);
                    FillLayout memoryCompositeLayout2 = new FillLayout(512);
                    this.dischargeGroup.setLayout((Layout)memoryCompositeLayout2);
                    this.dischargeGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memoryParameters[17] = new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 17, "", Messages.getString((String)"GDE_MSGT2268"), 175, "100 ~ 10000 mA", 220, true, 50, 150, 100, 10000, -100, false);
                    this.memoryParameters[18] = new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 18, "", Messages.getString((String)"GDE_MSGT2269"), 175, "2500 ~ 4200 mV", 220, true, 50, 150, 2500, 4200, -2500, false);
                    this.memoryParameters[20] = new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 20, "", Messages.getString((String)"GDE_MSGT2271"), 175, Messages.getString((String)"GDE_MSGT2311"), 220, false, 50, 150, 10, 105, -10, false);
                    this.memoryParameters[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 19, "", Messages.getString((String)"GDE_MSGT2270"), 175, "10 ~ 80\u00b0C", 220, false, 50, 150, 10, 80) : new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 19, "", Messages.getString((String)"GDE_MSGT2270"), 175, "50 ~ 176\u00b0F", 220, false, 50, 150, 50, 176);
                    this.memoryParameters[21] = new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 21, "", Messages.getString((String)"GDE_MSGT2283"), 175, "1100 ~ 1300 mV", 220, true, 50, 150, 1100, 1300, -1100, false);
                    this.cycleGroup = new Group(this.dischargeCycleComposite, 0);
                    RowData cycleGroupLData = new RowData(625, this.cycleSelectHeight);
                    this.cycleGroup.setLayoutData((Object)cycleGroupLData);
                    memoryCompositeLayout2 = new FillLayout(512);
                    this.cycleGroup.setLayout((Layout)memoryCompositeLayout2);
                    this.cycleGroup.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.cycleGroup.setText(Messages.getString((String)"GDE_MSGT2302"));
                    this.cycleGroup.setForeground(SWTResourceManager.getColor((int)9));
                    this.memoryParameters[22] = new ParameterConfigControl((Composite)this.cycleGroup, this.memoryValues, 22, Messages.getString((String)"GDE_MSGT2272"), 175, Messages.getString((String)"GDE_MSGT2292"), 220, cycleDirectionTypes, 50, 150);
                    this.memoryParameters[23] = new ParameterConfigControl((Composite)this.cycleGroup, this.memoryValues, 23, "", Messages.getString((String)"GDE_MSGT2273"), 175, "1 ~ 10", 220, false, 50, 150, 1, 10);
                    this.memoryParameters[24] = new ParameterConfigControl((Composite)this.cycleGroup, this.memoryValues, 24, "", Messages.getString((String)"GDE_MSGT2274"), 175, "1 ~ 30min", 220, false, 50, 150, 1, 30);
                    this.memoryParameters[25] = new ParameterConfigControl((Composite)this.cycleGroup, this.memoryValues, 25, "", Messages.getString((String)"GDE_MSGT2275"), 175, "1 ~ 30min", 220, false, 50, 150, 1, 30);
                    this.chargeTypeTabFolder.setSelection(0);
                    this.memoryCycleDataTabItem = new CTabItem(this.mainTabFolder, 0);
                    this.memoryCycleDataTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memoryCycleDataTabItem.setText(Messages.getString((String)"GDE_MSGT2320"));
                    this.memoryDataComposite = new Composite((Composite)this.mainTabFolder, 0);
                    this.memoryCycleDataTabItem.setControl((Control)this.memoryDataComposite);
                    this.memoryDataComposite.setLayout((Layout)new FormLayout());
                    this.memoryDataSelectComposite = new Composite(this.memoryDataComposite, 2048);
                    memorySelectLData = new FormData();
                    memorySelectLData.height = 50;
                    memorySelectLData.left = new FormAttachment(0, 1000, 0);
                    memorySelectLData.right = new FormAttachment(1000, 1000, 0);
                    memorySelectLData.top = new FormAttachment(0, 1000, 0);
                    this.memoryDataSelectComposite.setLayoutData((Object)memorySelectLData);
                    composite2Layout = new RowLayout(256);
                    this.memoryDataSelectComposite.setLayout((Layout)composite2Layout);
                    this.memoryDataSelectComposite.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    filler = new Composite(this.memoryDataSelectComposite, 0);
                    filler.setLayoutData((Object)new RowData(500, 10));
                    filler.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.memoryDataSelectLabel = new CLabel(this.memoryDataSelectComposite, 131072);
                    RowData memoryCycleDataSelectLabelLData = new RowData();
                    memoryCycleDataSelectLabelLData.width = 315;
                    memoryCycleDataSelectLabelLData.height = 20;
                    this.memoryDataSelectLabel.setLayoutData((Object)memoryCycleDataSelectLabelLData);
                    this.memoryDataSelectLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memoryDataSelectLabel.setText(Messages.getString((String)"GDE_MSGT2321") + Messages.getString((String)"GDE_MSGT2251"));
                    this.memoryDataSelectLabel.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.memoryDataCombo = new CCombo(this.memoryDataSelectComposite, 2048);
                    this.memoryDataCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.memoryDataCombo.setItems(this.memoryNames);
                    this.memoryDataCombo.setVisibleItemCount(20);
                    this.memoryDataCombo.setTextLimit(21);
                    RowData memoryComboCycleDataLData = new RowData();
                    memoryComboCycleDataLData.width = 165;
                    memoryComboCycleDataLData.height = GDE.IS_LINUX ? 20 : (GDE.IS_WINDOWS ? 16 : 18);
                    this.memoryDataCombo.setLayoutData((Object)memoryComboCycleDataLData);
                    this.memoryDataCombo.setToolTipText(Messages.getString((String)"GDE_MSGT2339"));
                    this.memoryDataCombo.select(0);
                    this.memoryDataCombo.setBackground(SWTResourceManager.getColor((int)1));
                    this.memoryDataCombo.setEditable(true);
                    this.memoryDataCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "memoryComboData.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.memorySelectionIndexData = UltraDuoPlusDialog.this.memoryDataCombo.getSelectionIndex() + 1;
                        }
                    });
                    final Button cycleDataButton = new Button(this.memoryDataComposite, 13);
                    FormData cycleDataButtonLData = new FormData();
                    cycleDataButtonLData.height = 30;
                    cycleDataButtonLData.left = new FormAttachment(0, 1000, 150);
                    cycleDataButtonLData.right = new FormAttachment(1000, 1000, -150);
                    cycleDataButtonLData.top = new FormAttachment(0, 1000, 70);
                    cycleDataButton.setLayoutData((Object)cycleDataButtonLData);
                    cycleDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    cycleDataButton.setText(Messages.getString((String)"GDE_MSGT2322"));
                    cycleDataButton.setToolTipText(Messages.getString((String)"GDE_MSGT2316"));
                    cycleDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        /*
                         * WARNING - void declaration
                         */
                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "cycleDataButton.widgetSelected, event=" + String.valueOf(evt));
                            try {
                                UltraDuoPlusDialog.this.cycleDataProgressBar.setSelection(0);
                                GraphicsWindow cycleGraph = (GraphicsWindow)UltraDuoPlusDialog.this.device.getUtilityDeviceTabItem();
                                RecordSet utilitySet = UltraDuoPlusDialog.this.application.getUtilitySet();
                                utilitySet.clear();
                                for (int i = 0; i < Ultramat.cycleDataRecordNames.length; ++i) {
                                    Record tmpRecord = new Record((IDevice)UltraDuoPlusDialog.this.device, i, Ultramat.cycleDataRecordNames[i], "", Ultramat.cycleDataUnitNames[i], true, null, new ArrayList(), 11);
                                    tmpRecord.setFactor(Ultramat.cycleDataFactors[i]);
                                    if (Ultramat.cycleDataSyncRefOrdinal[i] >= 0) {
                                        tmpRecord.createProperty(MeasurementPropertyTypes.SCALE_SYNC_REF_ORDINAL.value(), DataTypes.INTEGER, (Object)Ultramat.cycleDataSyncRefOrdinal[i]);
                                    }
                                    tmpRecord.setColorDefaultsAndPosition(i);
                                    utilitySet.put(Ultramat.cycleDataRecordNames[i], (AbstractRecord)tmpRecord);
                                    tmpRecord.setColor(SWTResourceManager.getColor((int)Ultramat.cycleDataColors[i][0], (int)Ultramat.cycleDataColors[i][1], (int)Ultramat.cycleDataColors[i][2]));
                                    if (i >= 4) {
                                        tmpRecord.setPositionLeft(false);
                                    }
                                    if ((i + 1) % 2 != 0) continue;
                                    tmpRecord.setVisible(false);
                                }
                                utilitySet.setValueGridType(1);
                                utilitySet.setValueGridRecordOrdinal(4);
                                utilitySet.setTimeGridType(1);
                                utilitySet.setTimeStep_ms(-1.0);
                                utilitySet.syncScaleOfSyncableRecords();
                                UltraDuoPlusDialog.this.application.getTabFolder().setSelection((CTabItem)cycleGraph);
                                UltraDuoPlusDialog.this.cycleDataProgressBar.setSelection(50);
                                long justNowPlus2Hours = new Date().getTime() + 0x6DDD00L;
                                long justNowMinus2Year = new Date().getTime() - 63072000000L;
                                Vector<Object> cyclesData = new Vector();
                                TreeMap<Long, int[]> sortCyclesData = new TreeMap<Long, int[]>();
                                if (Boolean.parseBoolean(System.getProperty("GDE_IS_SIMULATION"))) {
                                    void var11_14;
                                    String memoryCycleData = "00030026000B00040011050141C2040C00213F880000000B0004000B00040018017341D905910000000000000009002D000B0005000709BF417E03B50000000000000008002B000C00050009084341DC04B4000B0000000000000032000F00050012001A41F0000000000000000000090015000C0005001D0A2E4194044E00000000000000100004000B000600040ADF41960566000F0022001D00120034000B0006000C07D0418004740000000000000003000E000E0006000D094241E206A30000000000000000000000000000000000000000000000000000000000210088000000000000000000000000000000000000";
                                    boolean bl = false;
                                    while (var11_14 < 11) {
                                        void var12_18 = var11_14 * 44;
                                        void endIndex = (var11_14 + true) * 44;
                                        cyclesData.add(memoryCycleData.substring((int)var12_18, (int)endIndex).getBytes());
                                        ++var11_14;
                                    }
                                } else {
                                    cyclesData = UltraDuoPlusDialog.this.serialPort.readMemoryCycleData(UltraDuoPlusDialog.this.memorySelectionIndexData);
                                }
                                if (log.isLoggable(Level.INFO)) {
                                    Iterator sb = new StringBuilder();
                                    for (byte[] byArray : cyclesData) {
                                        ((StringBuilder)((Object)sb)).append(new String(byArray) + "\n");
                                    }
                                    log.log(Level.INFO, ((StringBuilder)((Object)sb)).toString());
                                }
                                UltraDuoPlusDialog.this.dataTable.removeAll();
                                for (byte[] byArray : cyclesData) {
                                    long l = 0L;
                                    int[] points = new int[6];
                                    int hour = 0;
                                    int minute = 0;
                                    int year = 0;
                                    int month = 0;
                                    int day = 0;
                                    try {
                                        hour = Integer.parseInt(String.format("%c%c%c%c", byArray[0], byArray[1], byArray[2], byArray[3]), 16);
                                        minute = Integer.parseInt(String.format("%c%c%c%c", byArray[4], byArray[5], byArray[6], byArray[7]), 16);
                                        day = Integer.parseInt(String.format("%c%c%c%c", byArray[8], byArray[9], byArray[10], byArray[11]), 16);
                                        month = Integer.parseInt(String.format("%c%c%c%c", byArray[12], byArray[13], byArray[14], byArray[15]), 16);
                                        year = Integer.parseInt(String.format("%c%c%c%c", byArray[16], byArray[17], byArray[18], byArray[19]), 16);
                                        l = new GregorianCalendar(2000 + year, month - 1, day, hour, minute, 0).getTimeInMillis();
                                    }
                                    catch (NumberFormatException e) {
                                        log.log(Level.WARNING, e.getMessage(), e);
                                    }
                                    try {
                                        points[2] = Integer.parseInt(String.format("%c%c%c%c", byArray[20], Character.valueOf((char)byArray[21]), Character.valueOf((char)byArray[22]), Character.valueOf((char)byArray[23])), 16);
                                        points[0] = Integer.parseInt(String.format("%c%c%c%c", byArray[24], Character.valueOf((char)byArray[25]), Character.valueOf((char)byArray[26]), Character.valueOf((char)byArray[27])), 16);
                                        points[4] = Integer.parseInt(String.format("%c%c%c%c", byArray[28], Character.valueOf((char)byArray[29]), Character.valueOf((char)byArray[30]), Character.valueOf((char)byArray[31])), 16);
                                        points[3] = Integer.parseInt(String.format("%c%c%c%c", byArray[32], Character.valueOf((char)byArray[33]), Character.valueOf((char)byArray[34]), Character.valueOf((char)byArray[35])), 16);
                                        points[1] = Integer.parseInt(String.format("%c%c%c%c", byArray[36], Character.valueOf((char)byArray[37]), Character.valueOf((char)byArray[38]), Character.valueOf((char)byArray[39])), 16);
                                        points[5] = Integer.parseInt(String.format("%c%c%c%c", byArray[40], Character.valueOf((char)byArray[41]), Character.valueOf((char)byArray[42]), Character.valueOf((char)byArray[43])), 16);
                                    }
                                    catch (Exception e) {
                                        log.log(Level.WARNING, e.getMessage(), e);
                                    }
                                    if (log.isLoggable(Level.FINE)) {
                                        StringBuilder sb = new StringBuilder();
                                        for (int point : points) {
                                            sb.append("; ").append(String.format("%8d", point));
                                        }
                                        log.log(Level.FINE, StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)l) + sb.toString());
                                    }
                                    long dataSum = 0L;
                                    for (int point : points) {
                                        dataSum += (long)point;
                                    }
                                    if (dataSum <= 0L) continue;
                                    sortCyclesData.put(l, (int[])points.clone());
                                }
                                for (Map.Entry entry : sortCyclesData.entrySet()) {
                                    TableItem tableItem = new TableItem(UltraDuoPlusDialog.this.dataTable, 0x1000000);
                                    int[] points = (int[])entry.getValue();
                                    tableItem.setText(new String[]{StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm", (long)((Long)entry.getKey())), String.format("%.3f", (double)points[0] / 1000.0), String.format("%.3f", (double)points[1] / 1000.0), String.format("%.0f", (double)points[2] / 1.0), String.format("%.0f", (double)points[3] / 1.0), String.format("%.1f", (double)points[4] / 10.0), String.format("%.1f", (double)points[5] / 10.0)});
                                }
                                log.log(Level.FINE, "used entries between " + StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)justNowMinus2Year) + " - " + StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)justNowPlus2Hours) + GDE.LINE_SEPARATOR);
                                long lastTimeStamp = 0L;
                                for (Map.Entry entry : sortCyclesData.entrySet()) {
                                    utilitySet.addPoints((int[])entry.getValue(), (double)(lastTimeStamp == 0L ? 0L : (Long)entry.getKey() - lastTimeStamp));
                                    if (log.isLoggable(Level.FINE)) {
                                        StringBuilder sb = new StringBuilder();
                                        for (int i = 0; i < ((int[])entry.getValue()).length; ++i) {
                                            sb.append("; ").append(String.format("%8d", ((int[])entry.getValue())[i]));
                                        }
                                        log.log(Level.FINE, StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)((Long)entry.getKey())) + String.format("; %12d%s", lastTimeStamp == 0L ? 0L : (Long)entry.getKey() - lastTimeStamp, sb.toString()));
                                    }
                                    lastTimeStamp = lastTimeStamp == 0L ? (Long)entry.getKey() : lastTimeStamp;
                                }
                                Object[] objectArray = sortCyclesData.keySet().toArray(new Long[0]);
                                Arrays.sort(objectArray);
                                if (objectArray != null && objectArray.length > 1) {
                                    utilitySet.setRecordSetDescription(UltraDuoPlusDialog.this.memoryDataCombo.getText() + " : " + StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)((Long)objectArray[0])) + " - " + StringHelper.getFormatedTime((String)"yyyy-MM-dd, HH:mm:ss", (long)((Long)objectArray[objectArray.length - 1])));
                                } else {
                                    utilitySet.setRecordSetDescription(UltraDuoPlusDialog.this.memoryDataCombo.getText());
                                }
                                cycleGraph.enableGraphicsHeader(true);
                                UltraDuoPlusDialog.this.application.getTabFolder().notifyListeners(13, new Event());
                                UltraDuoPlusDialog.this.cycleDataProgressBar.setSelection(100);
                            }
                            catch (Exception e) {
                                log.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    });
                    this.cycleDataProgressBar = new ProgressBar(this.memoryDataComposite, 0);
                    FormData cycleDataProgressBarLData = new FormData();
                    cycleDataProgressBarLData.height = 15;
                    cycleDataProgressBarLData.left = new FormAttachment(0, 1000, 150);
                    cycleDataProgressBarLData.right = new FormAttachment(1000, 1000, -150);
                    cycleDataProgressBarLData.top = new FormAttachment(0, 1000, 110);
                    this.cycleDataProgressBar.setLayoutData((Object)cycleDataProgressBarLData);
                    this.cycleDataProgressBar.setMinimum(0);
                    this.cycleDataProgressBar.setMinimum(100);
                    this.dataTable = new Table(this.memoryDataComposite, 2048);
                    FormData dataTableLData = new FormData();
                    dataTableLData.height = 200;
                    dataTableLData.left = new FormAttachment(0, 1000, 5);
                    dataTableLData.right = new FormAttachment(1000, 1000, -5);
                    dataTableLData.top = new FormAttachment(0, 1000, 140);
                    this.dataTable.setLayoutData((Object)dataTableLData);
                    this.dataTable.setLinesVisible(true);
                    this.dataTable.setHeaderVisible(true);
                    this.dataTable.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    TableColumn timeColumn = new TableColumn(this.dataTable, 0x1000000);
                    timeColumn.setText("yyyy-MM-dd, HH:mm");
                    timeColumn.setWidth(timeColumn.getText().length() * 9);
                    for (int i = 0; i < 6; ++i) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(Ultramat.cycleDataTableNames[i]).append(" [").append(Ultramat.cycleDataUnitNames[i]).append("]");
                        TableColumn column = new TableColumn(this.dataTable, 0x1000000);
                        column.setWidth(77);
                        column.setText(sb.toString());
                    }
                    this.channelSelectComposite = new Composite(this.memoryDataComposite, 2048);
                    FormData channelSelectLData = new FormData();
                    channelSelectLData.height = 50;
                    channelSelectLData.left = new FormAttachment(0, 1000, 0);
                    channelSelectLData.right = new FormAttachment(1000, 1000, 0);
                    channelSelectLData.bottom = new FormAttachment(1000, 1000, -90);
                    this.channelSelectComposite.setLayoutData((Object)channelSelectLData);
                    composite2Layout = new RowLayout(256);
                    this.channelSelectComposite.setLayout((Layout)composite2Layout);
                    this.channelSelectComposite.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    Composite filler2 = new Composite(this.channelSelectComposite, 0);
                    filler2.setLayoutData((Object)new RowData(500, 10));
                    filler2.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.channelSelectLabel = new CLabel(this.channelSelectComposite, 131072);
                    memoryCycleDataSelectLabelLData = new RowData();
                    memoryCycleDataSelectLabelLData.width = 370;
                    memoryCycleDataSelectLabelLData.height = 20;
                    this.channelSelectLabel.setLayoutData((Object)memoryCycleDataSelectLabelLData);
                    this.channelSelectLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.channelSelectLabel.setText(Messages.getString((String)"GDE_MSGT2334"));
                    this.channelSelectLabel.setBackground(this.application.COLOR_CANVAS_YELLOW);
                    this.channelCombo = new CCombo(this.channelSelectComposite, 0x1000800);
                    this.channelCombo.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.channelCombo.setItems(this.channelNumbers);
                    this.channelCombo.setVisibleItemCount(2);
                    memoryComboCycleDataLData = new RowData();
                    memoryComboCycleDataLData.width = 35;
                    memoryComboCycleDataLData.height = GDE.IS_LINUX ? 20 : (GDE.IS_WINDOWS ? 16 : 18);
                    this.channelCombo.setLayoutData((Object)memoryComboCycleDataLData);
                    this.channelCombo.setToolTipText(Messages.getString((String)"GDE_MSGT2335"));
                    this.channelCombo.select(0);
                    this.channelCombo.setBackground(SWTResourceManager.getColor((int)1));
                    this.channelCombo.setEditable(false);
                    this.channelCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "memoryComboData.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.channelSelectionIndex = UltraDuoPlusDialog.this.channelCombo.getSelectionIndex() + 1;
                        }
                    });
                    final Button graphicsDataButton = new Button(this.memoryDataComposite, 13);
                    FormData graphicsDataButtonLData = new FormData();
                    graphicsDataButtonLData.height = 30;
                    graphicsDataButtonLData.left = new FormAttachment(0, 1000, 150);
                    graphicsDataButtonLData.right = new FormAttachment(1000, 1000, -150);
                    graphicsDataButtonLData.bottom = new FormAttachment(1000, 1000, -40);
                    graphicsDataButton.setLayoutData((Object)graphicsDataButtonLData);
                    graphicsDataButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    graphicsDataButton.setText(Messages.getString((String)"GDE_MSGT2318"));
                    graphicsDataButton.setToolTipText(Messages.getString((String)"GDE_MSGT2319"));
                    graphicsDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "graphicsDataButton.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.dialogShell.setCursor(SWTResourceManager.getCursor((int)1));
                            graphicsDataButton.setEnabled(false);
                            cycleDataButton.setEnabled(false);
                            final int[] points = new int[UltraDuoPlusDialog.this.device.getNumberOfMeasurements(UltraDuoPlusDialog.this.channelSelectionIndex)];
                            final byte[][] graphicsData = new byte[3][];
                            Thread akkuDataGatherer = new Thread("akku data gatherer"){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Loose catch block
                                 */
                                @Override
                                public void run() {
                                    block10: {
                                        try {
                                            UltraDuoPlusDialog.this.serialPort.readGraphicsData(graphicsData, UltraDuoPlusDialog.this.channelSelectionIndex, UltraDuoPlusDialog.this);
                                            String processName = Messages.getString((String)"GDE_MSGT2337");
                                            RecordSet recordSet = null;
                                            Channel channel = (Channel)Channels.getInstance().get((Object)UltraDuoPlusDialog.this.channelSelectionIndex);
                                            if (channel == null) break block10;
                                            String recordSetKey = channel.getNextRecordSetNumber() + ") " + processName;
                                            recordSetKey = recordSetKey.length() <= 40 ? recordSetKey : recordSetKey.substring(0, 40);
                                            channel.put((Object)recordSetKey, (Object)RecordSet.createRecordSet((String)recordSetKey, (IDevice)UltraDuoPlusDialog.this.device, (int)UltraDuoPlusDialog.this.channelSelectionIndex, (boolean)true, (boolean)false, (boolean)true));
                                            channel.applyTemplateBasics(recordSetKey);
                                            log.log(Level.FINE, recordSetKey + " created for channel " + channel.getName());
                                            recordSet = (RecordSet)channel.get((Object)recordSetKey);
                                            UltraDuoPlusDialog.this.device.setTemperatureUnit(UltraDuoPlusDialog.this.channelSelectionIndex, recordSet, UltraDuoPlusDialog.this.initialAnswerData);
                                            recordSet.setAllDisplayable();
                                            UltraDuoPlusDialog.this.channels.switchChannel(UltraDuoPlusDialog.this.channelSelectionIndex, recordSetKey);
                                            channel.switchRecordSet(recordSetKey);
                                            String description = recordSet.getRecordSetDescription() + GDE.LINE_SEPARATOR + "Firmware  : " + UltraDuoPlusDialog.this.device.getFirmwareVersion(UltraDuoPlusDialog.this.initialAnswerData) + (String)(UltraDuoPlusDialog.this.device.getBatteryMemoryNumber(UltraDuoPlusDialog.this.channelSelectionIndex, UltraDuoPlusDialog.this.initialAnswerData) >= 1 ? "; Memory #" + UltraDuoPlusDialog.this.device.getBatteryMemoryNumber(UltraDuoPlusDialog.this.channelSelectionIndex, UltraDuoPlusDialog.this.initialAnswerData) : "");
                                            try {
                                                int batteryMemoryNumber = UltraDuoPlusDialog.this.device.getBatteryMemoryNumber(UltraDuoPlusDialog.this.channelSelectionIndex, UltraDuoPlusDialog.this.initialAnswerData);
                                                if (batteryMemoryNumber > 0 && UltraDuoPlusDialog.this.ultraDuoPlusSetup != null && UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(batteryMemoryNumber) != null) {
                                                    String batteryMemoryName = UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory().get(UltraDuoPlusDialog.this.device.getBatteryMemoryNumber(UltraDuoPlusDialog.this.channelSelectionIndex, UltraDuoPlusDialog.this.initialAnswerData) - 1).getName();
                                                    description = description + " - " + batteryMemoryName;
                                                    UltraDuoPlusDialog.this.device.matchBatteryMemory2ObjectKey(batteryMemoryName);
                                                }
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                            recordSet.setRecordSetDescription(description);
                                            int numOfPoints = Integer.parseInt(String.format("%c%c%c%c", graphicsData[0][1], Character.valueOf((char)graphicsData[0][2]), Character.valueOf((char)graphicsData[0][3]), Character.valueOf((char)graphicsData[0][4])), 16) - 10;
                                            int timeStep_sec = Integer.parseInt(String.format("%c%c%c%c", graphicsData[0][5], Character.valueOf((char)graphicsData[0][6]), Character.valueOf((char)graphicsData[0][7]), Character.valueOf((char)graphicsData[0][8])), 16);
                                            recordSet.setNewTimeStep_ms((double)timeStep_sec * 1000.0);
                                            int i = 0;
                                            int j = 9;
                                            while (i < numOfPoints) {
                                                points[0] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)graphicsData[0][j]), Character.valueOf((char)graphicsData[0][j + 1]), Character.valueOf((char)graphicsData[0][j + 2]), Character.valueOf((char)graphicsData[0][j + 3])), 16);
                                                points[1] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)graphicsData[1][j]), Character.valueOf((char)graphicsData[1][j + 1]), Character.valueOf((char)graphicsData[1][j + 2]), Character.valueOf((char)graphicsData[1][j + 3])), 16);
                                                points[5] = Integer.parseInt(String.format("%c%c%c%c", Character.valueOf((char)graphicsData[2][j]), Character.valueOf((char)graphicsData[2][j + 1]), Character.valueOf((char)graphicsData[2][j + 2]), Character.valueOf((char)graphicsData[2][j + 3])), 16);
                                                recordSet.addPoints(points);
                                                ++i;
                                                j += 4;
                                            }
                                            UltraDuoPlusDialog.this.device.updateVisibilityStatus(recordSet, true);
                                            UltraDuoPlusDialog.this.application.updateAllTabs(true);
                                        }
                                        catch (DataInconsitsentException e) {
                                            log.log(Level.SEVERE, e.getMessage(), e);
                                            UltraDuoPlusDialog.this.application.openMessageDialogAsync(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGT2338"));
                                            GDE.display.asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (UltraDuoPlusDialog.this.dialogShell != null && !UltraDuoPlusDialog.this.dialogShell.isDisposed() && graphicsDataButton != null && !graphicsDataButton.isDisposed()) {
                                                        UltraDuoPlusDialog.this.dialogShell.setCursor(SWTResourceManager.getCursor((int)0));
                                                        graphicsDataButton.setEnabled(true);
                                                        cycleDataButton.setEnabled(true);
                                                    }
                                                }
                                            });
                                        }
                                        catch (Exception e2) {
                                            log.log(Level.SEVERE, e2.getMessage(), e2);
                                            UltraDuoPlusDialog.this.application.openMessageDialogAsync(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGT2336"));
                                            {
                                                catch (Throwable throwable) {
                                                    GDE.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                                                    throw throwable;
                                                }
                                            }
                                            GDE.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                                        }
                                    }
                                    GDE.display.asyncExec(new /* invalid duplicate definition of identical inner class */);
                                }
                            };
                            akkuDataGatherer.start();
                        }
                    });
                    this.graphicsDataProgressBar = new ProgressBar(this.memoryDataComposite, 0);
                    FormData graphicsDataProgressBarLData = new FormData();
                    graphicsDataProgressBarLData.height = 15;
                    graphicsDataProgressBarLData.left = new FormAttachment(0, 1000, 150);
                    graphicsDataProgressBarLData.right = new FormAttachment(1000, 1000, -150);
                    graphicsDataProgressBarLData.bottom = new FormAttachment(1000, 1000, -15);
                    this.graphicsDataProgressBar.setLayoutData((Object)graphicsDataProgressBarLData);
                    this.graphicsDataProgressBar.setMinimum(0);
                    this.graphicsDataProgressBar.setMinimum(100);
                    this.mainTabFolder.setSelection(1);
                    this.restoreButton = new Button(this.boundsComposite, 0x1000008);
                    FormData restoreButtonLData = new FormData();
                    restoreButtonLData.width = 118;
                    restoreButtonLData.height = GDE.IS_MAC ? 33 : 30;
                    restoreButtonLData.left = new FormAttachment(0, 1000, 165);
                    restoreButtonLData.bottom = new FormAttachment(1000, 1000, -8);
                    this.restoreButton.setLayoutData((Object)restoreButtonLData);
                    this.restoreButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.restoreButton.setText(Messages.getString((String)"GDE_MSGT2284"));
                    this.restoreButton.setEnabled(false);
                    this.restoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "restoreButton.widgetSelected, event=" + String.valueOf(evt));
                            FileDialog fileDialog = UltraDuoPlusDialog.this.application.openFileOpenDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGT2284"), new String[]{"*.xml", "*"}, UltraDuoPlusDialog.this.settings.getDataFilePath(), "", 4);
                            if (fileDialog.getFileName().length() > 4) {
                                try {
                                    UltraDuoPlusDialog.this.setBackupRetoreButtons(false);
                                    UltraDuoPlusDialog.this.dialogShell.setCursor(SWTResourceManager.getCursor((int)1));
                                    Unmarshaller unmarshaller = UltraDuoPlusDialog.this.jc.createUnmarshaller();
                                    unmarshaller.setSchema(UltraDuoPlusDialog.this.schema);
                                    UltraDuoPlusDialog.this.mergeUltraDuoPlusSetup((UltraDuoPlusType)unmarshaller.unmarshal(new File(fileDialog.getFilterPath() + GDE.FILE_SEPARATOR + fileDialog.getFileName())));
                                    UltraDuoPlusDialog.this.synchronizerWrite = new UltraDuoPlusSychronizer(UltraDuoPlusDialog.this, UltraDuoPlusDialog.this.serialPort, UltraDuoPlusDialog.this.ultraDuoPlusSetup, UltraDuoPlusSychronizer.SYNC_TYPE.WRITE);
                                    UltraDuoPlusDialog.this.synchronizerWrite.start();
                                    UltraDuoPlusDialog.this.synchronizerWrite.join();
                                    UltraDuoPlusDialog.this.updateBatterySetup(0);
                                    if (UltraDuoPlusDialog.this.memoryCombo != null && !UltraDuoPlusDialog.this.memoryCombo.isDisposed()) {
                                        UltraDuoPlusDialog.this.memoryCombo.setItems(UltraDuoPlusDialog.this.memoryNames);
                                        UltraDuoPlusDialog.this.memoryCombo.select(0);
                                    }
                                }
                                catch (Exception e) {
                                    log.log(Level.SEVERE, e.getMessage(), e);
                                    if (e.getCause() instanceof FileNotFoundException) {
                                        UltraDuoPlusDialog.this.ultraDuoPlusSetup = new ObjectFactory().createUltraDuoPlusType();
                                        List<MemoryType> cellMemories = UltraDuoPlusDialog.this.ultraDuoPlusSetup.getMemory();
                                        if (cellMemories.size() < numberMemories) {
                                            for (int i = 0; i < numberMemories; ++i) {
                                                MemoryType cellMemory = new ObjectFactory().createMemoryType();
                                                cellMemory.setSetupData(new ObjectFactory().createMemoryTypeSetupData());
                                                cellMemories.add(cellMemory);
                                            }
                                        }
                                    } else {
                                        UltraDuoPlusDialog.this.application.openMessageDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGE0007", (Object[])new String[]{e.getMessage()}));
                                    }
                                }
                                finally {
                                    UltraDuoPlusDialog.this.dialogShell.setCursor(SWTResourceManager.getCursor((int)0));
                                    UltraDuoPlusDialog.this.setBackupRetoreButtons(true);
                                }
                            }
                        }
                    });
                    this.backupButton = new Button(this.boundsComposite, 0x1000008);
                    FormData backupButtonLData = new FormData();
                    backupButtonLData.width = 118;
                    backupButtonLData.height = GDE.IS_MAC ? 33 : 30;
                    backupButtonLData.left = new FormAttachment(0, 1000, 29);
                    backupButtonLData.bottom = new FormAttachment(1000, 1000, -8);
                    this.backupButton.setLayoutData((Object)backupButtonLData);
                    this.backupButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.backupButton.setText(Messages.getString((String)"GDE_MSGT2286"));
                    this.backupButton.setEnabled(false);
                    this.backupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "backupButton.widgetSelected, event=" + String.valueOf(evt));
                            FileDialog fileDialog = UltraDuoPlusDialog.this.application.prepareFileSaveDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGT2285"), new String[]{"*.xml", "*"}, UltraDuoPlusDialog.this.settings.getDataFilePath(), StringHelper.getDateAndTime((String)"yyyy-MM-dd-HH-mm-ss") + "_" + UltraDuoPlusDialog.this.device.getName() + UltraDuoPlusDialog.this.ultraDuoPlusSetup.getIdentifierName());
                            String configFilePath = fileDialog.open();
                            if (configFilePath != null && fileDialog.getFileName().length() > 4) {
                                if (FileUtils.checkFileExist((String)configFilePath) && 64 != UltraDuoPlusDialog.this.application.openYesNoMessageDialog(UltraDuoPlusDialog.this.dialogShell, Messages.getString((String)"GDE_MSGI0007", (Object[])new Object[]{configFilePath}))) {
                                    return;
                                }
                                UltraDuoPlusDialog.this.saveConfigUDP(configFilePath);
                            }
                        }
                    });
                    this.closeButton = new Button(this.boundsComposite, 0x1000008);
                    FormData writeButtonLData = new FormData();
                    writeButtonLData.width = 118;
                    writeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                    writeButtonLData.bottom = new FormAttachment(1000, 1000, -8);
                    writeButtonLData.right = new FormAttachment(1000, 1000, -21);
                    this.closeButton.setLayoutData((Object)writeButtonLData);
                    this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                    this.closeButton.setText(Messages.getString((String)"GDE_MSGT2287"));
                    this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "closeButton.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.dialogShell.dispose();
                        }
                    });
                    this.helpButton = new Button(this.boundsComposite, 0x1000008);
                    this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                    FormData LoadButtonLData = new FormData();
                    LoadButtonLData.width = 118;
                    LoadButtonLData.height = GDE.IS_MAC ? 33 : 30;
                    LoadButtonLData.bottom = new FormAttachment(1000, 1000, -8);
                    LoadButtonLData.right = new FormAttachment(1000, 1000, -158);
                    this.helpButton.setLayoutData((Object)LoadButtonLData);
                    this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent evt) {
                            log.finest(() -> "helpButton.widgetSelected, event=" + String.valueOf(evt));
                            UltraDuoPlusDialog.this.application.openHelpDialog(UltraDuoPlusDialog.DEVICE_JAR_NAME, "HelpInfo.html");
                        }
                    });
                    this.boundsComposite.addPaintListener(new PaintListener(this){

                        public void paintControl(PaintEvent evt) {
                            log.log(Level.FINER, "boundsComposite.paintControl() " + String.valueOf(evt));
                        }
                    });
                    this.application.setCursor(SWTResourceManager.getCursor((int)0));
                    this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 300, 30));
                    this.dialogShell.open();
                    this.lastMemorySelectionIndex = -1;
                    this.lastCellSelectionIndex = -1;
                    this.updateBaseSetup();
                    this.memoryCombo.notifyListeners(13, new Event());
                } else {
                    this.application.setCursor(SWTResourceManager.getCursor((int)0));
                    this.dialogShell.setVisible(true);
                    this.dialogShell.setActive();
                    this.lastMemorySelectionIndex = -1;
                    this.lastCellSelectionIndex = -1;
                    this.updateBaseSetup();
                    this.memoryCombo.notifyListeners(13, new Event());
                }
                Display display = this.dialogShell.getDisplay();
                log.log(Level.TIME, "open dialog time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - openStartTime)));
                while (!this.dialogShell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                return;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return;
            }
        }
        this.application.openMessageDialogAsync(null, Messages.getString((String)"GDE_MSGE0010"));
        this.application.getDeviceSelectionDialog().open();
        return;
        finally {
            if (!GDE.shell.isDisposed()) {
                this.application.setCursor(SWTResourceManager.getCursor((int)0));
                this.application.resetShellIcon();
                if (this.serialPort != null && this.serialPort.isConnected()) {
                    try {
                        this.serialPort.write(UltramatSerialPort.RESET);
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        this.serialPort.close();
                    }
                }
            }
        }
    }

    private void initStepChargeTab() {
        this.stepChargeTabItem = new CTabItem(this.chargeTypeTabFolder, 0, 1);
        this.stepChargeTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
        this.stepChargeTabItem.setText(Messages.getString((String)"GDE_MSGT2342"));
        this.stepChargeComposite = new StepChargeComposite((Composite)this.chargeTypeTabFolder, 2560);
        FillLayout scrolledMemoryCompositeLayout = new FillLayout();
        this.stepChargeComposite.setLayout((Layout)scrolledMemoryCompositeLayout);
        this.stepChargeTabItem.setControl((Control)this.stepChargeComposite);
        if (this.stepChargeTabItem.getListeners(13).length == 0) {
            this.stepChargeComposite.addListener(13, this.memoryParameterChangeListener);
        }
    }

    private void createUltraDuoPlusSetup(String useDeviceIdentifierName) {
        this.ultraDuoPlusSetup = new ObjectFactory().createUltraDuoPlusType();
        List<MemoryType> cellMemories = this.ultraDuoPlusSetup.getMemory();
        if (cellMemories.size() < numberMemories) {
            for (int i = 0; i < numberMemories; ++i) {
                MemoryType cellMemory = new ObjectFactory().createMemoryType();
                cellMemory.setSetupData(new ObjectFactory().createMemoryTypeSetupData());
                cellMemories.add(cellMemory);
            }
        }
        this.ultraDuoPlusSetup.setIdentifierName(useDeviceIdentifierName);
    }

    private void updateBaseSetup() throws IOException, TimeOutException, SerialPortException {
        int i;
        log.finest(() -> "entry - ");
        if (this.ultraDuoPlusSetup != null) {
            if (this.ultraDuoPlusSetup.getChannelData1() == null || !this.ultraDuoPlusSetup.getChannelData1().isSynced()) {
                UltraDuoPlusType.ChannelData1 channelData1 = new ObjectFactory().createUltraDuoPlusTypeChannelData1();
                channelData1.setValue(this.serialPort.readChannelData(1));
                this.ultraDuoPlusSetup.setChannelData1(channelData1);
            }
            if (!(this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45 || this.ultraDuoPlusSetup.getChannelData2() != null && this.ultraDuoPlusSetup.getChannelData2().isSynced())) {
                UltraDuoPlusType.ChannelData2 channelData2 = new ObjectFactory().createUltraDuoPlusTypeChannelData2();
                channelData2.setValue(this.serialPort.readChannelData(2));
                this.ultraDuoPlusSetup.setChannelData2(channelData2);
            }
            this.device.convert2IntArray(this.channelValues1, this.ultraDuoPlusSetup.channelData1.getValue());
            if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                this.device.convert2IntArray(this.channelValues2, this.ultraDuoPlusSetup.channelData2.getValue());
            }
            if (log.isLoggable(Level.FINEST)) {
                int i2;
                StringBuffer sb = new StringBuffer();
                for (i2 = 0; i2 < UltramatSerialPort.SIZE_CHANNEL_1_SETUP; ++i2) {
                    sb.append(this.channelValues1[i2]).append("[").append(i2).append("], ");
                }
                sb.append(" : ");
                for (i2 = 0; this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 && i2 < 4; ++i2) {
                    sb.append(this.channelValues2[i2]).append("[").append(i2).append("], ");
                }
                log.finest(() -> sb.toString());
            }
            if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                log.finest(() -> "add handler");
                this.baseDeviceSetupGroup2.addListener(13, new Listener(){

                    public void handleEvent(Event evt) {
                        log.finest(() -> "baseDeviceSetupComposite2.handleEvent, channelValues2[" + evt.index + "] changed");
                        UltraDuoPlusType.ChannelData2 value = new UltraDuoPlusType.ChannelData2();
                        value.setValue(StringHelper.integer2Hex4ByteString((int[])UltraDuoPlusDialog.this.channelValues2));
                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.setChannelData2(value);
                        UltraDuoPlusDialog.this.ultraDuoPlusSetup.getChannelData2().setChanged(true);
                    }
                });
            }
        }
        for (i = 0; i < UltramatSerialPort.SIZE_CHANNEL_1_SETUP; ++i) {
            if (this.channelParameters[i] == null) continue;
            this.channelParameters[i].setSliderSelection(this.channelValues1[i]);
        }
        for (i = 0; this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 && i < 4; ++i) {
            if (this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + i] == null) continue;
            this.channelParameters[UltramatSerialPort.SIZE_CHANNEL_1_SETUP + i].setSliderSelection(this.channelValues2[i]);
        }
        log.finest(() -> "exit - ");
    }

    private void updateBatterySetup(int memoryNumber) {
        log.log(Level.FINER, "entry - " + memoryNumber);
        try {
            if (this.chargeGroup != null && !this.chargeGroup.isDisposed()) {
                log.finest(() -> "remove event handler");
                this.memorySelectComposite.removeListener(13, this.memoryParameterChangeListener);
                this.chargeGroup.removeListener(13, this.memoryParameterChangeListener);
                this.dischargeGroup.removeListener(13, this.memoryParameterChangeListener);
                this.cycleGroup.removeListener(13, this.memoryParameterChangeListener);
            }
            if (this.stepChargeComposite != null && !this.stepChargeComposite.isDisposed()) {
                this.stepChargeComposite.removeListener(13, this.memoryParameterChangeListener);
            }
            if (this.ultraDuoPlusSetup != null && this.ultraDuoPlusSetup.getMemory() != null) {
                i = 0;
                while (i < numberMemories) {
                    if (this.ultraDuoPlusSetup.getMemory().get(i).isSynced()) {
                        this.memoryNames[i] = String.format(STRING_FORMAT_02d_s, i + 1, this.ultraDuoPlusSetup.getMemory().get(i).getName());
                    } else if (this.ultraDuoPlusSetup.getMemory().get(i) != null && this.ultraDuoPlusSetup.getMemory().get(i).getName() != null) {
                        this.memoryNames[i] = String.format(STRING_FORMAT_02d_s, i + 1, this.ultraDuoPlusSetup.getMemory().get(i).getName());
                    } else {
                        WaitTimer.delay((long)100L);
                        continue;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "-------> [" + i + "] " + this.memoryNames[i]);
                    }
                    ++i;
                }
                if (this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getSetupData() != null && !this.ultraDuoPlusSetup.getMemory().get(memoryNumber + 1).getSetupData().isSynced()) {
                    this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getSetupData().setValue(this.serialPort.readMemorySetup(memoryNumber + 1));
                }
                this.memoryValues = this.device.convert2IntArray(this.memoryValues, this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getSetupData().getValue());
                switch (this.device.getDeviceTypeIdentifier()) {
                    case UltraDuoPlus50: 
                    case UltraDuoPlus60: {
                        if (this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getStepChargeData() != null && !this.ultraDuoPlusSetup.getMemory().get(memoryNumber + 1).getStepChargeData().isSynced()) {
                            this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getStepChargeData().setValue(this.serialPort.readMemoryStepChargeSetup(memoryNumber + 1));
                        }
                        this.memoryStepValues = this.device.convert2IntArray(this.memoryStepValues, this.ultraDuoPlusSetup.getMemory().get(memoryNumber).getStepChargeData().getValue());
                        break;
                    }
                }
            } else {
                for (i = 0; i < numberMemories; ++i) {
                    this.memoryNames[i] = String.format("%02d - NEW-BATT-NAME", i + 1);
                }
                this.memoryValues[0] = 0;
                this.memoryValues[1] = 4;
                this.memoryValues[2] = 2000;
                this.memoryValues[3] = 0;
                this.memoryValues[4] = 1;
                this.memoryValues[5] = 1;
            }
            if (log.isLoggable(Level.FINE)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
                    sb.append(String.format("%04d", this.memoryValues[i])).append("[").append(i).append("], ");
                }
                log.log(Level.FINE, sb.toString());
            }
            if (this.memoryParameters[0] != null && !this.memoryParameters[0].getSlider().isDisposed()) {
                this.updateBatteryMemoryParameter(this.memoryValues[0]);
            }
            for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
                if (this.memoryParameters[i] == null) continue;
                this.memoryParameters[i].setSliderSelection(this.memoryValues[i]);
            }
            if (this.chargeGroup != null && !this.chargeGroup.isDisposed()) {
                log.finest(() -> "add event handler");
                this.memorySelectComposite.addListener(13, this.memoryParameterChangeListener);
                this.chargeGroup.addListener(13, this.memoryParameterChangeListener);
                this.dischargeGroup.addListener(13, this.memoryParameterChangeListener);
                this.cycleGroup.addListener(13, this.memoryParameterChangeListener);
            }
            if (this.stepChargeComposite != null && !this.stepChargeComposite.isDisposed() && this.stepChargeComposite.getListeners(13).length == 0) {
                this.stepChargeComposite.addListener(13, this.memoryParameterChangeListener);
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        log.log(Level.FINER, "exit - ");
    }

    private void updateBatteryMemoryParameter(int selectionIndex) {
        log.finest(() -> "entry - ");
        if (this.lastCellSelectionIndex != selectionIndex) {
            log.log(Level.FINE, "cell type changed to : " + cellTypeNames[this.memoryValues[0]]);
            this.memoryValues[0] = selectionIndex;
            switch (this.memoryValues[0]) {
                case 0: {
                    if (this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.memoryParameters[1].updateValueRange("1 ~ 30", 1, 14, 0);
                    } else {
                        this.memoryParameters[1].updateValueRange("1 ~ 18", 1, 18, 0);
                    }
                    this.memoryParameters[2].updateValueRange("100 ~ 9900 mAh", 100, 9900, -100);
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[9] = this.memoryParameters[9] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 9, "", Messages.getString((String)"GDE_MSGT2279"), 175, Messages.getString((String)"GDE_MSGT2312"), 220, false, 50, 150, 0, 550) : this.memoryParameters[9];
                    if (this.memoryParameters[7] == null) {
                        this.memoryParameters[7] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 7, "", Messages.getString((String)"GDE_MSGT2277"), 175, "5 ~ 25mV", 220, false, 50, 150, 5, 25, 0, false);
                    } else {
                        this.memoryParameters[7].updateValueRange("5 ~ 25mV", 5, 25, 0);
                    }
                    this.memoryParameters[8] = this.memoryParameters[8] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 8, "", Messages.getString((String)"GDE_MSGT2278"), 175, "1 ~ 20min", 220, false, 50, 150, 1, 20) : this.memoryParameters[8];
                    this.memoryParameters[13] = this.memoryParameters[13] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 13, "", Messages.getString((String)"GDE_MSGT2280"), 175, "1 ~ 5", 220, false, 50, 150, 1, 5) : this.memoryParameters[13];
                    this.memoryParameters[14] = this.memoryParameters[14] != null ? this.memoryParameters[14].dispose() : null;
                    this.memoryParameters[15] = this.memoryParameters[15] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 15, "", Messages.getString((String)"GDE_MSGT2281"), 175, "1 ~ 30min", 220, false, 50, 150, 1, 30) : this.memoryParameters[15];
                    this.memoryParameters[16] = this.memoryParameters[16] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 16, Messages.getString((String)"GDE_MSGT2282"), 175, Messages.getString((String)"GDE_MSGT2241") + " - " + Messages.getString((String)"GDE_MSGT2240"), 220, offOnType, 50, 150) : this.memoryParameters[16];
                    this.memoryParameters[18].updateValueRange("100 ~ 1300 mV", 100, 1300, -100);
                    this.memoryParameters[21] = this.memoryParameters[21] == null ? new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 21, "", Messages.getString((String)"GDE_MSGT2283"), 175, "1100 ~ 1300 mV", 220, true, 50, 150, 1100, 1300, -1100, false) : this.memoryParameters[21];
                    this.memoryParameters[26] = this.memoryParameters[26] != null ? this.memoryParameters[26].dispose() : null;
                    this.chargeSelectHeight = 10 * this.parameterSelectHeight;
                    this.dischargeSelectHeight = 5 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2310"), 10, 165);
                    this.cycleGroup.setVisible(true);
                    break;
                }
                case 1: {
                    if (this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.memoryParameters[1].updateValueRange("1 ~ 30", 1, 14, 0);
                    } else {
                        this.memoryParameters[1].updateValueRange("1 ~ 18", 1, 18, 0);
                    }
                    this.memoryParameters[2].updateValueRange("100 ~ 9900 mAh", 100, 9900, -100);
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[9] = this.memoryParameters[9] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 9, "", Messages.getString((String)"GDE_MSGT2279"), 175, Messages.getString((String)"GDE_MSGT2312"), 220, false, 50, 150, 0, 550) : this.memoryParameters[9];
                    if (this.memoryParameters[7] == null) {
                        this.memoryParameters[7] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 7, "", Messages.getString((String)"GDE_MSGT2277"), 175, "0 ~ 15mV", 220, false, 50, 150, 0, 15, 0, false);
                    } else {
                        this.memoryParameters[7].updateValueRange("0 ~ 15mV", 0, 15, 0);
                    }
                    this.memoryParameters[8] = this.memoryParameters[8] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 8, "", Messages.getString((String)"GDE_MSGT2278"), 175, "1 ~ 20min", 220, false, 50, 150, 1, 20) : this.memoryParameters[8];
                    this.memoryParameters[13] = this.memoryParameters[13] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 13, "", Messages.getString((String)"GDE_MSGT2280"), 175, "1 ~ 5", 220, false, 50, 150, 1, 5) : this.memoryParameters[13];
                    this.memoryParameters[14] = this.memoryParameters[14] != null ? this.memoryParameters[14].dispose() : null;
                    this.memoryParameters[15] = this.memoryParameters[15] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 15, "", Messages.getString((String)"GDE_MSGT2281"), 175, "1 ~ 30min", 220, false, 50, 150, 1, 30) : this.memoryParameters[15];
                    this.memoryParameters[16] = this.memoryParameters[16] == null ? new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 16, Messages.getString((String)"GDE_MSGT2282"), 175, Messages.getString((String)"GDE_MSGT2241") + " - " + Messages.getString((String)"GDE_MSGT2240"), 220, offOnType, 50, 150) : this.memoryParameters[16];
                    this.memoryParameters[18].updateValueRange("100 ~ 1300 mV", 100, 1300, -100);
                    this.memoryParameters[21] = this.memoryParameters[21] == null ? new ParameterConfigControl((Composite)this.dischargeGroup, this.memoryValues, 21, "", Messages.getString((String)"GDE_MSGT2283"), 175, "1100 ~ 1300 mV", 220, true, 50, 150, 1100, 1300, -1100, false) : this.memoryParameters[21];
                    this.memoryParameters[26] = this.memoryParameters[26] != null ? this.memoryParameters[26].dispose() : null;
                    this.chargeSelectHeight = 10 * this.parameterSelectHeight;
                    this.dischargeSelectHeight = 5 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2310"), 10, 165);
                    this.cycleGroup.setVisible(true);
                    break;
                }
                case 2: {
                    if (this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.memoryParameters[1].updateValueRange("1 ~ 14", 1, 14, 0);
                    } else {
                        this.memoryParameters[1].updateValueRange("1 ~ 7", 1, 7, 0);
                    }
                    this.memoryParameters[2].updateValueRange("100 ~ 65000 mAh", 100, 65000, -100);
                    this.memoryParameters[7] = this.memoryParameters[7] != null ? this.memoryParameters[7].dispose() : null;
                    this.memoryParameters[8] = this.memoryParameters[8] != null ? this.memoryParameters[8].dispose() : null;
                    this.memoryParameters[9] = this.memoryParameters[9] != null ? this.memoryParameters[9].dispose() : null;
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[13] = this.memoryParameters[13] != null ? this.memoryParameters[13].dispose() : null;
                    if (this.memoryParameters[14] == null) {
                        this.memoryParameters[14] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2267"), 175, "3600 ~ 4200 mV", 220, true, 50, 150, 3600, 4200, -3600, false);
                    } else {
                        this.memoryParameters[14].updateValueRange("3600 ~ 4200 mV", 3600, 4200, -3600);
                    }
                    this.memoryParameters[15] = this.memoryParameters[15] != null ? this.memoryParameters[15].dispose() : null;
                    this.memoryParameters[16] = this.memoryParameters[16] != null ? this.memoryParameters[16].dispose() : null;
                    this.memoryParameters[18].updateValueRange("2500 ~ 4100 mV", 2500, 4100, -2500);
                    ParameterConfigControl parameterConfigControl2 = this.memoryParameters[21] = this.memoryParameters[21] != null ? this.memoryParameters[21].dispose() : null;
                    if (this.memoryParameters[26] == null) {
                        this.memoryParameters[26] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 26, "", Messages.getString((String)"GDE_MSGT2276"), 175, "3600 ~ 3900 mV", 220, true, 50, 150, 3600, 3900, -3600, false);
                    } else {
                        this.memoryParameters[26].updateValueRange("3600 ~ 3900 mV", 3600, 3900, -3600);
                    }
                    this.chargeSelectHeight = 6 * this.parameterSelectHeight + 10;
                    this.dischargeSelectHeight = 4 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2314"), 10, 135);
                    this.cycleGroup.setVisible(true);
                    break;
                }
                case 3: {
                    if (this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.memoryParameters[1].updateValueRange("1 ~ 14", 1, 14, 0);
                    } else {
                        this.memoryParameters[1].updateValueRange("1 ~ 7", 1, 7, 0);
                    }
                    this.memoryParameters[2].updateValueRange("100 ~ 65000 mAh", 100, 65000, -100);
                    this.memoryParameters[7] = this.memoryParameters[7] != null ? this.memoryParameters[7].dispose() : null;
                    this.memoryParameters[8] = this.memoryParameters[8] != null ? this.memoryParameters[8].dispose() : null;
                    this.memoryParameters[9] = this.memoryParameters[9] != null ? this.memoryParameters[9].dispose() : null;
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[13] = this.memoryParameters[13] != null ? this.memoryParameters[13].dispose() : null;
                    if (this.memoryParameters[14] == null) {
                        this.memoryParameters[14] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2267"), 175, "3700 ~ 4300 mV", 220, true, 50, 150, 3700, 4300, -3700, false);
                    } else {
                        this.memoryParameters[14].updateValueRange("3700 ~ 4300 mV", 3700, 4300, -3700);
                    }
                    this.memoryParameters[15] = this.memoryParameters[15] != null ? this.memoryParameters[15].dispose() : null;
                    this.memoryParameters[16] = this.memoryParameters[16] != null ? this.memoryParameters[16].dispose() : null;
                    this.memoryParameters[18].updateValueRange("2500 ~ 4200 mV", 2500, 4200, -2500);
                    ParameterConfigControl parameterConfigControl3 = this.memoryParameters[21] = this.memoryParameters[21] != null ? this.memoryParameters[21].dispose() : null;
                    if (this.memoryParameters[26] == null) {
                        this.memoryParameters[26] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 26, "", Messages.getString((String)"GDE_MSGT2276"), 175, "3700 ~ 4000 mV", 220, true, 50, 150, 3700, 4000, -3700, false);
                    } else {
                        this.memoryParameters[26].updateValueRange("3700 ~ 4000 mV", 3700, 4000, -3700);
                    }
                    this.chargeSelectHeight = 6 * this.parameterSelectHeight + 10;
                    this.dischargeSelectHeight = 4 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2314"), 10, 135);
                    this.cycleGroup.setVisible(true);
                    break;
                }
                case 4: {
                    if (this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus40 || this.device.getDeviceTypeIdentifier() == Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                        this.memoryParameters[1].updateValueRange("1 ~ 14", 1, 14, 0);
                    } else {
                        this.memoryParameters[1].updateValueRange("1 ~ 7", 1, 7, 0);
                    }
                    this.memoryParameters[2].updateValueRange("100 ~ 65000 mAh", 100, 65000, -100);
                    this.memoryParameters[7] = this.memoryParameters[7] != null ? this.memoryParameters[7].dispose() : null;
                    this.memoryParameters[8] = this.memoryParameters[8] != null ? this.memoryParameters[8].dispose() : null;
                    this.memoryParameters[9] = this.memoryParameters[9] != null ? this.memoryParameters[9].dispose() : null;
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[13] = this.memoryParameters[13] != null ? this.memoryParameters[13].dispose() : null;
                    if (this.memoryParameters[14] == null) {
                        this.memoryParameters[14] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2267"), 175, "3300 ~ 3700 mV", 220, true, 50, 150, 3300, 3700, -3300, false);
                    } else {
                        this.memoryParameters[14].updateValueRange("3300 ~ 3700 mV", 3300, 3700, -3300);
                    }
                    this.memoryParameters[15] = this.memoryParameters[15] != null ? this.memoryParameters[15].dispose() : null;
                    this.memoryParameters[16] = this.memoryParameters[16] != null ? this.memoryParameters[16].dispose() : null;
                    this.memoryParameters[18].updateValueRange("2000 ~ 3700 mV", 2000, 3700, -2000);
                    ParameterConfigControl parameterConfigControl4 = this.memoryParameters[21] = this.memoryParameters[21] != null ? this.memoryParameters[21].dispose() : null;
                    if (this.memoryParameters[26] == null) {
                        this.memoryParameters[26] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 26, "", Messages.getString((String)"GDE_MSGT2276"), 175, "3300 ~ 3600 mV", 220, true, 50, 150, 3300, 3600, -3300, false);
                    } else {
                        this.memoryParameters[26].updateValueRange("3300 ~ 3600 mV", 3300, 3600, -3300);
                    }
                    this.chargeSelectHeight = 6 * this.parameterSelectHeight + 10;
                    this.dischargeSelectHeight = 4 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2314"), 10, 135);
                    this.cycleGroup.setVisible(true);
                    break;
                }
                case 5: {
                    this.memoryParameters[1].updateValueRange("1 ~ 6, 12", 1, 12, 0);
                    this.memoryParameters[2].updateValueRange("500 ~ 65000 mAh", 500, 65000, -500);
                    this.memoryParameters[7] = this.memoryParameters[7] != null ? this.memoryParameters[7].dispose() : null;
                    this.memoryParameters[8] = this.memoryParameters[8] != null ? this.memoryParameters[8].dispose() : null;
                    this.memoryParameters[9] = this.memoryParameters[9] != null ? this.memoryParameters[9].dispose() : null;
                    ParameterConfigControl parameterConfigControl = this.memoryParameters[13] = this.memoryParameters[13] != null ? this.memoryParameters[13].dispose() : null;
                    if (this.memoryParameters[14] == null) {
                        this.memoryParameters[14] = new ParameterConfigControl((Composite)this.chargeGroup, this.memoryValues, 14, "", Messages.getString((String)"GDE_MSGT2267"), 175, "1800 ~ 2450 mV", 220, true, 50, 150, 1800, 2450, -1800, false);
                    } else {
                        this.memoryParameters[14].updateValueRange("1800 ~ 2450 mV", 1800, 2450, -1800);
                    }
                    this.memoryParameters[15] = this.memoryParameters[15] != null ? this.memoryParameters[15].dispose() : null;
                    this.memoryParameters[16] = this.memoryParameters[16] != null ? this.memoryParameters[16].dispose() : null;
                    this.memoryParameters[18].updateValueRange("1500 ~ 2000 mV", 1500, 2000, -1500);
                    this.memoryParameters[21] = this.memoryParameters[21] != null ? this.memoryParameters[21].dispose() : null;
                    this.memoryParameters[26] = this.memoryParameters[26] != null ? this.memoryParameters[26].dispose() : null;
                    this.chargeSelectHeight = 5 * this.parameterSelectHeight + 10;
                    this.dischargeSelectHeight = 4 * this.parameterSelectHeight;
                    this.memoryParameters[11].updateValueRange(Messages.getString((String)"GDE_MSGT2314"), 10, 135);
                    this.cycleGroup.setVisible(false);
                }
            }
            this.chargeGroup.setSize(this.scrolledchargeComposite.getClientArea().width, this.chargeSelectHeight);
            this.chargeGroup.layout(true);
            this.scrolledchargeComposite.layout(true);
            switch (this.device.getDeviceTypeIdentifier()) {
                case UltraDuoPlus50: 
                case UltraDuoPlus60: {
                    if (selectionIndex == 1) {
                        if (this.stepChargeTabItem == null || this.stepChargeTabItem.isDisposed()) {
                            this.initStepChargeTab();
                        }
                        this.stepChargeComposite.setStepChargeValues(this.memoryValues[2], this.memoryValues[6], this.memoryStepValues);
                        break;
                    }
                    if (this.stepChargeTabItem != null && !this.stepChargeTabItem.isDisposed()) {
                        this.stepChargeTabItem.dispose();
                    }
                    this.stepChargeTabItem = null;
                    break;
                }
            }
            this.dischargeGroup.setLayoutData((Object)new RowData(this.dischargeCycleComposite.getClientArea().width - 18, this.dischargeSelectHeight));
            this.dischargeGroup.layout(true);
            this.dischargeCycleComposite.layout(true);
            this.lastCellSelectionIndex = this.memoryValues[0];
        } else if (this.memoryValues[0] == 1) {
            switch (this.device.getDeviceTypeIdentifier()) {
                case UltraDuoPlus50: 
                case UltraDuoPlus60: {
                    if (this.stepChargeTabItem == null || this.stepChargeTabItem.isDisposed()) {
                        this.initStepChargeTab();
                    }
                    this.stepChargeComposite.setStepChargeValues(this.memoryValues[2], this.memoryValues[6], this.memoryStepValues);
                    break;
                }
            }
        }
        log.finest(() -> "exit - ");
    }

    private void updateBatteryParameterValues(int updateIndex) {
        log.finest(() -> "entry - ");
        if (updateIndex == 2) {
            this.memoryValues[6] = this.memoryValues[2];
            this.memoryValues[17] = this.memoryValues[2];
        }
        if (updateIndex != 6) {
            this.memoryValues[20] = 105;
            this.memoryValues[23] = 1;
            this.memoryValues[24] = 30;
            this.memoryValues[25] = 10;
            switch (this.memoryValues[0]) {
                case 0: {
                    this.memoryValues[11] = 120;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 50 : 82;
                    this.memoryValues[12] = Double.valueOf(90.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    this.memoryValues[9] = updateIndex == 0 ? 550 : this.memoryValues[9];
                    this.memoryValues[7] = 7;
                    this.memoryValues[8] = 3;
                    this.memoryValues[13] = 1;
                    this.memoryValues[15] = 3;
                    this.memoryValues[16] = 1;
                    this.memoryValues[18] = 900;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 65 : 97;
                    this.memoryValues[21] = 1200;
                    break;
                }
                case 1: {
                    if (!(updateIndex != 2 || this.stepChargeTabItem == null && this.stepChargeTabItem.isDisposed())) {
                        this.memoryStepValues[7] = 0;
                        this.memoryStepValues[3] = 0;
                        this.stepChargeComposite.setStepChargeValues(this.memoryValues[2], this.memoryValues[6], this.memoryStepValues);
                        this.stepChargeComposite.getStepChargeValues(this.memoryStepValues);
                        this.chargeGroup.notifyListeners(13, new Event());
                    }
                    this.memoryValues[11] = 120;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 50 : 82;
                    this.memoryValues[12] = Double.valueOf(90.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    this.memoryValues[9] = updateIndex == 0 ? 0 : this.memoryValues[9];
                    this.memoryValues[7] = 5;
                    this.memoryValues[8] = 3;
                    this.memoryValues[13] = 1;
                    this.memoryValues[15] = 3;
                    this.memoryValues[16] = 1;
                    this.memoryValues[18] = 1000;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 65 : 97;
                    this.memoryValues[21] = 1200;
                    break;
                }
                case 2: {
                    this.memoryValues[11] = 105;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 45 : 77;
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    this.memoryValues[9] = 0;
                    this.memoryValues[14] = 4100;
                    this.memoryValues[26] = 3800;
                    this.memoryValues[18] = 3000;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 55 : 87;
                    break;
                }
                case 3: {
                    this.memoryValues[11] = 105;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 45 : 77;
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    this.memoryValues[9] = 0;
                    this.memoryValues[14] = 4200;
                    this.memoryValues[26] = 3900;
                    this.memoryValues[18] = 3100;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 55 : 87;
                    break;
                }
                case 4: {
                    this.memoryValues[11] = 105;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 45 : 77;
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    this.memoryValues[9] = 0;
                    this.memoryValues[14] = 3600;
                    this.memoryValues[26] = 3500;
                    this.memoryValues[18] = 2500;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 55 : 87;
                    break;
                }
                case 5: {
                    this.memoryValues[6] = this.memoryValues[2] / 10;
                    this.memoryValues[11] = 105;
                    this.memoryValues[10] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 50 : 82;
                    this.memoryValues[12] = 905;
                    this.memoryValues[9] = this.memoryValues[2] / 10;
                    this.memoryValues[14] = 2300;
                    this.memoryValues[18] = 1800;
                    this.memoryValues[19] = (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 ? this.channelValues1[4] == 0 : this.channelValues1[0] == 0) ? 55 : 87;
                }
            }
        } else {
            switch (this.memoryValues[0]) {
                case 0: {
                    this.memoryValues[12] = Double.valueOf(90.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    break;
                }
                case 1: {
                    this.memoryValues[12] = Double.valueOf(90.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    break;
                }
                case 2: {
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    break;
                }
                case 3: {
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    break;
                }
                case 4: {
                    this.memoryValues[12] = Double.valueOf(120.0 * (1.0 * (double)this.memoryValues[2] / (double)this.memoryValues[6])).intValue();
                    break;
                }
                case 5: {
                    this.memoryValues[12] = 905;
                }
            }
        }
        this.memoryValues[12] = this.memoryValues[12] > 905 ? 905 : this.memoryValues[12];
        for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
            if (this.memoryParameters[i] == null) continue;
            this.memoryParameters[i].setSliderSelection(this.memoryValues[i]);
        }
        if (log.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < UltramatSerialPort.SIZE_MEMORY_SETUP; ++i) {
                sb.append(String.format("%04d", this.memoryValues[i])).append("[").append(i).append("], ");
            }
            log.log(Level.FINER, sb.toString());
        }
    }

    private void saveConfigUDP(String fullQualifiedFilePath) {
        try {
            long startTime = new Date().getTime();
            if (this.ultraDuoPlusSetup != null) {
                new UltraDuoPlusSychronizer(this, this.serialPort, this.ultraDuoPlusSetup, UltraDuoPlusSychronizer.SYNC_TYPE.WRITE).run();
                this.ultraDuoPlusSetup.changed = null;
                this.ultraDuoPlusSetup.getChannelData1().synced = null;
                if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45) {
                    this.ultraDuoPlusSetup.getChannelData2().synced = null;
                }
                for (MemoryType cellMemory : this.ultraDuoPlusSetup.getMemory()) {
                    cellMemory.synced = null;
                    cellMemory.changed = null;
                    cellMemory.getSetupData().synced = null;
                    cellMemory.getSetupData().changed = null;
                    if (cellMemory.getStepChargeData() != null) {
                        cellMemory.getStepChargeData().synced = null;
                        cellMemory.getStepChargeData().changed = null;
                    }
                    if (cellMemory.getTraceData() != null) {
                        cellMemory.getTraceData().synced = null;
                        cellMemory.getTraceData().changed = null;
                    }
                    if (cellMemory.getCycleData() == null) continue;
                    cellMemory.getCycleData().synced = null;
                    cellMemory.getCycleData().changed = null;
                }
                for (UltraDuoPlusType.TireHeaterData tireHeater : this.ultraDuoPlusSetup.getTireHeaterData()) {
                    tireHeater.synced = null;
                    tireHeater.changed = null;
                }
                for (UltraDuoPlusType.MotorRunData motorRunData : this.ultraDuoPlusSetup.getMotorRunData()) {
                    motorRunData.synced = null;
                    motorRunData.changed = null;
                }
                Marshaller marshaller = this.jc.createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)ULTRA_DUO_PLUS_XSD);
                marshaller.marshal((Object)this.ultraDuoPlusSetup, (OutputStream)new FileOutputStream(fullQualifiedFilePath));
                log.log(Level.TIME, "write memory setup XML time = " + StringHelper.getFormatedTime((String)"ss:SSS", (long)(new Date().getTime() - startTime)));
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            this.application.openMessageDialogAsync(this.dialogShell != null && !this.dialogShell.isDisposed() ? this.dialogShell : null, Messages.getString((String)"GDE_MSGE0007", (Object[])new String[]{e.getMessage()}));
        }
    }

    public void setBackupRetoreButtons(final boolean enable) {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            if (!(this.dialogShell.isDisposed() || this.restoreButton == null || this.backupButton == null || this.restoreButton.isDisposed() || this.backupButton.isDisposed())) {
                this.restoreButton.setEnabled(enable);
                this.backupButton.setEnabled(enable);
                this.closeButton.setEnabled(enable);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!(UltraDuoPlusDialog.this.dialogShell.isDisposed() || UltraDuoPlusDialog.this.restoreButton == null || UltraDuoPlusDialog.this.backupButton == null || UltraDuoPlusDialog.this.restoreButton.isDisposed() || UltraDuoPlusDialog.this.backupButton.isDisposed())) {
                        UltraDuoPlusDialog.this.restoreButton.setEnabled(enable);
                        UltraDuoPlusDialog.this.backupButton.setEnabled(enable);
                        UltraDuoPlusDialog.this.closeButton.setEnabled(enable);
                    }
                }
            });
        }
    }

    private void mergeUltraDuoPlusSetup(UltraDuoPlusType tmpUltraDuoPlusSetup) {
        int i;
        if (!this.ultraDuoPlusSetup.getIdentifierName().equals(tmpUltraDuoPlusSetup.getIdentifierName())) {
            this.deviceIdentifierName = (tmpUltraDuoPlusSetup.getIdentifierName() + STRING_16_BLANK).substring(0, 16);
            this.ultraDuoPlusSetup.setIdentifierName(this.deviceIdentifierName);
            this.ultraDuoPlusSetup.setChanged(true);
            this.userNameText.setText(this.deviceIdentifierName);
        }
        if (!this.ultraDuoPlusSetup.getChannelData1().getValue().equals(tmpUltraDuoPlusSetup.getChannelData1().getValue())) {
            this.ultraDuoPlusSetup.getChannelData1().setValue(tmpUltraDuoPlusSetup.getChannelData1().getValue());
            this.ultraDuoPlusSetup.getChannelData1().setChanged(true);
            this.device.convert2IntArray(this.channelValues1, this.ultraDuoPlusSetup.channelData1.getValue());
            for (i = 0; i < UltramatSerialPort.SIZE_CHANNEL_1_SETUP; ++i) {
                if (this.channelParameters[i] == null) continue;
                this.channelParameters[i].setSliderSelection(this.channelValues1[i]);
            }
        }
        if (this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus40 && this.device.getDeviceTypeIdentifier() != Ultramat.GraupnerDeviceType.UltraDuoPlus45 && !this.ultraDuoPlusSetup.getChannelData2().getValue().equals(tmpUltraDuoPlusSetup.getChannelData2().getValue())) {
            this.ultraDuoPlusSetup.getChannelData2().setValue(tmpUltraDuoPlusSetup.getChannelData2().getValue());
            this.ultraDuoPlusSetup.getChannelData2().setChanged(true);
            this.device.convert2IntArray(this.channelValues2, this.ultraDuoPlusSetup.channelData2.getValue());
            for (i = 0; i < 4; ++i) {
                if (this.channelParameters[4 + i] == null) continue;
                this.channelParameters[4 + i].setSliderSelection(this.channelValues2[i]);
            }
        }
        List<MemoryType> cellMemories = this.ultraDuoPlusSetup.getMemory();
        List<MemoryType> tmpCellMemories = tmpUltraDuoPlusSetup.getMemory();
        Iterator<MemoryType> iterator = cellMemories.iterator();
        Iterator<MemoryType> tmpIterator = tmpCellMemories.iterator();
        while (iterator.hasNext()) {
            MemoryType cellMemory = iterator.next();
            MemoryType tmpCellMemory = tmpIterator.next();
            if (!cellMemory.getName().equals(tmpCellMemory.getName())) {
                cellMemory.setName((tmpCellMemory.getName() + STRING_16_BLANK).substring(0, 16));
                cellMemory.setChanged(true);
            }
            if (tmpCellMemory.getSetupData() != null && cellMemory.getSetupData() != null && !cellMemory.getSetupData().getValue().equals(tmpCellMemory.getSetupData().getValue())) {
                cellMemory.getSetupData().setValue(tmpCellMemory.getSetupData().getValue());
                cellMemory.getSetupData().setChanged(true);
            }
            if (tmpCellMemory.getStepChargeData() == null && cellMemory.getStepChargeData() != null) {
                cellMemory.setStepChargeData(null);
            }
            if (tmpCellMemory.getStepChargeData() != null && cellMemory.getStepChargeData() == null) {
                cellMemory.setStepChargeData(new ObjectFactory().createMemoryTypeStepChargeData());
                cellMemory.getStepChargeData().setValue(tmpCellMemory.getStepChargeData().getValue());
                cellMemory.getStepChargeData().setChanged(true);
            }
            if (tmpCellMemory.getStepChargeData() != null && cellMemory.getStepChargeData() != null && !cellMemory.getStepChargeData().getValue().equals(tmpCellMemory.getStepChargeData().getValue())) {
                cellMemory.getStepChargeData().setValue(tmpCellMemory.getStepChargeData().getValue());
                cellMemory.getStepChargeData().setChanged(true);
            }
            if (tmpCellMemory.getTraceData() == null && cellMemory.getTraceData() != null) {
                cellMemory.setTraceData(null);
            }
            if (tmpCellMemory.getTraceData() != null && cellMemory.getTraceData() == null) {
                cellMemory.setTraceData(new ObjectFactory().createMemoryTypeTraceData());
                cellMemory.getTraceData().setValue(tmpCellMemory.getTraceData().getValue());
                cellMemory.getTraceData().setChanged(true);
            }
            if (tmpCellMemory.getTraceData() != null && cellMemory.getTraceData() != null && !cellMemory.getTraceData().getValue().equals(tmpCellMemory.getTraceData().getValue())) {
                cellMemory.getTraceData().setValue(tmpCellMemory.getTraceData().getValue());
                cellMemory.getTraceData().setChanged(true);
            }
            if (tmpCellMemory.getCycleData() == null && cellMemory.getCycleData() != null) {
                cellMemory.setCycleData(null);
            }
            if (tmpCellMemory.getCycleData() != null && cellMemory.getCycleData() == null) {
                cellMemory.setCycleData(new ObjectFactory().createMemoryTypeCycleData());
                cellMemory.getCycleData().setValue(tmpCellMemory.getCycleData().getValue());
                cellMemory.getCycleData().setChanged(true);
            }
            if (tmpCellMemory.getCycleData() == null || cellMemory.getCycleData() == null || cellMemory.getCycleData().getValue().equals(tmpCellMemory.getCycleData().getValue())) continue;
            cellMemory.getCycleData().setValue(tmpCellMemory.getCycleData().getValue());
            cellMemory.getCycleData().setChanged(true);
        }
        List<UltraDuoPlusType.TireHeaterData> tireHeaters = this.ultraDuoPlusSetup.getTireHeaterData();
        List<UltraDuoPlusType.TireHeaterData> tmpTireHeaters = tmpUltraDuoPlusSetup.getTireHeaterData();
        Iterator<UltraDuoPlusType.TireHeaterData> tireIterator = tireHeaters.iterator();
        Iterator<UltraDuoPlusType.TireHeaterData> tmpTireIterator = tmpTireHeaters.iterator();
        while (iterator.hasNext()) {
            UltraDuoPlusType.TireHeaterData tireHeaterData = tireIterator.next();
            UltraDuoPlusType.TireHeaterData tmpTireHeaterData = tmpTireIterator.next();
            if (tmpTireHeaterData == null && tireHeaterData != null) {
                tireHeaterData = null;
            }
            if (tmpTireHeaterData != null && tireHeaterData == null) {
                tireHeaterData = new ObjectFactory().createUltraDuoPlusTypeTireHeaterData();
                tireHeaterData.setValue(tmpTireHeaterData.getValue());
                tireHeaterData.setChanged(true);
            }
            if (tmpTireHeaterData == null || tireHeaterData == null || tireHeaterData.getValue().equals(tmpTireHeaterData.getValue())) continue;
            tireHeaterData.setValue(tmpTireHeaterData.getValue());
            tireHeaterData.setChanged(true);
        }
        List<UltraDuoPlusType.MotorRunData> motorRunDatas = this.ultraDuoPlusSetup.getMotorRunData();
        List<UltraDuoPlusType.MotorRunData> tmpMotorRunDatas = tmpUltraDuoPlusSetup.getMotorRunData();
        Iterator<UltraDuoPlusType.MotorRunData> motorRunIterator = motorRunDatas.iterator();
        Iterator<UltraDuoPlusType.MotorRunData> tmpMotorRunIterator = tmpMotorRunDatas.iterator();
        while (iterator.hasNext()) {
            UltraDuoPlusType.MotorRunData motorRunData = motorRunIterator.next();
            UltraDuoPlusType.MotorRunData tmpMotorRunData = tmpMotorRunIterator.next();
            if (tmpMotorRunData == null && motorRunData != null) {
                motorRunData = null;
            }
            if (tmpMotorRunData != null && motorRunData == null) {
                motorRunData = new ObjectFactory().createUltraDuoPlusTypeMotorRunData();
                motorRunData.setValue(tmpMotorRunData.getValue());
                motorRunData.setChanged(true);
            }
            if (tmpMotorRunData == null || motorRunData == null || motorRunData.getValue().equals(tmpMotorRunData.getValue())) continue;
            motorRunData.setValue(tmpMotorRunData.getValue());
            motorRunData.setChanged(true);
        }
    }

    public void setGraphicsDataReadProgress(final int percentage) {
        if (Thread.currentThread().threadId() == this.application.getThreadId()) {
            if (!this.dialogShell.isDisposed() && this.graphicsDataProgressBar != null && !this.graphicsDataProgressBar.isDisposed()) {
                this.graphicsDataProgressBar.setSelection(percentage);
            }
        } else {
            GDE.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!UltraDuoPlusDialog.this.dialogShell.isDisposed() && UltraDuoPlusDialog.this.graphicsDataProgressBar != null && !UltraDuoPlusDialog.this.graphicsDataProgressBar.isDisposed()) {
                        UltraDuoPlusDialog.this.graphicsDataProgressBar.setSelection(percentage);
                    }
                }
            });
        }
    }
}

