/*
 * Decompiled with CFR 0.152.
 */
package gde.device.estner;

import gde.GDE;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.device.estner.Akkumatik;
import gde.device.estner.AkkumatikDialog;
import gde.device.estner.AkkumatikSerialPort;
import gde.exception.ApplicationConfigurationException;
import gde.exception.DataInconsitsentException;
import gde.exception.SerialPortException;
import gde.exception.TimeOutException;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.TimeLine;
import java.io.IOException;
import java.util.logging.Logger;

public class GathererThread
extends Thread {
    static final String $CLASS_NAME = GathererThread.class.getName();
    static final Logger log = Logger.getLogger(GathererThread.class.getName());
    static final int WAIT_TIME_RETRYS = 3600;
    final DataExplorer application;
    final AkkumatikSerialPort serialPort;
    final Akkumatik device;
    final Channels channels;
    Channel channel;
    final int channelNumber;
    String recordSetKey1 = Messages.getString((String)"GDE_MSGT0272");
    String recordSetKey2 = Messages.getString((String)"GDE_MSGT0272");
    boolean isPortOpenedByLiveGatherer = false;
    int statusNumberCh1 = 0;
    int statusNUmberCh2 = 0;
    int retryCounter = 3600;
    boolean isCollectDataStopped = false;
    int lastNumberDisplayableRecords1 = 0;
    int lastNumberDisplayableRecords2 = 0;

    public GathererThread(DataExplorer currentApplication, Akkumatik useDevice, AkkumatikSerialPort useSerialPort, int channelConfigNumber) throws ApplicationConfigurationException, SerialPortException {
        super("dataGatherer");
        this.application = currentApplication;
        this.device = useDevice;
        this.serialPort = useSerialPort;
        this.channels = Channels.getInstance();
        this.channelNumber = channelConfigNumber;
        this.channel = (Channel)this.channels.get((Object)this.channelNumber);
        if (!this.serialPort.isConnected()) {
            this.serialPort.open();
            this.isPortOpenedByLiveGatherer = true;
        }
        this.setPriority(10);
    }

    @Override
    public void run() {
        String $METHOD_NAME = "run";
        RecordSet recordSet1 = null;
        RecordSet recordSet2 = null;
        int[] points1 = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        int[] points2 = new int[this.device.getNumberOfMeasurements(this.channelNumber)];
        boolean isProgrammExecuting1 = false;
        boolean isProgrammExecuting2 = false;
        long startCycleTime1 = 0L;
        long startCycleTime2 = 0L;
        long timeStep1 = 0L;
        long timeStep2 = 0L;
        long lastCycleTime1 = 0L;
        long lastCycleTime2 = 0L;
        boolean isCycleMode1 = false;
        boolean isCycleMode2 = false;
        Object cycleCount1 = "";
        Object cycleCount2 = "";
        String[] data = null;
        this.isCollectDataStopped = false;
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "====> entry initial time step ms = " + this.device.getTimeStep_ms());
        try {
            this.serialPort.cleanInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!this.isCollectDataStopped) {
            try {
                data = this.serialPort.getDataArray(this.serialPort.getData());
                byte[] data2Write = AkkumatikDialog.getData2Write();
                if (data2Write != null && data2Write.length > 0) {
                    this.serialPort.write(data2Write);
                }
                String processName = this.device.isCycleMode(data) ? (data[4].startsWith("-") ? Messages.getString((String)"GDE_MSGT3401") : Messages.getString((String)"GDE_MSGT3400")) : Akkumatik.PROCESS_MODE[this.device.getProcessingMode(data)];
                String processType = this.device.getProcessingPhase(data) == 10 ? Messages.getString((String)"GDE_MSGT3420") : Akkumatik.CHARGE_MODE[this.device.getProcessingType(data)];
                switch (data != null ? Integer.valueOf(data[0]) : 0) {
                    case 1: {
                        RecordSet activeRecordSet;
                        isProgrammExecuting1 = this.device.isProcessing(data);
                        isCycleMode1 = this.device.isCycleMode(data);
                        cycleCount1 = (String)(isCycleMode1 ? "#" + this.device.getNumberOfCycle(data) : " ");
                        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", String.format("1: isProcessing = %b process mode = %s isCycleMode = %b(%s) process type = %s", isProgrammExecuting1, processName, isCycleMode1, cycleCount1, processType));
                        if (isProgrammExecuting1) {
                            this.channel = (Channel)this.channels.get((Object)1);
                            if (this.channel.size() == 0 || recordSet1 == null || !this.recordSetKey1.contains(processName) || ((String)cycleCount1).length() > 0 && !this.recordSetKey1.contains((CharSequence)cycleCount1) || !this.recordSetKey1.endsWith(processType)) {
                                this.application.setStatusMessage("");
                                int akkuType = this.device.getAccuCellType(data);
                                this.recordSetKey1 = this.channel.getNextRecordSetNumber() + ") " + processName + " [" + Akkumatik.ACCU_TYPES[akkuType];
                                if (isCycleMode1) {
                                    this.recordSetKey1 = this.recordSetKey1 + " " + Messages.getString((String)"GDE_MSGT3421", (Object[])new Object[]{cycleCount1});
                                }
                                this.recordSetKey1 = this.recordSetKey1 + "]";
                                if (processType.length() > 0) {
                                    this.recordSetKey1 = this.recordSetKey1 + " - " + processType;
                                }
                                log.logp(Level.FINE, $CLASS_NAME, "run", "Create record set with name = " + this.recordSetKey1);
                                this.channel.put((Object)this.recordSetKey1, (Object)RecordSet.createRecordSet((String)this.recordSetKey1, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", this.recordSetKey1 + " created for channel " + this.channel.getName());
                                if (this.channel.getActiveRecordSet() == null) {
                                    this.channel.setActiveRecordSet(this.recordSetKey1);
                                }
                                recordSet1 = (RecordSet)this.channel.get((Object)this.recordSetKey1);
                                this.channel.applyTemplateBasics(this.recordSetKey1);
                                if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                                    this.channels.getActiveChannel().switchRecordSet(this.recordSetKey1);
                                }
                                startCycleTime1 = this.device.getProcessingTime(data);
                                recordSet1.setAllDisplayable();
                                this.channels.switchChannel(this.channel.getName());
                                this.channel.switchRecordSet(this.recordSetKey1);
                                lastCycleTime1 = 0L;
                            }
                            recordSet1 = (RecordSet)this.channel.get((Object)this.recordSetKey1);
                            timeStep1 = this.device.getProcessingTime(data) - startCycleTime1;
                            if (lastCycleTime1 < timeStep1) {
                                recordSet1.addPoints(this.device.convertDataBytes(points1, data), (double)timeStep1);
                                if (log.isLoggable(Level.TIME)) {
                                    log.logp(Level.TIME, $CLASS_NAME, "run", "time = " + TimeLine.getFomatedTimeWithUnit((double)(startCycleTime1 + this.device.getProcessingTime(data))));
                                }
                                lastCycleTime1 = timeStep1;
                            }
                            if (recordSet1 != null && recordSet1.get(0).realSize() < 3 || recordSet1 != null && recordSet1.get(0).realSize() % 10 == 0) {
                                this.device.updateVisibilityStatus(recordSet1, true);
                            }
                            if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet1 != null && recordSet1.size() > 0 && recordSet1.isChildOfActiveChannel() && recordSet1.equals((Object)activeRecordSet)) {
                                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords1 != recordSet1.getConfiguredDisplayable());
                                this.lastNumberDisplayableRecords1 = recordSet1.getConfiguredDisplayable();
                            }
                            this.statusNumberCh1 = 0;
                        }
                        this.statusNumberCh1 = this.device.getNumberStatus(data);
                        break;
                    }
                    case 2: {
                        RecordSet activeRecordSet;
                        isProgrammExecuting2 = this.device.isProcessing(data);
                        isCycleMode2 = this.device.isCycleMode(data);
                        cycleCount2 = (String)(isCycleMode2 ? "#" + this.device.getNumberOfCycle(data) : " ");
                        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", String.format("2: isProcessing = %b process mode = %s isCycleMode = %b(%s) process type = %s", isProgrammExecuting2, processName, isCycleMode2, cycleCount2, processType));
                        if (isProgrammExecuting2) {
                            this.channel = (Channel)this.channels.get((Object)2);
                            if (this.channel.size() == 0 || recordSet2 == null || !this.recordSetKey2.contains(processName) || ((String)cycleCount2).length() > 0 && !this.recordSetKey2.contains((CharSequence)cycleCount2) || !this.recordSetKey2.endsWith(processType)) {
                                this.application.setStatusMessage("");
                                int akkuType = this.device.getAccuCellType(data);
                                this.recordSetKey2 = this.channel.getNextRecordSetNumber() + ") " + processName + " [" + Akkumatik.ACCU_TYPES[akkuType];
                                if (isCycleMode2) {
                                    this.recordSetKey2 = this.recordSetKey2 + " " + Messages.getString((String)"GDE_MSGT3421", (Object[])new Object[]{cycleCount2});
                                }
                                this.recordSetKey2 = this.recordSetKey2 + "]";
                                if (processType.length() > 0) {
                                    this.recordSetKey2 = this.recordSetKey2 + " - " + processType;
                                }
                                log.logp(Level.FINE, $CLASS_NAME, "run", "Create record set with name = " + this.recordSetKey2);
                                this.channel.put((Object)this.recordSetKey2, (Object)RecordSet.createRecordSet((String)this.recordSetKey2, (IDevice)this.application.getActiveDevice(), (int)this.channel.getNumber(), (boolean)true, (boolean)false, (boolean)true));
                                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", this.recordSetKey2 + " created for channel " + this.channel.getName());
                                if (this.channel.getActiveRecordSet() == null) {
                                    this.channel.setActiveRecordSet(this.recordSetKey2);
                                }
                                recordSet2 = (RecordSet)this.channel.get((Object)this.recordSetKey2);
                                this.channel.applyTemplateBasics(this.recordSetKey2);
                                if (this.channel.getName().equals(this.channels.getActiveChannel().getName())) {
                                    this.channels.getActiveChannel().switchRecordSet(this.recordSetKey2);
                                }
                                startCycleTime2 = this.device.getProcessingTime(data);
                                recordSet2.setAllDisplayable();
                                this.channels.switchChannel(this.channel.getName());
                                this.channel.switchRecordSet(this.recordSetKey2);
                                lastCycleTime2 = 0L;
                            }
                            recordSet2 = (RecordSet)this.channel.get((Object)this.recordSetKey2);
                            timeStep2 = this.device.getProcessingTime(data) - startCycleTime2;
                            if (lastCycleTime2 < timeStep2) {
                                recordSet2.addPoints(this.device.convertDataBytes(points2, data), (double)timeStep2);
                                if (log.isLoggable(Level.TIME)) {
                                    log.logp(Level.TIME, $CLASS_NAME, "run", "time = " + TimeLine.getFomatedTimeWithUnit((double)(startCycleTime2 + this.device.getProcessingTime(data))));
                                }
                                lastCycleTime2 = timeStep2;
                            }
                            if (recordSet2 != null && recordSet2.get(0).realSize() < 3 || recordSet2 != null && recordSet2.get(0).realSize() % 10 == 0) {
                                this.device.updateVisibilityStatus(recordSet2, true);
                            }
                            if ((activeRecordSet = this.channels.getActiveChannel().getActiveRecordSet()) != null && recordSet2 != null && recordSet2.size() > 0 && recordSet2.isChildOfActiveChannel() && recordSet2.equals((Object)activeRecordSet)) {
                                this.application.updateAllTabs(false, this.lastNumberDisplayableRecords2 != recordSet2.getConfiguredDisplayable());
                                this.lastNumberDisplayableRecords2 = recordSet2.getConfiguredDisplayable();
                            }
                            this.statusNUmberCh2 = 0;
                        }
                        this.statusNUmberCh2 = this.device.getNumberStatus(data);
                        break;
                    }
                    default: {
                        log.logp(Level.WARNING, $CLASS_NAME, "run", "Create record set with name = nothing executing ?");
                    }
                }
                if (!isProgrammExecuting1 || !isProgrammExecuting2) {
                    this.setProcessingStatus(this.statusNumberCh1, this.statusNUmberCh2);
                }
                if (isProgrammExecuting1 || isProgrammExecuting2) continue;
                log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "wait for Akkumatik activation");
                if (recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
                    this.finalizeRecordSet(false);
                    isProgrammExecuting2 = false;
                    isProgrammExecuting1 = false;
                    recordSet1 = null;
                }
                if (recordSet2 == null || recordSet2.getRecordDataSize(true) <= 5) continue;
                this.finalizeRecordSet(false);
                isProgrammExecuting2 = false;
                isProgrammExecuting1 = false;
                recordSet2 = null;
            }
            catch (DataInconsitsentException e) {
                String message = Messages.getString((String)"GDE_MSGE0036", (Object[])new Object[]{this.getClass().getSimpleName(), "run"});
                this.cleanup(message);
            }
            catch (Throwable e) {
                if (e instanceof TimeOutException) {
                    this.finalizeRecordSet(false);
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "(dry time) waiting...");
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3401"));
                    recordSet2 = null;
                    recordSet1 = null;
                    continue;
                }
                if (e instanceof TimeOutException && !isProgrammExecuting1 && !isProgrammExecuting2) {
                    this.application.setStatusMessage(Messages.getString((String)"GDE_MSGI3400"));
                    log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "wait for Akkumatik activation ...");
                    if (0 != this.setRetryCounter(this.getRetryCounter() - 1)) continue;
                    log.log(java.util.logging.Level.FINE, "Akkumatik activation timeout");
                    this.application.openMessageDialogAsync(Messages.getString((String)"GDE_MSGW3400"));
                    this.stopDataGatheringThread(false, null);
                    continue;
                }
                log.log(java.util.logging.Level.FINE, "Akkumatik program end detected");
                this.stopDataGatheringThread(true, e);
            }
        }
        this.application.setStatusMessage("");
        log.logp(java.util.logging.Level.FINE, $CLASS_NAME, "run", "======> exit");
    }

    void stopDataGatheringThread(boolean enableEndMessage, Throwable throwable) {
        String $METHOD_NAME = "stopDataGatheringThread";
        if (throwable != null) {
            log.logp(java.util.logging.Level.WARNING, $CLASS_NAME, "stopDataGatheringThread", throwable.getMessage(), throwable);
        }
        this.isCollectDataStopped = true;
        if (this.serialPort != null && this.serialPort.getXferErrors() > 0) {
            log.log(java.util.logging.Level.WARNING, "During complete data transfer " + this.serialPort.getXferErrors() + " number of errors occured!");
        }
        if (this.serialPort != null && this.serialPort.isConnected() && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        RecordSet recordSet1 = (RecordSet)this.channel.get((Object)this.recordSetKey1);
        RecordSet recordSet2 = (RecordSet)this.channel.get((Object)this.recordSetKey2);
        if (recordSet2 != null && recordSet2.getRecordDataSize(true) > 5 || recordSet1 != null && recordSet1.getRecordDataSize(true) > 5) {
            this.finalizeRecordSet(false);
            if (enableEndMessage) {
                this.application.openMessageDialog(Messages.getString((String)"GDE_MSGW3401"));
            }
        } else if (throwable != null) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0022", (Object[])new Object[]{throwable.getClass().getSimpleName(), throwable.getMessage()}) + "Datenaufnahme beendet");
        } else if (enableEndMessage) {
            this.cleanup(Messages.getString((String)"GDE_MSGE0026") + Messages.getString((String)"GDE_MSGW3401"));
        }
    }

    void finalizeRecordSet(boolean doClosePort) {
        RecordSet tmpRecordSet;
        if (doClosePort && this.isPortOpenedByLiveGatherer && this.serialPort.isConnected()) {
            this.serialPort.close();
        }
        if ((tmpRecordSet = (RecordSet)this.channel.get((Object)this.recordSetKey1)) != null) {
            this.device.updateVisibilityStatus(tmpRecordSet, true);
            this.device.makeInActiveDisplayable(tmpRecordSet);
            this.application.updateStatisticsData();
            this.application.updateDataTable(this.recordSetKey1, false);
            this.device.setAverageTimeStep_ms(tmpRecordSet.getAverageTimeStep_ms());
            log.log(java.util.logging.Level.FINE, "set average time step msec = " + this.device.getAverageTimeStep_ms());
        }
    }

    void cleanup(final String message) {
        if (this.channel.get((Object)this.recordSetKey1) != null) {
            ((RecordSet)this.channel.get((Object)this.recordSetKey1)).clear();
            this.channel.remove(this.recordSetKey1);
            if (Thread.currentThread().threadId() == this.application.getThreadId()) {
                this.application.getMenuToolBar().updateRecordSetSelectCombo();
                this.application.updateStatisticsData();
                this.application.updateDataTable(this.recordSetKey1, true);
                this.application.openMessageDialog(message);
            } else {
                final String useRecordSetKey = this.recordSetKey1;
                GDE.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        GathererThread.this.application.getMenuToolBar().updateRecordSetSelectCombo();
                        GathererThread.this.application.updateStatisticsData();
                        GathererThread.this.application.updateDataTable(useRecordSetKey, true);
                        GathererThread.this.application.openMessageDialog(message);
                    }
                });
            }
        } else {
            this.application.openMessageDialog(message);
        }
    }

    void setCollectDataStopped(boolean enabled) {
        this.isCollectDataStopped = enabled;
    }

    boolean isCollectDataStopped() {
        return this.isCollectDataStopped;
    }

    int getRetryCounter() {
        return this.retryCounter;
    }

    int setRetryCounter(int newRetryCounter) {
        this.retryCounter = newRetryCounter;
        return this.retryCounter;
    }

    void setProcessingStatus(int statusCh1, int statusCh2) {
        this.application.setStatusMessage(Messages.getString((String)"GDE_MSGT3466", (Object[])new String[]{this.getStatusMessage(statusCh1), this.getStatusMessage(statusCh2)}));
    }

    String getStatusMessage(int status) {
        String statusMsg = "";
        switch (status) {
            case 50: {
                statusMsg = Messages.getString((String)"GDE_MSGI3450");
                break;
            }
            case 51: {
                statusMsg = Messages.getString((String)"GDE_MSGI3451");
                break;
            }
            case 52: {
                statusMsg = Messages.getString((String)"GDE_MSGI3452");
                break;
            }
            case 54: {
                statusMsg = Messages.getString((String)"GDE_MSGI3454");
                break;
            }
            case 55: {
                statusMsg = Messages.getString((String)"GDE_MSGI3455");
                break;
            }
            case 56: {
                statusMsg = Messages.getString((String)"GDE_MSGI3456");
                break;
            }
            case 57: {
                statusMsg = Messages.getString((String)"GDE_MSGI3457");
                break;
            }
            case 58: {
                statusMsg = Messages.getString((String)"GDE_MSGI3458");
                break;
            }
            case 59: {
                statusMsg = Messages.getString((String)"GDE_MSGI3459");
                break;
            }
            case 60: {
                statusMsg = Messages.getString((String)"GDE_MSGI3460");
                break;
            }
            case 61: {
                statusMsg = Messages.getString((String)"GDE_MSGI3461");
                break;
            }
            case 62: {
                statusMsg = Messages.getString((String)"GDE_MSGI3462");
                break;
            }
            case 63: {
                statusMsg = Messages.getString((String)"GDE_MSGI3463");
                break;
            }
            case 64: {
                statusMsg = Messages.getString((String)"GDE_MSGI3464");
                break;
            }
            case 65: {
                statusMsg = Messages.getString((String)"GDE_MSGI3465");
                break;
            }
            case 66: {
                statusMsg = Messages.getString((String)"GDE_MSGI3466");
                break;
            }
            case 67: {
                statusMsg = Messages.getString((String)"GDE_MSGI3467");
                break;
            }
            default: {
                statusMsg = Messages.getString((String)"GDE_MSGI3468");
            }
        }
        return statusMsg;
    }
}

