/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jython;

import freemarker.ext.jython.JythonWrapper;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.Iterator;
import java.util.List;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;

public class JythonModel
implements TemplateBooleanModel,
TemplateScalarModel,
TemplateHashModel,
TemplateMethodModelEx,
AdapterTemplateModel,
WrapperTemplateModel {
    protected final PyObject object;
    protected final JythonWrapper wrapper;
    static final ModelFactory FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new JythonModel((PyObject)object, (JythonWrapper)wrapper);
        }
    };

    public JythonModel(PyObject object, JythonWrapper wrapper) {
        this.object = object;
        this.wrapper = wrapper;
    }

    @Override
    public boolean getAsBoolean() throws TemplateModelException {
        try {
            return this.object.__nonzero__();
        }
        catch (PyException e2) {
            throw new TemplateModelException((Exception)((Object)e2));
        }
    }

    @Override
    public String getAsString() throws TemplateModelException {
        try {
            return this.object.toString();
        }
        catch (PyException e2) {
            throw new TemplateModelException((Exception)((Object)e2));
        }
    }

    @Override
    public TemplateModel get(String key2) throws TemplateModelException {
        if (key2 != null) {
            key2 = key2.intern();
        }
        PyObject obj = null;
        try {
            if (this.wrapper.isAttributesShadowItems()) {
                obj = this.object.__findattr__(key2);
                if (obj == null) {
                    obj = this.object.__finditem__(key2);
                }
            } else {
                obj = this.object.__finditem__(key2);
                if (obj == null) {
                    obj = this.object.__findattr__(key2);
                }
            }
        }
        catch (PyException e2) {
            throw new TemplateModelException((Exception)((Object)e2));
        }
        return this.wrapper.wrap(obj);
    }

    @Override
    public boolean isEmpty() throws TemplateModelException {
        try {
            return this.object.__len__() == 0;
        }
        catch (PyException e2) {
            throw new TemplateModelException((Exception)((Object)e2));
        }
    }

    @Override
    public Object exec(List arguments2) throws TemplateModelException {
        int size = arguments2.size();
        try {
            switch (size) {
                case 0: {
                    return this.wrapper.wrap(this.object.__call__());
                }
                case 1: {
                    return this.wrapper.wrap(this.object.__call__(this.wrapper.unwrap((TemplateModel)arguments2.get(0))));
                }
            }
            PyObject[] pyargs = new PyObject[size];
            int i2 = 0;
            Iterator arg = arguments2.iterator();
            while (arg.hasNext()) {
                pyargs[i2++] = this.wrapper.unwrap((TemplateModel)arg.next());
            }
            return this.wrapper.wrap(this.object.__call__(pyargs));
        }
        catch (PyException e2) {
            throw new TemplateModelException((Exception)((Object)e2));
        }
    }

    public Object getAdaptedObject(Class hint) {
        if (this.object == null) {
            return null;
        }
        Object view = this.object.__tojava__(hint);
        if (view == Py.NoConversion) {
            view = this.object.__tojava__(Object.class);
        }
        return view;
    }

    @Override
    public Object getWrappedObject() {
        return this.object == null ? null : this.object.__tojava__(Object.class);
    }
}

