/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.RAFContainer;
import org.apache.derby.io.StorageRandomAccessFile;

class RAFContainer4
extends RAFContainer {
    private FileChannel ourChannel = null;
    private final Object channelCleanupMonitor = new Object();
    private volatile int threadsInPageIO = 0;
    private volatile boolean restoreChannelInProgress = false;
    private boolean giveUpIO = false;
    private final Object giveUpIOm = new Object();
    private int iosInProgress = 0;
    private ContainerKey currentIdentity;

    public RAFContainer4(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    private FileChannel getChannel(StorageRandomAccessFile storageRandomAccessFile) {
        if (storageRandomAccessFile instanceof RandomAccessFile) {
            return ((RandomAccessFile)((Object)storageRandomAccessFile)).getChannel();
        }
        return null;
    }

    private FileChannel getChannel() {
        if (this.ourChannel == null) {
            this.ourChannel = this.getChannel(this.fileData);
        }
        return this.ourChannel;
    }

    @Override
    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        this.currentIdentity = containerKey;
        return super.openContainer(containerKey);
    }

    @Override
    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        this.currentIdentity = containerKey;
        super.createContainer(containerKey);
    }

    private void reopen() throws StandardException {
        this.ourChannel = null;
        this.reopenContainer(this.currentIdentity);
    }

    @Override
    synchronized void closeContainer() {
        if (this.ourChannel != null) {
            try {
                this.ourChannel.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.ourChannel = null;
            }
        }
        super.closeContainer();
    }

    @Override
    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        this.readPage(l, byArray, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage(long l, byte[] byArray, long l2) throws IOException, StandardException {
        Object object;
        int n;
        boolean bl;
        boolean bl2 = Thread.holdsLock(this);
        boolean bl3 = Thread.holdsLock(this.allocCache);
        boolean bl4 = bl = bl2 || bl3;
        if (!bl) {
            Object object2 = this.channelCleanupMonitor;
            synchronized (object2) {
                n = 120;
                while (this.restoreChannelInProgress) {
                    if (n-- == 0) {
                        throw StandardException.newException("XSDG9.D", new Object[0]);
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean bl5 = false;
        n = 120;
        try {
            while (!bl5) {
                try {
                    if (l == 0L) {
                        object = this;
                        synchronized (object) {
                            this.readPage0(l, byArray, l2);
                        }
                    } else {
                        this.readPage0(l, byArray, l2);
                    }
                    bl5 = true;
                }
                catch (ClosedChannelException closedChannelException) {
                    this.handleClosedChannel(closedChannelException, bl, n--);
                }
            }
        }
        finally {
            if (!bl) {
                object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPage0(long l, byte[] byArray, long l2) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            fileChannel = this.getChannel();
        }
        if (fileChannel != null) {
            long l3 = l * (long)this.pageSize;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            if (l2 == -1L) {
                this.readFull(byteBuffer, fileChannel, l3);
            } else {
                this.readFull(byteBuffer, fileChannel, l2);
            }
            if (this.dataFactory.databaseEncrypted() && l != 0L && l != -1L) {
                this.decryptPage(byArray, this.pageSize);
            }
        } else {
            super.readPage(l, byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        Object object;
        int n;
        boolean bl2 = Thread.holdsLock(this.allocCache);
        if (!bl2) {
            Object object2 = this.channelCleanupMonitor;
            synchronized (object2) {
                n = 120;
                while (this.restoreChannelInProgress) {
                    if (n-- == 0) {
                        throw StandardException.newException("XSDG9.D", new Object[0]);
                    }
                    try {
                        this.channelCleanupMonitor.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                ++this.threadsInPageIO;
            }
        }
        boolean bl3 = false;
        n = 120;
        try {
            while (!bl3) {
                try {
                    if (l == 0L) {
                        object = this;
                        synchronized (object) {
                            this.writePage0(l, byArray, bl);
                        }
                    } else {
                        this.writePage0(l, byArray, bl);
                    }
                    bl3 = true;
                }
                catch (ClosedChannelException closedChannelException) {
                    this.handleClosedChannel(closedChannelException, bl2, n--);
                }
            }
        }
        finally {
            if (!bl2) {
                object = this.channelCleanupMonitor;
                synchronized (object) {
                    --this.threadsInPageIO;
                }
            }
        }
    }

    private void handleClosedChannel(ClosedChannelException closedChannelException, boolean bl, int n) throws StandardException {
        if (closedChannelException instanceof AsynchronousCloseException) {
            if (Thread.currentThread().isInterrupted() && this.recoverContainerAfterInterrupt(closedChannelException.toString(), bl)) {
                return;
            }
            this.awaitRestoreChannel(closedChannelException, bl);
        } else {
            InterruptStatus.noteAndClearInterrupt("ClosedChannelException", this.threadsInPageIO, this.hashCode());
            this.awaitRestoreChannel(closedChannelException, bl);
            if (n == 0) {
                throw StandardException.newException("XSDG9.D", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitRestoreChannel(Exception exception, boolean bl) throws StandardException {
        if (bl) {
            Object object = this.giveUpIOm;
            synchronized (object) {
                if (this.giveUpIO) {
                    throw StandardException.newException("XSDG9.D", new Object[0]);
                }
            }
            throw new InterruptDetectedException();
        }
        Object object = this.channelCleanupMonitor;
        synchronized (object) {
            --this.threadsInPageIO;
        }
        int n = -1;
        Object object2 = this.channelCleanupMonitor;
        synchronized (object2) {
            while (this.restoreChannelInProgress) {
                if (++n > 120) {
                    throw StandardException.newException("XSDG9.D", exception, new Object[0]);
                }
                try {
                    this.channelCleanupMonitor.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
            ++this.threadsInPageIO;
        }
        object2 = this.giveUpIOm;
        synchronized (object2) {
            if (this.giveUpIO) {
                --this.threadsInPageIO;
                throw StandardException.newException("XSDG9.D", new Object[0]);
            }
        }
        if (n == -1) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoverContainerAfterInterrupt(String string, boolean bl) throws StandardException {
        Object object;
        if (bl && this.restoreChannelInProgress) {
            InterruptStatus.noteAndClearInterrupt(string, this.threadsInPageIO, this.hashCode());
            return false;
        }
        Object object2 = this.channelCleanupMonitor;
        synchronized (object2) {
            if (this.restoreChannelInProgress) {
                InterruptStatus.noteAndClearInterrupt(string, this.threadsInPageIO, this.hashCode());
                return false;
            }
            if (!bl) {
                --this.threadsInPageIO;
            }
            this.restoreChannelInProgress = true;
        }
        int n = 120;
        while (true) {
            object = this.channelCleanupMonitor;
            synchronized (object) {
                if (this.threadsInPageIO == 0) {
                    break;
                }
                if (n-- == 0) {
                    this.restoreChannelInProgress = false;
                    this.channelCleanupMonitor.notifyAll();
                    throw StandardException.newException("XSDG9.D", new Object[0]);
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
        }
        object = this.channelCleanupMonitor;
        synchronized (object) {
            try {
                InterruptStatus.noteAndClearInterrupt(string, this.threadsInPageIO, this.hashCode());
                RAFContainer4 rAFContainer4 = this;
                synchronized (rAFContainer4) {
                }
                rAFContainer4 = this;
                synchronized (rAFContainer4) {
                    try {
                        this.reopen();
                    }
                    catch (Exception exception) {
                        Object object3 = this.giveUpIOm;
                        synchronized (object3) {
                            this.giveUpIO = true;
                            throw StandardException.newException("XSDG9.D", exception, new Object[0]);
                        }
                    }
                }
                if (bl) {
                } else {
                    ++this.threadsInPageIO;
                }
            }
            finally {
                this.restoreChannelInProgress = false;
                this.channelCleanupMonitor.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePage0(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        FileChannel fileChannel;
        RAFContainer4 rAFContainer4 = this;
        synchronized (rAFContainer4) {
            if (this.getCommittedDropState()) {
                return;
            }
            fileChannel = this.getChannel();
        }
        if (fileChannel != null) {
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted()) {
                byArray2 = new byte[this.pageSize];
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
            this.dataFactory.writeInProgress();
            try {
                this.writeFull(byteBuffer, fileChannel, l2);
            }
            catch (ClosedChannelException closedChannelException) {
                RAFContainer4 rAFContainer42 = this;
                synchronized (rAFContainer42) {
                    block25: {
                        if (!this.getCommittedDropState()) break block25;
                        return;
                    }
                    throw closedChannelException;
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    fileChannel.force(false);
                    return;
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                RAFContainer4 rAFContainer43 = this;
                synchronized (rAFContainer43) {
                    this.needsSync = true;
                    return;
                }
            }
        }
        super.writePage(l, byArray, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void writeAtOffset(StorageRandomAccessFile storageRandomAccessFile, byte[] byArray, long l) throws IOException, StandardException {
        FileChannel fileChannel = this.getChannel(storageRandomAccessFile);
        if (fileChannel == null) {
            super.writeAtOffset(storageRandomAccessFile, byArray, l);
            return;
        }
        this.ourChannel = fileChannel;
        boolean bl = false;
        while (!bl) {
            RAFContainer4 rAFContainer4 = this;
            synchronized (rAFContainer4) {
                fileChannel = this.getChannel();
            }
            try {
                this.writeFull(ByteBuffer.wrap(byArray), fileChannel, l);
                bl = true;
            }
            catch (ClosedChannelException closedChannelException) {
                this.handleClosedChannel(closedChannelException, true, -1);
            }
        }
    }

    @Override
    byte[] getEmbryonicPage(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        FileChannel fileChannel = this.getChannel(storageRandomAccessFile);
        if (fileChannel != null) {
            byte[] byArray = new byte[204];
            this.readPage(-1L, byArray, l);
            return byArray;
        }
        return super.getEmbryonicPage(storageRandomAccessFile, l);
    }

    private void readFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException, StandardException {
        while (byteBuffer.remaining() > 0) {
            if (fileChannel.read(byteBuffer, l + (long)byteBuffer.position()) == -1) {
                throw new EOFException("Reached end of file while attempting to read a whole page.");
            }
            if (!Thread.currentThread().isInterrupted() || fileChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private void writeFull(ByteBuffer byteBuffer, FileChannel fileChannel, long l) throws IOException {
        while (byteBuffer.remaining() > 0) {
            fileChannel.write(byteBuffer, l + (long)byteBuffer.position());
            if (!Thread.currentThread().isInterrupted() || fileChannel.isOpen()) continue;
            throw new ClosedByInterruptException();
        }
    }

    private static void debugTrace(String string) {
    }
}

