import os
import polib

def list_plural_forms():
    # Set the base directory to "../../po"
    po_dir = "../../po"

    # Ensure the directory exists
    if not os.path.isdir(po_dir):
        print(f"Error: The directory '{po_dir}' was not found.")
        return

    # List files in the new directory
    for filename in os.listdir(po_dir):
        if not filename.endswith('.po'):
            continue
        if '_old' in filename or filename.endswith('.bak'):
            continue

        lang_code = filename.split('.')[0]
        # Construct the full file path
        filepath = os.path.join(po_dir, filename)

        try:
            # Use the full filepath to open the file
            po = polib.pofile(filepath)
            plural_line = ''

            # The rest of the logic remains the same
            for line in po.metadata.get('Plural-Forms', '').splitlines():
                if 'nplurals' in line:
                    plural_line = line
                    break
            
            if not plural_line:  # fallback: use raw header
                for line in po.header.split('\n'):
                    if line.startswith('Plural-Forms:'):
                        plural_line = line
                        break
            
            if plural_line:
                print(f'{lang_code} - {plural_line}')
            else:
                print(f'{lang_code} - No Plural-Forms line found')
        except Exception as e:
            print(f'{lang_code} - Error reading file: {e}')

if __name__ == '__main__':
    list_plural_forms()
