# This script will replace all English texts in the options section of hints2
# with their translations. A 'translations' file has to be placed in the same 
# folder as this script with English/translation pairs. It has to be in the 
# following format:
#
# enabled by default - translation
# disabled by default - translation
# change requires restart - translation
# If disabled, XML tags are indented using four spaces per level. - translation
# If enabled, the root menu will contain only links to menus, while the menus themselves are listed above the root menu, as in the following example: - translation
# If disabled, everything is placed directly inside the root menu: - translation
# This ensures a uniform order of the menu’s options. - translation
# “<u>E</u>xecute options” refer to the options of an Execute action - translation
# (not to be confused with the deprecated “<u>e</u>xecute” options). - translation
# The arrangement follows this pattern: - translation
# When this setting is active, options can no longer be reordered. - translation
# <tt>"execute"</tt> options are deprecated. - translation
# <tt>"Execute"</tt> actions remain valid. - translation
# Deprecated "execute" options are automatically converted to "command" options. - translation
# A message is displayed when such a conversion has taken place. - translation

def read_translations(file_path):
    translations = {}
    with open(file_path, 'r', encoding='utf-8') as file:
        for line in file:
            if '-' in line:
                english, translation = line.strip().split(' - ')
                translations[english.strip()] = translation.strip()
    return translations

def split_translation(translation):
    parts = translation.split()
    total_length = len(translation)
    midpoint = total_length // 2
    current_length = 0

    # Find the closest space to the midpoint that does not split a word
    for i, part in enumerate(parts):
        current_length += len(part) + 1  # Account for the space
        if current_length >= midpoint:
            part1 = ' '.join(parts[:i+1])
            part2 = ' '.join(parts[i+1:])
            return part1, part2

def replace_in_file(file_path, replacements):
    with open(file_path, 'r', encoding='utf-8') as file:
        content = file.readlines()

    new_content = []
    i = 0
    while i < len(content):
        line = content[i]
        if "<span background=\"#cccccc\">" in line and "If enabled," in content[i]:
            full_sentence = ''.join(content[i:i+3])
            full_sentence = full_sentence.replace('<span background="#cccccc"> </span>', '').replace('\n', ' ')
            full_sentence = ' '.join(full_sentence.split())
            translation = replacements.get(full_sentence, None)
            if translation:
                part1, part2 = split_translation(translation)
                new_content.append(f'<span background=\"#cccccc\"> </span>  {part1}\n')
                new_content.append(f'<span background=\"#cccccc\"> </span>  {part2}\n')
            i += 3  # Skip the next two lines since they're part of this formatted block
            continue
        else:
            modified_line = line
            for eng, trans in replacements.items():
                modified_line = modified_line.replace(eng, trans)
            new_content.append(modified_line)
        i += 1

    with open(file_path, 'w', encoding='utf-8') as file:
        file.writelines(new_content)

def main():
    language_code = input("Enter the language code (e.g., 'de', 'fr', 'zh_CN'): ").strip()
    translation_file = 'translations'
    hints_file = f'../txts/hints/{language_code}/hints2_{language_code}'

    # Read translation pairs
    translations = read_translations(translation_file)

    # Replace translations in hints file
    replace_in_file(hints_file, translations)
    print(f'Translations have been updated in {hints_file}.')

if __name__ == "__main__":
    main()

